import os
import argparse
from jinja2 import Template


def main():
    # --workdir `pwd` --output-dir `pwd`/output --input 
    parser = argparse.ArgumentParser()

    parser.add_argument("--input-dir", "-d", required=True)
    parser.add_argument("--root-html", "-o", required=True)

    args = parser.parse_args()

    input_dir = args.input_dir
    root_html = args.root_html

    with open(root_html, 'w') as root_html_handle:
        root_html_handle.write("<ol>")
        for root, dirs, files in os.walk(input_dir, followlinks=True):
            print(root, dirs, files)
            relative_root = root.replace(input_dir, "")[:-1]
            print(relative_root)
            for f in files:
                f = "{0}/{1}".format(relative_root, f)
                if f.startswith("/"):
                    f = f[1:]
                root_html_handle.write("<li>{0}</li>".format(
                    f
                ))
                
if __name__ == "__main__":
    main()