import os
import argparse
from collections import Counter
from jinja2 import Template


def main():
    # --workdir `pwd` --output-dir `pwd`/output --input 
    parser = argparse.ArgumentParser()

    parser.add_argument("--workdir", "-w", required=True)
    parser.add_argument("--output-dir", "-o", required=True)
    parser.add_argument("--template", "-t", required=True)
    parser.add_argument("--output-conf", "-c", required=True)
    parser.add_argument("--input", "-i", action="append", required=True)
    parser.add_argument("--bed", "-b", default=None)

    

    args = parser.parse_args()

    workdir = args.workdir
    output_dir = args.output_dir
    input_files_raw = args.input
    template_file_path = args.template
    output_config_path = args.output_conf
    bed_file_path = args.bed
    
    
    if bed_file_path:
        bed_new_name = "bed_file.bed"
        bed_new_file_path = os.path.join(
            workdir,
            bed_new_name
        )
        os.symlink(bed_file_path, bed_new_file_path)
        bed_file_path = bed_new_file_path
    
    input_files = []
    phenotype_counter = Counter()
    for input_file in input_files_raw:
        if input_file.find(":"):
            forward_file, reverse_file, phenotype = input_file.split(":")
            phenotype_counter.update(phenotype)
            phenotype_count = phenotype_counter[phenotype]

            forward_new_name = "{phenotype}_{phenotype_count}_R1.fastq.gz".format(phenotype=phenotype, phenotype_count=phenotype_count)
            forward_new_file_path = os.path.join(
                workdir,
                forward_new_name
            )
            os.symlink(forward_file, forward_new_file_path)

            reverse_new_name = "{phenotype}_{phenotype_count}_R2.fastq.gz".format(phenotype=phenotype, phenotype_count=phenotype_count)
            reverse_new_file_path = os.path.join(
                workdir,
                reverse_new_name
            )
            os.symlink(reverse_file, reverse_new_file_path)
            
            input_files.append(
                {
                    "forward": forward_new_file_path, 
                    "reverse": reverse_new_file_path, 
                    "description": "{phenotype}_{phenotype_index}".format(phenotype=phenotype, phenotype_index=phenotype_count),
                    "phenotype": phenotype
                }
            )
        
    with open(output_config_path, 'w') as config_file_handle, open(template_file_path, 'r') as template_file_handle:
        template = Template(template_file_handle.read())
        config_file_handle.write(template.render(
            samples=input_files,
            output_dir=output_dir,
            bed_file_path=bed_file_path
        ))


if __name__ == "__main__":
    main()