# -*- coding: utf-8 -*-

from __future__ import print_function
import sys
import os
import shutil
from subprocess import call
from glob import glob

"""
Expected input format:
    ./thiscript output_file output_folder zipfile (args)
"""


def fail(exitcode):
    sys.stderr.write("Breseq did not finish successfully\n")
    sys.stderr.write("Exit code was: {0}\n".format(exitcode))
    sys.exit(1)


def main(args):
    output, outdir = args[1:3]
    cmd = ["breseq"] + args[3:]

    returncode = call(cmd)

    if returncode != 0:
        fail(returncode)

    # the short HTML report
    summary = "output/summary.html"
    if not os.path.isfile(summary):
        fail(returncode)

    # Data will be in the zipfile together will all the content of "output"
    shutil.move("data", "output/")

    if not os.path.isfile(outdir):
        os.mkdir(outdir)

    # Zip the whole folder
    shutil.make_archive("results", "zip", os.path.dirname(outdir), "output/")
    shutil.move("results.zip", outdir)

    shutil.copy(summary, output)

    # move all the files needed for preview of HTML
    for file in glob("output/*"):
        dest = file.split("/", 1)[1]
        # Folder "data" only needs to go in the zipfile not the HTML preview
        if file == "data":
            continue

        shutil.move(file, os.path.join(outdir, dest))


def usage():
    err = sys.stderr
    err.write("Usage:\n")
    err.write("  {0} output_filename output_folder [args]\n".format(
        sys.argv[0]))
    sys.exit(1)

if __name__ == "__main__":
    args = sys.argv

    if len(args) <= 3:
        usage()

    main(args)

# vim: ai sts=4 et sw=4
