/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Bond;
import org.jmol.script.Token;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;

public class ScriptVariable
extends Token {
    private static final ScriptVariable vT = new ScriptVariable(0x10000D, 1, "true");
    private static final ScriptVariable vF = new ScriptVariable(0x10000C, 0, "false");
    static final ScriptVariable vAll = new ScriptVariable(0x100003, "all");
    public int index = Integer.MAX_VALUE;
    private static final int FLAG_CANINCREMENT = 1;
    private static final int FLAG_LOCALVAR = 2;
    private int flags = 2;
    String name;
    private static final Point3f pt0 = new Point3f();

    public ScriptVariable() {
        this.tok = 4;
        this.value = "";
    }

    public ScriptVariable(int n) {
        this.tok = n;
    }

    public ScriptVariable(int n, int n2, Object object) {
        super(n, n2, object);
    }

    public ScriptVariable(int n, Object object) {
        super(n, object);
    }

    public ScriptVariable(int n, int n2) {
        super(n, n2);
    }

    public ScriptVariable(BitSet bitSet, int n) {
        this.value = bitSet;
        this.index = n;
        this.tok = 10;
    }

    public ScriptVariable(Token token) {
        this.tok = token.tok;
        this.intValue = token.intValue;
        this.value = token.value;
    }

    public static String typeOf(ScriptVariable scriptVariable) {
        int n = scriptVariable == null ? 0 : scriptVariable.tok;
        switch (n) {
            case 0x10000C: 
            case 0x10000D: {
                return "boolean";
            }
            case 10: {
                return scriptVariable.value instanceof Bond.BondSet ? "bondset" : "bitset";
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return astrType[n];
            }
        }
        return "?";
    }

    public static int sizeOf(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 10: {
                return BitSetUtil.cardinalityOf(ScriptVariable.bsSelect(token));
            }
            case 0x10000C: 
            case 0x10000D: {
                return -1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return -4;
            }
            case 8: {
                return -8;
            }
            case 9: {
                return -16;
            }
            case 11: {
                return -32;
            }
            case 12: {
                return -64;
            }
            case 4: {
                return ((String)token.value).length();
            }
            case 7: {
                return token.intValue == Integer.MAX_VALUE ? ((ScriptVariable)token).getList().size() : ScriptVariable.sizeOf(ScriptVariable.selectItem(token));
            }
            case 6: {
                return ((Map)token.value).size();
            }
        }
        return 0;
    }

    public static ScriptVariable intVariable(int n) {
        return new ScriptVariable(2, n);
    }

    public static boolean isVariableType(Object object) {
        return object instanceof ScriptVariable || object instanceof BitSet || object instanceof Boolean || object instanceof Float || object instanceof Integer || object instanceof Point3f || object instanceof Vector3f || object instanceof Point4f || object instanceof Quaternion || object instanceof String || object instanceof Map || object instanceof List || object instanceof ScriptVariable[] || object instanceof double[] || object instanceof float[] || object instanceof float[][] || object instanceof Float[] || object instanceof int[] || object instanceof int[][] || object instanceof Point4f[] || object instanceof String[];
    }

    public static ScriptVariable getVariable(Object hashtable) {
        if (hashtable == null) {
            return new ScriptVariable();
        }
        if (hashtable instanceof ScriptVariable) {
            return (ScriptVariable)((Object)hashtable);
        }
        if (hashtable instanceof Boolean) {
            return ScriptVariable.getBoolean((Boolean)((Object)hashtable));
        }
        if (hashtable instanceof Integer) {
            return new ScriptVariable(2, (int)((Integer)((Object)hashtable)));
        }
        if (hashtable instanceof Float) {
            return new ScriptVariable(3, hashtable);
        }
        if (hashtable instanceof String) {
            if ((hashtable = ScriptVariable.unescapePointOrBitsetAsVariable(hashtable)) instanceof ScriptVariable) {
                return (ScriptVariable)((Object)hashtable);
            }
            return new ScriptVariable(4, hashtable);
        }
        if (hashtable instanceof Point3f) {
            return new ScriptVariable(8, hashtable);
        }
        if (hashtable instanceof Vector3f) {
            return new ScriptVariable(8, new Point3f((Vector3f)((Object)hashtable)));
        }
        if (hashtable instanceof BitSet) {
            return new ScriptVariable(10, hashtable);
        }
        if (hashtable instanceof Point4f) {
            return new ScriptVariable(9, hashtable);
        }
        if (hashtable instanceof Quaternion) {
            return new ScriptVariable(9, ((Quaternion)((Object)hashtable)).toPoint4f());
        }
        if (hashtable instanceof Matrix3f) {
            return new ScriptVariable(11, hashtable);
        }
        if (hashtable instanceof Matrix4f) {
            return new ScriptVariable(12, hashtable);
        }
        if (hashtable instanceof Float[]) {
            return new ScriptVariable(13, hashtable);
        }
        if (hashtable instanceof Map) {
            Map map = hashtable;
            Iterator iterator = map.keySet().iterator();
            if (iterator.hasNext() && !(map.get(iterator.next()) instanceof ScriptVariable)) {
                Hashtable<String, ScriptVariable> hashtable2 = new Hashtable<String, ScriptVariable>();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashtable2.put(string, ScriptVariable.getVariable(map.get(string)));
                }
                hashtable = hashtable2;
            }
            return new ScriptVariable(6, hashtable);
        }
        ArrayList<ScriptVariable> arrayList = null;
        if (hashtable instanceof List) {
            List list = (List)((Object)hashtable);
            int n = list.size();
            if (n > 0 && list.get(0) instanceof ScriptVariable) {
                return new ScriptVariable(7, list);
            }
            arrayList = new ArrayList();
            for (int i = 0; i < n; ++i) {
                arrayList.add(ScriptVariable.getVariable(list.get(i)));
            }
            return new ScriptVariable(7, arrayList);
        }
        if (hashtable instanceof ScriptVariable[]) {
            arrayList = new ArrayList<ScriptVariable>();
            ScriptVariable[] scriptVariableArray = (ScriptVariable[])hashtable;
            arrayList = new ArrayList();
            for (int i = 0; i < scriptVariableArray.length; ++i) {
                arrayList.add(scriptVariableArray[i]);
            }
            return new ScriptVariable(7, arrayList);
        }
        if (hashtable instanceof String[]) {
            String[] stringArray = (String[])hashtable;
            arrayList = new ArrayList();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(ScriptVariable.getVariable(stringArray[i]));
            }
            return new ScriptVariable(7, arrayList);
        }
        if (hashtable instanceof int[]) {
            int[] nArray = (int[])hashtable;
            arrayList = new ArrayList();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(ScriptVariable.getVariable(nArray[i]));
            }
            return new ScriptVariable(7, arrayList);
        }
        if (hashtable instanceof float[]) {
            float[] fArray = (float[])hashtable;
            arrayList = new ArrayList();
            for (int i = 0; i < fArray.length; ++i) {
                arrayList.add(ScriptVariable.getVariable(Float.valueOf(fArray[i])));
            }
            return new ScriptVariable(7, arrayList);
        }
        if (hashtable instanceof double[]) {
            double[] dArray = (double[])hashtable;
            arrayList = new ArrayList();
            for (int i = 0; i < dArray.length; ++i) {
                arrayList.add(ScriptVariable.getVariable(Float.valueOf((float)dArray[i])));
            }
            return new ScriptVariable(7, arrayList);
        }
        if (hashtable instanceof int[][]) {
            int[][] nArray = (int[][])hashtable;
            arrayList = new ArrayList();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(ScriptVariable.getVariable(nArray[i]));
            }
            return new ScriptVariable(7, arrayList);
        }
        if (hashtable instanceof float[][]) {
            float[][] fArray = (float[][])hashtable;
            arrayList = new ArrayList();
            for (int i = 0; i < fArray.length; ++i) {
                arrayList.add(ScriptVariable.getVariable(fArray[i]));
            }
            return new ScriptVariable(7, arrayList);
        }
        return new ScriptVariable(4, Escape.toReadable(hashtable));
    }

    public ScriptVariable set(ScriptVariable scriptVariable, boolean bl) {
        this.index = scriptVariable.index;
        this.intValue = scriptVariable.intValue;
        this.tok = scriptVariable.tok;
        this.value = scriptVariable.value;
        if (bl) {
            switch (this.tok) {
                case 6: {
                    this.value = new Hashtable((Map)scriptVariable.value);
                    break;
                }
                case 7: {
                    ArrayList arrayList = new ArrayList();
                    List list = scriptVariable.getList();
                    for (int i = 0; i < list.size(); ++i) {
                        arrayList.add(list.get(i));
                    }
                    this.value = arrayList;
                }
            }
        }
        return this;
    }

    public ScriptVariable setName(String string) {
        this.name = string;
        this.flags |= 1;
        return this;
    }

    public ScriptVariable setGlobal() {
        this.flags &= 0xFFFFFFFD;
        return this;
    }

    public boolean canIncrement() {
        return ScriptVariable.tokAttr(this.flags, 1);
    }

    public boolean increment(int n) {
        if (!this.canIncrement()) {
            return false;
        }
        switch (this.tok) {
            case 2: {
                this.intValue += n;
                break;
            }
            case 3: {
                this.value = new Float(((Float)this.value).floatValue() + (float)n);
                break;
            }
            default: {
                this.value = ScriptVariable.nValue(this);
                if (this.value instanceof Integer) {
                    this.tok = 2;
                    this.intValue = (Integer)this.value;
                    break;
                }
                this.tok = 3;
            }
        }
        return true;
    }

    public boolean asBoolean() {
        return ScriptVariable.bValue(this);
    }

    public int asInt() {
        return ScriptVariable.iValue(this);
    }

    public float asFloat() {
        return ScriptVariable.fValue(this);
    }

    public String asString() {
        return ScriptVariable.sValue(this);
    }

    public Object getValAsObj() {
        return this.tok == 2 ? Integer.valueOf(this.intValue) : this.value;
    }

    public static Object oValue(ScriptVariable scriptVariable) {
        switch (scriptVariable == null ? 0 : scriptVariable.tok) {
            case 0x10000D: {
                return Boolean.TRUE;
            }
            case 0: 
            case 0x10000C: {
                return Boolean.FALSE;
            }
            case 2: {
                return scriptVariable.intValue;
            }
        }
        return scriptVariable.value;
    }

    public static Object nValue(Token token) {
        int n;
        switch (token == null ? 0 : token.tok) {
            case 3: {
                return token.value;
            }
            case 2: {
                n = token.intValue;
                break;
            }
            case 4: {
                if (((String)token.value).indexOf(".") >= 0) {
                    return new Float(ScriptVariable.toFloat((String)token.value));
                }
                n = (int)ScriptVariable.toFloat((String)token.value);
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static boolean bValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
            case 2: {
                return token.intValue != 0;
            }
            case 3: 
            case 4: 
            case 7: {
                return ScriptVariable.fValue(token) != 0.0f;
            }
            case 10: {
                return ScriptVariable.iValue(token) != 0;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return Math.abs(ScriptVariable.fValue(token)) > 1.0E-4f;
            }
        }
        return false;
    }

    public static int iValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 2: {
                return token.intValue;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return (int)ScriptVariable.fValue(token);
            }
            case 10: {
                return BitSetUtil.cardinalityOf(ScriptVariable.bsSelect(token));
            }
        }
        return 0;
    }

    public static float fValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x10000D: {
                return 1.0f;
            }
            case 0x10000C: {
                return 0.0f;
            }
            case 2: {
                return token.intValue;
            }
            case 3: {
                return ((Float)token.value).floatValue();
            }
            case 7: {
                int n = token.intValue;
                if (n == Integer.MAX_VALUE) {
                    return ((ScriptVariable)token).getList().size();
                }
            }
            case 4: {
                return ScriptVariable.toFloat(ScriptVariable.sValue(token));
            }
            case 10: {
                return ScriptVariable.iValue(token);
            }
            case 8: {
                return ((Point3f)token.value).distance(pt0);
            }
            case 9: {
                return Measure.distanceToPlane((Point4f)token.value, pt0);
            }
            case 11: {
                Point3f point3f = new Point3f();
                ((Matrix3f)token.value).transform(point3f);
                return point3f.distance(pt0);
            }
            case 12: {
                Point3f point3f = new Point3f();
                ((Matrix4f)token.value).transform(point3f);
                return point3f.distance(pt0);
            }
        }
        return 0.0f;
    }

    public static String sValue(Token token) {
        if (token == null) {
            return "";
        }
        switch (token.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + token.intValue;
            }
            case 8: {
                return Escape.escape((Point3f)token.value);
            }
            case 9: {
                return Escape.escape((Point4f)token.value);
            }
            case 11: {
                return Escape.escape((Matrix3f)token.value);
            }
            case 12: {
                return Escape.escape((Matrix4f)token.value);
            }
            case 10: {
                return Escape.escape(ScriptVariable.bsSelect(token), !(token.value instanceof Bond.BondSet));
            }
            case 6: 
            case 7: {
                if (token.tok == 7) {
                    List list = ((ScriptVariable)token).getList();
                    int n = token.intValue;
                    if (n <= 0) {
                        n = list.size() - n;
                    }
                    if (n != Integer.MAX_VALUE) {
                        return n < 1 || n > list.size() ? "" : ScriptVariable.sValue((ScriptVariable)list.get(n - 1));
                    }
                }
                StringBuffer stringBuffer = new StringBuffer();
                Hashtable hashtable = new Hashtable();
                ScriptVariable.sValueArray(stringBuffer, (ScriptVariable)token, hashtable, 0, false);
                return stringBuffer.toString();
            }
            case 4: {
                String string = (String)token.value;
                int n = token.intValue;
                if (n <= 0) {
                    n = string.length() - n;
                }
                if (n == Integer.MAX_VALUE) {
                    return string;
                }
                if (n < 1 || n > string.length()) {
                    return "";
                }
                return "" + string.charAt(n - 1);
            }
        }
        return "" + token.value;
    }

    private static void sValueArray(StringBuffer stringBuffer, ScriptVariable scriptVariable, Map map, int n, boolean bl) {
        switch (scriptVariable.tok) {
            case 6: {
                if (map.containsKey(scriptVariable)) {
                    stringBuffer.append(bl ? "{}" : (scriptVariable.name == null ? "<circular reference>" : "<" + scriptVariable.name + ">"));
                    break;
                }
                map.put(scriptVariable, Boolean.TRUE);
                Map map2 = (Map)scriptVariable.value;
                Object[] objectArray = map2.keySet().toArray();
                Arrays.sort(objectArray);
                if (bl) {
                    stringBuffer.append("{ ");
                    String string = "";
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string2 = (String)objectArray[i];
                        stringBuffer.append(string).append(Escape.escape(string2)).append(':');
                        ScriptVariable.sValueArray(stringBuffer, (ScriptVariable)map2.get(string2), map, n + 1, true);
                        string = ", ";
                    }
                    stringBuffer.append(" }");
                    break;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(objectArray[i]).append("\t:");
                    ScriptVariable scriptVariable2 = ScriptVariable.getVariable(map2.get(objectArray[i]));
                    StringBuffer stringBuffer2 = new StringBuffer();
                    ScriptVariable.sValueArray(stringBuffer2, scriptVariable2, map, n + 1, bl);
                    String string = stringBuffer2.toString();
                    stringBuffer.append(string.indexOf("\n") >= 0 ? "\n" : "\t");
                    stringBuffer.append(string).append("\n");
                }
                break;
            }
            case 7: {
                if (map.containsKey(scriptVariable)) {
                    stringBuffer.append(bl ? "[]" : (scriptVariable.name == null ? "<circular reference>" : "<" + scriptVariable.name + ">"));
                    break;
                }
                map.put(scriptVariable, Boolean.TRUE);
                if (bl) {
                    stringBuffer.append("[");
                }
                List list = scriptVariable.getList();
                for (int i = 0; i < list.size(); ++i) {
                    if (bl && i > 0) {
                        stringBuffer.append(",");
                    }
                    ScriptVariable scriptVariable3 = (ScriptVariable)list.get(i);
                    ScriptVariable.sValueArray(stringBuffer, scriptVariable3, map, n + 1, bl);
                    if (bl) continue;
                    stringBuffer.append("\n");
                }
                if (!bl) break;
                stringBuffer.append("]");
                break;
            }
            default: {
                if (!bl) {
                    for (int i = 0; i < n - 1; ++i) {
                        stringBuffer.append("\t");
                    }
                }
                stringBuffer.append(bl ? scriptVariable.escape() : ScriptVariable.sValue(scriptVariable));
            }
        }
    }

    public static Point3f ptValue(ScriptVariable scriptVariable) {
        switch (scriptVariable.tok) {
            case 8: {
                return (Point3f)scriptVariable.value;
            }
            case 4: {
                Object object = Escape.unescapePoint((String)scriptVariable.value);
                if (!(object instanceof Point3f)) break;
                return (Point3f)object;
            }
        }
        return null;
    }

    public static Point4f pt4Value(ScriptVariable scriptVariable) {
        switch (scriptVariable.tok) {
            case 9: {
                return (Point4f)scriptVariable.value;
            }
            case 4: {
                Object object = Escape.unescapePoint((String)scriptVariable.value);
                if (!(object instanceof Point4f)) break;
                return (Point4f)object;
            }
        }
        return null;
    }

    private static float toFloat(String string) {
        if (string.equalsIgnoreCase("true")) {
            return 1.0f;
        }
        if (string.equalsIgnoreCase("false") || string.length() == 0) {
            return 0.0f;
        }
        return Parser.parseFloatStrict(string);
    }

    public static ScriptVariable concatList(ScriptVariable scriptVariable, ScriptVariable scriptVariable2, boolean bl) {
        int n;
        List list = scriptVariable.getList();
        List list2 = scriptVariable2.getList();
        if (!bl) {
            if (list2 == null) {
                list.add(new ScriptVariable(scriptVariable2));
            } else {
                for (int i = 0; i < list2.size(); ++i) {
                    list.add(list2.get(i));
                }
            }
            return scriptVariable;
        }
        ArrayList<ScriptVariable> arrayList = new ArrayList<ScriptVariable>((list == null ? 1 : list.size()) + (list2 == null ? 1 : list2.size()));
        if (list == null) {
            arrayList.add(scriptVariable);
        } else {
            for (n = 0; n < list.size(); ++n) {
                arrayList.add((ScriptVariable)list.get(n));
            }
        }
        if (list2 == null) {
            arrayList.add(scriptVariable2);
        } else {
            for (n = 0; n < list2.size(); ++n) {
                arrayList.add((ScriptVariable)list2.get(n));
            }
        }
        return ScriptVariable.getVariable(arrayList);
    }

    public static BitSet bsSelect(Token token) {
        token = ScriptVariable.selectItem(token, Integer.MIN_VALUE);
        return (BitSet)token.value;
    }

    public static BitSet bsSelect(ScriptVariable scriptVariable) {
        if (scriptVariable.index == Integer.MAX_VALUE) {
            scriptVariable = ScriptVariable.selectItem(scriptVariable);
        }
        return (BitSet)scriptVariable.value;
    }

    public static BitSet bsSelectRange(Token token, int n) {
        token = ScriptVariable.selectItem(token);
        token = ScriptVariable.selectItem(token, n <= 0 ? n : 1);
        token = ScriptVariable.selectItem(token, n <= 0 ? 0x7FFFFFFE : n);
        return (BitSet)token.value;
    }

    public static ScriptVariable selectItem(ScriptVariable scriptVariable) {
        if (scriptVariable.index != Integer.MAX_VALUE || scriptVariable.tok == 7 && scriptVariable.intValue == Integer.MAX_VALUE) {
            return scriptVariable;
        }
        return ScriptVariable.selectItem(scriptVariable, Integer.MIN_VALUE);
    }

    public static Token selectItem(Token token) {
        return ScriptVariable.selectItem(token, Integer.MIN_VALUE);
    }

    public static ScriptVariable selectItem(ScriptVariable scriptVariable, int n) {
        return (ScriptVariable)ScriptVariable.selectItem((Token)scriptVariable, n);
    }

    public static Token selectItem(Token token, int n) {
        switch (token.tok) {
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                return token;
            }
        }
        BitSet bitSet = null;
        String string = null;
        int n2 = token.intValue;
        if (n2 == Integer.MAX_VALUE) {
            if (n == Integer.MIN_VALUE) {
                n = n2;
            }
            ScriptVariable scriptVariable = new ScriptVariable(token.tok, n, token.value);
            return scriptVariable;
        }
        int n3 = 0;
        boolean bl = token instanceof ScriptVariable && ((ScriptVariable)token).index != Integer.MAX_VALUE;
        ScriptVariable scriptVariable = new ScriptVariable(token.tok, Integer.MAX_VALUE);
        switch (token.tok) {
            case 10: {
                if (token.value instanceof Bond.BondSet) {
                    scriptVariable.value = new Bond.BondSet((BitSet)token.value, ((Bond.BondSet)token.value).getAssociatedAtoms());
                    bitSet = (BitSet)scriptVariable.value;
                    n3 = BitSetUtil.cardinalityOf(bitSet);
                    break;
                }
                bitSet = BitSetUtil.copy((BitSet)token.value);
                n3 = bl ? 1 : BitSetUtil.cardinalityOf(bitSet);
                scriptVariable.value = bitSet;
                break;
            }
            case 7: {
                n3 = ((ScriptVariable)token).getList().size();
                break;
            }
            case 4: {
                string = (String)token.value;
                n3 = string.length();
                break;
            }
            case 11: {
                n3 = -3;
                break;
            }
            case 12: {
                n3 = -4;
            }
        }
        if (n3 < 0) {
            n3 = -n3;
            if (n2 > 0 && Math.abs(n2) > n3) {
                int n4 = n2 % 10;
                int n5 = (n2 - n4) / 10;
                if (n4 > 0 && n4 <= n3 && n5 <= n3) {
                    if (token.tok == 11) {
                        return new ScriptVariable(3, new Float(((Matrix3f)token.value).getElement(n5 - 1, n4 - 1)));
                    }
                    return new ScriptVariable(3, new Float(((Matrix4f)token.value).getElement(n5 - 1, n4 - 1)));
                }
                return new ScriptVariable(4, "");
            }
            if (Math.abs(n2) > n3) {
                return new ScriptVariable(4, "");
            }
            float[] fArray = new float[n3];
            if (n3 == 3) {
                if (n2 < 0) {
                    ((Matrix3f)token.value).getColumn(-1 - n2, fArray);
                } else {
                    ((Matrix3f)token.value).getRow(n2 - 1, fArray);
                }
            } else if (n2 < 0) {
                ((Matrix4f)token.value).getColumn(-1 - n2, fArray);
            } else {
                ((Matrix4f)token.value).getRow(n2 - 1, fArray);
            }
            if (n == Integer.MIN_VALUE) {
                return ScriptVariable.getVariable(fArray);
            }
            if (n < 1 || n > n3) {
                return new ScriptVariable(4, "");
            }
            return ScriptVariable.getVariable(new Float(fArray[n - 1]));
        }
        if (n2 <= 0) {
            n2 = n3 + n2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n == 0) {
            n = n3;
        } else if (n < 0) {
            n = n3 + n;
        }
        if (n > n3) {
            n = n3;
        } else if (n < n2) {
            n = n2;
        }
        switch (token.tok) {
            case 10: {
                if (bl) {
                    if (n2 <= 1) break;
                    bitSet.clear();
                    break;
                }
                int n6 = 0;
                int n7 = bitSet.nextSetBit(0);
                while (n7 >= 0) {
                    if (++n6 < n2 || n6 > n) {
                        bitSet.clear(n7);
                    }
                    n7 = bitSet.nextSetBit(n7 + 1);
                }
                break;
            }
            case 4: {
                if (n2 < 1 || n2 > n3) {
                    scriptVariable.value = "";
                    break;
                }
                scriptVariable.value = string.substring(n2 - 1, n);
                break;
            }
            case 7: {
                if (n2 < 1 || n2 > n3 || n > n3) {
                    return new ScriptVariable(4, "");
                }
                if (n == n2) {
                    return (ScriptVariable)((ScriptVariable)token).getList().get(n2 - 1);
                }
                ArrayList<ScriptVariable> arrayList = new ArrayList<ScriptVariable>();
                List list = ((ScriptVariable)token).getList();
                int n8 = n - n2 + 1;
                for (int i = 0; i < n8; ++i) {
                    arrayList.add(new ScriptVariable((ScriptVariable)list.get(i + n2 - 1)));
                }
                scriptVariable.value = arrayList;
            }
        }
        return scriptVariable;
    }

    public boolean setSelectedValue(int n, ScriptVariable scriptVariable) {
        if (n == Integer.MAX_VALUE) {
            return false;
        }
        switch (this.tok) {
            case 11: 
            case 12: {
                List list;
                int n2;
                int n3 = n2 = this.tok == 11 ? 3 : 4;
                if (n > 10) {
                    int n4 = n % 10;
                    int n5 = (n - n4) / 10;
                    if (n4 > 0 && n4 <= n2 && n5 <= n2) {
                        if (this.tok == 11) {
                            ((Matrix3f)this.value).setElement(n5 - 1, n4 - 1, ScriptVariable.fValue(scriptVariable));
                        } else {
                            ((Matrix4f)this.value).setElement(n5 - 1, n4 - 1, ScriptVariable.fValue(scriptVariable));
                        }
                        return true;
                    }
                }
                if (n != 0 && Math.abs(n) <= n2 && scriptVariable.tok == 7 && (list = scriptVariable.getList()).size() == n2) {
                    float[] fArray = new float[n2];
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = ScriptVariable.fValue((ScriptVariable)list.get(i));
                    }
                    if (n > 0) {
                        if (this.tok == 11) {
                            ((Matrix3f)this.value).setRow(n - 1, fArray);
                        } else {
                            ((Matrix4f)this.value).setRow(n - 1, fArray);
                        }
                    } else if (this.tok == 11) {
                        ((Matrix3f)this.value).setColumn(-1 - n, fArray);
                    } else {
                        ((Matrix4f)this.value).setColumn(-1 - n, fArray);
                    }
                    return true;
                }
                return false;
            }
            case 4: {
                String string = (String)this.value;
                int n6 = string.length();
                if (n <= 0) {
                    n = n6 + n;
                }
                if (--n < 0) {
                    n = 0;
                }
                while (n >= string.length()) {
                    string = string + " ";
                }
                this.value = string.substring(0, n) + ScriptVariable.sValue(scriptVariable) + string.substring(n + 1);
                return true;
            }
            case 7: {
                int n7 = this.getList().size();
                if (n <= 0) {
                    n = n7 + n;
                }
                if (--n < 0) {
                    n = 0;
                }
                if (n7 <= n) {
                    for (int i = n7; i <= n; ++i) {
                        this.getList().add(ScriptVariable.getVariable(""));
                    }
                }
                this.getList().set(n, scriptVariable);
                return true;
            }
        }
        return false;
    }

    public String escape() {
        switch (this.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + this.intValue;
            }
            case 10: {
                return Escape.escape((BitSet)this.value, !(this.value instanceof Bond.BondSet));
            }
            case 6: 
            case 7: {
                StringBuffer stringBuffer = new StringBuffer();
                Hashtable hashtable = new Hashtable();
                ScriptVariable.sValueArray(stringBuffer, this, hashtable, 0, true);
                return stringBuffer.toString();
            }
            case 8: {
                return Escape.escape((Point3f)this.value);
            }
            case 9: {
                return Escape.escape((Point4f)this.value);
            }
            case 11: {
                return Escape.escape((Matrix3f)this.value);
            }
            case 12: {
                return Escape.escape((Matrix4f)this.value);
            }
        }
        return Escape.escape(this.value);
    }

    public static Object unescapePointOrBitsetAsVariable(Object object) {
        if (object == null) {
            return object;
        }
        Object object2 = null;
        String string = null;
        if (object instanceof ScriptVariable) {
            ScriptVariable scriptVariable = (ScriptVariable)object;
            switch (scriptVariable.tok) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    object2 = scriptVariable.value;
                    break;
                }
                case 4: {
                    string = (String)scriptVariable.value;
                    break;
                }
                default: {
                    string = ScriptVariable.sValue(scriptVariable);
                    break;
                }
            }
        } else if (object instanceof String) {
            string = (String)object;
        }
        if (string != null && string.length() == 0) {
            return string;
        }
        if (object2 == null) {
            object2 = Escape.unescapePointOrBitsetOrMatrixOrArray(string);
        }
        if (object2 instanceof Point3f) {
            return new ScriptVariable(8, object2);
        }
        if (object2 instanceof Point4f) {
            return new ScriptVariable(9, object2);
        }
        if (object2 instanceof BitSet) {
            if (string != null && string.indexOf("[{") == 0) {
                object2 = new Bond.BondSet((BitSet)object2);
            }
            return new ScriptVariable(10, object2);
        }
        if (object2 instanceof Matrix3f) {
            return new ScriptVariable(11, object2);
        }
        if (object2 instanceof Matrix4f) {
            return new ScriptVariable(12, object2);
        }
        return object;
    }

    public static ScriptVariable getBoolean(boolean bl) {
        return new ScriptVariable(bl ? vT : vF);
    }

    public static Object sprintf(String string, ScriptVariable scriptVariable) {
        if (scriptVariable == null) {
            return string;
        }
        int[] nArray = (int[])(string.indexOf("d") >= 0 || string.indexOf("i") >= 0 ? new int[1] : null);
        float[] fArray = string.indexOf("f") >= 0 ? new float[1] : null;
        double[] dArray = string.indexOf("e") >= 0 ? new double[1] : null;
        boolean bl = string.indexOf("s") >= 0;
        boolean bl2 = string.indexOf("p") >= 0 && scriptVariable.tok == 8 || string.indexOf("q") >= 0 && scriptVariable.tok == 9;
        Object[] objectArray = new Object[]{nArray, fArray, dArray, null, null};
        if (scriptVariable.tok != 7) {
            return ScriptVariable.sprintf(string, scriptVariable, objectArray, nArray, fArray, dArray, bl, bl2);
        }
        List list = scriptVariable.getList();
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ScriptVariable.sprintf(string, (ScriptVariable)list.get(i), objectArray, nArray, fArray, dArray, bl, bl2);
        }
        return stringArray;
    }

    private static String sprintf(String string, ScriptVariable scriptVariable, Object[] objectArray, int[] nArray, float[] fArray, double[] dArray, boolean bl, boolean bl2) {
        if (nArray != null) {
            nArray[0] = ScriptVariable.iValue(scriptVariable);
        }
        if (fArray != null) {
            fArray[0] = ScriptVariable.fValue(scriptVariable);
        }
        if (dArray != null) {
            dArray[0] = ScriptVariable.fValue(scriptVariable);
        }
        if (bl) {
            objectArray[3] = ScriptVariable.sValue(scriptVariable);
        }
        if (bl2) {
            objectArray[4] = scriptVariable.value;
        }
        return TextFormat.sprintf(string, objectArray);
    }

    public static String sprintf(ScriptVariable[] scriptVariableArray) {
        switch (scriptVariableArray.length) {
            case 0: {
                return "";
            }
            case 1: {
                return ScriptVariable.sValue(scriptVariableArray[0]);
            }
        }
        String[] stringArray = TextFormat.split(TextFormat.simpleReplace(ScriptVariable.sValue(scriptVariableArray[0]), "%%", "\u0001"), '%');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            Object object = ScriptVariable.sprintf(TextFormat.formatCheck("%" + stringArray[i]), i < scriptVariableArray.length ? scriptVariableArray[i] : null);
            if (object instanceof String[]) {
                String[] stringArray2 = (String[])object;
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringBuffer.append(stringArray2[j]).append("\n");
                }
                continue;
            }
            stringBuffer.append(object);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return super.toString() + "[" + this.name + "] index =" + this.index + " hashcode=" + this.hashCode();
    }

    public static BitSet getBitSet(ScriptVariable scriptVariable, boolean bl) {
        switch (scriptVariable.tok) {
            case 10: {
                return ScriptVariable.bsSelect(scriptVariable);
            }
            case 7: {
                BitSet bitSet = new BitSet();
                List list = (List)scriptVariable.value;
                for (int i = 0; i < list.size(); ++i) {
                    if (((ScriptVariable)list.get(i)).unEscapeBitSetArray(bitSet) || !bl) continue;
                    return null;
                }
                return bitSet;
            }
        }
        return bl ? null : new BitSet();
    }

    public static boolean areEqual(ScriptVariable scriptVariable, ScriptVariable scriptVariable2) {
        if (scriptVariable.tok == 4 && scriptVariable2.tok == 4) {
            return ScriptVariable.sValue(scriptVariable).equalsIgnoreCase(ScriptVariable.sValue(scriptVariable2));
        }
        if (scriptVariable.tok == 8 && scriptVariable2.tok == 8) {
            return (double)((Point3f)scriptVariable.value).distance((Point3f)scriptVariable2.value) < 1.0E-6;
        }
        if (scriptVariable.tok == 9 && scriptVariable2.tok == 9) {
            return (double)((Point4f)scriptVariable.value).distance((Point4f)scriptVariable2.value) < 1.0E-6;
        }
        return (double)Math.abs(ScriptVariable.fValue(scriptVariable) - ScriptVariable.fValue(scriptVariable2)) < 1.0E-6;
    }

    public ScriptVariable sortOrReverse(int n) {
        List list = this.getList();
        if (list == null || list.size() < 2) {
            return this;
        }
        if (n == Integer.MIN_VALUE) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                ScriptVariable scriptVariable = (ScriptVariable)list.get(i);
                list.set(i, list.get(--n2));
                list.set(n2, scriptVariable);
            }
        } else {
            Collections.sort(this.getList(), new Sort(--n));
        }
        return this;
    }

    public boolean unEscapeBitSetArray(BitSet bitSet) {
        switch (this.tok) {
            case 4: {
                BitSet bitSet2 = Escape.unescapeBitset((String)this.value);
                if (bitSet2 == null) {
                    return false;
                }
                bitSet.or(bitSet2);
                return true;
            }
            case 10: {
                bitSet.or((BitSet)this.value);
                return true;
            }
        }
        return false;
    }

    public static BitSet unEscapeBitSetArray(List list, boolean bl) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < list.size(); ++i) {
            if (((ScriptVariable)list.get(i)).unEscapeBitSetArray(bitSet) || !bl) continue;
            return null;
        }
        return bitSet;
    }

    public static String[] listValue(Token token) {
        if (token.tok != 7) {
            return new String[]{ScriptVariable.sValue(token)};
        }
        List list = ((ScriptVariable)token).getList();
        String[] stringArray = new String[list.size()];
        int n = list.size();
        while (--n >= 0) {
            stringArray[n] = ScriptVariable.sValue((ScriptVariable)list.get(n));
        }
        return stringArray;
    }

    public static float[] flistValue(Token token, int n) {
        if (token.tok != 7) {
            return new float[]{ScriptVariable.fValue(token)};
        }
        List list = ((ScriptVariable)token).getList();
        float[] fArray = new float[Math.max(n, list.size())];
        if (n == 0) {
            n = fArray.length;
        }
        int n2 = Math.min(list.size(), n);
        while (--n2 >= 0) {
            fArray[n2] = ScriptVariable.fValue((ScriptVariable)list.get(n2));
        }
        return fArray;
    }

    public void toArray() {
        int n;
        Matrix3f matrix3f = null;
        Matrix4f matrix4f = null;
        switch (this.tok) {
            case 11: {
                matrix3f = (Matrix3f)this.value;
                n = 3;
                break;
            }
            case 12: {
                matrix4f = (Matrix4f)this.value;
                n = 4;
                break;
            }
            default: {
                return;
            }
        }
        this.tok = 7;
        ArrayList<ScriptVariable> arrayList = new ArrayList<ScriptVariable>(n);
        for (int i = 0; i < n; ++i) {
            float[] fArray = new float[n];
            if (matrix3f == null) {
                matrix4f.getRow(i, fArray);
            } else {
                matrix3f.getRow(i, fArray);
            }
            arrayList.set(i, ScriptVariable.getVariable(fArray));
        }
        this.value = arrayList;
    }

    public ScriptVariable mapValue(String string) {
        return this.tok == 6 ? (ScriptVariable)((Map)this.value).get(string) : null;
    }

    public List getList() {
        return this.tok == 7 ? (List)this.value : null;
    }

    protected class Sort
    implements Comparator {
        private int arrayPt;

        protected Sort(int n) {
            this.arrayPt = n;
        }

        public int compare(Object object, Object object2) {
            ScriptVariable scriptVariable = (ScriptVariable)object;
            ScriptVariable scriptVariable2 = (ScriptVariable)object2;
            if (scriptVariable.tok != scriptVariable2.tok) {
                if (scriptVariable.tok == 3 || scriptVariable.tok == 2 || scriptVariable2.tok == 3 || scriptVariable2.tok == 2) {
                    float f;
                    float f2 = ScriptVariable.fValue(scriptVariable);
                    return f2 < (f = ScriptVariable.fValue(scriptVariable2)) ? -1 : (f2 > f ? 1 : 0);
                }
                if (scriptVariable.tok == 4 || scriptVariable2.tok == 4) {
                    return ScriptVariable.sValue(scriptVariable).compareTo(ScriptVariable.sValue(scriptVariable2));
                }
            }
            switch (scriptVariable.tok) {
                case 4: {
                    return ScriptVariable.sValue(scriptVariable).compareTo(ScriptVariable.sValue(scriptVariable2));
                }
                case 7: {
                    List list = scriptVariable.getList();
                    List list2 = scriptVariable2.getList();
                    if (list.size() != list2.size()) {
                        return list.size() < list2.size() ? -1 : 1;
                    }
                    int n = this.arrayPt;
                    if (n < 0) {
                        n += list.size();
                    }
                    if (n < 0 || n >= list.size()) {
                        return 0;
                    }
                    return this.compare(list.get(n), list2.get(n));
                }
            }
            float f = ScriptVariable.fValue(scriptVariable);
            float f3 = ScriptVariable.fValue(scriptVariable2);
            return f < f3 ? -1 : (f > f3 ? 1 : 0);
        }
    }
}

