/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.exceptions.AmbitIOException;
import ambit2.core.io.DelimitedFileFormat;
import ambit2.core.io.DelimitedFileWriter;
import ambit2.core.io.FileState;
import ambit2.core.io.IOutputState;
import ambit2.core.io.MDLWriter;
import ambit2.core.io.PDFWriter;
import ambit2.core.io.XLSFileWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.HINWriter;
import org.openscience.cdk.io.IChemObjectWriter;
import org.openscience.cdk.io.SMILESWriter;
import org.openscience.cdk.io.XYZWriter;

public class FileOutputState
extends FileState
implements IOutputState {
    public static final transient int SDF_INDEX = 0;
    public static final transient int CSV_INDEX = 1;
    public static final transient int SMI_INDEX = 2;
    public static final transient int TXT_INDEX = 3;
    public static final transient int CML_INDEX = 4;
    public static final transient int MOL_INDEX = 5;
    public static final transient int HIN_INDEX = 6;
    public static final transient int PDB_INDEX = 7;
    public static final transient int XYZ_INDEX = 8;
    public static final transient int XLS_INDEX = 9;
    public static final transient int HTML_INDEX = 10;
    public static final transient int PDF_INDEX = 11;
    public static final transient int SVG_INDEX = 12;
    public static final transient int JPG_INDEX = 13;
    public static final transient int PNG_INDEX = 14;
    public static final transient int RTF_INDEX = 15;
    public static final transient String[] extensions = new String[]{".sdf", ".csv", ".smi", ".txt", ".cml", ".mol", ".hin", ".pdb", ".xyz", ".xls", ".html", ".pdf", ".svg", ".jpg", ".png", ".rtf"};
    public static final transient String[] extensionDescription = new String[]{"SDF files with chemical compounds (*.sdf)", "CSV files (Comma delimited) *.csv)", "SMILES files (*.smi)", "Text files (Tab delimited) (*.txt)", "Chemical Markup Language files (*.cml)", "MOL files (*.mol)", "HIN files (*.hin)", "PDB files (*.pdb)", "XYZ files (*.xyz)", "Microsoft Office Excel Workbook (*.xls)", "HTML (*.html)", "Adobe PDF (*.pdf)", "SVG (*.svg)", "JPEG image (*.jpg)", "PNG image (*.png)", "Rich Text Format (*.rtf)"};

    public FileOutputState() {
        this.setSupportedExtDescriptions(extensionDescription);
        this.setSupportedExtensions(extensions);
    }

    public FileOutputState(String string) {
        super(string);
        this.setSupportedExtDescriptions(extensionDescription);
        this.setSupportedExtensions(extensions);
    }

    public FileOutputState(File file) {
        super(file);
        this.setSupportedExtDescriptions(extensionDescription);
        this.setSupportedExtensions(extensions);
    }

    @Override
    public IChemObjectWriter getWriter() throws AmbitIOException {
        IChemObjectWriter iChemObjectWriter = null;
        try {
            iChemObjectWriter = FileOutputState.getWriter(new FileOutputStream(this.getFile(), this.currentRecord > 0L), this.filename.toLowerCase());
        }
        catch (Exception exception) {
            throw new AmbitIOException(MSG_ERRORSAVE, (Throwable)exception);
        }
        return iChemObjectWriter;
    }

    public static IChemObjectWriter getWriter(OutputStream outputStream, String string) throws AmbitIOException {
        DefaultChemObjectWriter defaultChemObjectWriter;
        block11: {
            String string2 = string.toLowerCase();
            defaultChemObjectWriter = null;
            try {
                if (string2.endsWith(extensions[0])) {
                    defaultChemObjectWriter = new MDLWriter(outputStream);
                    defaultChemObjectWriter.dontWriteAromatic();
                    break block11;
                }
                if (string2.endsWith(extensions[1])) {
                    defaultChemObjectWriter = new DelimitedFileWriter(outputStream);
                    break block11;
                }
                if (string2.endsWith(extensions[3])) {
                    defaultChemObjectWriter = new DelimitedFileWriter(outputStream, new DelimitedFileFormat("\t", '\"'));
                    break block11;
                }
                if (string2.endsWith(extensions[2])) {
                    defaultChemObjectWriter = new SMILESWriter(outputStream);
                    break block11;
                }
                if (string2.endsWith(extensions[11])) {
                    defaultChemObjectWriter = new PDFWriter(outputStream);
                    break block11;
                }
                if (string2.endsWith(extensions[8])) {
                    defaultChemObjectWriter = new XYZWriter(outputStream);
                    break block11;
                }
                if (string2.endsWith(extensions[6])) {
                    defaultChemObjectWriter = new HINWriter(outputStream);
                    break block11;
                }
                if (string2.endsWith(extensions[5])) {
                    defaultChemObjectWriter = new MDLWriter(outputStream);
                    break block11;
                }
                if (string2.endsWith(extensions[9])) {
                    defaultChemObjectWriter = new XLSFileWriter(outputStream);
                    break block11;
                }
                throw new AmbitIOException(MSG_UNSUPPORTEDFORMAT + string);
            }
            catch (Exception exception) {
                throw new AmbitIOException(MSG_ERRORSAVE, (Throwable)exception);
            }
        }
        return defaultChemObjectWriter;
    }

    public static String getResponseType(String string) {
        if (string.endsWith(extensions[0])) {
            return "text/plain";
        }
        if (string.endsWith(extensions[2])) {
            return "text/plain";
        }
        if (string.endsWith(extensions[1])) {
            return "application/vnd.ms-excel";
        }
        if (string.endsWith(extensions[3])) {
            return "text/plain";
        }
        if (string.endsWith(extensions[13])) {
            return "image/jpeg";
        }
        if (string.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (string.endsWith(extensions[14])) {
            return "image/png";
        }
        return "text/plain";
    }
}

