/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.core.data.MoleculeTools;
import ambit2.smarts.IsomorphismTester;
import ambit2.smarts.RingQueryBond;
import ambit2.smarts.SmartsAtomExpression;
import ambit2.smarts.SmartsBondExpression;
import ambit2.smarts.SmartsExpressionToken;
import ambit2.smarts.SmartsHelper;
import ambit2.smarts.SmartsParser;
import ambit2.smarts.TopLayer;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.AnyOrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.OrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSBond;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class SmartsManager {
    int recursiveStrategy = 1;
    boolean FlagSetSmartsDataForTarget = true;
    boolean FlagUseCDKIsomorphismTester = true;
    SmartsParser parser = new SmartsParser();
    IsomorphismTester isoTester = new IsomorphismTester();
    String querySmarts;
    String errorMsg = "";
    QueryAtomContainer query;
    Vector<SmartsAtomExpression> recAtoms = new Vector();
    IAtom[] newAtoms;
    int[] recAtomNumSubSmarts;
    int[] recAtomLastLoAnd;
    int[] curComb;
    Vector<QueryAtomContainer> subQueryList = new Vector();
    TopLayer[] topLayers;
    Vector<Integer> bondRecAt1 = new Vector();
    Vector<Integer> bondRecAt2 = new Vector();
    Vector<IBond> bondRecBo = new Vector();
    Vector<Integer> compFrags = new Vector();
    boolean[][] fragMaps;
    int[] components;
    QueryAtomContainer baseStr;
    public boolean mGenerateSubQueries;
    protected IChemObjectBuilder builder;

    public boolean isFlagUseCDKIsomorphismTester() {
        return this.FlagUseCDKIsomorphismTester;
    }

    public SmartsManager(IChemObjectBuilder builder) {
        this.builder = builder == null ? SilentChemObjectBuilder.getInstance() : builder;
        this.parser.setComponentLevelGrouping(true);
    }

    public void setQuery(String smQuery) {
        this.querySmarts = smQuery;
        this.query = this.parser.parse(this.querySmarts);
        this.parser.setNeededDataFlags();
        this.errorMsg = this.parser.getErrorMessages();
        if (!this.errorMsg.equals("")) {
            System.out.println("Smarts Parser errors:\n" + this.errorMsg);
            this.query = null;
            return;
        }
        if (this.parser.hasRecursiveSmarts) {
            this.getRecursiveAtoms();
            if (this.recursiveStrategy == 0) {
                this.analyseRecursiveAtoms();
                if (this.mGenerateSubQueries) {
                    this.genSubQueries();
                }
            }
        }
    }

    public String getErrors() {
        return this.errorMsg;
    }

    public QueryAtomContainer getQueryContaner() {
        return this.query;
    }

    public void setSmartsDataForTarget(boolean flag) {
        this.FlagSetSmartsDataForTarget = flag;
    }

    public void calcSmartsDataForTarget(IAtomContainer mol) throws Exception {
        this.parser.setSMARTSData(mol);
    }

    public void setUseCDKIsomorphismTester(boolean flag) {
        this.FlagUseCDKIsomorphismTester = flag;
    }

    public void supportMOEExtension(boolean support) {
        this.parser.mSupportMOEExtension = support;
    }

    public void supportOpenEyeExtension(boolean support) {
        this.parser.mSupportOpenEyeExtension = support;
    }

    public void supportOpenBabelExtension(boolean support) {
        this.parser.mSupportOpenBabelExtension = support;
    }

    public void supportDoubleBondAromaticityNotSpecified(boolean support) {
        this.parser.mSupportDoubleBondAromaticityNotSpecified = support;
    }

    public void useMOEvPrimitive(boolean support) {
        this.parser.mUseMOEvPrimitive = support;
    }

    public boolean getSupportMOEExtension() {
        return this.parser.mSupportMOEExtension;
    }

    public boolean getSupportOpenEyeExtension() {
        return this.parser.mSupportOpenEyeExtension;
    }

    public boolean getSupportOpenBabelExtension() {
        return this.parser.mSupportOpenBabelExtension;
    }

    public boolean getSupportDoubleBondAromaticityNotSpecified() {
        return this.parser.mSupportDoubleBondAromaticityNotSpecified;
    }

    public boolean getUseMOEvPrimitive() {
        return this.parser.mUseMOEvPrimitive;
    }

    public boolean searchIn(IAtomContainer target) throws Exception {
        if (this.query == null) {
            return false;
        }
        if (this.FlagSetSmartsDataForTarget) {
            this.parser.setSMARTSData(target);
        }
        if (this.parser.numFragments > 1) {
            return this.fragmentSearchIn(target);
        }
        if (this.parser.hasRecursiveSmarts) {
            return this.recursiveSearchIn1(target);
        }
        return this.mappingIn(target);
    }

    boolean mappingIn(IAtomContainer target) throws Exception {
        if (this.FlagUseCDKIsomorphismTester) {
            boolean res = UniversalIsomorphismTester.isSubgraph((IAtomContainer)target, (IAtomContainer)this.query);
            return res;
        }
        this.isoTester.setQuery(this.query);
        return this.isoTester.hasIsomorphism(target);
    }

    boolean fragmentSearchIn(IAtomContainer target) throws Exception {
        int i;
        int i2;
        boolean noComponentsSpecified = true;
        for (i2 = 0; i2 < this.parser.fragmentComponents.size(); ++i2) {
            if (this.parser.fragmentComponents.get(i2) <= 0) continue;
            noComponentsSpecified = false;
            break;
        }
        if (this.parser.hasRecursiveSmarts) {
            this.clearQueryRecMatches();
            this.getQueryRecMatches(target);
        }
        if (noComponentsSpecified) {
            for (i2 = 0; i2 < this.parser.fragments.size(); ++i2) {
                this.query = this.parser.fragments.get(i2);
                if (this.mappingIn(target)) continue;
                return false;
            }
            return true;
        }
        IMoleculeSet ms = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)target);
        if (ms.getAtomContainerCount() < this.parser.maxCompNumber) {
            return false;
        }
        this.compFrags.clear();
        for (i = 0; i < this.parser.fragments.size(); ++i) {
            if (this.parser.fragmentComponents.get(i) == 0) {
                this.query = this.parser.fragments.get(i);
                boolean res = this.mappingIn(target);
                if (res) continue;
                return false;
            }
            this.compFrags.add(new Integer(i));
        }
        this.fragMaps = new boolean[this.compFrags.size()][ms.getAtomContainerCount()];
        this.components = new int[this.compFrags.size()];
        for (i = 0; i < this.compFrags.size(); ++i) {
            this.components[i] = this.parser.fragmentComponents.get(this.compFrags.get(i));
            for (int j = 0; j < ms.getAtomContainerCount(); ++j) {
                this.query = this.parser.fragments.get(this.compFrags.get(i));
                this.fragMaps[i][j] = this.mappingIn(ms.getAtomContainer(j));
            }
        }
        return this.checkComponentMapings();
    }

    void printComponentFrags() {
        System.out.println("---------------------------");
        SmartsHelper sh = new SmartsHelper(this.builder);
        for (int i = 0; i < this.compFrags.size(); ++i) {
            for (int k = 0; k < this.fragMaps[i].length; ++k) {
                System.out.print(this.fragMaps[i][k] ? "1 " : "0 ");
            }
            String frag = sh.toSmarts(this.parser.fragments.get(this.compFrags.get(i)));
            System.out.print(frag);
            System.out.println("  " + this.components[i]);
        }
        System.out.println("---------------------------");
    }

    boolean checkComponentMapings() {
        int[] a;
        Stack<int[]> comb = new Stack<int[]>();
        for (int k = 0; k < this.fragMaps[0].length; ++k) {
            if (!this.fragMaps[0][k]) continue;
            a = new int[this.components.length];
            this.resetCombination(a);
            a[0] = k;
            if (this.setComponentInCombination(0, a) == null) continue;
            comb.push(a);
        }
        boolean compMapResult = false;
        while (!comb.empty() && !compMapResult) {
            a = (int[])comb.pop();
            compMapResult = this.addComponentToCombination(a, comb);
        }
        return compMapResult;
    }

    void resetCombination(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = -1;
        }
    }

    boolean addComponentToCombination(int[] a, Stack<int[]> comb) {
        int n = this.firstElementInCombination(-1, a);
        if (n == -1) {
            return true;
        }
        for (int k = 0; k < this.fragMaps[n].length; ++k) {
            if (!this.fragMaps[n][k]) continue;
            int[] newC = (int[])a.clone();
            newC[n] = k;
            if (this.setComponentInCombination(n, newC) == null) continue;
            comb.push(newC);
        }
        return false;
    }

    int[] setComponentInCombination(int n, int[] a) {
        for (int i = n + 1; i < this.components.length && this.components[i] == this.components[n]; ++i) {
            if (!this.fragMaps[i][a[n]]) {
                return null;
            }
            a[i] = a[n];
        }
        return a;
    }

    int firstElementInCombination(int el, int[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != el) continue;
            return i;
        }
        return -1;
    }

    void getRecursiveAtoms() {
        this.recAtoms.clear();
        for (int i = 0; i < this.query.getAtomCount(); ++i) {
            if (!(this.query.getAtom(i) instanceof SmartsAtomExpression)) continue;
            SmartsAtomExpression sa = (SmartsAtomExpression)this.query.getAtom(i);
            if (sa.recSmartsStrings.size() <= 0) continue;
            this.recAtoms.add(sa);
        }
    }

    void analyseRecursiveAtoms() {
        this.mGenerateSubQueries = true;
        this.recAtomNumSubSmarts = new int[this.recAtoms.size()];
        this.recAtomLastLoAnd = new int[this.recAtoms.size()];
        for (int i = 0; i < this.recAtoms.size(); ++i) {
            SmartsAtomExpression sa = this.recAtoms.get(i);
            int lastLoAnd = this.getLastLoAndOperation(sa);
            if (this.getFirstRecursiveSmarts(sa) < lastLoAnd) {
                this.mGenerateSubQueries = false;
                return;
            }
            for (int j = lastLoAnd + 1; j < sa.tokens.size(); ++j) {
                SmartsExpressionToken token = sa.tokens.get(j);
                if (token.isLogicalOperation()) {
                    if (token.getLogOperation() == 2) continue;
                    this.mGenerateSubQueries = false;
                    return;
                }
                if (token.type == 14) continue;
                this.mGenerateSubQueries = false;
                return;
            }
            this.recAtomNumSubSmarts[i] = sa.recSmartsStrings.size();
            this.recAtomLastLoAnd[i] = lastLoAnd;
        }
    }

    int getLastLoAndOperation(SmartsAtomExpression sa) {
        int lastLoAnd = -1;
        for (int j = 0; j < sa.tokens.size(); ++j) {
            SmartsExpressionToken token = sa.tokens.get(j);
            if (!token.isLogicalOperation() || token.getLogOperation() != 3) continue;
            lastLoAnd = j;
        }
        return lastLoAnd;
    }

    int getFirstRecursiveSmarts(SmartsAtomExpression sa) {
        for (int j = 0; j < sa.tokens.size(); ++j) {
            SmartsExpressionToken token = sa.tokens.get(j);
            if (token.type == 14) continue;
            return j;
        }
        return sa.tokens.size();
    }

    void firstComb() {
        for (int i = 0; i < this.curComb.length; ++i) {
            this.curComb[i] = 0;
        }
    }

    void incComb(int pos) {
        int n = pos;
        this.curComb[n] = this.curComb[n] + 1;
        if (this.curComb[pos] >= this.recAtomNumSubSmarts[pos]) {
            if (pos == this.curComb.length - 1) {
                this.curComb = null;
            } else {
                this.curComb[pos] = 0;
                this.incComb(pos + 1);
            }
        }
    }

    void genSubQueries() {
        this.setRecAtomNeighbours();
        this.subQueryList.clear();
        this.curComb = new int[this.recAtomNumSubSmarts.length];
        this.firstComb();
        this.gatBaseStructure();
        while (this.curComb != null) {
            this.newAtoms = new IAtom[this.curComb.length];
            QueryAtomContainer subQuery = new QueryAtomContainer();
            subQuery.add((IAtomContainer)this.baseStr);
            for (int i = 0; i < this.curComb.length; ++i) {
                this.expandBaseStruct(subQuery, i);
            }
            this.restoreRecAtomBonds(subQuery);
            this.subQueryList.add(subQuery);
            this.incComb(0);
        }
    }

    void gatBaseStructure() {
        this.baseStr = new QueryAtomContainer();
        this.baseStr.add((IAtomContainer)this.query);
        for (int i = 0; i < this.recAtoms.size(); ++i) {
            this.baseStr.removeAtomAndConnectedElectronContainers((IAtom)this.recAtoms.get(i));
        }
    }

    void setRecAtomNeighbours() {
        int i;
        this.topLayers = new TopLayer[this.recAtoms.size()];
        for (i = 0; i < this.recAtoms.size(); ++i) {
            this.topLayers[i] = new TopLayer();
        }
        for (i = 0; i < this.query.getBondCount(); ++i) {
            IBond bond = this.query.getBond(i);
            int k0 = this.getRecAtomIndex(bond.getAtom(0));
            int k1 = this.getRecAtomIndex(bond.getAtom(1));
            if (k0 >= 0) {
                if (k1 >= 0) {
                    this.bondRecAt1.add(new Integer(k0));
                    this.bondRecAt2.add(new Integer(k1));
                    this.bondRecBo.add(bond);
                    continue;
                }
                this.topLayers[k0].atoms.add(bond.getAtom(1));
                this.topLayers[k0].bonds.add(bond);
                continue;
            }
            if (k1 < 0) continue;
            this.topLayers[k1].atoms.add(bond.getAtom(0));
            this.topLayers[k1].bonds.add(bond);
        }
    }

    int getRecAtomIndex(Object o) {
        for (int i = 0; i < this.recAtoms.size(); ++i) {
            if (this.recAtoms.get(i) != o) continue;
            return i;
        }
        return -1;
    }

    void expandBaseStruct(QueryAtomContainer struct, int pos) {
        int i;
        SmartsAtomExpression sa = this.recAtoms.get(pos);
        QueryAtomContainer fragment = sa.recSmartsContainers.get(this.curComb[pos]);
        if (this.recAtomLastLoAnd[pos] <= -1) {
            struct.addAtom(fragment.getFirstAtom());
            this.newAtoms[pos] = fragment.getFirstAtom();
        }
        TopLayer tl = this.topLayers[pos];
        for (i = 0; i < tl.atoms.size(); ++i) {
            this.addBond(struct, fragment.getFirstAtom(), tl.atoms.get(i), tl.bonds.get(i));
        }
        for (i = 1; i < fragment.getAtomCount(); ++i) {
            struct.addAtom(fragment.getAtom(i));
        }
        for (i = 0; i < fragment.getBondCount(); ++i) {
            struct.addBond(fragment.getBond(i));
        }
    }

    void addBond(QueryAtomContainer container, IAtom atom0, IAtom atom1, IBond bond) {
        Object newBond = null;
        if (bond instanceof AnyOrderQueryBond) {
            newBond = new AnyOrderQueryBond();
        } else if (bond instanceof OrderQueryBond) {
            newBond = new AnyOrderQueryBond();
            newBond.setOrder(bond.getOrder());
        } else if (bond instanceof AromaticQueryBond) {
            newBond = new AromaticQueryBond();
        } else if (bond instanceof RingQueryBond) {
            newBond = new RingQueryBond();
        } else if (bond instanceof SmartsBondExpression) {
            newBond = new SmartsBondExpression();
            ((SmartsBondExpression)((Object)newBond)).tokens = ((SmartsBondExpression)bond).tokens;
        } else {
            newBond = new AnyOrderQueryBond();
            newBond.setOrder(IBond.Order.SINGLE);
        }
        IAtom[] atoms = new IAtom[]{atom0, atom1};
        newBond.setAtoms(atoms);
        container.addBond((IBond)newBond);
    }

    void restoreRecAtomBonds(QueryAtomContainer container) {
        for (int i = 0; i < this.bondRecAt1.size(); ++i) {
            int k1 = this.bondRecAt1.get(i);
            int k2 = this.bondRecAt2.get(i);
            this.addBond(container, this.newAtoms[k1], this.newAtoms[k2], this.bondRecBo.get(i));
        }
    }

    boolean recursiveSearchIn0(IAtomContainer target) throws Exception {
        for (int i = 0; i < this.subQueryList.size(); ++i) {
            QueryAtomContainer subQuery = this.subQueryList.get(i);
            boolean res = UniversalIsomorphismTester.isSubgraph((IAtomContainer)target, (IAtomContainer)subQuery);
            if (!res) continue;
            return true;
        }
        return false;
    }

    public IAtomContainerSet getAllIsomorphismMappings(IAtomContainer target) throws Exception {
        IAtomContainerSet s = MoleculeTools.newAtomContainerSet(SilentChemObjectBuilder.getInstance());
        if (this.query == null) {
            return s;
        }
        if (this.FlagUseCDKIsomorphismTester) {
            if (this.query.getAtomCount() < 3) {
                if (this.FlagSetSmartsDataForTarget) {
                    this.parser.setSMARTSData(target);
                }
                if (this.parser.hasRecursiveSmarts) {
                    this.clearQueryRecMatches();
                    this.getQueryRecMatches(target);
                }
            }
            if (this.query.getAtomCount() == 1) {
                Vector<IAtom> v = this.getAtomMappingsFor1AtomQuery(target, (IAtomContainer)this.query);
                for (int i = 0; i < v.size(); ++i) {
                    IMolecule c = MoleculeTools.newMolecule(SilentChemObjectBuilder.getInstance());
                    c.addAtom(v.get(i));
                    s.addAtomContainer((IAtomContainer)c);
                }
                return s;
            }
            if (this.query.getAtomCount() == 2) {
                return this.getAllIsomorphismMappingsFor2AtomQuery(target, (IAtomContainer)this.query);
            }
            List maps = this.getBondMappings(target);
            for (List bondMap : maps) {
                IAtomContainer c = this.generateFullIsomorphismMapping(bondMap, target, (IAtomContainer)this.query);
                s.addAtomContainer(c);
            }
            return s;
        }
        return s;
    }

    boolean recursiveSearchIn1(IAtomContainer target) throws Exception {
        this.clearQueryRecMatches();
        this.getQueryRecMatches(target);
        return this.mappingIn(target);
    }

    public Vector<IAtom> getFirstPosAtomMappings(IAtomContainer target) throws Exception {
        if (this.query == null) {
            return null;
        }
        if (this.FlagSetSmartsDataForTarget) {
            this.parser.setSMARTSData(target);
        }
        if (this.parser.hasRecursiveSmarts) {
            this.clearQueryRecMatches();
            this.getQueryRecMatches(target);
        }
        return this.getFirstPosAtomMappings(target, (IAtomContainer)this.query);
    }

    public List getBondMappings(IAtomContainer target) throws Exception {
        List bondList;
        if (this.query == null) {
            return null;
        }
        if (this.FlagSetSmartsDataForTarget) {
            this.parser.setSMARTSData(target);
        }
        if (this.parser.hasRecursiveSmarts) {
            this.clearQueryRecMatches();
            this.getQueryRecMatches(target);
        }
        try {
            bondList = UniversalIsomorphismTester.getSubgraphMaps((IAtomContainer)target, (IAtomContainer)this.query);
        }
        catch (CDKException e) {
            bondList = null;
        }
        return bondList;
    }

    void clearQueryRecMatches() {
        for (int i = 0; i < this.recAtoms.size(); ++i) {
            this.recAtoms.get((int)i).recSmartsMatches = new Vector();
        }
    }

    void getQueryRecMatches(IAtomContainer target) throws Exception {
        for (int i = 0; i < this.recAtoms.size(); ++i) {
            Vector<QueryAtomContainer> vRecCon = this.recAtoms.get((int)i).recSmartsContainers;
            for (int j = 0; j < vRecCon.size(); ++j) {
                Vector<IAtom> v = this.FlagUseCDKIsomorphismTester ? this.getFirstPosAtomMappings(target, (IAtomContainer)vRecCon.get(j)) : this.getFirstPosAtomMappings_CurrentIsoTester(target, vRecCon.get(j));
                this.recAtoms.get((int)i).recSmartsMatches.add(v);
            }
        }
    }

    public String matchesToString(IAtomContainer target, Vector<IAtom> atomMaps) {
        StringBuffer sb = new StringBuffer();
        for (IAtom at : atomMaps) {
            sb.append(" " + target.getAtomNumber(at));
        }
        return sb.toString();
    }

    Vector<IAtom> getFirstPosAtomMappings_CurrentIsoTester(IAtomContainer target, QueryAtomContainer recQuery) {
        this.isoTester.setQuery(recQuery);
        Vector<Integer> pos = this.isoTester.getIsomorphismPositions(target);
        Vector<IAtom> v = new Vector<IAtom>();
        for (int i = 0; i < pos.size(); ++i) {
            v.add(target.getAtom(pos.get(i).intValue()));
        }
        return v;
    }

    Vector<IAtom> getFirstPosAtomMappings(IAtomContainer target, IAtomContainer recQuery) throws Exception {
        if (recQuery.getAtomCount() == 1) {
            return this.getAtomMappingsFor1AtomQuery(target, recQuery);
        }
        if (recQuery.getAtomCount() == 2) {
            return this.getFirstPosAtomMappingsFor2AtomQuery(target, recQuery);
        }
        List bondMaps = UniversalIsomorphismTester.getSubgraphMaps((IAtomContainer)target, (IAtomContainer)recQuery);
        return this.getAtomMapsFromBondMaps(bondMaps, target, recQuery);
    }

    Vector<IAtom> getAtomMappingsFor1AtomQuery(IAtomContainer target, IAtomContainer recQuery) {
        SMARTSAtom qAtom = (SMARTSAtom)recQuery.getAtom(0);
        Vector<IAtom> atomMaps = new Vector<IAtom>();
        for (int i = 0; i < target.getAtomCount(); ++i) {
            if (!qAtom.matches(target.getAtom(i))) continue;
            atomMaps.add(target.getAtom(i));
        }
        return atomMaps;
    }

    Vector<IAtom> getFirstPosAtomMappingsFor2AtomQuery(IAtomContainer target, IAtomContainer recQuery) {
        Vector<IAtom> atomMaps = new Vector<IAtom>();
        if (recQuery.getBondCount() == 0) {
            return atomMaps;
        }
        SMARTSAtom qAtom0 = (SMARTSAtom)recQuery.getAtom(0);
        SMARTSAtom qAtom1 = (SMARTSAtom)recQuery.getAtom(1);
        SMARTSBond qBond = (SMARTSBond)recQuery.getBond(0);
        block0: for (int i = 0; i < target.getAtomCount(); ++i) {
            IAtom at = target.getAtom(i);
            if (!qAtom0.matches(at)) continue;
            List ca = target.getConnectedAtomsList(at);
            for (int j = 0; j < ca.size(); ++j) {
                IBond bo;
                if (!qAtom1.matches((IAtom)ca.get(j)) || (bo = target.getBond(at, (IAtom)ca.get(j))) == null || !qBond.matches(bo)) continue;
                atomMaps.add(at);
                continue block0;
            }
        }
        return atomMaps;
    }

    IAtomContainerSet getAllIsomorphismMappingsFor2AtomQuery(IAtomContainer target, IAtomContainer recQuery) {
        IAtomContainerSet s = MoleculeTools.newAtomContainerSet(SilentChemObjectBuilder.getInstance());
        if (recQuery.getBondCount() == 0) {
            return s;
        }
        SMARTSAtom qAtom0 = (SMARTSAtom)recQuery.getAtom(0);
        SMARTSAtom qAtom1 = (SMARTSAtom)recQuery.getAtom(1);
        SMARTSBond qBond = (SMARTSBond)recQuery.getBond(0);
        for (int i = 0; i < target.getAtomCount(); ++i) {
            IAtom at = target.getAtom(i);
            if (!qAtom0.matches(at)) continue;
            List ca = target.getConnectedAtomsList(at);
            for (int j = 0; j < ca.size(); ++j) {
                IBond bo;
                if (!qAtom1.matches((IAtom)ca.get(j)) || (bo = target.getBond(at, (IAtom)ca.get(j))) == null || !qBond.matches(bo)) continue;
                IMolecule c = MoleculeTools.newMolecule(SilentChemObjectBuilder.getInstance());
                c.addAtom(at);
                c.addAtom((IAtom)ca.get(j));
                c.addBond(bo);
                s.addAtomContainer((IAtomContainer)c);
            }
        }
        return s;
    }

    Vector<IAtom> getAtomMapsFromBondMaps(List bondMapping, IAtomContainer target, IAtomContainer recQuery) {
        Vector<IAtom> atomMaps = new Vector<IAtom>();
        if (recQuery.getBondCount() < 2) {
            return atomMaps;
        }
        SMARTSBond qBond0 = (SMARTSBond)recQuery.getBond(0);
        SMARTSBond qBond1 = (SMARTSBond)recQuery.getBond(1);
        int qID0 = recQuery.getBondNumber((IBond)qBond0);
        int qID1 = recQuery.getBondNumber((IBond)qBond1);
        SMARTSAtom qAtom0 = (SMARTSAtom)recQuery.getAtom(0);
        SMARTSAtom qAtom1 = (SMARTSAtom)recQuery.getAtom(1);
        IAtom commonQAt = this.getBondsCommonAtom((IBond)qBond0, (IBond)qBond1);
        if (commonQAt != qAtom0 && commonQAt != qAtom1) {
            return atomMaps;
        }
        IBond tBond0 = null;
        IBond tBond1 = null;
        for (Object aList : bondMapping) {
            List mapList = (List)aList;
            int found = 0;
            for (Object aMap : mapList) {
                RMap map = (RMap)aMap;
                if (map.getId2() == qID0) {
                    ++found;
                    tBond0 = target.getBond(map.getId1());
                }
                if (map.getId2() == qID1) {
                    ++found;
                    tBond1 = target.getBond(map.getId1());
                }
                if (found < 2) continue;
                break;
            }
            if (found < 2) continue;
            IAtom commonTAt = this.getBondsCommonAtom(tBond0, tBond1);
            if (commonQAt == qAtom0) {
                atomMaps.add(commonTAt);
                continue;
            }
            if (commonTAt == tBond0.getAtom(0)) {
                atomMaps.add(tBond0.getAtom(1));
                continue;
            }
            atomMaps.add(tBond0.getAtom(0));
        }
        return atomMaps;
    }

    public Vector<IAtom> generateFullAtomMapping(List bondMapList, IAtomContainer target, IAtomContainer queryStr) {
        int tBoNum0;
        int qBoNum0;
        List conAtList;
        IAtom qAt;
        int i;
        Vector<IAtom> atomMaps = new Vector<IAtom>();
        if (queryStr.getAtomCount() < 3 || queryStr.getBondCount() < 2) {
            return atomMaps;
        }
        IAtom[] atMaps = new IAtom[queryStr.getAtomCount()];
        for (int i2 = 0; i2 < atMaps.length; ++i2) {
            atMaps[i2] = null;
        }
        for (i = 0; i < queryStr.getAtomCount(); ++i) {
            qAt = queryStr.getAtom(i);
            conAtList = queryStr.getConnectedAtomsList(qAt);
            if (conAtList.size() <= 1) continue;
            qBoNum0 = queryStr.getBondNumber(qAt, (IAtom)conAtList.get(0));
            tBoNum0 = this.getTargetPartnerBondID(qBoNum0, bondMapList);
            int qBoNum1 = queryStr.getBondNumber(qAt, (IAtom)conAtList.get(1));
            int tBoNum1 = this.getTargetPartnerBondID(qBoNum1, bondMapList);
            atMaps[i] = this.getBondsCommonAtom(target.getBond(tBoNum0), target.getBond(tBoNum1));
        }
        for (i = 0; i < queryStr.getAtomCount(); ++i) {
            IBond b;
            if (atMaps[i] != null || (conAtList = queryStr.getConnectedAtomsList(qAt = queryStr.getAtom(i))).size() != 1) continue;
            int neighborNum = queryStr.getAtomNumber((IAtom)conAtList.get(0));
            atMaps[i] = atMaps[neighborNum] == (b = target.getBond(tBoNum0 = this.getTargetPartnerBondID(qBoNum0 = queryStr.getBondNumber(qAt, (IAtom)conAtList.get(0)), bondMapList))).getAtom(0) ? b.getAtom(1) : b.getAtom(0);
        }
        for (i = 0; i < atMaps.length; ++i) {
            atomMaps.add(atMaps[i]);
        }
        return atomMaps;
    }

    public IAtomContainer generateFullIsomorphismMapping(List bondMapList, IAtomContainer target, IAtomContainer queryStr) {
        Vector<IAtom> v = this.generateFullAtomMapping(bondMapList, target, queryStr);
        IMolecule ac = MoleculeTools.newMolecule(SilentChemObjectBuilder.getInstance());
        for (int i = 0; i < v.size(); ++i) {
            ac.addAtom(v.get(i));
        }
        for (Object aMap : bondMapList) {
            RMap map = (RMap)aMap;
            int targetBondNum = map.getId1();
            ac.addBond(target.getBond(targetBondNum));
        }
        return ac;
    }

    int getTargetPartnerBondID(int queryBondID, List mapList) {
        for (Object aMap : mapList) {
            RMap map = (RMap)aMap;
            if (map.getId2() != queryBondID) continue;
            return map.getId1();
        }
        return 0;
    }

    IAtom getBondsCommonAtom(IBond b1, IBond b2) {
        if (b1.contains(b2.getAtom(0))) {
            return b2.getAtom(0);
        }
        if (b1.contains(b2.getAtom(1))) {
            return b2.getAtom(1);
        }
        return null;
    }

    public void testCombinations() {
        this.recAtomNumSubSmarts = new int[]{3, 4, 5};
        this.curComb = new int[this.recAtomNumSubSmarts.length];
        this.firstComb();
        while (this.curComb != null) {
            for (int i = this.curComb.length - 1; i >= 0; --i) {
                System.out.print(this.curComb[i] + " ");
            }
            System.out.println();
            this.incComb(0);
        }
    }

    public void testTopLayers() {
        for (int i = 0; i < this.topLayers.length; ++i) {
            TopLayer tl = this.topLayers[i];
            System.out.print("  : ");
            for (int j = 0; j < tl.atoms.size(); ++j) {
                System.out.print(SmartsHelper.atomToString((IAtom)((SMARTSAtom)tl.atoms.get(j))) + " " + tl.bonds.get(j).getOrder() + "   ");
            }
            System.out.println();
        }
    }

    public void testSubQueries() {
        SmartsHelper smwriter = new SmartsHelper(this.builder);
        for (int i = 0; i < this.subQueryList.size(); ++i) {
            System.out.println("subQuery " + i + "  " + smwriter.toSmarts(this.subQueryList.get(i)));
        }
    }
}

