/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.SmartsHelper;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class SequenceElement {
    IAtom center;
    IAtom[] atoms;
    IBond[] bonds;
    int[] atomNums;
    int centerNum;

    public void setAtomNums(IAtomContainer container) {
        this.centerNum = this.center != null ? container.getAtomNumber(this.center) : -1;
        this.atomNums = new int[this.atoms.length];
        for (int i = 0; i < this.atoms.length; ++i) {
            this.atomNums[i] = container.getAtomNumber(this.atoms[i]);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.center == null) {
            sb.append("Bond " + SmartsHelper.atomToString(this.atoms[0]) + " " + SmartsHelper.atomToString(this.atoms[1]) + "   " + SmartsHelper.bondToString(this.bonds[0]));
        } else {
            sb.append("Center = " + SmartsHelper.atomToString(this.center) + "  atoms: ");
            for (int i = 0; i < this.atoms.length; ++i) {
                sb.append("(" + SmartsHelper.atomToString(this.atoms[i]) + "," + SmartsHelper.bondToString(this.bonds[i]) + ") ");
            }
        }
        return sb.toString();
    }
}

