/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.core.io.MyIteratingMDLReader;
import ambit2.hashcode.MoleculeAndAtomsHashing;
import ambit2.smarts.ChemObjectToSmiles;
import ambit2.smarts.IsomorphismTester;
import ambit2.smarts.QuerySequenceElement;
import ambit2.smarts.SequenceElement;
import ambit2.smarts.SmartsManager;
import ambit2.smarts.SmartsParser;
import ambit2.smarts.SmartsToChemObject;
import ambit2.smarts.StructInfo;
import ambit2.smarts.TopLayer;
import java.io.File;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import org.openscience.cdk.Bond;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class ChemObjectFactory {
    public Vector<SequenceElement> sequence = new Vector();
    Vector<IAtom> sequencedAtoms = new Vector();
    Vector<IAtom> sequencedBondAt1 = new Vector();
    Vector<IAtom> sequencedBondAt2 = new Vector();
    MoleculeAndAtomsHashing molHash = new MoleculeAndAtomsHashing();
    SmartsManager man;
    SmartsParser parser = new SmartsParser();
    SmartsToChemObject stco;
    IsomorphismTester isoTester = new IsomorphismTester();
    IChemObjectBuilder builder;

    public ChemObjectFactory(IChemObjectBuilder builder) {
        this.setBuilder(builder);
        this.stco = new SmartsToChemObject(builder);
        this.man = new SmartsManager(builder);
    }

    public IChemObjectBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    public void setAtomSequence(IAtomContainer target, IAtom startAtom) {
        IAtom firstAtom = startAtom == null ? target.getFirstAtom() : startAtom;
        this.sequence.clear();
        this.sequencedAtoms.clear();
        this.sequencedBondAt1.clear();
        this.sequencedBondAt2.clear();
        if (target.getAtom(0).getProperty((Object)"TL") == null) {
            TopLayer.setAtomTopLayers(target, "TL");
        }
        this.sequencedAtoms.add(firstAtom);
        SequenceElement seqEl = new SequenceElement();
        seqEl.center = firstAtom;
        TopLayer topLayer = (TopLayer)firstAtom.getProperty((Object)"TL");
        int n = topLayer.atoms.size();
        seqEl.atoms = new IAtom[n];
        seqEl.bonds = new IBond[n];
        for (int i = 0; i < n; ++i) {
            this.sequencedAtoms.add(topLayer.atoms.get(i));
            seqEl.atoms[i] = topLayer.atoms.get(i);
            seqEl.bonds[i] = topLayer.bonds.get(i);
            this.addSeqBond(seqEl.center, seqEl.atoms[i]);
        }
        this.sequence.add(seqEl);
        Stack<SequenceElement> stack = new Stack<SequenceElement>();
        stack.push(seqEl);
        while (!stack.empty()) {
            SequenceElement curSeqAt = (SequenceElement)stack.pop();
            for (int i = 0; i < curSeqAt.atoms.length; ++i) {
                topLayer = (TopLayer)curSeqAt.atoms[i].getProperty((Object)"TL");
                if (topLayer.atoms.size() == 1) continue;
                int[] a = this.getSeqAtomsInLayer(topLayer);
                n = 0;
                for (int k = 0; k < a.length; ++k) {
                    if (a[k] != 0) continue;
                    ++n;
                }
                if (n > 0) {
                    seqEl = new SequenceElement();
                    seqEl.center = curSeqAt.atoms[i];
                    seqEl.atoms = new IAtom[n];
                    seqEl.bonds = new IBond[n];
                    this.sequence.add(seqEl);
                    stack.add(seqEl);
                }
                int j = 0;
                for (int k = 0; k < a.length; ++k) {
                    if (a[k] == 0) {
                        seqEl.atoms[j] = topLayer.atoms.get(k);
                        seqEl.bonds[j] = topLayer.bonds.get(k);
                        this.addSeqBond(seqEl.center, seqEl.atoms[j]);
                        this.sequencedAtoms.add(seqEl.atoms[j]);
                        ++j;
                        continue;
                    }
                    if (curSeqAt.center == topLayer.atoms.get(k) || this.getSeqBond(curSeqAt.atoms[i], topLayer.atoms.get(k)) != -1) continue;
                    SequenceElement newSeqEl = new SequenceElement();
                    newSeqEl.center = null;
                    newSeqEl.atoms = new IAtom[2];
                    newSeqEl.bonds = new IBond[1];
                    newSeqEl.atoms[0] = curSeqAt.atoms[i];
                    newSeqEl.atoms[1] = topLayer.atoms.get(k);
                    this.addSeqBond(newSeqEl.atoms[0], newSeqEl.atoms[1]);
                    newSeqEl.bonds[0] = topLayer.bonds.get(k);
                    this.sequence.add(newSeqEl);
                }
            }
        }
        for (int i = 0; i < this.sequence.size(); ++i) {
            this.sequence.get(i).setAtomNums(target);
        }
    }

    void addSeqBond(IAtom at1, IAtom at2) {
        this.sequencedBondAt1.add(at1);
        this.sequencedBondAt2.add(at2);
    }

    int[] getSeqAtomsInLayer(TopLayer topLayer) {
        int[] a = new int[topLayer.atoms.size()];
        for (int i = 0; i < topLayer.atoms.size(); ++i) {
            a[i] = this.containsAtom(this.sequencedAtoms, topLayer.atoms.get(i)) ? 1 : 0;
        }
        return a;
    }

    boolean containsAtom(Vector<IAtom> v, IAtom atom) {
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) != atom) continue;
            return true;
        }
        return false;
    }

    int getSeqBond(IAtom at1, IAtom at2) {
        for (int i = 0; i < this.sequencedBondAt1.size(); ++i) {
            if (!(this.sequencedBondAt1.get(i) == at1 ? this.sequencedBondAt2.get(i) == at2 : this.sequencedBondAt1.get(i) == at2 && this.sequencedBondAt2.get(i) == at1)) continue;
            return i;
        }
        return -1;
    }

    public IAtomContainer getFragmentFromSequence(int numSteps) {
        IAtomContainer mol = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        HashMap<IAtom, IAtom> m = new HashMap<IAtom, IAtom>();
        SequenceElement el = this.sequence.get(0);
        IAtom a0 = this.getAtomCopy(el.center);
        mol.addAtom(a0);
        m.put(el.center, a0);
        for (int k = 0; k < el.atoms.length; ++k) {
            IAtom a = this.getAtomCopy(el.atoms[k]);
            mol.addAtom(a);
            m.put(el.atoms[k], a);
            this.addBond(mol, (IAtom)m.get(el.center), a, el.bonds[k].getOrder(), el.bonds[k].getFlag(5));
        }
        for (int i = 1; i <= numSteps; ++i) {
            el = this.sequence.get(i);
            if (el.center == null) {
                this.addBond(mol, (IAtom)m.get(el.atoms[0]), (IAtom)m.get(el.atoms[1]), el.bonds[0].getOrder(), el.bonds[0].getFlag(5));
                continue;
            }
            for (int k = 0; k < el.atoms.length; ++k) {
                IAtom a = this.getAtomCopy(el.atoms[k]);
                mol.addAtom(a);
                m.put(el.atoms[k], a);
                this.addBond(mol, (IAtom)m.get(el.center), a, el.bonds[k].getOrder(), el.bonds[k].getFlag(5));
            }
        }
        return mol;
    }

    IAtom getAtomCopy(IAtom atom) {
        int charge;
        IAtom copyAtom = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{atom.getSymbol()});
        if (atom.getFlag(5)) {
            copyAtom.setFlag(5, true);
        }
        if ((charge = atom.getFormalCharge().intValue()) != 0) {
            copyAtom.setFormalCharge(Integer.valueOf(charge));
        }
        return copyAtom;
    }

    void addBond(IAtomContainer mol, IAtom at1, IAtom at2, IBond.Order order, boolean isAromatic) {
        IAtom[] atoms = new IAtom[]{at1, at2};
        Bond b = new Bond();
        b.setAtoms(atoms);
        b.setOrder(order);
        if (isAromatic) {
            b.setFlag(5, true);
        }
        mol.addBond((IBond)b);
    }

    public IAtomContainer getCarbonSkelleton(Vector<QuerySequenceElement> sequence) {
        IAtomContainer mol = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        HashMap<IQueryAtom, IAtom> m = new HashMap<IQueryAtom, IAtom>();
        QuerySequenceElement el = sequence.get(0);
        IAtom a0 = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"});
        mol.addAtom(a0);
        m.put(el.center, a0);
        for (int k = 0; k < el.atoms.length; ++k) {
            IAtom a = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"});
            mol.addAtom(a);
            m.put(el.atoms[k], a);
            this.addSkelletonBond(mol, (IAtom)m.get(el.center), a);
        }
        for (int i = 1; i < sequence.size(); ++i) {
            el = sequence.get(i);
            if (el.center == null) {
                this.addSkelletonBond(mol, (IAtom)m.get(el.atoms[0]), (IAtom)m.get(el.atoms[1]));
                continue;
            }
            el = sequence.get(i);
            for (int k = 0; k < el.atoms.length; ++k) {
                IAtom a = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"});
                mol.addAtom(a);
                m.put(el.atoms[k], a);
                this.addSkelletonBond(mol, (IAtom)m.get(el.center), a);
            }
        }
        return mol;
    }

    void addSkelletonBond(IAtomContainer mol, IAtom at1, IAtom at2) {
        IAtom[] atoms = new IAtom[]{at1, at2};
        IBond b = (IBond)this.builder.newInstance(IBond.class, new Object[0]);
        b.setAtoms(atoms);
        b.setOrder(IBond.Order.SINGLE);
        mol.addBond(b);
    }

    void connectFragmentToMolecule(IAtomContainer base, IAtomContainer fragment, int bondType, int basePos, int fragPos) {
    }

    void connectFragmentToMoleculeSpiro(IAtomContainer base, IAtomContainer fragment, int basePos, int fragPos) {
    }

    void condenseFragmentToMolecule(IAtomContainer base, IAtomContainer fragment, int bondType, int basePos, int fragPos) {
    }

    public void produceStructuresExhaustively(IAtomContainer mol, Vector<StructInfo> vStr, int maxNumSeqSteps, int maxStrSize) throws Exception {
        ChemObjectToSmiles cots = new ChemObjectToSmiles();
        for (int k = 0; k < mol.getAtomCount(); ++k) {
            IAtomContainer struct;
            this.setAtomSequence(mol, mol.getAtom(k));
            int n = this.sequence.size();
            if (n > maxNumSeqSteps) {
                n = maxNumSeqSteps;
            }
            for (int i = 0; i < n && (struct = this.getFragmentFromSequence(i)).getAtomCount() <= maxStrSize; ++i) {
                String smiles = cots.getSMILES(struct);
                if (this.checkForDuplication(smiles, vStr)) continue;
                StructInfo strInfo = new StructInfo();
                strInfo.smiles = smiles;
                strInfo.atomCount = struct.getAtomCount();
                strInfo.bondCount = struct.getBondCount();
                vStr.add(strInfo);
            }
        }
    }

    public void produceStructuresRandomly(IAtomContainer mol, Vector<StructInfo> vStr, int maxNumSeqSteps, int numStructs, int minGenStrSize) {
        Random random = new Random();
        ChemObjectToSmiles cots = new ChemObjectToSmiles();
        for (int k = 0; k < numStructs; ++k) {
            IAtomContainer struct;
            int atNum = random.nextInt(mol.getAtomCount());
            this.setAtomSequence(mol, mol.getAtom(atNum));
            int n = this.sequence.size() - 1;
            if (n > maxNumSeqSteps) {
                n = maxNumSeqSteps;
            }
            int numSteps = n;
            if (n > 1) {
                numSteps = 1 + random.nextInt(n - 1);
            }
            if ((struct = this.getFragmentFromSequence(numSteps)).getAtomCount() < minGenStrSize) continue;
            String smiles = cots.getSMILES(struct);
            StructInfo strInfo = new StructInfo();
            strInfo.smiles = smiles;
            strInfo.atomCount = struct.getAtomCount();
            strInfo.bondCount = struct.getBondCount();
            vStr.add(strInfo);
            if (mol.getAtomCount() < 15) break;
        }
    }

    boolean checkForDuplication(String smarts, Vector<StructInfo> vStr) throws Exception {
        this.man.setQuery(smarts);
        for (int i = 0; i < vStr.size(); ++i) {
            StructInfo s = vStr.get(i);
            if (this.man.getQueryContaner().getAtomCount() != s.atomCount || this.man.getQueryContaner().getBondCount() != s.bondCount) continue;
            if (smarts.equals(s.smiles)) {
                return true;
            }
            QueryAtomContainer q = this.parser.parse(s.smiles);
            IAtomContainer ac = this.stco.extractAtomContainer(q, null);
            boolean res = this.man.searchIn(ac);
            if (!res) continue;
            return true;
        }
        return false;
    }

    public void produceStructsFromMDL(String mdlFile, int maxNumSeqSteps, int maxNumRecord, int maxStrSize, Vector<StructInfo> vStr, String outFile) throws Exception {
        MyIteratingMDLReader reader = new MyIteratingMDLReader(new FileReader(mdlFile), this.builder);
        int record = 0;
        while (reader.hasNext()) {
            IAtomContainer mol;
            if (++record % 50 == 0) {
                this.saveStructs(vStr, outFile);
            }
            if (record > maxNumRecord) break;
            Object o = reader.next();
            if (!(o instanceof IAtomContainer) || (mol = (IAtomContainer)o).getAtomCount() == 0) continue;
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)mol);
            CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)mol);
            this.produceStructuresExhaustively(mol, vStr, maxNumSeqSteps, maxStrSize);
            System.out.println("record " + record + "  " + vStr.size());
        }
        this.saveStructs(vStr, outFile);
    }

    public void produceRandomStructsFromMDL(String mdlFile, int maxNumSeqSteps, int minGenStrSize, int maxNumRecord, Vector<StructInfo> vStr, String outFile) throws Exception {
        MyIteratingMDLReader reader = new MyIteratingMDLReader(new FileReader(mdlFile), this.builder);
        int record = 0;
        while (reader.hasNext()) {
            IAtomContainer mol;
            if (++record % 50 == 0) {
                this.saveStructs(vStr, outFile);
            }
            if (record > maxNumRecord) break;
            Object o = reader.next();
            if (!(o instanceof IAtomContainer) || (mol = (IAtomContainer)o).getAtomCount() == 0) continue;
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)mol);
            CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)mol);
            this.produceStructuresRandomly(mol, vStr, maxNumSeqSteps, 4, minGenStrSize);
            System.out.println("record " + record + "  " + vStr.size());
        }
        this.saveStructs(vStr, outFile);
    }

    void saveStructs(Vector<StructInfo> vStr, String fName) throws Exception {
        File file = new File(fName);
        RandomAccessFile f = new RandomAccessFile(file, "rw");
        f.setLength(0L);
        for (int i = 0; i < vStr.size(); ++i) {
            f.write((vStr.get((int)i).smiles + "\r\n").getBytes());
        }
        f.close();
    }

    void saveStructStatistics(Vector<String> smiles, Vector<Integer> stat, String fName) throws Exception {
        File file = new File(fName);
        RandomAccessFile f = new RandomAccessFile(file, "rw");
        f.setLength(0L);
        for (int i = 0; i < smiles.size(); ++i) {
            f.write((stat.get(i).toString() + "  " + smiles.get(i) + "\r\n").getBytes());
        }
        f.close();
    }

    public void performStructureStatistics(String smilesFile, String mdlFile, int portionSize, int nUsedStr, String outFile) throws Exception {
        File file = new File(smilesFile);
        RandomAccessFile f = new RandomAccessFile(file, "r");
        long length = f.length();
        Vector<String> smiles = new Vector<String>();
        Vector<String> allSmiles = new Vector<String>();
        Vector<Integer> allStat = new Vector<Integer>();
        int n = 0;
        while (f.getFilePointer() < length) {
            ++n;
            String line = f.readLine();
            smiles.add(line);
            if (smiles.size() % portionSize != 0) continue;
            System.out.println("Stattistics " + n);
            Vector<Integer> stat = this.doStatisticsForStructs(smiles, mdlFile, nUsedStr);
            for (int i = 0; i < smiles.size(); ++i) {
                allSmiles.add(smiles.get(i));
                allStat.add(stat.get(i));
            }
            smiles.clear();
            this.saveStructStatistics(allSmiles, allStat, outFile);
        }
        if (!smiles.isEmpty()) {
            Vector<Integer> stat = this.doStatisticsForStructs(smiles, mdlFile, nUsedStr);
            for (int i = 0; i < smiles.size(); ++i) {
                allSmiles.add(smiles.get(i));
                allStat.add(stat.get(i));
            }
            this.saveStructStatistics(allSmiles, allStat, outFile);
        }
        f.close();
    }

    Vector<Integer> doStatisticsForStructs(Vector<String> smiles, String mdlFile, int nUsedStr) throws Exception {
        System.out.print(" queries ...");
        Vector<QueryAtomContainer> queries = new Vector<QueryAtomContainer>();
        int n = smiles.size();
        int[] frequency = new int[n];
        for (int i = 0; i < n; ++i) {
            QueryAtomContainer q = this.parser.parse(smiles.get(i));
            queries.add(q);
            frequency[i] = 0;
        }
        System.out.println(" done");
        MyIteratingMDLReader reader = null;
        try {
            reader = new MyIteratingMDLReader(new FileReader(mdlFile), this.builder);
            int record = 0;
            while (reader.hasNext()) {
                IAtomContainer mol;
                if (++record % 200 == 0) {
                    System.out.println("  searched records " + record);
                }
                if (record > nUsedStr) {
                    break;
                }
                Object o = reader.next();
                if (!(o instanceof IAtomContainer) || (mol = (IAtomContainer)o).getAtomCount() == 0) continue;
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)mol);
                CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)mol);
                for (int i = 0; i < n; ++i) {
                    boolean res = UniversalIsomorphismTester.isSubgraph((IAtomContainer)mol, (IAtomContainer)((IAtomContainer)queries.get(i)));
                    if (!res) continue;
                    int n2 = i;
                    frequency[n2] = frequency[n2] + 1;
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception x) {}
        }
        Vector<Integer> stat = new Vector<Integer>();
        for (int i = 0; i < n; ++i) {
            stat.add(new Integer(frequency[i]));
        }
        return stat;
    }
}

