/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.signature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.signature.OrbitTest")
public class Orbit
implements Iterable<Integer>,
Cloneable {
    private List<Integer> atomIndices;
    private String label;
    private int height;

    public Orbit(String label, int height) {
        this.label = label;
        this.atomIndices = new ArrayList<Integer>();
        this.height = height;
    }

    @Override
    @TestMethod(value="iteratorTest")
    public Iterator<Integer> iterator() {
        return this.atomIndices.iterator();
    }

    @TestMethod(value="testClone")
    public Object clone() {
        Orbit orbit = new Orbit(this.label, this.height);
        for (Integer i : this.atomIndices) {
            orbit.atomIndices.add((int)i);
        }
        return orbit;
    }

    @TestMethod(value="sortTest")
    public void sort() {
        Collections.sort(this.atomIndices);
    }

    @TestMethod(value="getHeightTest")
    public int getHeight() {
        return this.height;
    }

    @TestMethod(value="getAtomIndicesTest")
    public List<Integer> getAtomIndices() {
        return this.atomIndices;
    }

    @TestMethod(value="addAtomTest")
    public void addAtom(int atomIndex) {
        this.atomIndices.add(atomIndex);
    }

    @TestMethod(value="hasLabelTest")
    public boolean hasLabel(String otherLabel) {
        return this.label.equals(otherLabel);
    }

    @TestMethod(value="isEmptyTest")
    public boolean isEmpty() {
        return this.atomIndices.isEmpty();
    }

    @TestMethod(value="getFirstAtomTest")
    public int getFirstAtom() {
        return this.atomIndices.get(0);
    }

    @TestMethod(value="removeTest")
    public void remove(int atomIndex) {
        this.atomIndices.remove(this.atomIndices.indexOf(atomIndex));
    }

    @TestMethod(value="getLabelTest")
    public String getLabel() {
        return this.label;
    }

    @TestMethod(value="containsTest")
    public boolean contains(int atomIndex) {
        return this.atomIndices.contains(atomIndex);
    }

    @TestMethod(value="toStringTest")
    public String toString() {
        return this.label + " " + Arrays.deepToString(this.atomIndices.toArray());
    }
}

