/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.CDKOWLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.libio.jena.Convertor;

public class CDKOWLWriter
extends DefaultChemObjectWriter {
    private Writer output;

    public CDKOWLWriter(Writer output) {
        this.output = output;
    }

    public CDKOWLWriter() {
        this.output = null;
    }

    public IResourceFormat getFormat() {
        return CDKOWLFormat.getInstance();
    }

    public void setWriter(Writer out) throws CDKException {
        this.output = out;
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.output = new OutputStreamWriter(output);
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        if (IMolecule.class.equals((Object)classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IMolecule.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        if (object instanceof IMolecule) {
            try {
                this.writeMolecule((IMolecule)object);
            }
            catch (Exception ex) {
                throw new CDKException("Error while writing HIN file: " + ex.getMessage(), ex);
            }
        } else {
            throw new CDKException("CDKOWLWriter only supports output of IMolecule classes.");
        }
    }

    private void writeMolecule(IMolecule mol) {
        Model model = Convertor.molecule2Model(mol);
        model.write(this.output, "N3");
    }
}

