/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.vocabulary.RDF;

public class ListLength
extends BaseBuiltin {
    public String getName() {
        return "listLength";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        this.checkArgs(length, context);
        BindingEnvironment env = context.getEnv();
        int len = ListLength.getLength(this.getArg(0, args, context), context);
        if (len == -1) {
            return false;
        }
        env.bind(args[1], Util.makeIntNode(len));
        return true;
    }

    protected static int getLength(Node node, RuleContext context) {
        if (node.equals(RDF.Nodes.nil)) {
            return 0;
        }
        Node next = Util.getPropValue(node, RDF.Nodes.rest, context);
        if (next == null) {
            return -1;
        }
        int sublen = ListLength.getLength(next, context);
        if (sublen == -1) {
            return -1;
        }
        return 1 + sublen;
    }
}

