/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.chemistry.CompoundAbstractProcessing;
import com.rapidminer.operator.chemistry.Compounds;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

public class CompoundRename
extends CompoundAbstractProcessing {
    public static final String PARAMETER_CPD_INDEX = "index_of_compound_to_rename";
    public static final String PARAMETER_CPD_NEW_NAME = "new_name";

    public CompoundRename(OperatorDescription operatorDescription) {
        super(operatorDescription);
    }

    public List<ParameterType> getParameterTypes() {
        List list = super.getParameterTypes();
        ParameterTypeInt parameterTypeInt = null;
        parameterTypeInt = new ParameterTypeInt(PARAMETER_CPD_INDEX, "Index of compound to rename.", 1, Integer.MAX_VALUE, 1);
        parameterTypeInt.setExpert(false);
        list.add(parameterTypeInt);
        parameterTypeInt = new ParameterTypeString(PARAMETER_CPD_NEW_NAME, "Compound's new name.", false);
        parameterTypeInt.setExpert(false);
        list.add(parameterTypeInt);
        return list;
    }

    public void doWork() throws OperatorException {
        int n;
        Compounds compounds = (Compounds)this.molInput.getData();
        Compounds compounds2 = new Compounds();
        try {
            int n2 = compounds.size();
            for (n = 0; n < n2; ++n) {
                compounds2.addMolecule(compounds.getMolecule(n).clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = this.getParameterAsInt(PARAMETER_CPD_INDEX);
        String string = this.getParameterAsString(PARAMETER_CPD_NEW_NAME);
        compounds.setMoleculeName(n - 1, string);
        compounds.calculateStatistics(compounds.getMolecule(n - 1), n - 1);
        this.molOriginal.deliver((IOObject)compounds2);
        this.molOutput.deliver((IOObject)compounds);
    }
}

