/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts.query;

import ambit2.core.data.MoleculeTools;
import ambit2.smarts.SmartsManager;
import ambit2.smarts.processors.SMARTSPropertiesReader;
import ambit2.smarts.query.AbstractSmartsPattern;
import ambit2.smarts.query.SMARTSException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class SmartsPatternAmbit
extends AbstractSmartsPattern<IAtomContainer> {
    protected transient SmartsManager sman;
    protected transient SMARTSPropertiesReader reader = new SMARTSPropertiesReader();
    protected boolean useCDKIsomorphism = true;
    private static final long serialVersionUID = 4400701166436805492L;

    public boolean isUseCDKIsomorphism() {
        return this.sman == null ? this.useCDKIsomorphism : this.sman.isFlagUseCDKIsomorphismTester();
    }

    public void setUseCDKIsomorphism(boolean useCDKIsomorphism) {
        this.useCDKIsomorphism = useCDKIsomorphism;
        if (this.sman != null) {
            this.sman.setUseCDKIsomorphismTester(useCDKIsomorphism);
        }
    }

    public SmartsPatternAmbit() throws SMARTSException {
        this(SilentChemObjectBuilder.getInstance());
    }

    public SmartsPatternAmbit(IChemObjectBuilder builder) throws SMARTSException {
        this("C", builder);
    }

    public SmartsPatternAmbit(String smarts) throws SMARTSException {
        this(smarts, SilentChemObjectBuilder.getInstance());
    }

    public SmartsPatternAmbit(String smarts, IChemObjectBuilder builder) throws SMARTSException {
        this(smarts, false, builder);
    }

    public SmartsPatternAmbit(String smarts, boolean negate, IChemObjectBuilder builder) throws SMARTSException {
        this.sman = new SmartsManager(builder);
        this.sman.setUseCDKIsomorphismTester(this.useCDKIsomorphism);
        this.setSmarts(smarts);
        this.setNegate(negate);
    }

    @Override
    public QueryAtomContainer getQuery() {
        return this.sman.getQueryContaner();
    }

    @Override
    public IAtomContainer getObjectToVerify(IAtomContainer mol) {
        return mol;
    }

    @Override
    public IAtomContainer getMatchingStructure(IAtomContainer mol) throws SMARTSException {
        IAtomContainerSet set;
        try {
            set = this.sman.getAllIsomorphismMappings(mol);
        }
        catch (Exception x) {
            throw new SMARTSException(x);
        }
        if (set == null) {
            return null;
        }
        if (set.getAtomContainerCount() == 0) {
            return null;
        }
        if (set.getAtomContainerCount() == 1) {
            return set.getAtomContainer(0);
        }
        IAtomContainer match = MoleculeTools.newAtomContainer(SilentChemObjectBuilder.getInstance());
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            match.add(set.getAtomContainer(i));
        }
        return match;
    }

    @Override
    public int hasSMARTSPattern(IAtomContainer mol) throws SMARTSException {
        if (this.sman == null) {
            throw new SMARTSException("Smarts parser not initialized!");
        }
        try {
            this.sman.setSmartsDataForTarget(this.reader.process(mol) == null);
        }
        catch (Exception x) {
            x.printStackTrace();
            this.sman.setSmartsDataForTarget(true);
        }
        try {
            if (this.sman.searchIn(mol)) {
                return 1;
            }
            return 0;
        }
        catch (Exception x) {
            throw new SMARTSException(x);
        }
    }

    public String getImplementationDetails() {
        return "AMBIT smarts package";
    }

    @Override
    public void setSmarts(String smarts) throws SMARTSException {
        super.setSmarts(smarts);
        this.sman.setQuery(smarts);
        if (!this.sman.getErrors().equals("")) {
            String errors = this.sman.getErrors();
            this.sman = null;
            throw new SMARTSException(errors);
        }
    }

    @Override
    public void useMOEvPrimitive(boolean flag) throws UnsupportedOperationException {
        this.sman.useMOEvPrimitive(flag);
    }
}

