/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.Plane3;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.Transform3;
import org.xmlcml.euclid.Vector3;

public class Line3
implements EuclidConstants {
    Vector3 vect = new Vector3();
    Point3 point = new Point3();

    public Line3() {
    }

    public Line3(Point3 p, Vector3 v) {
        this.vect = new Vector3(v);
        this.point = new Point3(p);
        if (!this.vect.isZero()) {
            this.vect.normalize();
        }
    }

    public Line3(Point3 p1, Point3 p2) {
        this(p1, p2.subtract(p1));
    }

    public Line3(Line3 l) {
        this.vect = new Vector3(l.vect);
        this.point = new Point3(l.point);
    }

    public boolean isEqualTo(Line3 l2) {
        if (!this.vect.isEqualTo(l2.vect)) {
            return false;
        }
        return this.containsPoint(l2.point);
    }

    public Line3 negative() {
        Line3 l = new Line3(this.point, this.vect.negative());
        return l;
    }

    public Vector3 getVector() {
        return this.vect;
    }

    public Point3 getPoint() {
        return this.point;
    }

    public Line3 transform(Transform3 t) {
        Line3 lout = new Line3();
        lout.point = this.point.transform(t);
        lout.vect = this.vect.transform(t);
        return lout;
    }

    public boolean isParallelTo(Line3 l2) {
        return this.vect.isIdenticalTo(l2.vect);
    }

    public boolean isAntiparallelTo(Line3 l2) {
        Vector3 v = new Vector3(l2.vect);
        return this.vect.isIdenticalTo(v.negative());
    }

    public boolean containsPoint(Point3 p) {
        return Real.isZero(this.getDistanceFromPoint(p), Real.getEpsilon());
    }

    public Point3 getClosestPointTo(Point3 p2) {
        Point3 p1 = new Point3();
        Vector3 v2 = new Vector3(p2);
        Vector3 v1 = new Vector3(this.point);
        p1 = this.point.plus(this.vect.multiplyBy(v2.subtract(v1).dot(this.vect)));
        return p1;
    }

    public double getDistanceFromPoint(Point3 p) {
        Point3 p0 = this.getClosestPointTo(p);
        Vector3 v = new Vector3(p.subtract(p0));
        return v.getLength();
    }

    public Point3 getIntersectionWith(Plane3 pl) {
        return pl.getIntersectionWith(this);
    }

    public String toString() {
        return "(" + this.vect + "," + this.point + ")";
    }
}

