/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.graph.DefaultDirectedGraph;
import org._3pq.jgrapht.graph.SimpleGraph;
import org._3pq.jgrapht.traverse.BreadthFirstIterator;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.graph.MinimalPathIteratorTest")
public class MinimalPathIterator
implements Iterator {
    private Object sourceVertex;
    private Object targetVertex;
    private Graph g;
    private DirectedGraph shortestPathGraph;
    private Stack edgeIteratorStack;
    private Stack vertexStack;
    private Object next;

    public MinimalPathIterator(SimpleGraph g, Object sourceVertex, Object targetVertex) {
        this.g = g;
        this.sourceVertex = sourceVertex;
        this.targetVertex = targetVertex;
        this.createShortestPathGraph();
    }

    private void createShortestPathGraph() {
        this.shortestPathGraph = new DefaultDirectedGraph();
        this.shortestPathGraph.addVertex(this.targetVertex);
        HashMap<Object, Integer> distanceMap = new HashMap<Object, Integer>();
        MyBreadthFirstIterator iter = new MyBreadthFirstIterator(this.g, this.targetVertex);
        while (iter.hasNext()) {
            Object vertex = iter.next();
            this.shortestPathGraph.addVertex(vertex);
            int distance = iter.level;
            distanceMap.put(vertex, distance);
            for (Edge edge : this.g.edgesOf(vertex)) {
                Object opposite = edge.oppositeVertex(vertex);
                if (distanceMap.get(opposite) == null || (Integer)distanceMap.get(opposite) + 1 != distance) continue;
                this.shortestPathGraph.addVertex(opposite);
                this.shortestPathGraph.addEdge(vertex, opposite);
            }
            if (vertex != this.sourceVertex) continue;
            break;
        }
        Iterator edgeIterator = this.shortestPathGraph.outgoingEdgesOf(this.sourceVertex).iterator();
        this.edgeIteratorStack = new Stack();
        this.edgeIteratorStack.push(edgeIterator);
        this.vertexStack = new Stack();
        this.vertexStack.push(this.sourceVertex);
    }

    @TestMethod(value="testMinimalPathIterator")
    public boolean hasNext() {
        if (this.next == null) {
            while (this.next == null && !this.edgeIteratorStack.isEmpty()) {
                Iterator edgeIterator = (Iterator)this.edgeIteratorStack.peek();
                Object currentVertex = this.vertexStack.peek();
                if (edgeIterator.hasNext()) {
                    Edge edge = (Edge)edgeIterator.next();
                    currentVertex = edge.oppositeVertex(currentVertex);
                    edgeIterator = this.shortestPathGraph.outgoingEdgesOf(currentVertex).iterator();
                    this.edgeIteratorStack.push(edgeIterator);
                    this.vertexStack.push(currentVertex);
                    continue;
                }
                if (currentVertex == this.targetVertex) {
                    this.next = this.edgeList(this.g, this.vertexStack);
                }
                this.edgeIteratorStack.pop();
                this.vertexStack.pop();
            }
        }
        return this.next != null;
    }

    @TestMethod(value="testMinimalPathIterator")
    public Object next() {
        if (this.hasNext()) {
            Object result = this.next;
            this.next = null;
            return result;
        }
        return null;
    }

    @TestMethod(value="testRemove")
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private List edgeList(Graph g, List vertexList) {
        ArrayList edgeList = new ArrayList(vertexList.size() - 1);
        Iterator vertices = vertexList.iterator();
        Object currentVertex = vertices.next();
        while (vertices.hasNext()) {
            Object nextVertex = vertices.next();
            edgeList.add(g.getAllEdges(currentVertex, nextVertex).get(0));
            currentVertex = nextVertex;
        }
        return edgeList;
    }

    private static class MyBreadthFirstIterator
    extends BreadthFirstIterator {
        int level = -1;
        private Object firstVertexOfNextLevel;

        public MyBreadthFirstIterator(Graph g, Object startVertex) {
            super(g, startVertex);
        }

        protected void encounterVertex(Object vertex, Edge edge) {
            super.encounterVertex(vertex, edge);
            if (this.firstVertexOfNextLevel == null) {
                this.firstVertexOfNextLevel = vertex;
            }
        }

        protected Object provideNextVertex() {
            Object nextVertex = super.provideNextVertex();
            if (this.firstVertexOfNextLevel == nextVertex) {
                this.firstVertexOfNextLevel = null;
                ++this.level;
            }
            return nextVertex;
        }
    }
}

