/*
 * Decompiled with CFR 0.152.
 */
package jena;

import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModBase;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.shared.uuid.UUID_V1_Gen;
import com.hp.hpl.jena.shared.uuid.UUID_V4_Gen;

public class juuid
extends CmdGeneral {
    ModJUUID modJUUID = new ModJUUID();
    int number = 1;
    boolean resetEachTime = false;
    int uuidType = 0;
    boolean asURN = false;
    boolean asURI = false;
    boolean asPlain = false;
    static ArgDecl argDeclNum = new ArgDecl(true, "num", "n");
    static ArgDecl argDeclReset = new ArgDecl(false, "reset");
    static ArgDecl argDeclGen = new ArgDecl(true, "gen", "scheme");
    static ArgDecl argDeclURN = new ArgDecl(false, "urn");
    static ArgDecl argDeclURI = new ArgDecl(false, "uri");
    static ArgDecl argDeclPlain = new ArgDecl(false, "plain");

    public static void main(String[] argv) {
        new juuid(argv).mainAndExit();
    }

    private juuid(String[] argv) {
        super(argv);
        super.addModule((ArgModuleGeneral)this.modJUUID);
    }

    protected String getSummary() {
        return this.getCommandName() + " [--num=N] [--reset] [--type={1|4}]";
    }

    protected void exec() {
        if (this.uuidType == 1) {
            JenaUUID.setFactory(new UUID_V1_Gen());
        }
        if (this.uuidType == 4) {
            JenaUUID.setFactory(new UUID_V4_Gen());
        }
        for (int i = 0; i < this.number; ++i) {
            if (this.resetEachTime && i != 0) {
                JenaUUID.reset();
            }
            JenaUUID uuid = JenaUUID.generate();
            String str = null;
            if (this.asURN) {
                str = uuid.asURN();
            } else if (this.asURN) {
                str = uuid.asURI();
            } else if (this.asPlain) {
                str = uuid.asString();
            }
            if (str == null) {
                str = uuid.asString();
            }
            System.out.println(str);
        }
    }

    protected String getCommandName() {
        return "uuid";
    }

    protected void processModulesAndArgs() {
    }

    class ModJUUID
    extends ModBase {
        ModJUUID() {
        }

        public void registerWith(CmdGeneral cmdLine) {
            cmdLine.add(argDeclNum);
            cmdLine.add(argDeclReset);
            cmdLine.add(argDeclGen);
            cmdLine.add(argDeclURN);
            cmdLine.add(argDeclURI);
            cmdLine.add(argDeclPlain);
        }

        public void processArgs(CmdArgModule cmdLine) {
            String numStr = null;
            if (juuid.this.getNumPositional() > 1) {
                juuid.this.cmdError("Too many positional arguments");
            }
            if (cmdLine.contains(argDeclNum)) {
                if (juuid.this.getNumPositional() != 0) {
                    juuid.this.cmdError("--num and positional arguments don't go together");
                }
                numStr = juuid.this.getValue(argDeclNum);
            }
            if (numStr == null && cmdLine.getNumPositional() == 1) {
                numStr = cmdLine.getPositionalArg(0);
            }
            if (numStr != null) {
                try {
                    juuid.this.number = Integer.parseInt(numStr);
                    if (juuid.this.number < 0 || juuid.this.number > 10000) {
                        cmdLine.cmdError("Number out of range:" + numStr);
                    }
                }
                catch (NumberFormatException e) {
                    cmdLine.cmdError("Bad argument: " + numStr);
                }
            }
            juuid.this.resetEachTime = cmdLine.contains(argDeclReset);
            if (juuid.this.contains(argDeclGen)) {
                String s = juuid.this.getValue(argDeclGen);
                if (s.equalsIgnoreCase("time") || s.equalsIgnoreCase("1")) {
                    juuid.this.uuidType = 1;
                } else if (s.equalsIgnoreCase("random") || s.equalsIgnoreCase("rand") || s.equalsIgnoreCase("4")) {
                    juuid.this.uuidType = 4;
                } else {
                    juuid.this.cmdError("Unrecognized UUID scheme: " + s);
                }
            }
            if (juuid.this.contains(argDeclURN) || juuid.this.contains(argDeclURI) || juuid.this.contains(argDeclPlain)) {
                juuid.this.asURN = juuid.this.contains(argDeclURN);
                juuid.this.asURI = juuid.this.contains(argDeclURI);
                juuid.this.asPlain = juuid.this.contains(argDeclPlain);
            } else {
                juuid.this.asURN = true;
                juuid.this.asURI = false;
                juuid.this.asPlain = false;
            }
        }
    }
}

