/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static boolean isNumeric(Node n) {
        return n.isLiteral() && n.getLiteralValue() instanceof Number;
    }

    public static int getIntValue(Node n) {
        return ((Number)n.getLiteralValue()).intValue();
    }

    public static int compareNumbers(Node n1, Node n2) {
        if (n1.isLiteral() && n2.isLiteral()) {
            Object v1 = n1.getLiteralValue();
            Object v2 = n2.getLiteralValue();
            if (v1 instanceof Number && v2 instanceof Number) {
                long l2;
                if (v1 instanceof Float || v1 instanceof Double || v2 instanceof Float || v2 instanceof Double) {
                    double d2;
                    double d1 = ((Number)v1).doubleValue();
                    return d1 < (d2 = ((Number)v2).doubleValue()) ? -1 : (d1 == d2 ? 0 : 1);
                }
                long l1 = ((Number)v1).longValue();
                return l1 < (l2 = ((Number)v2).longValue()) ? -1 : (l1 == l2 ? 0 : 1);
            }
        }
        throw new ClassCastException("Non-numeric literal in compareNumbers");
    }

    public static boolean isInstant(Node n) {
        if (n.isLiteral()) {
            Object o = n.getLiteralValue();
            return o instanceof XSDDateTime;
        }
        return false;
    }

    public static int compareInstants(Node n1, Node n2) {
        if (n1.isLiteral() && n2.isLiteral()) {
            Object v1 = n1.getLiteralValue();
            Object v2 = n2.getLiteralValue();
            if (v1 instanceof XSDDateTime && v2 instanceof XSDDateTime) {
                XSDDateTime a = (XSDDateTime)v1;
                XSDDateTime b = (XSDDateTime)v2;
                return a.compare(b);
            }
        }
        throw new ClassCastException("Non-numeric literal in compareNumbers");
    }

    public static Node getPropValue(Node root, Node prop, Finder context) {
        return Util.doGetPropValue(context.find(new TriplePattern(root, prop, null)));
    }

    public static Node getPropValue(Node root, Node prop, Graph context) {
        return Util.doGetPropValue(context.find(root, prop, null));
    }

    public static Node getPropValue(Node root, Node prop, RuleContext context) {
        return Util.doGetPropValue(context.find(root, prop, null));
    }

    private static Node doGetPropValue(ClosableIterator<Triple> it) {
        Node result = null;
        if (it.hasNext()) {
            result = ((Triple)it.next()).getObject();
        }
        it.close();
        return result;
    }

    public static List<Node> convertList(Node root, RuleContext context) {
        return Util.convertList(root, context, new LinkedList<Node>());
    }

    private static List<Node> convertList(Node node, RuleContext context, List<Node> sofar) {
        if (node == null || node.equals(RDF.nil.asNode())) {
            return sofar;
        }
        Node next = Util.getPropValue(node, RDF.first.asNode(), context);
        if (next != null) {
            sofar.add(next);
            return Util.convertList(Util.getPropValue(node, RDF.rest.asNode(), context), context, sofar);
        }
        return sofar;
    }

    public static Node makeIntNode(int value) {
        return Node.createLiteral(new LiteralLabel(new Integer(value)));
    }

    public static Node makeLongNode(long value) {
        if (value > Integer.MAX_VALUE) {
            return Node.createLiteral(new LiteralLabel(new Long(value)));
        }
        return Node.createLiteral(new LiteralLabel(new Integer((int)value)));
    }

    public static Node makeDoubleNode(double value) {
        return Node.createLiteral(new LiteralLabel(new Double(value)));
    }

    public static Node makeList(Node[] nodes, Graph graph) {
        return Util.doMakeList(nodes, 0, graph);
    }

    private static Node doMakeList(Node[] nodes, int next, Graph graph) {
        if (next < nodes.length) {
            Node listNode = Node.createAnon();
            graph.add(new Triple(listNode, RDF.Nodes.first, nodes[next]));
            graph.add(new Triple(listNode, RDF.Nodes.rest, Util.doMakeList(nodes, next + 1, graph)));
            return listNode;
        }
        return RDF.Nodes.nil;
    }

    public static Rule.Parser loadRuleParserFromResourceFile(String filename) {
        return Rule.rulesParserFromReader(FileUtils.openResourceFile(filename));
    }

    public static String loadURLFile(String urlStr) throws IOException {
        int l;
        BufferedReader dataReader = FileUtils.readerFromURL(urlStr);
        StringWriter sw = new StringWriter(1024);
        char[] buff = new char[1024];
        while (dataReader.ready() && (l = dataReader.read(buff)) > 0) {
            sw.write(buff, 0, l);
        }
        dataReader.close();
        sw.close();
        return sw.toString();
    }

    public static Boolean checkBinaryPredicate(Property predicate, Resource configuration) {
        StmtIterator i = configuration.listProperties(predicate);
        if (i.hasNext()) {
            return new Boolean(((Object)i.nextStatement().getObject()).toString().equalsIgnoreCase("true"));
        }
        return null;
    }

    public static Integer getIntegerPredicate(Property predicate, Resource configuration) {
        RDFNode lit;
        StmtIterator i = configuration.listProperties(predicate);
        if (i.hasNext() && (lit = i.nextStatement().getObject()) instanceof Literal) {
            return new Integer(((Literal)lit).getInt());
        }
        return null;
    }

    public static boolean convertBooleanPredicateArg(Property parameter, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return ((String)value).equalsIgnoreCase("true");
        }
        throw new IllegalParameterException("Illegal type for " + parameter + " setting - use a Boolean");
    }

    public static int convertIntegerPredicateArg(Property parameter, Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalParameterException("Illegal type for " + parameter + " setting - use an integer");
            }
        }
        throw new IllegalParameterException("Illegal type for " + parameter + " setting - use an integer");
    }

    public static void updateParameter(Resource config, Property parameter, Object value) {
        StmtIterator i = config.listProperties(parameter);
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        config.addProperty(parameter, value.toString());
    }
}

