/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.PSet_TripleStore_RDB;
import com.hp.hpl.jena.db.impl.ReificationStatementMask;
import com.hp.hpl.jena.db.impl.ResultSetReifIterator;
import com.hp.hpl.jena.db.impl.ResultSetStringIterator;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.RDF;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSet_ReifStore_RDB
extends PSet_TripleStore_RDB {
    private static Logger logger = LoggerFactory.getLogger(PSet_ReifStore_RDB.class);

    public void storeReifStmt(Node n, Triple t, IDBID my_GID) {
        this.storeTripleAR(t, my_GID, n, true, false, null);
    }

    public void deleteReifStmt(Node n, Triple t, IDBID my_GID) {
        this.deleteTripleAR(t, my_GID, n, false, null);
    }

    public ResultSetReifIterator findReifStmt(Node stmtURI, boolean hasType, IDBID graphID, boolean getTriples) {
        String astName = this.getTblName();
        int gid = graphID.getIntID();
        ResultSetReifIterator result = new ResultSetReifIterator((IPSet)this, getTriples, graphID);
        PreparedStatement ps = null;
        boolean objIsBlankOrURI = false;
        int args = 1;
        boolean findAll = stmtURI == null || stmtURI.equals(Node.ANY);
        boolean notFound = false;
        String stmtStr = findAll ? (hasType ? "selectReifiedT" : "selectReified") : (hasType ? "selectReifiedNT" : "selectReifiedN");
        try {
            ps = this.m_sql.getPreparedSQLStatement(stmtStr, this.getTblName());
            if (!findAll) {
                String stmt_uri = this.m_driver.nodeToRDBString(stmtURI, false);
                if (stmt_uri == null) {
                    notFound = true;
                } else {
                    ps.setString(args++, stmt_uri);
                }
            }
            if (hasType) {
                ps.setString(args++, "T");
            }
            ps.setInt(args++, gid);
        }
        catch (Exception e) {
            notFound = true;
            logger.warn("Getting prepared statement for " + stmtStr + " Caught exception ", e);
            throw new JenaException("Exception during database access", e);
        }
        if (notFound) {
            result.close();
        } else {
            try {
                this.m_sql.executeSQL(ps, stmtStr, result);
            }
            catch (Exception e) {
                logger.debug("find encountered exception ", e);
                throw new JenaException("Exception during database access", e);
            }
        }
        return result;
    }

    public ResultSetReifIterator findReifTripleMatch(TripleMatch t, IDBID graphID) {
        String astName = this.getTblName();
        int gid = graphID.getIntID();
        ResultSetReifIterator result = new ResultSetReifIterator((IPSet)this, true, graphID);
        PreparedStatement ps = null;
        String stmtStr = "*findReif ";
        boolean gotStmt = false;
        boolean gotPred = false;
        boolean gotObj = false;
        boolean objIsStmt = false;
        int reifProp = 32;
        String objNode = null;
        boolean done = false;
        int argc = 1;
        Node stmtURI = t.getMatchSubject();
        Node obj = t.getMatchObject();
        Node pred = t.getMatchPredicate();
        if (stmtURI != null && !stmtURI.equals(Node.ANY)) {
            gotStmt = true;
            stmtStr = stmtStr + "N";
        }
        if (pred != null && !pred.equals(Node.ANY)) {
            gotPred = true;
            if (pred.equals(RDF.Nodes.subject)) {
                reifProp = 83;
            } else if (pred.equals(RDF.Nodes.predicate)) {
                reifProp = 80;
            } else if (pred.equals(RDF.Nodes.object)) {
                reifProp = 79;
            } else if (pred.equals(RDF.Nodes.type)) {
                reifProp = 84;
            } else {
                done = true;
            }
            stmtStr = stmtStr + "P" + (char)reifProp;
        }
        if (obj != null && !obj.equals(Node.ANY)) {
            gotObj = true;
            stmtStr = stmtStr + "O";
            if (obj.equals(RDF.Nodes.Statement)) {
                objIsStmt = true;
                stmtStr = stmtStr + "C";
            } else if (reifProp == 84) {
                done = true;
            }
        }
        if (!done) {
            try {
                ps = this.m_sql.getPreparedSQLStatement(stmtStr, this.getTblName());
                ps.setInt(argc++, gid);
                if (gotStmt) {
                    String stmtNode = this.m_driver.nodeToRDBString(stmtURI, false);
                    if (stmtNode == null) {
                        done = true;
                    } else {
                        ps.setString(argc++, stmtNode);
                    }
                }
                if (!(!gotObj || gotPred && objIsStmt)) {
                    objNode = this.m_driver.nodeToRDBString(obj, false);
                    ps.setString(argc++, objNode);
                    if (!gotPred) {
                        ps.setString(argc++, objNode);
                        ps.setString(argc++, objNode);
                    }
                }
            }
            catch (Exception e) {
                done = true;
                logger.warn("Getting prepared statement for " + stmtStr + " Caught exception ", e);
                throw new JenaException("Exception during database access", e);
            }
        }
        if (done) {
            result.close();
        } else {
            if (gotPred) {
                result.close();
                result = new ResultSetReifIterator((IPSet)this, (char)reifProp, graphID);
            } else if (gotObj) {
                result.close();
                result = new ResultSetReifIterator((IPSet)this, obj, graphID);
            }
            try {
                this.m_sql.executeSQL(ps, stmtStr, result);
            }
            catch (Exception e) {
                logger.debug("find encountered exception ", e);
                throw new JenaException("Exception during database access", e);
            }
        }
        return result;
    }

    public ExtendedIterator<Node> findReifStmtURIByTriple(Triple t, IDBID my_GID) {
        String stmtStr = null;
        int argc = 1;
        PreparedStatement ps = null;
        ResultSetStringIterator result = new ResultSetStringIterator();
        boolean notFound = false;
        stmtStr = "selectReifNode";
        stmtStr = stmtStr + (t == null ? "T" : "SPOT");
        try {
            ps = this.m_sql.getPreparedSQLStatement(stmtStr, this.getTblName());
            ps.clearParameters();
            if (t != null) {
                String argStr = this.m_driver.nodeToRDBString(t.getSubject(), false);
                if (argStr == null) {
                    notFound = true;
                } else {
                    ps.setString(argc++, argStr);
                }
                argStr = this.m_driver.nodeToRDBString(t.getPredicate(), false);
                if (argStr == null) {
                    notFound = true;
                } else {
                    ps.setString(argc++, argStr);
                }
                argStr = this.m_driver.nodeToRDBString(t.getObject(), false);
                if (argStr == null) {
                    notFound = true;
                } else {
                    ps.setString(argc++, argStr);
                }
            }
            ps.setInt(argc, my_GID.getIntID());
        }
        catch (Exception e) {
            notFound = true;
            logger.warn("Getting prepared statement for " + stmtStr + " Caught exception ", e);
            throw new JenaException("Exception during database access", e);
        }
        if (notFound) {
            result.close();
        } else {
            try {
                this.m_sql.executeSQL(ps, stmtStr, result);
            }
            catch (Exception e) {
                logger.debug("find encountered exception ", e);
                throw new JenaException("Exception during database access", e);
            }
        }
        return result.mapWith(new MapResultSetToNode());
    }

    public void storeFrag(Node stmtURI, Triple frag, ReificationStatementMask fragMask, IDBID my_GID) {
        Node subj = fragMask.hasSubj() ? frag.getObject() : Node.NULL;
        Node prop = fragMask.hasPred() ? frag.getObject() : Node.NULL;
        Node obj = fragMask.hasObj() ? frag.getObject() : Node.NULL;
        Triple t = Triple.create(subj, prop, obj);
        this.storeTripleAR(t, my_GID, stmtURI, fragMask.hasType(), false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOneFrag(Node stmtURI, Triple frag, ReificationStatementMask fragMask, boolean nullify, IDBID my_GID) {
        String stmtStr = null;
        Node val = null;
        int argc = 1;
        if (!fragMask.hasOneBit()) {
            throw new JenaException("Reification can only update one column");
        }
        PreparedStatement ps = null;
        if (fragMask.hasSubj()) {
            stmtStr = "updateReifiedS";
            if (!nullify) {
                val = frag.getObject();
            }
        } else if (fragMask.hasPred()) {
            stmtStr = "updateReifiedP";
            if (!nullify) {
                val = frag.getObject();
            }
        } else if (fragMask.hasObj()) {
            stmtStr = "updateReifiedO";
            if (!nullify) {
                val = frag.getObject();
            }
        } else if (fragMask.hasType()) {
            stmtStr = "updateReifiedT";
        }
        try {
            try {
                String argStr;
                ps = this.m_sql.getPreparedSQLStatement(stmtStr, this.getTblName());
                ps.clearParameters();
                if (fragMask.hasSubj() || fragMask.hasPred() || fragMask.hasObj()) {
                    if (nullify) {
                        ps.setNull(argc++, 12);
                    } else {
                        argStr = this.m_driver.nodeToRDBString(val, true);
                        if (argStr == null) {
                            throw new RDFRDBException("Invalid update argument: " + val.toString());
                        }
                        ps.setString(argc++, argStr);
                    }
                } else if (nullify) {
                    ps.setString(argc++, " ");
                } else {
                    ps.setString(argc++, "T");
                }
                argStr = this.m_driver.nodeToRDBString(stmtURI, true);
                if (argStr == null) {
                    throw new RDFRDBException("Invalid update statement URI: " + stmtURI.toString());
                }
                ps.setString(argc++, argStr);
                ps.setInt(argc++, my_GID.getIntID());
            }
            catch (Exception e) {
                logger.warn("Getting prepared statement for " + stmtStr + " Caught exception ", e);
                throw new JenaException("Exception during database access", e);
            }
            try {
                ps.executeUpdate();
            }
            catch (SQLException e1) {
                logger.error("SQLException caught during reification update" + e1.getErrorCode(), e1);
                throw new JenaException("Exception during database access", e1);
            }
        }
        finally {
            if (ps != null) {
                this.m_sql.returnPreparedSQLStatement(ps);
            }
        }
    }

    public void nullifyFrag(Node stmtURI, ReificationStatementMask fragMask, IDBID my_GID) {
        this.updateOneFrag(stmtURI, null, fragMask, true, my_GID);
    }

    public void updateFrag(Node stmtURI, Triple frag, ReificationStatementMask fragMask, IDBID my_GID) {
        this.updateOneFrag(stmtURI, frag, fragMask, false, my_GID);
    }

    public ResultSetReifIterator findFrag(Node stmtURI, Triple frag, ReificationStatementMask fragMask, IDBID my_GID) {
        String stmtStr = null;
        Node val = null;
        int argc = 1;
        ResultSetReifIterator result = new ResultSetReifIterator((IPSet)this, true, my_GID);
        boolean notFound = false;
        Object litNode = null;
        Object ll = null;
        Object lval = null;
        boolean litIsPlain = false;
        boolean objIsURI = false;
        if (!fragMask.hasOneBit()) {
            throw new JenaException("Reification can only find one column");
        }
        PreparedStatement ps = null;
        val = frag.getObject();
        if (fragMask.hasSubj()) {
            stmtStr = "selectReifiedNS";
        } else if (fragMask.hasPred()) {
            stmtStr = "selectReifiedNP";
        } else if (fragMask.hasObj()) {
            stmtStr = "selectReifiedNO";
        } else if (fragMask.hasType()) {
            stmtStr = "selectReifiedNT";
        }
        try {
            ps = this.m_sql.getPreparedSQLStatement(stmtStr, this.getTblName());
            ps.clearParameters();
            String argStr = this.m_driver.nodeToRDBString(stmtURI, false);
            if (argStr == null) {
                notFound = true;
            } else {
                ps.setString(argc++, argStr);
            }
            if (fragMask.hasSubj() || fragMask.hasPred() || fragMask.hasObj()) {
                argStr = this.m_driver.nodeToRDBString(val, false);
                if (argStr == null) {
                    notFound = true;
                } else {
                    ps.setString(argc++, argStr);
                }
            } else {
                ps.setString(argc++, "T");
            }
            ps.setInt(argc, my_GID.getIntID());
        }
        catch (Exception e) {
            logger.warn("Getting prepared statement for " + stmtStr + " Caught exception ", e);
            throw new JenaException("Exception during database access", e);
        }
        if (notFound) {
            result.close();
        } else {
            try {
                this.m_sql.executeSQL(ps, stmtStr, result);
            }
            catch (Exception e) {
                logger.debug("find encountered exception ", e);
                throw new JenaException("Exception during database access", e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFrag(Triple frag, ReificationStatementMask fragMask, IDBID my_GID) {
        if (!fragMask.hasOneBit()) {
            throw new JenaException("Can only delete one fragment");
        }
        int argc = 1;
        PreparedStatement ps = null;
        String stmtStr = "deleteReified";
        if (fragMask.hasSubj()) {
            stmtStr = stmtStr + "S";
        } else if (fragMask.hasPred()) {
            stmtStr = stmtStr + "P";
        } else if (fragMask.hasObj()) {
            stmtStr = stmtStr + "O";
        } else if (fragMask.hasType()) {
            stmtStr = stmtStr + "T";
        } else {
            throw new JenaException("Unspecified reification fragment in deleteFrag");
        }
        Node val = frag.getObject();
        String argStr = this.m_driver.nodeToRDBString(val, false);
        Node stmtURI = frag.getSubject();
        String uriStr = this.m_driver.nodeToRDBString(stmtURI, false);
        try {
            try {
                ps = this.m_sql.getPreparedSQLStatement(stmtStr, this.getTblName());
                ps.clearParameters();
                if (fragMask.hasSubj()) {
                    ps.setString(argc++, argStr);
                } else if (fragMask.hasPred()) {
                    ps.setString(argc++, argStr);
                } else if (fragMask.hasObj()) {
                    ps.setString(argc++, argStr);
                }
                ps.setInt(argc++, my_GID.getIntID());
                ps.setString(argc, uriStr);
            }
            catch (Exception e) {
                logger.warn("Getting prepared statement for " + stmtStr + " Caught exception ", e);
                throw new JenaException("Exception during database access", e);
            }
            try {
                ps.executeUpdate();
            }
            catch (Exception e) {
                logger.debug("deleteFrag encountered exception ", e);
                throw new JenaException("Exception during database access", e);
            }
        }
        finally {
            if (ps != null) {
                this.m_sql.returnPreparedSQLStatement(ps);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapResultSetToNode
    implements Map1<List<String>, Node> {
        private MapResultSetToNode() {
        }

        @Override
        public Node map1(List<String> l) {
            String n = l.get(0);
            Node r = PSet_ReifStore_RDB.this.m_driver.RDBStringToNode(n);
            return r;
        }
    }
}

