/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.processors;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IProcessor;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class ProcessorsChain<Target, Result, P extends IProcessor>
extends ArrayList<P>
implements IProcessor<Target, Result> {
    private static final long serialVersionUID = 1289381455884215893L;
    protected boolean abortOnError = false;

    public boolean isAbortOnError() {
        return this.abortOnError;
    }

    public void setAbortOnError(boolean bl) {
        this.abortOnError = bl;
    }

    @Override
    public Result process(Target Target) throws AmbitException {
        Object object = Target;
        for (int i = 0; i < this.size(); ++i) {
            try {
                if (!((IProcessor)this.get(i)).isEnabled()) continue;
                this.preprocess((IProcessor)this.get(i), object);
                object = ((IProcessor)this.get(i)).process(object);
                this.postprocess((IProcessor)this.get(i), object);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.abortOnError) continue;
                throw new AmbitException(exception);
            }
        }
        try {
            return (Result)object;
        }
        catch (Exception exception) {
            throw new AmbitException(exception);
        }
    }

    protected void preprocess(P p, Object object) {
    }

    protected void postprocess(P p, Object object) {
    }

    public void close() {
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append(this.get(i));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isEnabled() {
        for (int i = 0; i < this.size(); ++i) {
            if (!((IProcessor)this.get(i)).isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean bl) {
        for (int i = 0; i < this.size(); ++i) {
            ((IProcessor)this.get(i)).setEnabled(bl);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public long getID() {
        return 0L;
    }
}

