/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.data.LiteratureEntry;
import ambit2.base.data.Property;
import ambit2.core.io.DelimitedFileWriter;
import ambit2.core.smiles.SmilesParserWrapper;
import java.util.ArrayList;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;
import org.openscience.cdk.tools.LoggingTool;

public abstract class IteratingFilesWithHeaderReader<COLUMN>
extends DefaultIteratingChemObjectReader {
    protected SmilesParserWrapper sp = SmilesParserWrapper.getInstance();
    protected InChIGeneratorFactory inchiFactory = null;
    protected static LoggingTool logger = new LoggingTool(DelimitedFileWriter.class);
    public static String defaultSMILESHeader = "SMILES";
    private ArrayList<COLUMN> header = null;
    protected int smilesIndex = -1;
    protected int inchiIndex = -1;
    protected long timeout = 60000L;
    protected int numberOfHeaderLines = 1;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public int getNumberOfHeaderLines() {
        return this.numberOfHeaderLines;
    }

    public void setNumberOfHeaderLines(int n) {
        this.numberOfHeaderLines = n;
    }

    protected abstract LiteratureEntry getReference();

    protected void addHeaderColumn(String string) {
        this.header.add(this.createPropertyByColumnName(string));
        this.fireIOSettingQuestion((IOSetting)new StringIOSetting(string, 1, Property.IO_QUESTION.IO_TRANSLATE_NAME.toString(), string));
    }

    protected void setHeaderColumn(int n, String string) {
        this.header.ensureCapacity(n);
        while (n > this.header.size()) {
            this.header.add(this.createPropertyByColumnName(""));
        }
        this.addHeaderColumn(string);
    }

    protected abstract COLUMN createPropertyByColumnName(String var1);

    protected COLUMN getHeaderColumn(int n) {
        return this.header.get(n);
    }

    protected int getNumberOfColumns() {
        return this.header.size();
    }

    protected boolean isHeaderEmpty() {
        boolean bl;
        boolean bl2 = bl = this.header == null;
        if (bl) {
            this.header = this.createHeader();
        }
        return bl;
    }

    protected abstract ArrayList<COLUMN> createHeader();
}

