/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class DownloadTool {
    public static void download(URL uRL, File file) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            DownloadTool.download(inputStream, file);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        finally {
            inputStream.close();
        }
    }

    public static void download(InputStream inputStream, File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            DownloadTool.download(inputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static void download(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[512];
        long l = 0L;
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        outputStream.flush();
    }

    public static void download(String string, OutputStream outputStream) throws IOException {
        InputStream inputStream = DownloadTool.class.getClassLoader().getResourceAsStream(string);
        try {
            DownloadTool.download(inputStream, outputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        finally {
            inputStream.close();
        }
    }

    public static void download(String string, File file) throws IOException {
        InputStream inputStream = DownloadTool.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(string);
        }
        try {
            DownloadTool.download(inputStream, file);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        finally {
            inputStream.close();
        }
    }

    private static void channelCopy1(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            writableByteChannel.write(byteBuffer);
            byteBuffer.compact();
        }
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            writableByteChannel.write(byteBuffer);
        }
    }

    public static void channelCopy2(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                writableByteChannel.write(byteBuffer);
            }
            byteBuffer.clear();
        }
    }
}

