/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.diff.AtomTypeDiff;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.DoubleDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IntegerDifference;
import org.openscience.cdk.tools.diff.tree.Point2dDifference;
import org.openscience.cdk.tools.diff.tree.Point3dDifference;

@TestClass(value="org.openscience.cdk.tools.diff.AtomDiffTest")
public class AtomDiff {
    private AtomDiff() {
    }

    @TestMethod(value="testMatchAgainstItself,testDiff")
    public static String diff(IChemObject first, IChemObject second) {
        IDifference diff = AtomDiff.difference(first, second);
        if (diff == null) {
            return "";
        }
        return diff.toString();
    }

    @TestMethod(value="testDifference")
    public static IDifference difference(IChemObject first, IChemObject second) {
        if (!(first instanceof IAtom) || !(second instanceof IAtom)) {
            return null;
        }
        IAtom firstElem = (IAtom)first;
        IAtom secondElem = (IAtom)second;
        ChemObjectDifference totalDiff = new ChemObjectDifference("AtomDiff");
        totalDiff.addChild(IntegerDifference.construct("H", firstElem.getImplicitHydrogenCount(), secondElem.getImplicitHydrogenCount()));
        totalDiff.addChild(IntegerDifference.construct("SP", firstElem.getStereoParity(), secondElem.getStereoParity()));
        totalDiff.addChild(Point2dDifference.construct("2D", firstElem.getPoint2d(), secondElem.getPoint2d()));
        totalDiff.addChild(Point3dDifference.construct("3D", firstElem.getPoint3d(), secondElem.getPoint3d()));
        totalDiff.addChild(Point3dDifference.construct("F3D", firstElem.getFractionalPoint3d(), secondElem.getFractionalPoint3d()));
        totalDiff.addChild(DoubleDifference.construct("C", firstElem.getCharge(), secondElem.getCharge()));
        totalDiff.addChild(AtomTypeDiff.difference(first, second));
        if (totalDiff.childCount() > 0) {
            return totalDiff;
        }
        return null;
    }
}

