/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import ambit2.smarts.SMIRKSManager;
import ambit2.smarts.SMIRKSReaction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import libpadeldescriptor.PaDELDearomatize;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.AtomTypeTools;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class PaDELStandardize {
    private boolean removeSalt_ = true;
    private boolean dearomatize_ = true;
    private boolean standardizeTautomers_ = true;
    private boolean standardizeNitro_ = true;
    private boolean retain3D_ = false;
    private String[] tautomerList_;

    public void setRemoveSalt(boolean bl) {
        this.removeSalt_ = bl;
    }

    public void setDearomatize(boolean bl) {
        this.dearomatize_ = bl;
    }

    public void setStandardizeTautomers(boolean bl) {
        this.standardizeTautomers_ = bl;
    }

    public String[] getTautomerList() {
        return this.tautomerList_;
    }

    public void setTautomerList(String[] stringArray) {
        this.tautomerList_ = stringArray;
    }

    public void setTautomerList(File file) {
        this.setTautomerList(PaDELStandardize.getTautomerList(file));
    }

    public static String[] getTautomerList(File file) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            stringArray = new BufferedReader(new FileReader(file));
            while ((string = stringArray.readLine()) != null) {
                if (string.trim().isEmpty() || string.startsWith("//")) continue;
                String[] stringArray2 = string.split("\\t");
                arrayList.add(stringArray2[0]);
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.FINE, exception.getMessage());
            return null;
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] getTautomerList(InputStream inputStream) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            stringArray = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = stringArray.readLine()) != null) {
                if (string.trim().isEmpty() || string.startsWith("//")) continue;
                String[] stringArray2 = string.split("\\t");
                arrayList.add(stringArray2[0]);
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.FINE, exception.getMessage());
            return null;
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public void setStandardizeNitro(boolean bl) {
        this.standardizeNitro_ = bl;
    }

    public void setRetain3D(boolean bl) {
        this.retain3D_ = bl;
    }

    public IAtomContainer Standardize(IAtomContainer iAtomContainer) throws Exception {
        if (this.removeSalt_) {
            iAtomContainer = this.RemoveSalt(iAtomContainer);
        }
        this.CleanMolecule(iAtomContainer);
        this.PerceiveAtomTypes(iAtomContainer);
        CDKHydrogenAdder cDKHydrogenAdder = CDKHydrogenAdder.getInstance(DefaultChemObjectBuilder.getInstance());
        cDKHydrogenAdder.addImplicitHydrogens(iAtomContainer);
        if (this.dearomatize_) {
            iAtomContainer = this.Dearomatize(iAtomContainer);
        }
        if (this.standardizeNitro_) {
            PaDELStandardize.StandardizeNitro2(iAtomContainer);
        }
        if (this.standardizeTautomers_) {
            iAtomContainer = this.StandardizeTautomers(iAtomContainer);
        }
        new AtomTypeTools().assignAtomTypePropertiesToAtom((IMolecule)iAtomContainer, false);
        cDKHydrogenAdder.addImplicitHydrogens(iAtomContainer);
        AtomContainerManipulator.convertImplicitToExplicitHydrogens(iAtomContainer);
        this.PerceiveAtomTypes(iAtomContainer);
        return iAtomContainer;
    }

    private IAtomContainer RemoveSalt(IAtomContainer iAtomContainer) {
        if (!ConnectivityChecker.isConnected(iAtomContainer)) {
            IMoleculeSet iMoleculeSet = ConnectivityChecker.partitionIntoMolecules(iAtomContainer);
            IMolecule iMolecule = iMoleculeSet.getMolecule(0);
            for (int i = 1; i < iMoleculeSet.getMoleculeCount(); ++i) {
                if (iMoleculeSet.getMolecule(i).getBondCount() <= iMolecule.getBondCount()) continue;
                iMolecule = iMoleculeSet.getMolecule(i);
            }
            iAtomContainer = (Molecule)iMolecule;
        }
        return iAtomContainer;
    }

    private void CleanMolecule(IAtomContainer iAtomContainer) {
        for (IAtom iAtom : iAtomContainer.atoms()) {
            if (iAtom.getAtomicNumber() == CDKConstants.UNSET) {
                iAtom.setAtomicNumber(PeriodicTable.getAtomicNumber(iAtom.getSymbol()));
            }
            if (iAtom.getAtomicNumber() != 7 || iAtomContainer.getConnectedBondsCount(iAtom) != 4 || iAtom.getFormalCharge() != 0) continue;
            iAtom.setFormalCharge(1);
        }
    }

    private void PerceiveAtomTypes(IAtomContainer iAtomContainer) throws CDKException {
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(iAtomContainer);
        boolean bl = false;
        do {
            bl = false;
            for (IBond iBond : iAtomContainer.bonds()) {
                if (!iBond.getFlag(5)) continue;
                for (IAtom iAtom : iBond.atoms()) {
                    if (iAtom.getFlag(5)) continue;
                    iAtom.setFlag(5, true);
                    bl = true;
                }
            }
            for (IBond iBond : iAtomContainer.bonds()) {
                if (iBond.getFlag(5)) continue;
                boolean bl2 = true;
                for (IAtom iAtom : iBond.atoms()) {
                    if (iAtom.getFlag(5)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2 || iBond.getFlag(5)) continue;
                iBond.setFlag(5, true);
                bl = true;
            }
        } while (bl);
    }

    private IAtomContainer Dearomatize(IAtomContainer iAtomContainer) throws InvalidSmilesException, CDKException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.setLength(0);
        if (iAtomContainer.getProperty("cdk:Title") != null) {
            stringBuffer.append(iAtomContainer.getProperty("cdk:Title"));
        }
        if (!this.retain3D_) {
            iAtomContainer = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        }
        iAtomContainer = PaDELDearomatize.Dearomatize(iAtomContainer);
        CDKHydrogenAdder cDKHydrogenAdder = CDKHydrogenAdder.getInstance(DefaultChemObjectBuilder.getInstance());
        cDKHydrogenAdder.addImplicitHydrogens(iAtomContainer);
        if (!this.retain3D_) {
            iAtomContainer = new SmilesParser(DefaultChemObjectBuilder.getInstance()).parseSmiles(new SmilesGenerator(true).createSMILES(iAtomContainer));
            iAtomContainer.setProperty("cdk:Title", stringBuffer.toString());
        }
        CDKHueckelAromaticityDetector.detectAromaticity(iAtomContainer);
        return iAtomContainer;
    }

    private IAtomContainer StandardizeTautomers(IAtomContainer iAtomContainer) throws CDKException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.setLength(0);
        if (iAtomContainer.getProperty("cdk:Title") != null) {
            stringBuffer.append(iAtomContainer.getProperty("cdk:Title"));
        }
        CDKHydrogenAdder cDKHydrogenAdder = CDKHydrogenAdder.getInstance(DefaultChemObjectBuilder.getInstance());
        cDKHydrogenAdder.addImplicitHydrogens(iAtomContainer);
        AtomContainerManipulator.convertImplicitToExplicitHydrogens(iAtomContainer);
        this.PerceiveAtomTypes(iAtomContainer);
        if (this.tautomerList_ != null) {
            int n = 0;
            int n2 = -1;
            int n3 = 100;
            boolean bl = true;
            int n4 = this.tautomerList_.length;
            SMIRKSManager sMIRKSManager = new SMIRKSManager(DefaultChemObjectBuilder.getInstance());
            do {
                String string = this.tautomerList_[n];
                SMIRKSReaction sMIRKSReaction = sMIRKSManager.parse(string);
                try {
                    if (n2 == n) {
                        bl = false;
                    } else if (sMIRKSManager.applyTransformation(iAtomContainer, sMIRKSReaction)) {
                        n2 = n;
                        if (!this.retain3D_) {
                            iAtomContainer = new SmilesParser(DefaultChemObjectBuilder.getInstance()).parseSmiles(new SmilesGenerator(true).createSMILES(iAtomContainer));
                            iAtomContainer.setProperty("cdk:Title", stringBuffer.toString());
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.FINE, "SMIRKSManager:" + stringBuffer.toString() + ":" + exception.getMessage());
                }
                if (n == n4 - 1) {
                    if (n2 == -1) {
                        bl = false;
                        continue;
                    }
                    n = 0;
                    continue;
                }
                ++n;
            } while (bl && --n3 > 0);
        }
        return iAtomContainer;
    }

    public static void StandardizeNitro(IAtomContainer iAtomContainer) {
        for (IAtom iAtom : iAtomContainer.atoms()) {
            List<IAtom> list;
            List<IAtom> list2;
            if (iAtom.getAtomicNumber() != 7 || (list2 = iAtomContainer.getConnectedAtomsList(iAtom)).size() != 3) continue;
            int n = 0;
            boolean bl = true;
            block1: for (IAtom iAtom2 : list2) {
                if (iAtom2.getAtomicNumber() != 8) continue;
                ++n;
                list = iAtomContainer.getConnectedAtomsList(iAtom2);
                for (IAtom iAtom3 : list) {
                    if (iAtom3 == iAtom || iAtom3.getAtomicNumber() == 1) continue;
                    bl = false;
                    continue block1;
                }
            }
            if (n != 2 || !bl) continue;
            iAtom.setFlag(5, true);
            iAtom.setFormalCharge(0);
            iAtom.setHybridization(IAtomType.Hybridization.SP2);
            iAtom.setImplicitHydrogenCount(0);
            iAtom.setAtomTypeName("N.sp2");
            for (IAtom iAtom2 : list2) {
                if (iAtom2.getAtomicNumber() == 8) {
                    iAtom2.setFlag(5, true);
                    iAtom2.setFormalCharge(0);
                    iAtom2.setHybridization(IAtomType.Hybridization.SP2);
                    iAtom2.setAtomTypeName("O.sp2");
                    iAtom2.setImplicitHydrogenCount(0);
                    list = iAtomContainer.getConnectedAtomsList(iAtom2);
                    for (IAtom iAtom3 : list) {
                        if (iAtom3 == iAtom) continue;
                        iAtomContainer.removeBond(iAtom2, iAtom3);
                        iAtomContainer.removeAtom(iAtom3);
                    }
                    IBond iBond = iAtomContainer.getBond(iAtom, iAtom2);
                    iBond.setOrder(IBond.Order.SINGLE);
                    iBond.setFlag(5, true);
                    continue;
                }
                if (!iAtom2.getFlag(5)) continue;
                iAtomContainer.getBond(iAtom, iAtom2).setFlag(5, true);
            }
        }
    }

    public static void StandardizeNitro2(IAtomContainer iAtomContainer) {
        for (IAtom iAtom : iAtomContainer.atoms()) {
            Object object;
            Object object2;
            List<IAtom> list;
            if (iAtom.getAtomicNumber() != 7 || (list = iAtomContainer.getConnectedAtomsList(iAtom)).size() != 3) continue;
            int n = 0;
            boolean bl = true;
            block1: for (IAtom iAtom2 : list) {
                if (iAtom2.getAtomicNumber() != 8) continue;
                ++n;
                Object object3 = iAtomContainer.getConnectedAtomsList(iAtom2);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (object == iAtom || object.getAtomicNumber() == 1) continue;
                    bl = false;
                    continue block1;
                }
            }
            if (n != 2 || !bl) continue;
            iAtom.setFlag(5, false);
            iAtom.setFormalCharge(1);
            iAtom.setHybridization(IAtomType.Hybridization.SP2);
            iAtom.setImplicitHydrogenCount(0);
            iAtom.setAtomTypeName("N.plus.sp2");
            boolean bl2 = true;
            for (Object object3 : list) {
                if (object3.getAtomicNumber() == 8) {
                    object3.setImplicitHydrogenCount(0);
                    object2 = iAtomContainer.getConnectedAtomsList((IAtom)object3);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        IAtom iAtom3 = (IAtom)object.next();
                        if (iAtom3 == iAtom) continue;
                        iAtomContainer.removeBond((IAtom)object3, iAtom3);
                        iAtomContainer.removeAtom(iAtom3);
                    }
                    object = iAtomContainer.getBond(iAtom, (IAtom)object3);
                    if (bl2) {
                        object3.setFlag(5, false);
                        object3.setFormalCharge(-1);
                        object3.setHybridization(IAtomType.Hybridization.SP3);
                        object3.setAtomTypeName("O.minus");
                        object.setOrder(IBond.Order.SINGLE);
                        object.setFlag(5, false);
                        bl2 = false;
                        continue;
                    }
                    object3.setFlag(5, false);
                    object3.setFormalCharge(0);
                    object3.setHybridization(IAtomType.Hybridization.SP2);
                    object3.setAtomTypeName("O.sp2");
                    object.setOrder(IBond.Order.DOUBLE);
                    object.setFlag(5, false);
                    bl2 = true;
                    continue;
                }
                if (!object3.getFlag(5)) continue;
                iAtomContainer.getBond(iAtom, (IAtom)object3).setFlag(5, false);
            }
        }
    }

    public static void StandardizeNitro3(IAtomContainer iAtomContainer) {
        for (IAtom iAtom : iAtomContainer.atoms()) {
            List<IAtom> list;
            List<IAtom> list2;
            if (iAtom.getAtomicNumber() != 7 || (list2 = iAtomContainer.getConnectedAtomsList(iAtom)).size() != 3) continue;
            int n = 0;
            boolean bl = true;
            block1: for (IAtom iAtom2 : list2) {
                if (iAtom2.getAtomicNumber() != 8) continue;
                ++n;
                list = iAtomContainer.getConnectedAtomsList(iAtom2);
                for (IAtom iAtom3 : list) {
                    if (iAtom3 == iAtom || iAtom3.getAtomicNumber() == 1) continue;
                    bl = false;
                    continue block1;
                }
            }
            if (n != 2 || !bl) continue;
            iAtom.setFlag(5, false);
            iAtom.setFormalCharge(1);
            iAtom.setHybridization(IAtomType.Hybridization.SP2);
            iAtom.setImplicitHydrogenCount(0);
            iAtom.setAtomTypeName("N.sp2");
            for (IAtom iAtom2 : list2) {
                if (iAtom2.getAtomicNumber() == 8) {
                    iAtom2.setImplicitHydrogenCount(0);
                    list = iAtomContainer.getConnectedAtomsList(iAtom2);
                    for (IAtom iAtom3 : list) {
                        if (iAtom3 == iAtom) continue;
                        iAtomContainer.removeBond(iAtom2, iAtom3);
                        iAtomContainer.removeAtom(iAtom3);
                    }
                    IBond iBond = iAtomContainer.getBond(iAtom, iAtom2);
                    iAtom2.setFlag(5, false);
                    iAtom2.setFormalCharge(0);
                    iAtom2.setHybridization(IAtomType.Hybridization.SP2);
                    iAtom2.setAtomTypeName("O.sp2");
                    iBond.setOrder(IBond.Order.DOUBLE);
                    iBond.setFlag(5, false);
                    continue;
                }
                if (!iAtom2.getFlag(5)) continue;
                iAtomContainer.getBond(iAtom, iAtom2).setFlag(5, false);
            }
        }
    }
}

