/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.chemistry.CompoundAbstractProcessing;
import com.rapidminer.operator.chemistry.Compounds;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

public class CompoundCountSubstructure
extends CompoundAbstractProcessing {
    public static final String PARAMETER_SMARTS = "SMARTS";

    public CompoundCountSubstructure(OperatorDescription operatorDescription) {
        super(operatorDescription);
    }

    public List<ParameterType> getParameterTypes() {
        List list = super.getParameterTypes();
        ParameterTypeString parameterTypeString = null;
        parameterTypeString = new ParameterTypeString(PARAMETER_SMARTS, "SMARTS pattern.", false);
        parameterTypeString.setExpert(false);
        list.add(parameterTypeString);
        return list;
    }

    public void doWork() throws OperatorException {
        Compounds compounds = (Compounds)this.molInput.getData();
        Compounds compounds2 = new Compounds();
        String string = this.getParameterAsString(PARAMETER_SMARTS);
        ArrayList<String> arrayList = new ArrayList<String>(compounds.size());
        int n = compounds.size();
        for (int i = 0; i < n; ++i) {
            IAtomContainer iAtomContainer = compounds.getMolecule(i);
            try {
                compounds2.addMolecule(iAtomContainer.clone());
                SMARTSQueryTool sMARTSQueryTool = new SMARTSQueryTool(string);
                if (sMARTSQueryTool.matches(iAtomContainer)) {
                    arrayList.add(String.valueOf(sMARTSQueryTool.getUniqueMatchingAtoms().size()));
                    continue;
                }
                arrayList.add("0");
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.FINE, null, exception);
            }
        }
        compounds.addColumn(string, arrayList.toArray(new String[0]));
        this.molOriginal.deliver((IOObject)compounds2);
        this.molOutput.deliver((IOObject)compounds);
    }
}

