/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class HeavyAtomCountDescriptor
implements IMolecularDescriptor {
    public static final String[] names = new String[]{"nHeavyAtom"};
    private String elementName = "*";

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("atomCount", this.getClass().getName(), "$Id: HeavyAtomCountDescriptor.java 1 2010-05-01 10:12:38Z yapchunwei $", "PaDEL");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
        if (objectArray.length > 1) {
            throw new CDKException("AtomCount only expects one parameter");
        }
        if (!(objectArray[0] instanceof String)) {
            throw new CDKException("The parameter must be of type String");
        }
        this.elementName = (String)objectArray[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] objectArray = new Object[]{this.elementName};
        return objectArray;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        this.elementName = "*";
        int n = this.CountAtoms(iAtomContainer);
        if (n == -1) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("The supplied AtomContainer was NULL"));
        }
        if (n == -2) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("The supplied AtomContainer did not have any atoms"));
        }
        this.elementName = "H";
        int n2 = this.CountAtoms(iAtomContainer);
        if (n2 == -1) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("The supplied AtomContainer was NULL"));
        }
        if (n2 == -2) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("The supplied AtomContainer did not have any atoms"));
        }
        int n3 = n - n2;
        if (n3 < 0) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("Number of heavy atoms is less than zero"));
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(n3), this.getDescriptorNames());
    }

    private int CountAtoms(IAtomContainer iAtomContainer) {
        int n = 0;
        if (iAtomContainer == null) {
            return -1;
        }
        if (iAtomContainer.getAtomCount() == 0) {
            return -2;
        }
        if (this.elementName.equals("*")) {
            for (int i = 0; i < iAtomContainer.getAtomCount(); ++i) {
                Integer n2 = iAtomContainer.getAtom(i).getImplicitHydrogenCount();
                if (n2 == CDKConstants.UNSET) continue;
                n += n2.intValue();
            }
            n += iAtomContainer.getAtomCount();
        } else if (this.elementName.equals("H")) {
            for (int i = 0; i < iAtomContainer.getAtomCount(); ++i) {
                if (iAtomContainer.getAtom(i).getSymbol().equals(this.elementName)) {
                    ++n;
                    continue;
                }
                Integer n3 = iAtomContainer.getAtom(i).getImplicitHydrogenCount();
                if (n3 == CDKConstants.UNSET) continue;
                n += n3.intValue();
            }
        } else {
            for (int i = 0; i < iAtomContainer.getAtomCount(); ++i) {
                if (!iAtomContainer.getAtom(i).getSymbol().equals(this.elementName)) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] stringArray = new String[]{"elementName"};
        return stringArray;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return "";
    }
}

