/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.Image;
import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Circle3D;
import org.jmol.g3d.Colix3D;
import org.jmol.g3d.Cylinder3D;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Hermite3D;
import org.jmol.g3d.Line3D;
import org.jmol.g3d.Normix3D;
import org.jmol.g3d.Platform3D;
import org.jmol.g3d.Rgb16;
import org.jmol.g3d.Shade3D;
import org.jmol.g3d.Sphere3D;
import org.jmol.g3d.Text3D;
import org.jmol.g3d.Triangle3D;
import org.jmol.modelset.Atom;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public final class Graphics3D
implements JmolRendererInterface {
    Platform3D platform;
    Line3D line3d;
    Circle3D circle3d;
    Sphere3D sphere3d;
    Triangle3D triangle3d;
    Cylinder3D cylinder3d;
    Hermite3D hermite3d;
    Normix3D normix3d;
    boolean isFullSceneAntialiasingEnabled;
    private boolean antialiasThisFrame;
    private boolean antialias2;
    private boolean antialiasEnabled;
    boolean inGreyscaleMode;
    byte[] anaglyphChannelBytes;
    boolean twoPass = false;
    boolean isPass2;
    boolean addAllPixels;
    boolean haveTranslucentObjects;
    boolean translucentCoverOnly = false;
    int windowWidth;
    int windowHeight;
    int width;
    int height;
    int displayMinX;
    int displayMaxX;
    int displayMinY;
    int displayMaxY;
    int slab;
    int depth;
    int zSlab;
    int zDepth;
    boolean zShade;
    int xLast;
    int yLast;
    int[] pbuf;
    int[] pbufT;
    int[] zbuf;
    int[] zbufT;
    int bufferSize;
    short colixCurrent;
    int[] shadesCurrent;
    int argbCurrent;
    boolean isScreened;
    int translucencyMask;
    int argbNoisyUp;
    int argbNoisyDn;
    Font3D font3dCurrent;
    public static final byte ENDCAPS_NONE = 0;
    public static final byte ENDCAPS_OPEN = 1;
    public static final byte ENDCAPS_FLAT = 2;
    public static final byte ENDCAPS_SPHERICAL = 3;
    public static final byte ENDCAPS_OPENEND = 4;
    public static final short INHERIT_ALL = 0;
    public static final short USE_PALETTE = 2;
    public static final short BLACK = 4;
    public static final short ORANGE = 5;
    public static final short PINK = 6;
    public static final short BLUE = 7;
    public static final short WHITE = 8;
    public static final short CYAN = 9;
    public static final short RED = 10;
    public static final short GREEN = 11;
    public static final short GRAY = 12;
    public static final short SILVER = 13;
    public static final short LIME = 14;
    public static final short MAROON = 15;
    public static final short NAVY = 16;
    public static final short OLIVE = 17;
    public static final short PURPLE = 18;
    public static final short TEAL = 19;
    public static final short MAGENTA = 20;
    public static final short YELLOW = 21;
    public static final short HOTPINK = 22;
    public static final short GOLD = 23;
    int newWindowWidth;
    int newWindowHeight;
    boolean newAntialiasing;
    public double random;
    int anaglyphLength;
    public Image backgroundImage;
    public int bgcolor;
    Pixel pixel;
    int zShadeR;
    int zShadeG;
    int zShadeB;
    private int currentShadeIndex;
    int zMargin;
    boolean currentlyRendering;
    static final int yGT = 1;
    static final int yLT = 2;
    static final int xGT = 4;
    static final int xLT = 8;
    static final int zGT = 16;
    static final int zLT = 32;
    private static final short CHANGEABLE_MASK = Short.MIN_VALUE;
    private static final short UNMASK_CHANGEABLE_TRANSLUCENT = 2047;
    private static final int TRANSLUCENT_SHIFT = 11;
    private static final int ALPHA_SHIFT = 13;
    private static final int TRANSLUCENT_MASK = 30720;
    private static final int TRANSLUCENT_SCREENED = 30720;
    private static final int TRANSPARENT = 16384;
    static final int TRANSLUCENT_50 = 8192;
    public static final short OPAQUE_MASK = -30721;
    private static final short INHERIT_COLOR = 1;
    static final short UNUSED_OPTION3 = 3;
    static final short SPECIAL_COLIX_MAX = 4;
    private short[] changeableColixMap = new short[16];
    private final Vector3f vectorAB = new Vector3f();
    private final Vector3f vectorAC = new Vector3f();
    private final Vector3f vectorNormal = new Vector3f();
    private static final String[] colorNames = new String[]{"black", "pewhite", "pecyan", "pepurple", "pegreen", "peblue", "peviolet", "pebrown", "pepink", "peyellow", "pedarkgreen", "peorange", "pelightblue", "pedarkcyan", "pedarkgray", "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen", "bluetint", "greenblue", "greentint", "grey", "pinktint", "redorange", "yellowtint"};
    private static final int[] colorArgbs = new int[]{-16777216, -1, -16711681, -3137281, -16711936, -10460929, -32576, -6021080, -10024, -256, -16728064, -20480, -5197569, -16736096, -10461088, -984833, -332841, -16711681, -8388652, -983041, -657956, -6972, -5171, -16776961, -7722014, -5952982, -2180985, -10510688, -8388864, -2987746, -32944, -10185235, -1828, -2354116, -16711681, -16777077, -16741493, -4684277, -5658199, -16751616, -4343957, -7667573, -11179217, -29696, -6737204, -7667712, -1468806, -7357297, -12042869, -13676721, -16724271, -7077677, -60269, -16728065, -9868951, -14774017, -5103070, -1296, -14513374, -65281, -2302756, -460545, -10496, -2448096, -8355712, -16744448, -5374161, -983056, -38476, -3318692, -11861886, -16, -989556, -1644806, -3851, -8586240, -1331, -5383962, -1015680, -2031617, -329006, -7278960, -2894893, -18751, -24454, -14634326, -7876870, -8943463, -5192482, -32, -16711936, -13447886, -331546, -65281, -8388608, -10039894, -16777011, -4565549, -7114533, -12799119, -8689426, -16713062, -12004916, -3730043, -15132304, -655366, -6943, -6987, -8531, -16777088, -133658, -8355840, -9728477, -23296, -47872, -2461482, -1120086, -6751336, -5247250, -2396013, -4139, -9543, -3308225, -16181, -2252579, -5185306, -8388480, -65536, -4419697, -12490271, -7650029, -360334, -744352, -13726889, -2578, -6270419, -4144960, -7876885, -9807155, -9404272, -1286, -16711809, -12156236, -2968436, -16744320, -2572328, -40121, -12525360, -1146130, -663885, -1, -657931, -256, -6632142, -5253121, -13726889, -6750285, -8355712, -21573, -47872, -592267};
    private static final Hashtable mapJavaScriptColors = new Hashtable();
    public static final short NORMIX_NULL = 9999;
    public static final int EXPORT_NOT = 0;
    public static final int EXPORT_CARTESIAN = 1;
    public static final int EXPORT_RAYTRACER = 2;

    public void destroy() {
        this.releaseBuffers();
        this.platform = null;
    }

    public boolean isDisplayAntialiased() {
        return this.antialiasEnabled;
    }

    public boolean isAntialiased() {
        return this.antialiasThisFrame;
    }

    public void setTranslucentCoverOnly(boolean bl) {
        this.translucentCoverOnly = bl;
    }

    public Graphics3D(Component component) {
        this.platform = Platform3D.createInstance(component);
        this.line3d = new Line3D(this);
        this.circle3d = new Circle3D(this);
        this.sphere3d = new Sphere3D(this);
        this.triangle3d = new Triangle3D(this);
        this.cylinder3d = new Cylinder3D(this);
        this.hermite3d = new Hermite3D(this);
        this.normix3d = new Normix3D();
    }

    public boolean currentlyRendering() {
        return this.currentlyRendering;
    }

    public void setWindowParameters(int n, int n2, boolean bl) {
        this.newWindowWidth = n;
        this.newWindowHeight = n2;
        this.newAntialiasing = bl;
        if (this.currentlyRendering) {
            this.endRendering();
        }
    }

    public void setNewWindowParametersForExport() {
        this.windowWidth = this.newWindowWidth;
        this.windowHeight = this.newWindowHeight;
        this.setWidthHeight(false);
    }

    private void setWidthHeight(boolean bl) {
        this.width = this.windowWidth;
        this.height = this.windowHeight;
        if (bl) {
            this.width <<= 1;
            this.height <<= 1;
        }
        this.xLast = this.width - 1;
        this.yLast = this.height - 1;
        this.displayMinX = -(this.width >> 1);
        this.displayMaxX = this.width - this.displayMinX;
        this.displayMinY = -(this.height >> 1);
        this.displayMaxY = this.height - this.displayMinY;
        this.bufferSize = this.width * this.height;
    }

    public boolean checkTranslucent(boolean bl) {
        if (bl) {
            this.haveTranslucentObjects = true;
        }
        return !this.twoPass || this.twoPass && this.isPass2 == bl;
    }

    public void beginRendering(Matrix3f matrix3f) {
        if (this.currentlyRendering) {
            this.endRendering();
        }
        if (this.windowWidth != this.newWindowWidth || this.windowHeight != this.newWindowHeight || this.newAntialiasing != this.isFullSceneAntialiasingEnabled) {
            this.windowWidth = this.newWindowWidth;
            this.windowHeight = this.newWindowHeight;
            this.isFullSceneAntialiasingEnabled = this.newAntialiasing;
            this.releaseBuffers();
        }
        this.normix3d.setRotationMatrix(matrix3f);
        this.antialiasEnabled = this.antialiasThisFrame = this.newAntialiasing;
        this.currentlyRendering = true;
        this.twoPass = true;
        this.isPass2 = false;
        this.colixCurrent = 0;
        this.haveTranslucentObjects = false;
        this.addAllPixels = true;
        if (this.pbuf == null) {
            this.platform.allocateBuffers(this.windowWidth, this.windowHeight, this.antialiasThisFrame);
            this.pbuf = this.platform.pBuffer;
            this.zbuf = this.platform.zBuffer;
        }
        this.setWidthHeight(this.antialiasThisFrame);
        this.platform.obtainScreenBuffer();
        if (this.backgroundImage != null) {
            this.plotImage(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, this.backgroundImage, null, (short)0, 0, 0);
        }
        this.random = Math.random();
    }

    private void releaseBuffers() {
        this.pbuf = null;
        this.zbuf = null;
        this.pbufT = null;
        this.zbufT = null;
        this.platform.releaseBuffers();
    }

    public boolean setPass2(boolean bl) {
        if (!this.haveTranslucentObjects || !this.currentlyRendering) {
            return false;
        }
        this.isPass2 = true;
        this.colixCurrent = 0;
        this.addAllPixels = true;
        if (this.pbufT == null || this.antialias2 != bl) {
            this.platform.allocateTBuffers(bl);
            this.pbufT = this.platform.pBufferT;
            this.zbufT = this.platform.zBufferT;
        }
        this.antialias2 = bl;
        if (this.antialiasThisFrame && !this.antialias2) {
            this.downsampleFullSceneAntialiasing(true);
        }
        this.platform.clearTBuffer();
        return true;
    }

    public void endRendering() {
        if (!this.currentlyRendering) {
            return;
        }
        if (this.pbuf != null) {
            if (this.isPass2) {
                this.mergeOpaqueAndTranslucentBuffers();
            }
            if (this.antialiasThisFrame) {
                this.downsampleFullSceneAntialiasing(false);
            }
        }
        this.platform.setBackgroundColor(this.bgcolor);
        this.platform.notifyEndOfRendering();
        this.currentlyRendering = false;
    }

    public void snapshotAnaglyphChannelBytes() {
        if (this.currentlyRendering) {
            throw new NullPointerException();
        }
        this.anaglyphLength = this.windowWidth * this.windowHeight;
        if (this.anaglyphChannelBytes == null || this.anaglyphChannelBytes.length != this.anaglyphLength) {
            this.anaglyphChannelBytes = new byte[this.anaglyphLength];
        }
        int n = this.anaglyphLength;
        while (--n >= 0) {
            this.anaglyphChannelBytes[n] = (byte)this.pbuf[n];
        }
    }

    public void applyCustomAnaglyph(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1] & 0xFFFFFF;
        int n3 = this.anaglyphLength;
        while (--n3 >= 0) {
            int n4 = this.anaglyphChannelBytes[n3] & 0xFF;
            n4 = (n4 | (n4 | n4 << 8) << 8) & n2;
            this.pbuf[n3] = this.pbuf[n3] & n | n4;
        }
    }

    public void applyGreenAnaglyph() {
        int n = this.anaglyphLength;
        while (--n >= 0) {
            int n2 = (this.anaglyphChannelBytes[n] & 0xFF) << 8;
            this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n2;
        }
    }

    public void applyBlueAnaglyph() {
        int n = this.anaglyphLength;
        while (--n >= 0) {
            int n2 = this.anaglyphChannelBytes[n] & 0xFF;
            this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n2;
        }
    }

    public void applyCyanAnaglyph() {
        int n = this.anaglyphLength;
        while (--n >= 0) {
            int n2 = this.anaglyphChannelBytes[n] & 0xFF;
            int n3 = n2 << 8 | n2;
            this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n3;
        }
    }

    public Image getScreenImage() {
        return this.platform.imagePixelBuffer;
    }

    public void releaseScreenImage() {
        this.platform.clearScreenBufferThreaded();
    }

    public boolean haveTranslucentObjects() {
        return this.haveTranslucentObjects;
    }

    public int getRenderWidth() {
        return this.width;
    }

    public int getRenderHeight() {
        return this.height;
    }

    public int getSlab() {
        return this.slab;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setBackgroundTransparent(boolean bl) {
        if (this.platform != null) {
            this.platform.setBackgroundTransparent(bl);
        }
    }

    public void setBackgroundArgb(int n) {
        this.bgcolor = n;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public void setGreyscaleMode(boolean bl) {
        this.inGreyscaleMode = bl;
    }

    public void setSlabAndDepthValues(int n, int n2, boolean bl, int n3, int n4) {
        this.slab = n < 0 ? 0 : n;
        this.depth = n2 < 0 ? 0 : n2;
        this.zShade = bl;
        if (bl) {
            this.zSlab = n3 < 0 ? 0 : n3;
            this.zDepth = n4 < 0 ? 0 : n4;
            this.zShadeR = this.bgcolor & 0xFF;
            this.zShadeG = (this.bgcolor & 0xFF00) >> 8;
            this.zShadeB = (this.bgcolor & 0xFF0000) >> 16;
            this.pixel = new ShadePixel();
        } else {
            this.pixel = new Pixel();
        }
    }

    public void setSlab(int n) {
        this.slab = n;
    }

    private void downsampleFullSceneAntialiasing(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.width;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.bgcolor;
        if (bl) {
            n7 += (n7 & 0xFF) == 255 ? -1 : 1;
        }
        for (n3 = 0; n3 < this.pbuf.length; ++n3) {
            if (this.pbuf[n3] != 0) continue;
            this.pbuf[n3] = n7;
        }
        n7 &= 0xFFFFFF;
        n3 = this.windowHeight;
        while (--n3 >= 0) {
            n2 = this.windowWidth;
            while (--n2 >= 0) {
                n = (this.pbuf[n6] >> 2 & 0x3F3F3F3F) + (this.pbuf[n6++ + n4] >> 2 & 0x3F3F3F3F) + (this.pbuf[n6] >> 2 & 0x3F3F3F3F) + (this.pbuf[n6++ + n4] >> 2 & 0x3F3F3F3F);
                n += (n & 0xC0C0C0C0) >> 6;
                this.pbuf[n5] = n & 0xFFFFFF;
                ++n5;
            }
            n6 += n4;
        }
        if (bl) {
            n6 = 0;
            n5 = 0;
            n3 = this.windowHeight;
            while (--n3 >= 0) {
                n2 = this.windowWidth;
                while (--n2 >= 0) {
                    n = Math.min(this.zbuf[n6], this.zbuf[n6 + n4]);
                    n = Math.min(n, this.zbuf[++n6]);
                    if ((n = Math.min(n, this.zbuf[n6 + n4])) != Integer.MAX_VALUE) {
                        n >>= 1;
                    }
                    this.zbuf[n5] = this.pbuf[n5] == n7 ? Integer.MAX_VALUE : n;
                    ++n5;
                    ++n6;
                }
                n6 += n4;
            }
            this.antialiasThisFrame = false;
            this.setWidthHeight(false);
        }
    }

    void mergeOpaqueAndTranslucentBuffers() {
        if (this.pbufT == null) {
            return;
        }
        for (int i = 0; i < this.bufferSize; ++i) {
            Graphics3D.mergeBufferPixel(this.pbuf, this.pbufT[i], i, this.bgcolor);
        }
    }

    static void averageBufferPixel(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray[n - n2];
        int n4 = nArray[n + n2];
        if (n3 == 0 || n4 == 0) {
            return;
        }
        nArray2[n] = ((n3 & 0xFF000000) >> 1) + ((n4 & 0xFF000000) >> 1) << 1 | (n3 & 0xFF00FF) + (n4 & 0xFF00FF) >> 1 & 0xFF00FF | (n3 & 0xFF00) + (n4 & 0xFF00) >> 1 & 0xFF00;
    }

    static void mergeBufferPixel(int[] nArray, int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        int n4 = nArray[n2];
        if (n4 == n) {
            return;
        }
        if (n4 == 0) {
            n4 = n3;
        }
        int n5 = n4 & 0xFF00FF;
        int n6 = n4 & 0xFF00;
        int n7 = n & 0xFF00FF;
        int n8 = n & 0xFF00;
        int n9 = n >> 24 & 7;
        switch (n9) {
            case 1: {
                n5 = (n7 << 2) + (n7 << 1) + n7 + n5 >> 3 & 0xFF00FF;
                n6 = (n8 << 2) + (n8 << 1) + n8 + n6 >> 3 & 0xFF00;
                break;
            }
            case 2: {
                n5 = (n7 << 1) + n7 + n5 >> 2 & 0xFF00FF;
                n6 = (n8 << 1) + n8 + n6 >> 2 & 0xFF00;
                break;
            }
            case 3: {
                n5 = (n7 << 2) + n7 + (n5 << 1) + n5 >> 3 & 0xFF00FF;
                n6 = (n8 << 2) + n8 + (n6 << 1) + n6 >> 3 & 0xFF00;
                break;
            }
            case 4: {
                n5 = n5 + n7 >> 1 & 0xFF00FF;
                n6 = n6 + n8 >> 1 & 0xFF00;
                break;
            }
            case 5: {
                n5 = (n7 << 1) + n7 + (n5 << 2) + n5 >> 3 & 0xFF00FF;
                n6 = (n8 << 1) + n8 + (n6 << 2) + n6 >> 3 & 0xFF00;
                break;
            }
            case 6: {
                n5 = (n5 << 1) + n5 + n7 >> 2 & 0xFF00FF;
                n6 = (n6 << 1) + n6 + n8 >> 2 & 0xFF00;
                break;
            }
            case 7: {
                n5 = (n5 << 2) + (n5 << 1) + n5 + n7 >> 3 & 0xFF00FF;
                n6 = (n6 << 2) + (n6 << 1) + n6 + n8 >> 3 & 0xFF00;
            }
        }
        nArray[n2] = 0xFF000000 | n5 | n6;
    }

    public boolean hasContent() {
        return this.platform.hasContent();
    }

    public boolean setColix(short s) {
        if (s == this.colixCurrent && this.currentShadeIndex == -1) {
            return true;
        }
        int n = s & 0x7800;
        if (n == 16384) {
            return false;
        }
        boolean bl = n != 0;
        this.isScreened = bl && n == 30720;
        if (!this.checkTranslucent(bl && !this.isScreened)) {
            return false;
        }
        boolean bl2 = this.addAllPixels = this.isPass2 || !bl;
        if (this.isPass2) {
            this.translucencyMask = n << 13 | 0xFFFFFF;
        }
        this.colixCurrent = s;
        this.shadesCurrent = this.getShades(s);
        this.currentShadeIndex = -1;
        this.argbNoisyUp = this.argbNoisyDn = this.getColorArgbOrGray(s);
        this.argbCurrent = this.argbNoisyDn;
        return true;
    }

    void setZMargin(int n) {
        this.zMargin = n;
    }

    void addPixel(int n, int n2, int n3) {
        this.pixel.addPixel(n, n2, n3);
    }

    public void drawFilledCircle(short s, short s2, int n, int n2, int n3, int n4) {
        boolean bl;
        if (this.isClippedZ(n4)) {
            return;
        }
        int n5 = (n + 1) / 2;
        boolean bl2 = bl = n2 < n5 || n2 + n5 >= this.width || n3 < n5 || n3 + n5 >= this.height;
        if (bl && this.isClippedXY(n, n2, n3)) {
            return;
        }
        if (s != 0 && this.setColix(s)) {
            if (bl) {
                this.circle3d.plotCircleCenteredClipped(n2, n3, n4, n);
            } else {
                this.circle3d.plotCircleCenteredUnclipped(n2, n3, n4, n);
            }
        }
        if (s2 != 0 && this.setColix(s2)) {
            if (bl) {
                this.circle3d.plotFilledCircleCenteredClipped(n2, n3, n4, n);
            } else {
                this.circle3d.plotFilledCircleCenteredUnclipped(n2, n3, n4, n);
            }
        }
    }

    public void fillSphere(int n, int n2, int n3, int n4) {
        switch (n) {
            case 1: {
                this.plotPixelClipped(this.argbCurrent, n2, n3, n4);
                return;
            }
            case 0: {
                return;
            }
        }
        if (n <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, !this.addAllPixels, n, n2, n3, n4, null, null, null, -1, null);
        }
    }

    public void fillSphere(int n, Point3i point3i) {
        this.fillSphere(n, point3i.x, point3i.y, point3i.z);
    }

    public void fillSphere(int n, Point3f point3f) {
        this.fillSphere(n, (int)point3f.x, (int)point3f.y, (int)point3f.z);
    }

    public void fillEllipsoid(Point3f point3f, Point3f[] point3fArray, int n, int n2, int n3, int n4, Matrix3f matrix3f, double[] dArray, Matrix4f matrix4f, int n5, Point3i[] point3iArray) {
        switch (n4) {
            case 1: {
                this.plotPixelClipped(this.argbCurrent, n, n2, n3);
                return;
            }
            case 0: {
                return;
            }
        }
        if (n4 <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, !this.addAllPixels, n4, n, n2, n3, matrix3f, dArray, matrix4f, n5, point3iArray);
        }
    }

    public void drawRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 != 0 && this.isClippedZ(n4)) {
            return;
        }
        int n7 = n5 - 1;
        int n8 = n6 - 1;
        int n9 = n + n7;
        int n10 = n2 + n8;
        if (n2 >= 0 && n2 < this.height) {
            this.drawHLine(n, n2, n3, n7);
        }
        if (n10 >= 0 && n10 < this.height) {
            this.drawHLine(n, n10, n3, n7);
        }
        if (n >= 0 && n < this.width) {
            this.drawVLine(n, n2, n3, n8);
        }
        if (n9 >= 0 && n9 < this.width) {
            this.drawVLine(n9, n2, n3, n8);
        }
    }

    private void drawHLine(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            n += n4;
            n4 = -n4;
        }
        if (n < 0) {
            n4 += n;
            n = 0;
        }
        if (n + n4 >= this.width) {
            n4 = this.width - 1 - n;
        }
        int n5 = n + this.width * n2;
        if (this.addAllPixels) {
            for (int i = 0; i <= n4; ++i) {
                if (n3 < this.zbuf[n5]) {
                    this.addPixel(n5, n3, this.argbCurrent);
                }
                ++n5;
            }
            return;
        }
        boolean bl = ((n ^ n2) & 1) != 0;
        for (int i = 0; i <= n4; ++i) {
            if ((bl = !bl) && n3 < this.zbuf[n5]) {
                this.addPixel(n5, n3, this.argbCurrent);
            }
            ++n5;
        }
    }

    private void drawVLine(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n2 + n4 >= this.height) {
            n4 = this.height - 1 - n2;
        }
        int n5 = n + this.width * n2;
        if (this.addAllPixels) {
            for (int i = 0; i <= n4; ++i) {
                if (n3 < this.zbuf[n5]) {
                    this.addPixel(n5, n3, this.argbCurrent);
                }
                n5 += this.width;
            }
            return;
        }
        boolean bl = ((n ^ n2) & 1) != 0;
        for (int i = 0; i <= n4; ++i) {
            if ((bl = !bl) && n3 < this.zbuf[n5]) {
                this.addPixel(n5, n3, this.argbCurrent);
            }
            n5 += this.width;
        }
    }

    public void fillRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isClippedZ(n4)) {
            return;
        }
        if (n < 0) {
            if ((n5 += n) <= 0) {
                return;
            }
            n = 0;
        }
        if (n + n5 > this.width && (n5 = this.width - n) <= 0) {
            return;
        }
        if (n2 < 0) {
            if ((n6 += n2) <= 0) {
                return;
            }
            n2 = 0;
        }
        if (n2 + n6 > this.height) {
            n6 = this.height - n2;
        }
        while (--n6 >= 0) {
            this.plotPixelsUnclipped(n5, n, n2++, n3);
        }
    }

    public void drawString(String string, Font3D font3D, int n, int n2, int n3, int n4) {
        if (string == null) {
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        this.drawStringNoSlab(string, font3D, n, n2, n3);
    }

    public void drawStringNoSlab(String string, Font3D font3D, int n, int n2, int n3) {
        if (string == null) {
            return;
        }
        if (font3D != null) {
            this.font3dCurrent = font3D;
        }
        this.plotText(n, n2, n3, this.argbCurrent, string, this.font3dCurrent, null);
    }

    public void plotText(int n, int n2, int n3, int n4, String string, Font3D font3D, JmolRendererInterface jmolRendererInterface) {
        Text3D.plot(n, n2, n3, n4, string, font3D, this, jmolRendererInterface, this.antialiasThisFrame);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, short s, int n5, int n6) {
        if (image == null || n5 == 0 || n6 == 0) {
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        this.plotImage(n, n2, n3, image, null, s, n5, n6);
    }

    public void plotImage(int n, int n2, int n3, Image image, JmolRendererInterface jmolRendererInterface, short s, int n4, int n5) {
        this.setColix(s);
        if (s == 0) {
            this.argbCurrent = 0;
        }
        Text3D.plotImage(n, n2, n3, image, this, jmolRendererInterface, this.antialiasThisFrame, this.argbCurrent, n4, n5);
    }

    public void setFont(byte by) {
        this.font3dCurrent = Font3D.getFont3D(by);
    }

    public void setFont(Font3D font3D) {
        this.font3dCurrent = font3D;
    }

    public Font3D getFont3DCurrent() {
        return this.font3dCurrent;
    }

    public void drawPixel(int n, int n2, int n3) {
        this.plotPixelClipped(n, n2, n3);
    }

    public void drawPoints(int n, int[] nArray, int n2) {
        if (n2 > 1) {
            float f = (float)(n2 * n2) * 0.8f;
            for (int i = -n2; i < n2; ++i) {
                for (int j = -n2; j < n2; ++j) {
                    if ((float)(i * i + j * j) > f) continue;
                    this.plotPoints(n, nArray, i, j);
                    this.plotPoints(n, nArray, i, j);
                }
            }
        } else {
            this.plotPoints(n, nArray, 0, 0);
        }
    }

    public void drawDashedLine(int n, int n2, Point3i point3i, Point3i point3i2) {
        this.line3d.plotDashedLine(this.argbCurrent, !this.addAllPixels, n, n2, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, true);
    }

    public void drawDottedLine(Point3i point3i, Point3i point3i2) {
        this.line3d.plotDashedLine(this.argbCurrent, !this.addAllPixels, 2, 1, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, true);
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5, int n6) {
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, n, n2, n3, n4, n5, n6, true);
    }

    public void drawLine(short s, short s2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.setColix(s)) {
            s = 0;
        }
        boolean bl = !this.addAllPixels;
        int n7 = this.argbCurrent;
        if (!this.setColix(s2)) {
            s2 = 0;
        }
        if (s == 0 && s2 == 0) {
            return;
        }
        this.line3d.plotLine(n7, bl, this.argbCurrent, !this.addAllPixels, n, n2, n3, n4, n5, n6, true);
    }

    public void drawLine(Point3i point3i, Point3i point3i2) {
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, true);
    }

    public void fillCylinder(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl;
        if (!this.setColix(s)) {
            s = 0;
        }
        boolean bl2 = bl = !this.addAllPixels;
        if (!this.setColix(s2)) {
            s2 = 0;
        }
        if (s == 0 && s2 == 0) {
            return;
        }
        this.cylinder3d.render(s, s2, bl, !this.addAllPixels, by, n, n2, n3, n4, n5, n6, n7);
    }

    public void fillCylinderScreen(byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.cylinder3d.render(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, n2, n3, n4, n5, n6, n7);
    }

    public void fillCylinderScreen(byte by, int n, Point3i point3i, Point3i point3i2) {
        this.cylinder3d.render(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z);
    }

    public void fillCylinder(byte by, int n, Point3i point3i, Point3i point3i2) {
        this.cylinder3d.render(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z);
    }

    public void fillCylinderBits(byte by, int n, Point3f point3f, Point3f point3f2) {
        this.cylinder3d.renderBits(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, point3f.x, point3f.y, point3f.z, point3f2.x, point3f2.y, point3f2.z);
    }

    public void fillConeScreen(byte by, int n, Point3i point3i, Point3i point3i2) {
        this.cylinder3d.renderCone(this.colixCurrent, !this.addAllPixels, by, n, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, false);
    }

    public void fillConeSceen(byte by, int n, Point3f point3f, Point3f point3f2) {
        this.cylinder3d.renderCone(this.colixCurrent, !this.addAllPixels, by, n, point3f.x, point3f.y, point3f.z, point3f2.x, point3f2.y, point3f2.z, true);
    }

    public void drawHermite(int n, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        this.hermite3d.renderHermiteRope(false, n, 0, 0, 0, point3i, point3i2, point3i3, point3i4);
    }

    public void drawHermite(boolean bl, boolean bl2, int n, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4, Point3i point3i5, Point3i point3i6, Point3i point3i7, Point3i point3i8, int n2) {
        this.hermite3d.renderHermiteRibbon(bl, bl2, n, point3i, point3i2, point3i3, point3i4, point3i5, point3i6, point3i7, point3i8, n2);
    }

    public void fillHermite(int n, int n2, int n3, int n4, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        this.hermite3d.renderHermiteRope(true, n, n2, n3, n4, point3i, point3i2, point3i3, point3i4);
    }

    public static void getHermiteList(int n, Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, Tuple3f tuple3f4, Tuple3f tuple3f5, Tuple3f[] tuple3fArray, int n2, int n3) {
        Hermite3D.getHermiteList(n, tuple3f, tuple3f2, tuple3f3, tuple3f4, tuple3f5, tuple3fArray, n2, n3);
    }

    public void drawTriangle(Point3i point3i, short s, Point3i point3i2, short s2, Point3i point3i3, short s3, int n) {
        if ((n & 1) == 1) {
            this.drawLine(s, s2, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z);
        }
        if ((n & 2) == 2) {
            this.drawLine(s2, s3, point3i2.x, point3i2.y, point3i2.z, point3i3.x, point3i3.y, point3i3.z);
        }
        if ((n & 4) == 4) {
            this.drawLine(s, s3, point3i.x, point3i.y, point3i.z, point3i3.x, point3i3.y, point3i3.z);
        }
    }

    public void drawTriangle(Point3i point3i, Point3i point3i2, Point3i point3i3, int n) {
        if ((n & 1) == 1) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, true);
        }
        if ((n & 2) == 2) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, point3i2.x, point3i2.y, point3i2.z, point3i3.x, point3i3.y, point3i3.z, true);
        }
        if ((n & 4) == 4) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, point3i.x, point3i.y, point3i.z, point3i3.x, point3i3.y, point3i3.z, true);
        }
    }

    public void fillTriangleTwoSided(short s, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setColorNoisy(this.normix3d.getShadeIndex(s));
        this.triangle3d.fillTriangle(n, n2, n3, n4, n5, n6, n7, n8, n9, false);
    }

    public void fillTriangle(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        this.setColorNoisy(this.getShadeIndex(point3f, point3f2, point3f3));
        this.triangle3d.fillTriangle(point3f, point3f2, point3f3, false);
    }

    public void fillTriangle(Point3i point3i, Point3i point3i2, Point3i point3i3) {
        this.triangle3d.fillTriangle(point3i, point3i2, point3i3, false);
    }

    public void fillTriangle(Point3i point3i, short s, short s2, Point3i point3i2, short s3, short s4, Point3i point3i3, short s5, short s6, float f) {
        boolean bl;
        if (!this.isPass2 && s2 == s4 && s2 == s6 && s == s3 && s == s5) {
            this.setTriangleColixAndShadeIndex(s, this.normix3d.getShadeIndex(s2));
            bl = false;
        } else {
            if (!this.setTriangleTranslucency(s, s3, s5)) {
                return;
            }
            this.triangle3d.setGouraud(this.getShades(s)[this.normix3d.getShadeIndex(s2)], this.getShades(s3)[this.normix3d.getShadeIndex(s4)], this.getShades(s5)[this.normix3d.getShadeIndex(s6)]);
            bl = true;
        }
        this.triangle3d.fillTriangle(point3i, point3i2, point3i3, f, bl);
    }

    public void fillTriangle(Point3i point3i, short s, short s2, Point3i point3i2, short s3, short s4, Point3i point3i3, short s5, short s6) {
        boolean bl;
        if (!this.isPass2 && s2 == s4 && s2 == s6 && s == s3 && s == s5) {
            this.setTriangleColixAndShadeIndex(s, this.normix3d.getShadeIndex(s2));
            bl = false;
        } else {
            if (!this.setTriangleTranslucency(s, s3, s5)) {
                return;
            }
            this.triangle3d.setGouraud(this.getShades(s)[this.normix3d.getShadeIndex(s2)], this.getShades(s3)[this.normix3d.getShadeIndex(s4)], this.getShades(s5)[this.normix3d.getShadeIndex(s6)]);
            bl = true;
        }
        this.triangle3d.fillTriangle(point3i, point3i2, point3i3, bl);
    }

    private void setTriangleColixAndShadeIndex(short s, int n) {
        if (s == this.colixCurrent && this.currentShadeIndex == n) {
            return;
        }
        this.currentShadeIndex = -1;
        this.setColix(s);
        this.setColorNoisy(n);
    }

    private boolean setTriangleTranslucency(short s, short s2, short s3) {
        if (!this.isPass2) {
            return true;
        }
        int n = s & 0x7800;
        int n2 = s2 & 0x7800;
        int n3 = s3 & 0x7800;
        int n4 = ((n &= 0xFFFFBFFF) + (n2 &= 0xFFFFBFFF) + (n3 &= 0xFFFFBFFF)) / 3 & 0x7800;
        this.translucencyMask = n4 << 13 | 0xFFFFFF;
        return true;
    }

    public void drawQuadrilateral(short s, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        this.setColix(s);
        this.drawLine(point3i, point3i2);
        this.drawLine(point3i2, point3i3);
        this.drawLine(point3i3, point3i4);
        this.drawLine(point3i4, point3i);
    }

    public void fillQuadrilateral(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        this.setColorNoisy(this.getShadeIndex(point3f, point3f2, point3f3));
        this.triangle3d.fillTriangle(point3f, point3f2, point3f3, false);
        this.triangle3d.fillTriangle(point3f, point3f3, point3f4, false);
    }

    public void fillQuadrilateral(Point3i point3i, short s, short s2, Point3i point3i2, short s3, short s4, Point3i point3i3, short s5, short s6, Point3i point3i4, short s7, short s8) {
        this.fillTriangle(point3i, s, s2, point3i2, s3, s4, point3i3, s5, s6);
        this.fillTriangle(point3i, s, s2, point3i3, s5, s6, point3i4, s7, s8);
    }

    public void drawSurface(MeshSurface meshSurface, Point3f[] point3fArray, Point3f point3f) {
    }

    public boolean isClipped(int n, int n2, int n3) {
        return n < 0 || n >= this.width || n2 < 0 || n2 >= this.height || n3 < this.slab || n3 > this.depth;
    }

    public boolean isClipped(int n, int n2) {
        return n < 0 || n >= this.width || n2 < 0 || n2 >= this.height;
    }

    public boolean isInDisplayRange(int n, int n2) {
        return n >= this.displayMinX && n < this.displayMaxX && n2 >= this.displayMinY && n2 < this.displayMaxY;
    }

    public boolean isClippedXY(int n, int n2, int n3) {
        int n4 = n + 1 >> 1;
        return n2 < -n4 || n2 >= this.width + n4 || n3 < -n4 || n3 >= this.height + n4;
    }

    public boolean isClippedZ(int n) {
        return n != Integer.MIN_VALUE && (n < this.slab || n > this.depth);
    }

    public int clipCode(int n, int n2, int n3) {
        int n4 = 0;
        if (n < 0) {
            n4 |= 8;
        } else if (n >= this.width) {
            n4 |= 4;
        }
        if (n2 < 0) {
            n4 |= 2;
        } else if (n2 >= this.height) {
            n4 |= 1;
        }
        if (n3 < this.slab) {
            n4 |= 0x20;
        } else if (n3 > this.depth) {
            n4 |= 0x10;
        }
        return n4;
    }

    public int clipCode(int n) {
        int n2 = 0;
        if (n < this.slab) {
            n2 |= 0x20;
        } else if (n > this.depth) {
            n2 |= 0x10;
        }
        return n2;
    }

    void plotPixelClipped(int n, int n2, int n3) {
        if (this.isClipped(n, n2, n3)) {
            return;
        }
        int n4 = n2 * this.width + n;
        if (n3 < this.zbuf[n4]) {
            this.addPixel(n4, n3, this.argbCurrent);
        }
    }

    public void plotPixelClipped(Point3i point3i) {
        this.plotPixelClipped(point3i.x, point3i.y, point3i.z);
    }

    void plotPixelClipped(int n, int n2, int n3, int n4) {
        if (this.isClipped(n2, n3, n4)) {
            return;
        }
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    public void plotPixelClippedNoSlab(int n, int n2, int n3, int n4) {
        if (this.isClipped(n2, n3)) {
            return;
        }
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    void plotPixelClipped(int n, boolean bl, int n2, int n3, int n4) {
        if (this.isClipped(n2, n3, n4)) {
            return;
        }
        if (bl && ((n2 ^ n3) & 1) != 0) {
            return;
        }
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    void plotPixelUnclipped(int n, int n2, int n3) {
        int n4 = n2 * this.width + n;
        if (n3 < this.zbuf[n4]) {
            this.addPixel(n4, n3, this.argbCurrent);
        }
    }

    void plotPixelUnclipped(int n, int n2, int n3, int n4) {
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    void plotPixelsClipped(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n3 >= this.height || n2 >= this.width) {
            return;
        }
        if (n2 < 0) {
            n += n2;
            n2 = 0;
        }
        if (n + n2 > this.width) {
            n = this.width - n2;
        }
        if (n <= 0) {
            return;
        }
        int n5 = n3 * this.width + n2;
        int n6 = n5 + n;
        int n7 = 1;
        if (!this.addAllPixels) {
            n7 = 2;
            if (((n2 ^ n3) & 1) != 0) {
                ++n5;
            }
        }
        while (n5 < n6) {
            if (n4 < this.zbuf[n5]) {
                this.addPixel(n5, n4, this.argbCurrent);
            }
            n5 += n7;
        }
    }

    void plotPixelsClipped(int n, int n2, int n3, int n4, int n5, Rgb16 rgb16, Rgb16 rgb162) {
        if (n <= 0 || n3 < 0 || n3 >= this.height || n2 >= this.width || n4 < this.slab && n5 < this.slab || n4 > this.depth && n5 > this.depth) {
            return;
        }
        int n6 = (n2 << 16) + (n3 << 1) ^ 0x33333333;
        int n7 = (n4 << 10) + 512;
        int n8 = n5 - n4;
        int n9 = n / 2;
        int n10 = ((n8 << 10) + (n8 >= 0 ? n9 : -n9)) / n;
        if (n2 < 0) {
            n2 = -n2;
            n7 += n10 * n2;
            if ((n -= n2) <= 0) {
                return;
            }
            n2 = 0;
        }
        if (n + n2 > this.width) {
            n = this.width - n2;
        }
        boolean bl = ((n2 ^ n3) & 1) != 0;
        int n11 = n3 * this.width + n2;
        if (rgb16 == null) {
            while (--n >= 0) {
                int n12;
                if ((this.addAllPixels || (bl = !bl)) && (n12 = n7 >> 10) >= this.slab && n12 <= this.depth && n12 < this.zbuf[n11]) {
                    int n13 = (n6 = (n6 << 16) + (n6 << 1) + n6 & Integer.MAX_VALUE) >> 16 & 7;
                    this.addPixel(n11, n12, n13 == 0 ? this.argbNoisyDn : (n13 == 1 ? this.argbNoisyUp : this.argbCurrent));
                }
                ++n11;
                n7 += n10;
            }
        } else {
            int n14 = rgb16.rScaled << 8;
            int n15 = (rgb162.rScaled - rgb16.rScaled << 8) / n;
            int n16 = rgb16.gScaled;
            int n17 = (rgb162.gScaled - n16) / n;
            int n18 = rgb16.bScaled;
            int n19 = (rgb162.bScaled - n18) / n;
            while (--n >= 0) {
                int n20;
                if ((this.addAllPixels || (bl = !bl)) && (n20 = n7 >> 10) >= this.slab && n20 <= this.depth && n20 < this.zbuf[n11]) {
                    this.addPixel(n11, n20, 0xFF000000 | n14 & 0xFF0000 | n16 & 0xFF00 | n18 >> 8 & 0xFF);
                }
                ++n11;
                n7 += n10;
                n14 += n15;
                n16 += n17;
                n18 += n19;
            }
        }
    }

    void plotPixelsUnclipped(int n, int n2, int n3, int n4, int n5, Rgb16 rgb16, Rgb16 rgb162) {
        if (n <= 0) {
            return;
        }
        int n6 = (n2 << 16) + (n3 << 1) ^ 0x33333333;
        boolean bl = ((n2 ^ n3) & 1) != 0;
        int n7 = (n4 << 10) + 512;
        int n8 = n5 - n4;
        int n9 = n / 2;
        int n10 = ((n8 << 10) + (n8 >= 0 ? n9 : -n9)) / n;
        int n11 = n3 * this.width + n2;
        if (rgb16 == null) {
            while (--n >= 0) {
                int n12;
                if ((this.addAllPixels || (bl = !bl)) && (n12 = n7 >> 10) < this.zbuf[n11]) {
                    int n13 = (n6 = (n6 << 16) + (n6 << 1) + n6 & Integer.MAX_VALUE) >> 16 & 7;
                    this.addPixel(n11, n12, n13 == 0 ? this.argbNoisyDn : (n13 == 1 ? this.argbNoisyUp : this.argbCurrent));
                }
                ++n11;
                n7 += n10;
            }
        } else {
            int n14 = rgb16.rScaled << 8;
            int n15 = (rgb162.rScaled - rgb16.rScaled << 8) / n;
            int n16 = rgb16.gScaled;
            int n17 = (rgb162.gScaled - n16) / n;
            int n18 = rgb16.bScaled;
            int n19 = (rgb162.bScaled - n18) / n;
            while (--n >= 0) {
                int n20;
                if ((this.addAllPixels || (bl = !bl)) && (n20 = n7 >> 10) < this.zbuf[n11]) {
                    this.addPixel(n11, n20, 0xFF000000 | n14 & 0xFF0000 | n16 & 0xFF00 | n18 >> 8 & 0xFF);
                }
                ++n11;
                n7 += n10;
                n14 += n15;
                n16 += n17;
                n18 += n19;
            }
        }
    }

    void plotPixelsUnclipped(int n, int n2, int n3, int n4) {
        int n5 = n3 * this.width + n2;
        if (this.addAllPixels) {
            while (--n >= 0) {
                if (n4 < this.zbuf[n5]) {
                    this.addPixel(n5, n4, this.argbCurrent);
                }
                ++n5;
            }
        } else {
            int n6 = n5 + n;
            if (((n2 ^ n3) & 1) != 0 && ++n5 == n6) {
                return;
            }
            do {
                if (n4 >= this.zbuf[n5]) continue;
                this.addPixel(n5, n4, this.argbCurrent);
            } while ((n5 += 2) < n6);
        }
    }

    private void plotPoints(int n, int[] nArray, int n2, int n3) {
        int n4 = n * 3;
        while (n4 > 0) {
            int n5;
            int n6;
            int n7;
            int n8 = nArray[--n4];
            --n4;
            if (this.isClipped(n7 = nArray[--n4] + n2, n6 = nArray[n4] + n3, n8)) continue;
            if (n8 < this.zbuf[n5 = n6 * this.width + n7++]) {
                this.addPixel(n5, n8, this.argbCurrent);
            }
            if (!this.antialiasThisFrame) continue;
            n5 = n6 * this.width + n7;
            if (!this.isClipped(n7, n6, n8) && n8 < this.zbuf[n5]) {
                this.addPixel(n5, n8, this.argbCurrent);
            }
            n5 = ++n6 * this.width + n7;
            if (!this.isClipped(n7, n6, n8) && n8 < this.zbuf[n5]) {
                this.addPixel(n5, n8, this.argbCurrent);
            }
            n5 = n6 * this.width + --n7;
            if (this.isClipped(n7, n6, n8) || n8 >= this.zbuf[n5]) continue;
            this.addPixel(n5, n8, this.argbCurrent);
        }
    }

    public static int calcGreyscaleRgbFromRgb(int n) {
        int n2 = (2989 * (n >> 16 & 0xFF) + 5870 * (n >> 8 & 0xFF) + 1140 * (n & 0xFF) + 5000) / 10000;
        return Shade3D.rgb(n2, n2, n2);
    }

    public static short getColix(int n) {
        return Colix3D.getColix(n);
    }

    public short[] getBgColixes(short[] sArray) {
        return sArray;
    }

    public static short getColixTranslucent(int n) {
        int n2 = n >> 24 & 0xFF;
        if (n2 == 255) {
            return Graphics3D.getColix(n);
        }
        return Graphics3D.getColixTranslucent(Graphics3D.getColix(n), true, (float)n2 / 255.0f);
    }

    public static String getHexCodes(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < sArray.length; ++i) {
            stringBuffer.append(i == 0 ? "" : " ").append(Graphics3D.getHexCode(sArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String getHexCode(short s) {
        return Escape.escapeColor(Graphics3D.getArgb(s));
    }

    public static short[] getColixArray(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = Parser.getTokens(string);
        short[] sArray = new short[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            sArray[i] = Graphics3D.getColix(Graphics3D.getArgbFromString(stringArray[i]));
            if (sArray[i] != 0) continue;
            return null;
        }
        return sArray;
    }

    public static final Point3f colorPointFromInt(int n, Point3f point3f) {
        point3f.z = n & 0xFF;
        point3f.y = n >> 8 & 0xFF;
        point3f.x = n >> 16 & 0xFF;
        return point3f;
    }

    public static int colorPtToInt(Point3f point3f) {
        return Graphics3D.colorTriadToInt(point3f.x, point3f.y, point3f.z);
    }

    public static int colorTriadToInt(float f, float f2, float f3) {
        if (f <= 1.0f && f2 <= 1.0f && f3 <= 1.0f) {
            if (f > 0.0f) {
                f = f * 256.0f - 1.0f;
            }
            if (f2 > 0.0f) {
                f2 = f2 * 256.0f - 1.0f;
            }
            if (f3 > 0.0f) {
                f3 = f3 * 256.0f - 1.0f;
            }
        }
        return Shade3D.rgb((int)f, (int)f2, (int)f3);
    }

    public static final Point3f colorPointFromInt2(int n) {
        return new Point3f(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static final Point3f colorPointFromString(String string, Point3f point3f) {
        return Graphics3D.colorPointFromInt(Graphics3D.getArgbFromString(string), point3f);
    }

    public static short getColix(String string) {
        int n = Graphics3D.getArgbFromString(string);
        if (n != 0) {
            return Colix3D.getColix(n);
        }
        if ("none".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("opaque".equalsIgnoreCase(string)) {
            return 1;
        }
        return 2;
    }

    public static int getArgbFromString(String string) {
        Object object;
        int n = 0;
        if (string == null || (n = string.length()) == 0) {
            return 0;
        }
        if (string.charAt(0) == '[' && string.charAt(n - 1) == ']') {
            if (string.indexOf(",") >= 0) {
                String[] stringArray = TextFormat.split(string.substring(1, string.length() - 1), ",");
                if (stringArray.length != 3) {
                    return 0;
                }
                float f = Parser.parseFloat(stringArray[0]);
                float f2 = Parser.parseFloat(stringArray[1]);
                float f3 = Parser.parseFloat(stringArray[2]);
                return Graphics3D.colorTriadToInt(f, f2, f3);
            }
            switch (n) {
                case 9: {
                    object = "x";
                    break;
                }
                case 10: {
                    object = "0x";
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (string.indexOf((String)object) != 1) {
                return 0;
            }
            string = "#" + string.substring(n - 7, n - 1);
            n = 7;
        }
        if (n == 7 && string.charAt(0) == '#') {
            try {
                float f = Integer.parseInt(string.substring(1, 3), 16);
                float f4 = Integer.parseInt(string.substring(3, 5), 16);
                float f5 = Integer.parseInt(string.substring(5, 7), 16);
                return Graphics3D.colorTriadToInt(f, f4, f5);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        object = (Integer)mapJavaScriptColors.get(string.toLowerCase());
        return object == null ? 0 : (Integer)object;
    }

    private static final short applyColorTranslucencyLevel(short s, float f) {
        if (f == 0.0f) {
            return (short)(s & 0xFFFF87FF);
        }
        if (f < 0.0f) {
            return (short)(s | 0x7800);
        }
        if (Float.isNaN(f) || f >= 255.0f || (double)f == 1.0) {
            return (short)(s & 0xFFFF87FF | 0x4000);
        }
        int n = (int)(f < 1.0f ? f * 256.0f : (f <= 9.0f ? (float)((int)(f - 1.0f) << 5) : (f < 15.0f ? 256.0f : f)));
        n = (n >> 5) % 16;
        return (short)(s & 0xFFFF87FF | n << 11);
    }

    public static final int getColixTranslucencyLevel(short s) {
        int n = s >> 11 & 0xF;
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return n << 5;
            }
            case 15: {
                return -1;
            }
        }
        return 255;
    }

    public static float translucencyFractionalFromColix(short s) {
        int n = Graphics3D.getColixTranslucencyLevel(s);
        return n == -1 ? 0.5f : (n == 0 ? 0.0f : (n == 255 ? 1.0f : (float)n / 256.0f));
    }

    public static short getColix(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Byte) {
            return (Byte)object == 0 ? (short)0 : 2;
        }
        if (object instanceof Integer) {
            return Colix3D.getColix((Integer)object);
        }
        if (object instanceof String) {
            return Graphics3D.getColix((String)object);
        }
        if (Logger.debugging) {
            Logger.debug("?? getColix(" + object + ")");
        }
        return 22;
    }

    public static final short getColixTranslucent(short s, boolean bl, float f) {
        if (s == 0) {
            s = 1;
        }
        s = (short)(s & 0xFFFF87FF);
        if (!bl) {
            return s;
        }
        return Graphics3D.applyColorTranslucencyLevel(s, f);
    }

    public int getColorArgbOrGray(short s) {
        if (s < 0) {
            s = this.changeableColixMap[s & 0x7FF];
        }
        if (!this.inGreyscaleMode) {
            return Colix3D.getArgb(s);
        }
        return Colix3D.getArgbGreyscale(s);
    }

    int[] getShades(short s) {
        if (s < 0) {
            s = this.changeableColixMap[s & 0x7FF];
        }
        if (!this.inGreyscaleMode) {
            return Colix3D.getShades(s);
        }
        return Colix3D.getShadesGreyscale(s);
    }

    public static final short getChangeableColixIndex(short s) {
        if (s >= 0) {
            return -1;
        }
        return (short)(s & 0x7FF);
    }

    public static final boolean isColixTranslucent(short s) {
        return (s & 0x7800) != 0;
    }

    public static final short getColixInherited(short s, short s2) {
        switch (s) {
            case 0: {
                return s2;
            }
            case 1: {
                return (short)(s2 & 0xFFFF87FF);
            }
        }
        return (s & 0xFFFF87FF) == 1 ? (short)(s2 & 0xFFFF87FF | s & 0x7800) : s;
    }

    public static final boolean isColixColorInherited(short s) {
        switch (s) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return (s & 0xFFFF87FF) == 1;
    }

    public static int getArgb(short s) {
        return Colix3D.getArgb(s);
    }

    public short getChangeableColix(short s, int n) {
        if (s >= this.changeableColixMap.length) {
            short[] sArray = new short[s + 16];
            System.arraycopy(this.changeableColixMap, 0, sArray, 0, this.changeableColixMap.length);
            this.changeableColixMap = sArray;
        }
        if (this.changeableColixMap[s] == 0) {
            this.changeableColixMap[s] = Colix3D.getColix(n);
        }
        return (short)(s | Short.MIN_VALUE);
    }

    public void changeColixArgb(short s, int n) {
        if (s < this.changeableColixMap.length && this.changeableColixMap[s] != 0) {
            this.changeableColixMap[s] = Colix3D.getColix(n);
        }
    }

    private static void flushCaches() {
        Colix3D.flushShades();
        Sphere3D.flushSphereCache();
    }

    public static Point3f getLightSource() {
        return new Point3f(Shade3D.xLight, Shade3D.yLight, Shade3D.zLight);
    }

    public static synchronized void setSpecular(boolean bl) {
        if (Shade3D.specularOn == bl) {
            return;
        }
        Shade3D.specularOn = bl;
        Graphics3D.flushCaches();
    }

    public static boolean getSpecular() {
        return Shade3D.specularOn;
    }

    public static synchronized void setZShadePower(int n) {
        Shade3D.zPower = n;
    }

    public static int getZShadePower() {
        return Shade3D.zPower;
    }

    public static synchronized void setAmbientPercent(int n) {
        if (Shade3D.ambientPercent == n) {
            return;
        }
        Shade3D.ambientPercent = n;
        Shade3D.ambientFraction = (float)n / 100.0f;
        Graphics3D.flushCaches();
    }

    public static int getAmbientPercent() {
        return Shade3D.ambientPercent;
    }

    public static synchronized void setDiffusePercent(int n) {
        if (Shade3D.diffusePercent == n) {
            return;
        }
        Shade3D.diffusePercent = n;
        Shade3D.diffuseFactor = (float)n / 100.0f;
        Graphics3D.flushCaches();
    }

    public static int getDiffusePercent() {
        return Shade3D.diffusePercent;
    }

    public static synchronized void setPhongExponent(int n) {
        if (Shade3D.phongExponent == n && Shade3D.usePhongExponent) {
            return;
        }
        Shade3D.phongExponent = n;
        float f = (float)(Math.log(n) / Math.log(2.0));
        boolean bl = Shade3D.usePhongExponent = f != (float)((int)f);
        if (!Shade3D.usePhongExponent) {
            Shade3D.specularExponent = (int)f;
        }
        Graphics3D.flushCaches();
    }

    public static int getPhongExponent() {
        return Shade3D.phongExponent;
    }

    public static synchronized void setSpecularExponent(int n) {
        if (Shade3D.specularExponent == n) {
            return;
        }
        Shade3D.specularExponent = n;
        Shade3D.phongExponent = (int)Math.pow(2.0, n);
        Shade3D.usePhongExponent = false;
        Graphics3D.flushCaches();
    }

    public static int getSpecularExponent() {
        return Shade3D.specularExponent;
    }

    public static synchronized void setSpecularPercent(int n) {
        if (Shade3D.specularPercent == n) {
            return;
        }
        Shade3D.specularPercent = n;
        Shade3D.specularFactor = (float)n / 100.0f;
        Graphics3D.flushCaches();
    }

    public static int getSpecularPercent() {
        return Shade3D.specularPercent;
    }

    public static synchronized void setSpecularPower(int n) {
        if (n < 0) {
            Graphics3D.setSpecularExponent(-n);
            return;
        }
        if (Shade3D.specularPower == n) {
            return;
        }
        Shade3D.specularPower = n;
        Shade3D.intenseFraction = (float)n / 100.0f;
        Graphics3D.flushCaches();
    }

    public static int getSpecularPower() {
        return Shade3D.specularPower;
    }

    void setColorNoisy(int n) {
        this.currentShadeIndex = n;
        this.argbCurrent = this.shadesCurrent[n];
        this.argbNoisyUp = this.shadesCurrent[n < 63 ? n + 1 : 63];
        this.argbNoisyDn = this.shadesCurrent[n > 0 ? n - 1 : 0];
    }

    public void setNoisySurfaceShade(Point3i point3i, Point3i point3i2, Point3i point3i3) {
        int n;
        this.vectorAB.set(point3i2.x - point3i.x, point3i2.y - point3i.y, point3i2.z - point3i.z);
        if (point3i3 == null) {
            n = Shade3D.getShadeIndex(-this.vectorAB.x, -this.vectorAB.y, this.vectorAB.z);
        } else {
            this.vectorAC.set(point3i3.x - point3i.x, point3i3.y - point3i.y, point3i3.z - point3i.z);
            this.vectorAB.cross(this.vectorAB, this.vectorAC);
            int n2 = n = this.vectorAB.z >= 0.0f ? Shade3D.getShadeIndex(-this.vectorAB.x, -this.vectorAB.y, this.vectorAB.z) : Shade3D.getShadeIndex(this.vectorAB.x, this.vectorAB.y, -this.vectorAB.z);
        }
        if (n > 56) {
            n = 56;
        }
        this.setColorNoisy(n);
    }

    private int getShadeIndex(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        this.vectorAB.sub(point3f2, point3f);
        this.vectorAC.sub(point3f3, point3f);
        this.vectorNormal.cross(this.vectorAB, this.vectorAC);
        return this.vectorNormal.z >= 0.0f ? Shade3D.getShadeIndex(-this.vectorNormal.x, -this.vectorNormal.y, this.vectorNormal.z) : Shade3D.getShadeIndex(this.vectorNormal.x, this.vectorNormal.y, -this.vectorNormal.z);
    }

    public Font3D getFont3D(float f) {
        return Font3D.getFont3D(0, 0, f, f, this.platform);
    }

    public Font3D getFont3D(String string, float f) {
        return Font3D.getFont3D(Font3D.getFontFaceID(string), 0, f, f, this.platform);
    }

    public static int getFontStyleID(String string) {
        return Font3D.getFontStyleID(string);
    }

    public Font3D getFont3D(String string, String string2, float f) {
        int n = Font3D.getFontStyleID(string2);
        if (n < 0) {
            n = 0;
        }
        return Font3D.getFont3D(Font3D.getFontFaceID(string), n, f, f, this.platform);
    }

    public Font3D getFont3DScaled(Font3D font3D, float f) {
        float f2 = font3D.fontSizeNominal * f;
        return f2 == font3D.fontSize ? font3D : Font3D.getFont3D(font3D.idFontFace, this.isAntialiased() ? font3D.idFontStyle | 1 : font3D.idFontStyle, f2, font3D.fontSizeNominal, this.platform);
    }

    public byte getFontFid(float f) {
        return this.getFont3D((float)f).fid;
    }

    public byte getFontFid(String string, float f) {
        return this.getFont3D((String)string, (float)f).fid;
    }

    public static short getInverseNormix(short s) {
        return Normix3D.getInverseNormix(s);
    }

    public static short getNormix(Vector3f vector3f, BitSet bitSet) {
        return Normix3D.getNormix(vector3f, bitSet);
    }

    public static short get2SidedNormix(Vector3f vector3f, BitSet bitSet) {
        return Normix3D.get2SidedNormix(vector3f, bitSet);
    }

    public static Vector3f getNormixVector(short s) {
        return Normix3D.getVector(s);
    }

    public boolean isDirectedTowardsCamera(short s) {
        return this.normix3d.isDirectedTowardsCamera(s);
    }

    public Vector3f[] getTransformedVertexVectors() {
        return this.normix3d.getTransformedVectors();
    }

    public void renderBackground() {
        this.renderBackground(null);
    }

    public void renderBackground(JmolRendererInterface jmolRendererInterface) {
        if (this.backgroundImage != null) {
            this.plotImage(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, this.backgroundImage, jmolRendererInterface, (short)0, 0, 0);
        }
    }

    public void drawAtom(Atom atom) {
        this.fillSphere(atom.screenDiameter, atom.screenX, atom.screenY, atom.screenZ);
    }

    public int getExportType() {
        return 0;
    }

    public String getExportName() {
        return null;
    }

    public boolean canDoTriangles() {
        return true;
    }

    public boolean isCartesianExport() {
        return false;
    }

    public boolean initializeExporter(String string, Viewer viewer, Graphics3D graphics3D, Object object) {
        return false;
    }

    public String finalizeOutput() {
        return null;
    }

    public void drawBond(Atom atom, Atom atom2, short s, short s2, byte by, short s3) {
    }

    public boolean drawEllipse(Point3f point3f, Point3f point3f2, Point3f point3f3, boolean bl, boolean bl2) {
        return false;
    }

    static {
        int n = colorNames.length;
        while (--n >= 0) {
            mapJavaScriptColors.put(colorNames[n], new Integer(colorArgbs[n]));
        }
    }

    class ShadePixel
    extends Pixel {
        ShadePixel() {
        }

        void addPixel(int n, int n2, int n3) {
            if (n2 > Graphics3D.this.zDepth) {
                return;
            }
            if (n2 <= Graphics3D.this.zDepth && n2 >= Graphics3D.this.zSlab) {
                int n4 = n3 & 0xFF;
                int n5 = (n3 & 0xFF00) >> 8;
                int n6 = (n3 & 0xFF0000) >> 16;
                int n7 = n3 & 0xFF000000;
                float f = (float)(Graphics3D.this.zDepth - n2) / (float)(Graphics3D.this.zDepth - Graphics3D.this.zSlab);
                if (Shade3D.zPower > 1) {
                    for (int i = 0; i < Shade3D.zPower; ++i) {
                        f *= f;
                    }
                }
                n4 = Graphics3D.this.zShadeR + (int)(f * (float)(n4 - Graphics3D.this.zShadeR));
                n5 = Graphics3D.this.zShadeG + (int)(f * (float)(n5 - Graphics3D.this.zShadeG));
                n6 = Graphics3D.this.zShadeB + (int)(f * (float)(n6 - Graphics3D.this.zShadeB));
                n3 = n6 << 16 | n5 << 8 | n4 | n7;
            }
            super.addPixel(n, n2, n3);
        }
    }

    class Pixel {
        Pixel() {
        }

        void addPixel(int n, int n2, int n3) {
            if (!Graphics3D.this.isPass2) {
                Graphics3D.this.zbuf[n] = n2;
                Graphics3D.this.pbuf[n] = n3;
                return;
            }
            int n4 = Graphics3D.this.zbufT[n];
            if (n2 < n4) {
                int n5 = Graphics3D.this.pbufT[n];
                if (!Graphics3D.this.translucentCoverOnly && n5 != 0 && n4 - n2 > Graphics3D.this.zMargin) {
                    Graphics3D.mergeBufferPixel(Graphics3D.this.pbuf, n5, n, Graphics3D.this.bgcolor);
                }
                Graphics3D.this.zbufT[n] = n2;
                Graphics3D.this.pbufT[n] = n3 & Graphics3D.this.translucencyMask;
            } else if (n2 != n4 && !Graphics3D.this.translucentCoverOnly && n2 - n4 > Graphics3D.this.zMargin) {
                Graphics3D.mergeBufferPixel(Graphics3D.this.pbuf, n3 & Graphics3D.this.translucencyMask, n, Graphics3D.this.bgcolor);
            }
        }
    }
}

