/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.SingleElectron;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.reaction.mechanism.HomolyticCleavageMechanismTest")
public class HomolyticCleavageMechanism
implements IReactionMechanism {
    @Override
    @TestMethod(value="testInitiate_IMoleculeSet_ArrayList_ArrayList")
    public IReaction initiate(IMoleculeSet moleculeSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IMolecule reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance(moleculeSet.getBuilder());
        if (moleculeSet.getMoleculeCount() != 1) {
            throw new CDKException("TautomerizationMechanism only expects one IMolecule");
        }
        if (atomList.size() != 2) {
            throw new CDKException("HomolyticCleavageMechanism expects two atoms in the ArrayList");
        }
        if (bondList.size() != 1) {
            throw new CDKException("HomolyticCleavageMechanism only expect one bond in the ArrayList");
        }
        IMolecule molecule = moleculeSet.getMolecule(0);
        try {
            reactantCloned = molecule.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IMolecule!", e);
        }
        IAtom atom1 = atomList.get(0);
        IAtom atom1C = reactantCloned.getAtom(molecule.getAtomNumber(atom1));
        IAtom atom2 = atomList.get(1);
        IAtom atom2C = reactantCloned.getAtom(molecule.getAtomNumber(atom2));
        IBond bond1 = bondList.get(0);
        int posBond1 = molecule.getBondNumber(bond1);
        if (bond1.getOrder() == IBond.Order.SINGLE) {
            reactantCloned.removeBond(reactantCloned.getBond(posBond1));
        } else {
            BondManipulator.decreaseBondOrder(reactantCloned.getBond(posBond1));
        }
        reactantCloned.addSingleElectron(new SingleElectron(atom1C));
        reactantCloned.addSingleElectron(new SingleElectron(atom2C));
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        atom1C.setHybridization(null);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, atom1C);
        if (type == null) {
            return null;
        }
        atom2C.setHybridization(null);
        type = atMatcher.findMatchingAtomType(reactantCloned, atom2C);
        if (type == null) {
            return null;
        }
        IReaction reaction = DefaultChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule);
        for (IAtom atom : molecule.atoms()) {
            IMapping mapping = DefaultChemObjectBuilder.getInstance().newInstance(IMapping.class, atom, reactantCloned.getAtom(molecule.getAtomNumber(atom)));
            reaction.addMapping(mapping);
        }
        if (bond1.getOrder() != IBond.Order.SINGLE) {
            reaction.addProduct(reactantCloned);
        } else {
            IMoleculeSet moleculeSetP = ConnectivityChecker.partitionIntoMolecules(reactantCloned);
            for (int z = 0; z < moleculeSetP.getAtomContainerCount(); ++z) {
                reaction.addProduct(moleculeSetP.getMolecule(z));
            }
        }
        return reaction;
    }
}

