/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.ClosureBond;
import ambit2.smarts.SmartsHelper;
import ambit2.smarts.TopLayer;
import java.util.Vector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class ChemObjectToSmiles {
    public boolean mAromaticity = true;
    IAtomContainer mol;
    int NA;
    int[] walkedAtoms;
    Vector<ClosureBond> closures = new Vector();
    String[] closureNums;
    int curIndex;

    public String getSMILES(IAtomContainer ac) {
        int i;
        this.mol = ac;
        TopLayer.setAtomTopLayers(this.mol, "TL");
        this.NA = this.mol.getAtomCount();
        this.closures.clear();
        this.closureNums = new String[this.NA];
        this.walkedAtoms = new int[this.NA];
        for (i = 0; i < this.NA; ++i) {
            this.closureNums[i] = "";
        }
        for (i = 0; i < this.NA; ++i) {
            this.walkedAtoms[i] = 0;
        }
        this.curIndex = 1;
        this.walkedAtoms[0] = 1;
        this.walkMolecule(0, -1);
        for (i = 0; i < this.NA; ++i) {
            this.walkedAtoms[i] = 0;
        }
        this.setClosureNums();
        this.walkedAtoms[0] = 1;
        return this.getAtomWalkString(0, -1);
    }

    String getAtom(int atNum) {
        return this.getAtom(this.mol.getAtom(atNum));
    }

    String getAtom(IAtom at) {
        if (at.getSymbol().equals("B") || at.getSymbol().equals("C") || at.getSymbol().equals("N") || at.getSymbol().equals("O") || at.getSymbol().equals("S") || at.getSymbol().equals("P") || at.getSymbol().equals("Cl") || at.getSymbol().equals("F") || at.getSymbol().equals("Br") || at.getSymbol().equals("I")) {
            if (this.mAromaticity) {
                if (at.getFlag(5)) {
                    return at.getSymbol().toLowerCase();
                }
                return at.getSymbol();
            }
            return at.getSymbol();
        }
        return "[" + at.getSymbol() + "]";
    }

    void setClosureNums() {
        for (int i = 0; i < this.closures.size(); ++i) {
            ClosureBond cb = this.closures.get(i);
            int n = cb.at1;
            this.closureNums[n] = this.closureNums[n] + cb.getIndexAt1();
            int n2 = cb.at2;
            this.closureNums[n2] = this.closureNums[n2] + cb.getIndexAt2(this.mAromaticity);
        }
    }

    void walkMolecule(int atNum, int parentAt) {
        TopLayer tl = (TopLayer)this.mol.getAtom(atNum).getProperty((Object)"TL");
        for (int i = 0; i < tl.atoms.size(); ++i) {
            int a = this.mol.getAtomNumber(tl.atoms.get(i));
            if (a == parentAt) continue;
            if (this.walkedAtoms[a] == 0) {
                this.walkedAtoms[a] = 1;
                this.walkMolecule(a, atNum);
                continue;
            }
            ClosureBond cb = new ClosureBond();
            cb.at2 = atNum;
            cb.at1 = a;
            cb.bt = tl.bonds.get(i);
            cb.index = this.curIndex;
            this.addClosureBond(cb);
        }
    }

    void addClosureBond(ClosureBond cb) {
        for (int i = 0; i < this.closures.size(); ++i) {
            if (!this.closures.get(i).isEqualTo(cb)) continue;
            return;
        }
        this.closures.add(cb);
        ++this.curIndex;
    }

    String getAtomWalkString(int atNum, int parentAt) {
        Vector<String> v = new Vector<String>();
        TopLayer tl = (TopLayer)this.mol.getAtom(atNum).getProperty((Object)"TL");
        for (int i = 0; i < tl.atoms.size(); ++i) {
            int a = this.mol.getAtomNumber(tl.atoms.get(i));
            if (a == parentAt || this.walkedAtoms[a] != 0) continue;
            this.walkedAtoms[a] = 1;
            IBond b = tl.bonds.get(i);
            v.add(SmartsHelper.smilesBondToString(b, this.mAromaticity) + this.getAtomWalkString(a, atNum));
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAtom(atNum));
        sb.append(this.closureNums[atNum]);
        if (!v.isEmpty()) {
            for (int i = 0; i < v.size(); ++i) {
                if (i == v.size() - 1) {
                    sb.append((String)v.get(i));
                    continue;
                }
                sb.append("(" + (String)v.get(i) + ")");
            }
        }
        return sb.toString();
    }
}

