/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.data.ILiteratureEntry;
import ambit2.base.data.LiteratureEntry;
import ambit2.base.data.Property;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.base.processors.CASProcessor;
import ambit2.core.data.EINECS;
import ambit2.core.io.FileInputState;
import ambit2.core.io.IRawReader;
import ambit2.core.io.IteratingFolderReader;
import ambit2.core.io.RawIteratingMOLReader;
import ambit2.core.io.RawIteratingSDFReader;
import java.io.File;
import java.io.FileReader;
import org.openscience.cdk.index.CASNumber;

public class RawIteratingFolderReader
extends IteratingFolderReader<IStructureRecord, IRawReader<IStructureRecord>>
implements IRawReader<IStructureRecord> {
    protected FileNameMode mode;
    protected CASProcessor casTransformer = new CASProcessor();
    protected Property einecsProperty = Property.getEINECSInstance();
    protected Property casProperty = Property.getInstance((String)"CasRN", (ILiteratureEntry)LiteratureEntry.getCASReference());
    protected Property nameProperty = Property.getNameInstance();

    public RawIteratingFolderReader(File[] fileArray) {
        super(fileArray);
        this.casProperty.setLabel("CasRN");
    }

    @Override
    public void setFiles(File[] fileArray) {
        super.setFiles(fileArray);
        this.casTransformer = new CASProcessor();
        int[] nArray = new int[FileNameMode.values().length];
        for (File file : fileArray) {
            String string = file.getName().toLowerCase();
            int n = string.indexOf(46);
            if (n < 0) continue;
            String string2 = string.substring(0, n);
            try {
                String string3 = this.casTransformer.process(string2);
                if (CASNumber.isValid((String)string3)) {
                    int n2 = FileNameMode.CAS.ordinal();
                    nArray[n2] = nArray[n2] + 1;
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (EINECS.isValid(string2)) {
                    int n3 = FileNameMode.EC.ordinal();
                    nArray[n3] = nArray[n3] + 1;
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n4 = FileNameMode.Name.ordinal();
            nArray[n4] = nArray[n4] + 1;
        }
        this.mode = FileNameMode.CAS;
        for (FileNameMode fileNameMode : FileNameMode.values()) {
            if (nArray[fileNameMode.ordinal()] <= nArray[this.mode.ordinal()]) continue;
            this.mode = fileNameMode;
        }
    }

    @Override
    public Object next() {
        Object object = super.next();
        if (object instanceof IStructureRecord) {
            switch (this.mode) {
                case CAS: {
                    this.assignCASRN((IStructureRecord)object);
                    break;
                }
                case EC: {
                    this.assignEINECS((IStructureRecord)object);
                    break;
                }
                default: {
                    this.assignName((IStructureRecord)object);
                }
            }
        }
        return object;
    }

    @Override
    public IStructureRecord nextRecord() {
        if (this.reader == null) {
            return null;
        }
        IStructureRecord iStructureRecord = (IStructureRecord)((IRawReader)this.reader).nextRecord();
        switch (this.mode) {
            case CAS: {
                this.assignCASRN(iStructureRecord);
                break;
            }
            case EC: {
                this.assignEINECS(iStructureRecord);
                break;
            }
            default: {
                this.assignName(iStructureRecord);
            }
        }
        return iStructureRecord;
    }

    protected void assignCASRN(IStructureRecord iStructureRecord) {
        int n;
        if (iStructureRecord.getProperty(this.casProperty) != null) {
            iStructureRecord.removeProperty(this.casProperty);
        }
        if ((n = this.files[this.index].getName().indexOf(46)) >= 0) {
            String string = this.files[this.index].getName().substring(0, n);
            try {
                string = this.casTransformer.process(string);
                if (CASProcessor.isValidFormat((String)string)) {
                    iStructureRecord.setProperty(this.casProperty, (Object)string);
                } else {
                    iStructureRecord.setProperty(this.nameProperty, (Object)this.files[this.index].getName().substring(0, n));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void assignEINECS(IStructureRecord iStructureRecord) {
        int n;
        if (iStructureRecord.getProperty(this.einecsProperty) != null) {
            iStructureRecord.removeProperty(this.einecsProperty);
        }
        if ((n = this.files[this.index].getName().indexOf(46)) >= 0) {
            String string = this.files[this.index].getName().substring(0, n);
            if (EINECS.isValidFormat(string)) {
                iStructureRecord.setProperty(this.einecsProperty, (Object)string);
            } else {
                iStructureRecord.setProperty(this.nameProperty, (Object)string);
            }
        }
    }

    protected void assignName(IStructureRecord iStructureRecord) {
        int n;
        if (iStructureRecord.getProperty(this.nameProperty) != null) {
            iStructureRecord.removeProperty(this.nameProperty);
        }
        if ((n = this.files[this.index].getName().indexOf(46)) >= 0) {
            String string = this.files[this.index].getName().substring(0, n);
            iStructureRecord.setProperty(this.nameProperty, (Object)string);
        } else {
            iStructureRecord.setProperty(this.nameProperty, (Object)this.files[this.index].getName());
        }
    }

    @Override
    protected IRawReader<IStructureRecord> getItemReader(int n) throws Exception {
        String string = this.files[n].getName().toLowerCase();
        if (string.endsWith(FileInputState.extensions[0])) {
            RawIteratingSDFReader rawIteratingSDFReader = new RawIteratingSDFReader(new FileReader(this.files[n]));
            rawIteratingSDFReader.setReference(LiteratureEntry.getInstance((String)this.files[n].getName(), (String)("file:///" + this.files[n].getAbsolutePath())));
            return rawIteratingSDFReader;
        }
        if (string.endsWith(FileInputState.extensions[4])) {
            RawIteratingMOLReader rawIteratingMOLReader = new RawIteratingMOLReader(new FileReader(this.files[n]));
            rawIteratingMOLReader.setReference(LiteratureEntry.getInstance((String)this.files[n].getName(), (String)("file:///" + this.files[n].getAbsolutePath())));
            return rawIteratingMOLReader;
        }
        throw new Exception("Unsupported format " + string);
    }

    protected static enum FileNameMode {
        CAS,
        EC,
        Name;

    }
}

