/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.io.DelimitedFileWriter;
import ambit2.core.io.Header;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.MoleculeSet;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.LoggingTool;

public abstract class FileWithHeaderWriter
extends DefaultChemObjectWriter {
    protected static LoggingTool logger = new LoggingTool(DelimitedFileWriter.class);
    protected Header header = null;
    protected int smilesIndex = -1;
    protected SmilesGenerator sg = new SmilesGenerator(true);
    public static String defaultSMILESHeader = "SMILES";
    protected boolean writingStarted = false;

    public void write(IChemObject iChemObject) throws CDKException {
        this.fireIOSettingQuestion(null);
        if (iChemObject instanceof IMoleculeSet) {
            this.writeSetOfMolecules((IMoleculeSet)iChemObject);
        } else if (iChemObject instanceof IMolecule) {
            this.writeMolecule((IMolecule)iChemObject);
        } else {
            throw new CDKException("Only supported is writing of ChemFile and Molecule objects." + iChemObject.getClass().getName());
        }
    }

    protected abstract void writeHeader() throws IOException;

    public synchronized Header getHeader() {
        return this.header;
    }

    public synchronized void setHeader(ArrayList arrayList) {
        if (this.writingStarted) {
            logger.error((Object)"Can't change header while writing !!!!");
            return;
        }
        if (this.header == null) {
            this.header = new Header();
        }
        this.header.list = arrayList;
        this.smilesIndex = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!this.header.list.get(i).equals(defaultSMILESHeader)) continue;
            this.smilesIndex = i;
        }
        if (this.smilesIndex == -1) {
            this.header.list.add(0, defaultSMILESHeader);
            this.smilesIndex = 0;
        }
        logger.info((Object)"Header created\t", new Object[]{arrayList});
    }

    public void setHeader(Map map) {
        if (this.writingStarted) {
            logger.error((Object)"Can't change header while writing !!!!");
            return;
        }
        this.header = new Header();
        Iterator iterator = map.keySet().iterator();
        this.smilesIndex = -1;
        int n = 0;
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k.equals("SmallestRings") || k.equals("AllRings") || k.equals("CRAMERFLAGS") || k.equals("AMBIT_ID") || k.equals("AMBIT_IDSUBSTANCE")) continue;
            this.header.list.add(k);
            if (this.header.list.get(n).equals(defaultSMILESHeader)) {
                this.smilesIndex = n;
            }
            ++n;
        }
        if (this.smilesIndex == -1) {
            this.header.list.add(0, defaultSMILESHeader);
            this.smilesIndex = 0;
        }
        logger.info((Object)"Header created from hashtable\t", new Object[]{this.header});
    }

    public abstract void writeMolecule(IMolecule var1);

    public void writeSetOfMolecules(IMoleculeSet iMoleculeSet) {
        Iterator iterator = iMoleculeSet.molecules().iterator();
        while (iterator.hasNext()) {
            this.writeMolecule((IMolecule)iterator.next());
        }
    }

    public ChemObject highestSupportedChemObject() {
        return new MoleculeSet();
    }
}

