/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point2d;
import net.sf.jniinchi.INCHI_BOND_STEREO;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.INCHI_KEY;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.INCHI_PARITY;
import net.sf.jniinchi.INCHI_RADICAL;
import net.sf.jniinchi.INCHI_RET;
import net.sf.jniinchi.INCHI_STEREOTYPE;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiOutput;
import net.sf.jniinchi.JniInchiOutputKey;
import net.sf.jniinchi.JniInchiStereo0D;
import net.sf.jniinchi.JniInchiWrapper;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomParity;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.inchi.InChIGeneratorTest")
public class InChIGenerator {
    protected JniInchiInput input;
    protected JniInchiOutput output;
    protected IAtomContainer atomContainer;

    @TestMethod(value="testGetInchiFromChlorineAtom,testGetInchiFromLithiumIon,testGetStandardInchiFromChlorine37Atom")
    protected InChIGenerator(IAtomContainer atomContainer) throws CDKException {
        try {
            this.input = new JniInchiInput("");
            this.generateInchiFromCDKAtomContainer(atomContainer);
        }
        catch (JniInchiException jie) {
            throw new CDKException("InChI generation failed: " + jie.getMessage(), jie);
        }
    }

    protected InChIGenerator(IAtomContainer atomContainer, String options) throws CDKException {
        try {
            this.input = new JniInchiInput(options);
            this.generateInchiFromCDKAtomContainer(atomContainer);
        }
        catch (JniInchiException jie) {
            throw new CDKException("InChI generation failed: " + jie.getMessage(), jie);
        }
    }

    protected InChIGenerator(IAtomContainer atomContainer, List<INCHI_OPTION> options) throws CDKException {
        try {
            this.input = new JniInchiInput(options);
            this.generateInchiFromCDKAtomContainer(atomContainer);
        }
        catch (JniInchiException jie) {
            throw new CDKException("InChI generation failed: " + jie.getMessage(), jie);
        }
    }

    private void generateInchiFromCDKAtomContainer(IAtomContainer atomContainer) throws CDKException {
        this.atomContainer = atomContainer;
        Iterator<IAtom> atoms = atomContainer.atoms().iterator();
        boolean all3d = true;
        boolean all2d = true;
        while (atoms.hasNext()) {
            IAtom atom = atoms.next();
            if (atom.getPoint3d() == null) {
                all3d = false;
            }
            if (atom.getPoint2d() != null) continue;
            all2d = false;
        }
        IsotopeFactory ifact = null;
        try {
            ifact = IsotopeFactory.getInstance(atomContainer.getBuilder());
        }
        catch (Exception e) {
            // empty catch block
        }
        HashMap<IAtom, JniInchiAtom> atomMap = new HashMap<IAtom, JniInchiAtom>();
        for (IAtom atom : atomContainer.atoms()) {
            int count;
            Integer implicitH;
            Integer isotopeNumber;
            double z;
            double y;
            double x;
            Serializable p;
            if (all3d) {
                p = atom.getPoint3d();
                x = p.x;
                y = p.y;
                z = p.z;
            } else if (all2d) {
                p = atom.getPoint2d();
                x = ((Point2d)p).x;
                y = ((Point2d)p).y;
                z = 0.0;
            } else {
                x = 0.0;
                y = 0.0;
                z = 0.0;
            }
            String el = atom.getSymbol();
            JniInchiAtom iatom = this.input.addAtom(new JniInchiAtom(x, y, z, el));
            atomMap.put(atom, iatom);
            int charge = atom.getFormalCharge();
            if (charge != 0) {
                iatom.setCharge(charge);
            }
            if ((isotopeNumber = atom.getMassNumber()) != CDKConstants.UNSET && ifact != null) {
                IAtom isotope = atomContainer.getBuilder().newInstance(IAtom.class, el);
                ifact.configure(isotope);
                if (isotope.getMassNumber().intValue() == isotopeNumber.intValue()) {
                    isotopeNumber = 0;
                }
            }
            if (isotopeNumber != CDKConstants.UNSET) {
                iatom.setIsotopicMass(isotopeNumber);
            }
            if ((implicitH = atom.getImplicitHydrogenCount()) == CDKConstants.UNSET) {
                implicitH = 0;
            }
            if (implicitH != 0) {
                iatom.setImplicitH(implicitH);
            }
            if ((count = atomContainer.getConnectedSingleElectronsCount(atom)) == 0) continue;
            if (count == 1) {
                iatom.setRadical(INCHI_RADICAL.DOUBLET);
                continue;
            }
            if (count == 2) {
                iatom.setRadical(INCHI_RADICAL.TRIPLET);
                continue;
            }
            throw new CDKException("Unrecognised radical type");
        }
        HashMap<IBond, JniInchiBond> bondMap = new HashMap<IBond, JniInchiBond>();
        for (IBond bond : atomContainer.bonds()) {
            INCHI_BOND_TYPE order;
            JniInchiAtom at0 = (JniInchiAtom)atomMap.get(bond.getAtom(0));
            JniInchiAtom at1 = (JniInchiAtom)atomMap.get(bond.getAtom(1));
            IBond.Order bo = bond.getOrder();
            if (bond.getFlag(5)) {
                order = INCHI_BOND_TYPE.ALTERN;
            } else if (bo == CDKConstants.BONDORDER_SINGLE) {
                order = INCHI_BOND_TYPE.SINGLE;
            } else if (bo == CDKConstants.BONDORDER_DOUBLE) {
                order = INCHI_BOND_TYPE.DOUBLE;
            } else if (bo == CDKConstants.BONDORDER_TRIPLE) {
                order = INCHI_BOND_TYPE.TRIPLE;
            } else {
                throw new CDKException("Failed to generate InChI: Unsupported bond type");
            }
            JniInchiBond ibond = new JniInchiBond(at0, at1, order);
            bondMap.put(bond, ibond);
            this.input.addBond(ibond);
            IBond.Stereo stereo = bond.getStereo();
            if (stereo == IBond.Stereo.NONE) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.NONE);
                continue;
            }
            if (stereo == IBond.Stereo.DOWN) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_1DOWN);
                continue;
            }
            if (stereo == IBond.Stereo.UP) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_1UP);
                continue;
            }
            if (stereo == IBond.Stereo.DOWN_INVERTED) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_2DOWN);
                continue;
            }
            if (stereo == IBond.Stereo.UP_INVERTED) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_2UP);
                continue;
            }
            if (stereo != CDKConstants.UNSET) continue;
            if (order == INCHI_BOND_TYPE.SINGLE) {
                ibond.setStereoDefinition(INCHI_BOND_STEREO.SINGLE_1EITHER);
                continue;
            }
            if (order != INCHI_BOND_TYPE.DOUBLE) continue;
            ibond.setStereoDefinition(INCHI_BOND_STEREO.DOUBLE_EITHER);
        }
        for (IAtom atom : atomContainer.atoms()) {
            IAtomParity parity = AtomContainerManipulator.getAtomParity(atomContainer, atom);
            if (parity == null) continue;
            IAtom[] surroundingAtoms = parity.getSurroundingAtoms();
            int sign = parity.getParity();
            JniInchiAtom atC = (JniInchiAtom)atomMap.get(atom);
            JniInchiAtom at0 = (JniInchiAtom)atomMap.get(surroundingAtoms[0]);
            JniInchiAtom at1 = (JniInchiAtom)atomMap.get(surroundingAtoms[1]);
            JniInchiAtom at2 = (JniInchiAtom)atomMap.get(surroundingAtoms[2]);
            JniInchiAtom at3 = (JniInchiAtom)atomMap.get(surroundingAtoms[3]);
            INCHI_PARITY p = INCHI_PARITY.UNKNOWN;
            if (sign > 0) {
                p = INCHI_PARITY.EVEN;
            } else if (sign < 0) {
                p = INCHI_PARITY.ODD;
            } else {
                throw new CDKException("Atom parity of zero");
            }
            this.input.addStereo0D(new JniInchiStereo0D(atC, at0, at1, at2, at3, INCHI_STEREOTYPE.TETRAHEDRAL, p));
        }
        for (IStereoElement stereoElem : atomContainer.stereoElements()) {
            JniInchiStereo0D jniStereo;
            INCHI_PARITY p;
            JniInchiAtom at3;
            JniInchiAtom at2;
            JniInchiAtom at1;
            JniInchiAtom at0;
            Enum stereoType;
            if (stereoElem instanceof ITetrahedralChirality) {
                ITetrahedralChirality chirality = (ITetrahedralChirality)stereoElem;
                IAtom[] surroundingAtoms = chirality.getLigands();
                stereoType = chirality.getStereo();
                JniInchiAtom atC = (JniInchiAtom)atomMap.get(chirality.getChiralAtom());
                at0 = (JniInchiAtom)atomMap.get(surroundingAtoms[0]);
                at1 = (JniInchiAtom)atomMap.get(surroundingAtoms[1]);
                at2 = (JniInchiAtom)atomMap.get(surroundingAtoms[2]);
                at3 = (JniInchiAtom)atomMap.get(surroundingAtoms[3]);
                p = INCHI_PARITY.UNKNOWN;
                if (stereoType == ITetrahedralChirality.Stereo.ANTI_CLOCKWISE) {
                    p = INCHI_PARITY.ODD;
                } else if (stereoType == ITetrahedralChirality.Stereo.CLOCKWISE) {
                    p = INCHI_PARITY.EVEN;
                } else {
                    throw new CDKException("Unknown tetrahedral chirality");
                }
                jniStereo = new JniInchiStereo0D(atC, at0, at1, at2, at3, INCHI_STEREOTYPE.TETRAHEDRAL, p);
                this.input.addStereo0D(jniStereo);
                continue;
            }
            if (!(stereoElem instanceof IDoubleBondStereochemistry)) continue;
            IDoubleBondStereochemistry dbStereo = (IDoubleBondStereochemistry)stereoElem;
            IBond[] surroundingBonds = dbStereo.getBonds();
            if (surroundingBonds[0] == null || surroundingBonds[1] == null) {
                throw new CDKException("Cannot generate an InChI with incomplete double bond info");
            }
            stereoType = dbStereo.getStereo();
            IBond stereoBond = dbStereo.getStereoBond();
            at0 = null;
            at1 = null;
            at2 = null;
            at3 = null;
            if (stereoBond.contains(surroundingBonds[0].getAtom(0))) {
                at1 = (JniInchiAtom)atomMap.get(surroundingBonds[0].getAtom(0));
                at0 = (JniInchiAtom)atomMap.get(surroundingBonds[0].getAtom(1));
            } else {
                at0 = (JniInchiAtom)atomMap.get(surroundingBonds[0].getAtom(0));
                at1 = (JniInchiAtom)atomMap.get(surroundingBonds[0].getAtom(1));
            }
            if (stereoBond.contains(surroundingBonds[1].getAtom(0))) {
                at2 = (JniInchiAtom)atomMap.get(surroundingBonds[1].getAtom(0));
                at3 = (JniInchiAtom)atomMap.get(surroundingBonds[1].getAtom(1));
            } else {
                at2 = (JniInchiAtom)atomMap.get(surroundingBonds[1].getAtom(1));
                at3 = (JniInchiAtom)atomMap.get(surroundingBonds[1].getAtom(0));
            }
            p = INCHI_PARITY.UNKNOWN;
            if (stereoType == IDoubleBondStereochemistry.Conformation.TOGETHER) {
                p = INCHI_PARITY.ODD;
            } else if (stereoType == IDoubleBondStereochemistry.Conformation.OPPOSITE) {
                p = INCHI_PARITY.EVEN;
            } else {
                throw new CDKException("Unknown double bond stereochemistry");
            }
            jniStereo = new JniInchiStereo0D(null, at0, at1, at2, at3, INCHI_STEREOTYPE.DOUBLEBOND, p);
            this.input.addStereo0D(jniStereo);
        }
        try {
            this.output = JniInchiWrapper.getInchi(this.input);
        }
        catch (JniInchiException jie) {
            throw new CDKException("Failed to generate InChI: " + jie.getMessage(), jie);
        }
    }

    @TestMethod(value="testGetInchiFromLandDAlanine3D,testGetInchiEandZ12Dichloroethene2D")
    public INCHI_RET getReturnStatus() {
        return this.output.getReturnStatus();
    }

    @TestMethod(value="testGetInchiEandZ12Dichloroethene2D,testGetInchiFromEthyne,testGetInchiFromEthene")
    public String getInchi() {
        return this.output.getInchi();
    }

    @TestMethod(value="testGetInchiFromEthane")
    public String getInchiKey() throws CDKException {
        try {
            JniInchiOutputKey key = JniInchiWrapper.getInchiKey(this.output.getInchi());
            if (key.getReturnStatus() == INCHI_KEY.OK) {
                return key.getKey();
            }
            throw new CDKException("Error while creating InChIKey: " + (Object)((Object)key.getReturnStatus()));
        }
        catch (JniInchiException exception) {
            throw new CDKException("Error while creating InChIKey: " + exception.getMessage(), exception);
        }
    }

    @TestMethod(value="testGetAuxInfo")
    public String getAuxInfo() {
        return this.output.getAuxInfo();
    }

    @TestMethod(value="testGetMessage,testGetWarningMessage")
    public String getMessage() {
        return this.output.getMessage();
    }

    @TestMethod(value="testGetLog")
    public String getLog() {
        return this.output.getLog();
    }
}

