/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.data.LiteratureEntry;
import ambit2.base.log.AmbitLogger;
import ambit2.core.io.IRawReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;

public abstract class RawIteratingReader<T>
extends DefaultIteratingChemObjectReader
implements IRawReader<T> {
    protected static AmbitLogger logger = new AmbitLogger(RawIteratingReader.class);
    protected BufferedReader input;
    protected StringBuilder recordBuffer = null;
    protected LiteratureEntry reference;

    public LiteratureEntry getReference() {
        return this.reference;
    }

    public void setReference(LiteratureEntry literatureEntry) {
        this.reference = literatureEntry;
    }

    public RawIteratingReader(Reader reader) throws CDKException {
        this.setReader(reader);
    }

    public void setReader(InputStream inputStream) throws CDKException {
        this.setReader(new InputStreamReader(inputStream));
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = new BufferedReader(reader);
    }

    public abstract IResourceFormat getFormat();

    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
    }

    public boolean hasNext() {
        this.recordBuffer = null;
        try {
            String string;
            while ((string = this.input.readLine()) != null) {
                if (this.recordBuffer == null) {
                    this.recordBuffer = new StringBuilder();
                }
                this.recordBuffer.append(string);
                this.recordBuffer.append('\n');
                if (!this.isEndOfRecord(string)) continue;
                return true;
            }
            return this.acceptLastRecord();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            return false;
        }
    }

    protected boolean acceptLastRecord() {
        return false;
    }

    public Object next() {
        return this.recordBuffer.toString();
    }

    @Override
    public abstract T nextRecord();

    public abstract boolean isEndOfRecord(String var1);
}

