/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.data.MoleculeTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.io.MDLReaderTest")
public class MDLReader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLReader.class);
    private BooleanIOSetting forceReadAs3DCoords;

    public MDLReader() {
        this(new StringReader(""));
    }

    public MDLReader(InputStream inputStream) {
        this(inputStream, IChemObjectReader.Mode.RELAXED);
    }

    public MDLReader(InputStream inputStream, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(inputStream));
        this.mode = mode;
    }

    public MDLReader(Reader reader) {
        this(reader, IChemObjectReader.Mode.RELAXED);
    }

    public MDLReader(Reader reader, IChemObjectReader.Mode mode) {
        this.mode = mode;
        this.input = new BufferedReader(reader);
        this.initIOSettings();
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream inputStream) throws CDKException {
        this.setReader(new InputStreamReader(inputStream));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (IChemFile.class.equals(classArray[i])) {
                return true;
            }
            if (IChemModel.class.equals(classArray[i])) {
                return true;
            }
            if (!IMolecule.class.equals(classArray[i])) continue;
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            return this.accepts(clazz2);
        }
        return false;
    }

    public IChemObject read(IChemObject iChemObject) throws CDKException {
        if (iChemObject instanceof IChemFile) {
            return this.readChemFile((IChemFile)iChemObject);
        }
        if (iChemObject instanceof IChemModel) {
            return this.readChemModel((IChemModel)iChemObject);
        }
        if (iChemObject instanceof IMolecule) {
            return this.readMolecule((IMolecule)iChemObject);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private IChemModel readChemModel(IChemModel iChemModel) throws CDKException {
        IMolecule iMolecule;
        IMoleculeSet iMoleculeSet = iChemModel.getMoleculeSet();
        if (iMoleculeSet == null) {
            iMoleculeSet = MoleculeTools.newMoleculeSet(iChemModel.getBuilder());
        }
        if ((iMolecule = this.readMolecule(MoleculeTools.newMolecule(iChemModel.getBuilder()))) != null) {
            iMoleculeSet.addMolecule(iMolecule);
        }
        iChemModel.setMoleculeSet(iMoleculeSet);
        return iChemModel;
    }

    private IChemFile readChemFile(IChemFile iChemFile) throws CDKException {
        String string;
        IChemSequence iChemSequence = MoleculeTools.newChemSequence(iChemFile.getBuilder());
        IChemModel iChemModel = MoleculeTools.newChemModel(iChemFile.getBuilder());
        IMoleculeSet iMoleculeSet = MoleculeTools.newMoleculeSet(iChemFile.getBuilder());
        IMolecule iMolecule = this.readMolecule(MoleculeTools.newMolecule(iChemFile.getBuilder()));
        if (iMolecule != null) {
            iMoleculeSet.addMolecule(iMolecule);
        }
        iChemModel.setMoleculeSet(iMoleculeSet);
        iChemSequence.addChemModel(iChemModel);
        iMoleculeSet = MoleculeTools.newMoleculeSet(iChemFile.getBuilder());
        iChemModel = MoleculeTools.newChemModel(iChemFile.getBuilder());
        try {
            String string2;
            while ((string2 = this.input.readLine()) != null) {
                logger.debug((Object)"line: ", new Object[]{string2});
                String string3 = new String(string2);
                if (string3.equals("$$$$")) {
                    iMolecule = this.readMolecule(MoleculeTools.newMolecule(iChemFile.getBuilder()));
                    if (iMolecule == null) continue;
                    iMoleculeSet.addMolecule(iMolecule);
                    iChemModel.setMoleculeSet(iMoleculeSet);
                    iChemSequence.addChemModel(iChemModel);
                    iMoleculeSet = MoleculeTools.newMoleculeSet(iChemFile.getBuilder());
                    iChemModel = MoleculeTools.newChemModel(iChemFile.getBuilder());
                    continue;
                }
                if (iMolecule == null) continue;
                string = null;
                if (string3.startsWith("> ")) {
                    int n;
                    string3.substring(2);
                    int n2 = string3.indexOf("<");
                    if (n2 != -1 && (n = string3.substring(n2).indexOf(">")) != -1) {
                        string = string3.substring(n2 + 1, n2 + n);
                    }
                    while ((string2 = this.input.readLine()) != null && string2.startsWith(">")) {
                        logger.debug((Object)"data header line: ", new Object[]{string2});
                    }
                }
                if (string2 == null) {
                    throw new CDKException("Expecting data line here, but found null!");
                }
                String string4 = string2;
                while ((string2 = this.input.readLine()) != null && string2.trim().length() > 0) {
                    if (string2.equals("$$$$")) {
                        logger.error((Object)"Expecting data line here, but found end of molecule: ", new Object[]{string2});
                        break;
                    }
                    logger.debug((Object)"data line: ", new Object[]{string2});
                    string4 = string4 + string2;
                    if (string2.length() >= 80) continue;
                    string4 = string4 + System.getProperty("line.separator");
                }
                if (string == null) continue;
                logger.info((Object)"fieldName, data: ", new Object[]{string, ", ", string4});
                iMolecule.setProperty((Object)string, (Object)string4);
            }
        }
        catch (CDKException cDKException) {
            throw cDKException;
        }
        catch (Exception exception) {
            String string5 = "Error while parsing SDF";
            logger.error((Object)string5);
            logger.debug((Object)exception);
            throw new CDKException(string5, (Throwable)exception);
        }
        try {
            this.input.close();
        }
        catch (Exception exception) {
            string = "Error while closing file: " + exception.getMessage();
            logger.error((Object)string);
            throw new CDKException(string, (Throwable)exception);
        }
        iChemFile.addChemSequence(iChemSequence);
        return iChemFile;
    }

    private IMolecule readMolecule(IMolecule iMolecule) throws CDKException {
        logger.debug((Object)"Reading new molecule");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        IBond.Stereo stereo = (IBond.Stereo)CDKConstants.UNSET;
        int n7 = 1;
        int n8 = 0;
        String[] stringArray = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        String string = "";
        try {
            Object object;
            Object object2;
            Object object32;
            IsotopeFactory isotopeFactory = IsotopeFactory.getInstance((IChemObjectBuilder)iMolecule.getBuilder());
            logger.info((Object)"Reading header");
            string = this.input.readLine();
            ++n;
            if (string == null) {
                return null;
            }
            logger.debug((Object)("Line " + n + ": " + string));
            if (string.startsWith("$$$$")) {
                logger.debug((Object)"File is empty, returning empty molecule");
                return iMolecule;
            }
            if (string.length() > 0) {
                iMolecule.setProperty((Object)"cdk:Title", (Object)string);
            }
            string = this.input.readLine();
            logger.debug((Object)("Line " + ++n + ": " + string));
            string = this.input.readLine();
            logger.debug((Object)("Line " + ++n + ": " + string));
            if (string.length() > 0) {
                iMolecule.setProperty((Object)"cdk:Remark", (Object)string);
            }
            logger.info((Object)"Reading rest of file");
            string = this.input.readLine();
            logger.debug((Object)("Line " + ++n + ": " + string));
            if (this.mode == IChemObjectReader.Mode.STRICT) {
                if (string.contains("V2000") || string.contains("v2000")) {
                    throw new CDKException("This file must be read with the MDLV2000Reader.");
                }
                if (string.contains("V3000") || string.contains("v3000")) {
                    throw new CDKException("This file must be read with the MDLV3000Reader.");
                }
            }
            n2 = Integer.valueOf(string.substring(0, 3).trim());
            logger.debug((Object)("Atomcount: " + n2));
            n3 = Integer.valueOf(string.substring(3, 6).trim());
            logger.debug((Object)("Bondcount: " + n3));
            logger.info((Object)"Reading atom block");
            for (int i = 0; i < n2; ++i) {
                IAtom iAtom;
                string = this.input.readLine();
                ++n;
                d = new Double(string.substring(0, 10).trim());
                d2 = new Double(string.substring(10, 20).trim());
                d3 = new Double(string.substring(20, 30).trim());
                d4 += Math.abs(d);
                d5 += Math.abs(d2);
                d6 += Math.abs(d3);
                logger.debug((Object)("Coordinates: " + d + "; " + d2 + "; " + d3));
                object32 = string.substring(31, 34).trim();
                logger.debug((Object)"Atom type: ", new Object[]{object32});
                if (isotopeFactory.isElement((String)object32)) {
                    iAtom = isotopeFactory.configure(MoleculeTools.newAtom(iMolecule.getBuilder(), (String)object32));
                } else if ("A".equals(object32)) {
                    iAtom = MoleculeTools.newPseudoAtom(iMolecule.getBuilder(), (String)object32);
                } else if ("Q".equals(object32)) {
                    iAtom = MoleculeTools.newPseudoAtom(iMolecule.getBuilder(), (String)object32);
                } else if ("*".equals(object32)) {
                    iAtom = MoleculeTools.newPseudoAtom(iMolecule.getBuilder(), (String)object32);
                } else if ("LP".equals(object32)) {
                    iAtom = MoleculeTools.newPseudoAtom(iMolecule.getBuilder(), (String)object32);
                } else if ("L".equals(object32)) {
                    iAtom = MoleculeTools.newPseudoAtom(iMolecule.getBuilder(), (String)object32);
                } else if (((String)object32).length() > 0 && ((String)object32).charAt(0) == 'R') {
                    logger.debug((Object)"Atom ", new Object[]{object32, " is not an regular element. Creating a PseudoAtom."});
                    stringArray = ((String)object32).split("^R");
                    if (stringArray.length > 1) {
                        try {
                            n7 = n8 = Integer.parseInt(stringArray[stringArray.length - 1]);
                        }
                        catch (Exception exception) {
                            n8 = n7++;
                        }
                        object32 = "R" + n8;
                    }
                    iAtom = MoleculeTools.newPseudoAtom(iMolecule.getBuilder(), (String)object32);
                } else {
                    if (this.mode == IChemObjectReader.Mode.STRICT) {
                        throw new CDKException("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.");
                    }
                    iAtom = MoleculeTools.newPseudoAtom(iMolecule.getBuilder(), (String)object32);
                }
                iAtom.setPoint3d(new Point3d(d, d2, d3));
                object2 = string.substring(34, 36).trim();
                logger.debug((Object)"Mass difference: ", new Object[]{object2});
                if (!(iAtom instanceof IPseudoAtom)) {
                    try {
                        int n9 = Integer.parseInt((String)object2);
                        if (n9 != 0) {
                            IIsotope iIsotope = IsotopeFactory.getInstance((IChemObjectBuilder)iMolecule.getBuilder()).getMajorIsotope((String)object32);
                            iAtom.setAtomicNumber(Integer.valueOf(iIsotope.getAtomicNumber() + n9));
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Could not parse mass difference field");
                    }
                } else {
                    logger.error((Object)"Cannot set mass difference for a non-element!");
                }
                object = string.substring(36, 39).trim();
                logger.debug((Object)"Atom charge code: ", new Object[]{object});
                int n10 = Integer.parseInt((String)object);
                if (n10 != 0) {
                    if (n10 == 1) {
                        iAtom.setFormalCharge(Integer.valueOf(3));
                    } else if (n10 == 2) {
                        iAtom.setFormalCharge(Integer.valueOf(2));
                    } else if (n10 == 3) {
                        iAtom.setFormalCharge(Integer.valueOf(1));
                    } else if (n10 != 4) {
                        if (n10 == 5) {
                            iAtom.setFormalCharge(Integer.valueOf(-1));
                        } else if (n10 == 6) {
                            iAtom.setFormalCharge(Integer.valueOf(-2));
                        } else if (n10 == 7) {
                            iAtom.setFormalCharge(Integer.valueOf(-3));
                        }
                    }
                }
                try {
                    String string2 = string.substring(60, 63).trim();
                    logger.debug((Object)"Parsing mapping id: ", new Object[]{string2});
                    try {
                        int n11 = Integer.parseInt(string2);
                        if (n11 != 0) {
                            iAtom.setID(string2);
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Mapping number ", new Object[]{string2, " is not an integer."});
                        logger.debug((Object)exception);
                    }
                }
                catch (Exception exception) {
                    logger.warn((Object)"A few fields are missing. Older MDL MOL file?");
                }
                if (string.length() >= 78) {
                    double d7 = Double.parseDouble(string.substring(69, 80).trim());
                    iAtom.setProperty((Object)"first shift", (Object)new Double(d7));
                }
                if (string.length() >= 87) {
                    double d8 = Double.parseDouble(string.substring(79, 87).trim());
                    iAtom.setProperty((Object)"second shift", (Object)new Double(d8));
                }
                iMolecule.addAtom(iAtom);
            }
            if (d4 == 0.0 && d5 == 0.0 && d6 == 0.0) {
                logger.info((Object)"All coordinates are 0.0");
                for (Object object32 : iMolecule.atoms()) {
                    object32.setPoint3d(null);
                }
            } else if (d6 == 0.0 && !this.forceReadAs3DCoords.isSet()) {
                logger.info((Object)"Total 3D Z is 0.0, interpreting it as a 2D structure");
                for (Object object32 : iMolecule.atoms()) {
                    object2 = object32.getPoint3d();
                    object32.setPoint2d(new Point2d(object2.x, object2.y));
                    object32.setPoint3d(null);
                }
            }
            logger.info((Object)"Reading bond block");
            for (int i = 0; i < n3; ++i) {
                string = this.input.readLine();
                ++n;
                n4 = Integer.valueOf(string.substring(0, 3).trim());
                n5 = Integer.valueOf(string.substring(3, 6).trim());
                n6 = Integer.valueOf(string.substring(6, 9).trim());
                if (string.length() > 12) {
                    int n12 = Integer.valueOf(string.substring(9, 12).trim());
                    if (n12 == 1) {
                        stereo = IBond.Stereo.UP;
                    } else if (n12 == 6) {
                        stereo = IBond.Stereo.DOWN;
                    } else if (n12 == 0) {
                        stereo = IBond.Stereo.NONE;
                    } else if (n12 == 4) {
                        stereo = (IBond.Stereo)CDKConstants.UNSET;
                    }
                } else {
                    logger.warn((Object)("Missing expected stereo field at line: " + string));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Bond: " + n4 + " - " + n5 + "; order " + n6));
                }
                object32 = iMolecule.getAtom(n4 - 1);
                object2 = iMolecule.getAtom(n5 - 1);
                object = null;
                if (n6 == 1) {
                    object = MoleculeTools.newBond(iMolecule.getBuilder(), (IAtom)object32, (IAtom)object2, IBond.Order.SINGLE, stereo);
                } else if (n6 == 2) {
                    object = MoleculeTools.newBond(iMolecule.getBuilder(), (IAtom)object32, (IAtom)object2, IBond.Order.DOUBLE, stereo);
                } else if (n6 == 3) {
                    object = MoleculeTools.newBond(iMolecule.getBuilder(), (IAtom)object32, (IAtom)object2, IBond.Order.TRIPLE, stereo);
                } else if (n6 == 4) {
                    object = MoleculeTools.newBond(iMolecule.getBuilder(), (IAtom)object32, (IAtom)object2, IBond.Order.SINGLE, stereo);
                    object.setFlag(5, true);
                    object32.setFlag(5, true);
                    object2.setFlag(5, true);
                }
                iMolecule.addBond(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = "Error while parsing line " + n + ": " + string + " -> " + exception.getMessage();
            logger.error((Object)string3);
            logger.debug((Object)exception);
            throw new CDKException(string3, (Throwable)exception);
        }
        return iMolecule;
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = new BooleanIOSetting("ForceReadAs3DCoordinates", 2, "Should coordinates always be read as 3D?", "true");
    }

    public void customizeJob() {
        this.fireIOSettingQuestion((IOSetting)this.forceReadAs3DCoords);
    }

    public IOSetting[] getIOSettings() {
        IOSetting[] iOSettingArray = new IOSetting[]{this.forceReadAs3DCoords};
        return iOSettingArray;
    }
}

