/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure.key;

import ambit2.base.interfaces.IProcessor;

public interface IStructureKey<Target, Result>
extends IProcessor<Target, Result> {
    public Object getKey();

    public Object getQueryKey();

    public Class getType();

    public static enum Matcher {
        CAS{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.CASKey";
            }

            @Override
            public String getDescription() {
                return "Match by CAS registry number";
            }
        }
        ,
        EINECS{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.EINECSKey";
            }

            @Override
            public String getDescription() {
                return "Match by EINECS registry number";
            }
        }
        ,
        PubChemID{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.PubchemCID";
            }

            @Override
            public String getDescription() {
                return "Match by PubChem Compound ID (PUBCHEM_COMPOUND_CID)";
            }
        }
        ,
        DSSToxCID{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.DSSToxCID";
            }

            @Override
            public String getDescription() {
                return "Match by DSSTox Chemical ID (DSSTox_CID) number uniquely assigned to a particular STRUCTURE across all DSSTox files";
            }
        }
        ,
        DSSToxRID{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.DSSToxRID";
            }

            @Override
            public String getDescription() {
                return "Match by DSSTox Record ID (DSSTox_RID) is number uniquely assigned to each DSSTox record across all DSSTox files";
            }
        }
        ,
        InChI{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.InchiPropertyKey";
            }

            @Override
            public String getDescription() {
                return "Match by InChI";
            }
        }
        ,
        SMILES{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.SmilesKey";
            }

            @Override
            public String getDescription() {
                return "Match by SMILES";
            }
        }
        ,
        ChEMBL{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.ChEMBLCompoundURI";
            }

            @Override
            public String getDescription() {
                return "http://rdf.farmbio.uu.se/chembl/onto/#forMolecule";
            }
        }
        ,
        SAMPLE{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.SampleKey";
            }

            @Override
            public String getDescription() {
                return "Match by column \"SAMPLE\"";
            }
        }
        ,
        NAME{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.NameKey";
            }

            @Override
            public String getDescription() {
                return "Match by chemical name";
            }
        }
        ,
        None{

            @Override
            public String getClassName() {
                return "ambit2.core.processors.structure.key.NoneKey";
            }

            @Override
            public String getDescription() {
                return "Don't match, add as a new structure";
            }
        };


        public abstract String getClassName();

        public abstract String getDescription();

        public IStructureKey getMatcher() {
            try {
                Class<?> clazz = Class.forName(this.getClassName());
                return (IStructureKey)clazz.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

