/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.SmartsParser;
import java.util.Vector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.SSSRFinder;

public class CMLUtilities {
    public static final String SMARTSProp = "SMARTSProp";
    public static final String RingData = "RingData";
    public static final String RingData2 = "RingData2";
    public static final String ExplicitH = "ExplicitH";
    public static final int MAXRINGS = 4;
    int[] expH;
    Vector<int[]> rd;
    Vector<int[]> rd2;

    public void setCMLSMARTSProperties(IMolecule mol) {
        SSSRFinder sssrf = new SSSRFinder((IAtomContainer)mol);
        IRingSet ringSet = sssrf.findSSSR();
        SmartsParser.setNeighbourData((IAtomContainer)mol);
        SmartsParser.setValenceData((IAtomContainer)mol);
        this.expH = SmartsParser.getExplicitHAtomData((IAtomContainer)mol);
        this.rd = SmartsParser.getRindData((IAtomContainer)mol, ringSet);
        this.rd2 = SmartsParser.getRindData2((IAtomContainer)mol, ringSet);
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            String prop = this.getAtomCMLSMARTSProperty(i, mol);
            mol.getAtom(i).setProperty((Object)SMARTSProp, (Object)prop);
        }
    }

    String getAtomCMLSMARTSProperty(int n, IMolecule mol) {
        StringBuffer sb = new StringBuffer();
        IAtom atom = mol.getAtom(n);
        sb.append(this.expH[n]);
        sb.append(atom.getValency());
        sb.append(atom.getFormalNeighbourCount());
        if (this.rd.get(n) == null) {
            sb.append("0");
        } else {
            sb.append(this.rd.get(n).length);
            this.addData(sb, this.rd.get(n));
            this.addData(sb, this.rd2.get(n));
        }
        return sb.toString();
    }

    void addZeros(StringBuffer sb, int n) {
        for (int i = 0; i < n; ++i) {
            sb.append("0");
        }
    }

    void addData(StringBuffer sb, int[] r) {
        if (r == null) {
            return;
        }
        for (int i = 0; i < r.length; ++i) {
            if (r[i] <= 9) {
                sb.append("0");
            }
            sb.append(r[i]);
        }
    }

    public void extractSMARTSProperties(IMolecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            IAtom atom = mol.getAtom(i);
            Object o = atom.getProperty((Object)SMARTSProp);
            if (o == null) continue;
            this.extractCMLAtomProperties(atom, o.toString());
        }
    }

    public void extractCMLAtomProperties(IAtom atom, String CMLProperty) {
        int i;
        if (CMLProperty.length() < 4) {
            return;
        }
        atom.setProperty((Object)ExplicitH, (Object)new Integer(this.extractInteger(CMLProperty, 0, 1)));
        atom.setValency(Integer.valueOf(this.extractInteger(CMLProperty, 1, 1)));
        atom.setFormalNeighbourCount(Integer.valueOf(this.extractInteger(CMLProperty, 2, 1)));
        int numRings = this.extractInteger(CMLProperty, 3, 1);
        if (CMLProperty.length() < 4 + 4 * numRings) {
            return;
        }
        int[] r = new int[numRings];
        int[] r2 = new int[numRings];
        int pos = 4;
        for (i = 0; i < numRings; ++i) {
            r[i] = this.extractInteger(CMLProperty, pos, 2);
            pos += 2;
        }
        for (i = 0; i < numRings; ++i) {
            r2[i] = this.extractInteger(CMLProperty, pos, 2);
            pos += 2;
        }
        atom.setProperty((Object)RingData, (Object)r);
        atom.setProperty((Object)RingData2, (Object)r2);
    }

    int extractInteger(String s, int pos, int lenght) {
        Integer i = new Integer(s.substring(pos, pos + lenght));
        return i;
    }
}

