/*
 * Decompiled with CFR 0.152.
 */
package padeldescriptor;

import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import libpadeldescriptor.PaDELStandardize;
import libpadeldescriptor.libPaDELDescriptorMaster;
import libpadeldescriptor.libPaDELDescriptorType;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import padeldescriptor.PaDELDescriptorView;

public class PaDELDescriptorApp
extends SingleFrameApplication {
    private StartTask start;
    private Options options = new Options();
    private String directory;
    private String descriptorFile;
    private boolean compute2D = false;
    private boolean compute3D = false;
    private boolean computeFingerprints = false;
    private boolean removeSalt = true;
    private boolean detectAromaticity = true;
    private boolean standardizeTautomers = false;
    private String[] tautomerList = null;
    private boolean standardizeNitro = true;
    private boolean retain3D = false;
    private boolean convert3D = false;
    private String forceField = "mm2";
    private boolean logResults = false;
    private int maxThreads = -1;
    private int maxJobsWaiting = -1;
    private long maxRunTime = -1L;
    private int maxCpdPerFile = 0;
    private boolean retainOrder = true;
    private boolean useFilenameAsMolName = false;
    private String config;
    private String descriptortypes;

    public PaDELDescriptorApp() {
        OptionBuilder.withArgName((String)"config");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Configuration file");
        this.options.addOption(OptionBuilder.create((String)"config"));
        OptionBuilder.withArgName((String)"descriptortypes");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Descriptor types file");
        this.options.addOption(OptionBuilder.create((String)"descriptortypes"));
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set directory containing structural files");
        this.options.addOption(OptionBuilder.create((String)"dir"));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set file to save calculated descriptors");
        this.options.addOption(OptionBuilder.create((String)"file"));
        this.options.addOption("2d", false, "Calculate 1D and 2D descriptors");
        this.options.addOption("3d", false, "Calculate 3D descriptors");
        this.options.addOption("fingerprints", false, "Calculate fingerprints");
        this.options.addOption("removesalt", false, "Remove salt from molecule");
        this.options.addOption("detectaromaticity", false, "Remove existing aromaticity information and automatically detect aromaticity in the molecule before calculation of descriptors");
        this.options.addOption("standardizetautomers", false, "Standardize tautomers");
        OptionBuilder.withArgName((String)"tautomerlist");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"SMIRKS tautomers file");
        this.options.addOption(OptionBuilder.create((String)"tautomerlist"));
        this.options.addOption("standardizenitro", false, "Standardize nitro groups to N(:O):O");
        this.options.addOption("retain3d", false, "Retain 3D coordinates when standardizing structure. However, this may prevent some structures from being standardized");
        this.options.addOption("convert3d", false, "Convert molecule to 3D");
        this.options.addOption("log", false, "Create a log file.\nName of log file is the name of the descriptors file with a .log extension.");
        OptionBuilder.withArgName((String)"threads");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum number of threads to use. Use -1 to use as many threads as the number of cpu cores");
        this.options.addOption(OptionBuilder.create((String)"threads"));
        OptionBuilder.withArgName((String)"waitingjobs");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum number of jobs to store in queue for worker threads to process. Use -1 to set it to 50*Max threads.");
        this.options.addOption(OptionBuilder.create((String)"waitingjobs"));
        OptionBuilder.withArgName((String)"maxruntime");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum running time per molecule (in milliseconds). Use -1 for unlimited.");
        this.options.addOption(OptionBuilder.create((String)"maxruntime"));
        OptionBuilder.withArgName((String)"maxcpdperfile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Maximum number of compounds to be stored in each descriptor file. Use 0 for unlimited");
        this.options.addOption(OptionBuilder.create((String)"maxcpdperfile"));
        this.options.addOption("retainorder", false, "Retain order of molecules in structural files for descriptor file. This may lead to large memory use if descriptor calculations are stuck at one molecule as the others will not be written to file and cleared from memory");
        this.options.addOption("usefilenameasmolname", false, "Use filename (minus the extension) as molecule name");
        this.options.addOption("help", false, "Print this message");
    }

    @Override
    protected void startup() {
        this.show(new PaDELDescriptorView(this));
    }

    @Override
    protected void configureWindow(Window window) {
    }

    public static PaDELDescriptorApp getApplication() {
        return Application.getInstance(PaDELDescriptorApp.class);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            PaDELDescriptorApp.launch(PaDELDescriptorApp.class, stringArray);
        } else {
            PaDELDescriptorApp.getApplication().launchCommandLine(stringArray);
        }
    }

    public void launchCommandLine(String[] stringArray) {
        GnuParser gnuParser = new GnuParser();
        try {
            CommandLine commandLine = gnuParser.parse(this.options, stringArray);
            if (commandLine.hasOption("help")) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("java -jar PaDEL-Descriptor.jar", this.options);
            } else {
                this.config = commandLine.getOptionValue("config");
                if (this.config != null) {
                    try {
                        String string;
                        Properties properties = new Properties();
                        FileInputStream fileInputStream = new FileInputStream(this.config);
                        properties.load(fileInputStream);
                        this.directory = properties.getProperty("Directory");
                        this.descriptorFile = properties.getProperty("DescriptorFile");
                        this.compute2D = Boolean.valueOf(properties.getProperty("Compute2D"));
                        this.compute3D = Boolean.valueOf(properties.getProperty("Compute3D"));
                        this.computeFingerprints = Boolean.valueOf(properties.getProperty("ComputeFingerprints"));
                        this.removeSalt = Boolean.valueOf(properties.getProperty("RemoveSalt"));
                        this.detectAromaticity = Boolean.valueOf(properties.getProperty("DetectAromaticity"));
                        this.standardizeTautomers = Boolean.valueOf(properties.getProperty("StandardizeTautomers"));
                        this.standardizeNitro = Boolean.valueOf(properties.getProperty("StandardizeNitro"));
                        this.retain3D = Boolean.valueOf(properties.getProperty("Retain3D"));
                        String string2 = properties.getProperty("TautomerFile");
                        if (string2 != null && !string2.trim().isEmpty()) {
                            this.tautomerList = PaDELStandardize.getTautomerList((File)new File(string2));
                        }
                        if ((string = properties.getProperty("Convert3D")).equals("No")) {
                            this.convert3D = false;
                        } else {
                            this.convert3D = true;
                            this.forceField = string.equals("Yes (use MM2 forcefield)") ? "mm2" : "mmff94";
                        }
                        this.logResults = Boolean.valueOf(properties.getProperty("Log"));
                        this.maxThreads = Integer.valueOf(properties.getProperty("MaxThreads"));
                        this.maxJobsWaiting = Integer.valueOf(properties.getProperty("MaxJobsWaiting"));
                        this.maxRunTime = Long.valueOf(properties.getProperty("MaxRunTime"));
                        this.maxCpdPerFile = Integer.valueOf(properties.getProperty("MaxCpdPerFile"));
                        this.retainOrder = Boolean.valueOf(properties.getProperty("RetainOrder"));
                        this.useFilenameAsMolName = Boolean.valueOf(properties.getProperty("UseFilenameAsMolName"));
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        System.out.println("Cannot load configuration");
                        return;
                    }
                } else {
                    String string;
                    this.compute2D = false;
                    this.compute3D = false;
                    this.computeFingerprints = false;
                    this.removeSalt = false;
                    this.detectAromaticity = false;
                    this.standardizeTautomers = false;
                    this.standardizeNitro = false;
                    this.retain3D = false;
                    this.convert3D = false;
                    this.logResults = false;
                    this.retainOrder = false;
                    this.useFilenameAsMolName = false;
                    this.directory = commandLine.getOptionValue("dir");
                    this.descriptorFile = commandLine.getOptionValue("file");
                    if (commandLine.hasOption("2d")) {
                        this.compute2D = true;
                    }
                    if (commandLine.hasOption("3d")) {
                        this.compute3D = true;
                    }
                    if (commandLine.hasOption("fingerprints")) {
                        this.computeFingerprints = true;
                    }
                    if (commandLine.hasOption("removesalt")) {
                        this.removeSalt = true;
                    }
                    if (commandLine.hasOption("detectaromaticity")) {
                        this.detectAromaticity = true;
                    }
                    if (commandLine.hasOption("standardizetautomers")) {
                        this.standardizeTautomers = true;
                    }
                    if ((string = commandLine.getOptionValue("tautomerlist")) != null && !string.trim().isEmpty()) {
                        this.tautomerList = PaDELStandardize.getTautomerList((File)new File(string));
                    }
                    if (commandLine.hasOption("standardizenitro")) {
                        this.standardizeNitro = true;
                    }
                    if (commandLine.hasOption("retain3d")) {
                        this.retain3D = true;
                    }
                    if (commandLine.hasOption("convert3d")) {
                        this.convert3D = true;
                    }
                    if (commandLine.hasOption("log")) {
                        this.logResults = true;
                    }
                    if (commandLine.hasOption("threads")) {
                        this.maxThreads = Integer.valueOf(commandLine.getOptionValue("threads"));
                    }
                    if (commandLine.hasOption("waitingjobs")) {
                        this.maxJobsWaiting = Integer.valueOf(commandLine.getOptionValue("waitingjobs"));
                    }
                    if (commandLine.hasOption("maxruntime")) {
                        this.maxRunTime = Long.valueOf(commandLine.getOptionValue("maxruntime"));
                    }
                    if (commandLine.hasOption("maxcpdperfile")) {
                        this.maxCpdPerFile = Integer.valueOf(commandLine.getOptionValue("maxcpdperfile"));
                    }
                    if (commandLine.hasOption("retainorder")) {
                        this.retainOrder = true;
                    }
                    if (commandLine.hasOption("usefilenameasmolname")) {
                        this.useFilenameAsMolName = true;
                    }
                }
                this.descriptortypes = commandLine.getOptionValue("descriptortypes");
                this.StartCmd();
            }
        }
        catch (ParseException parseException) {
            Logger.getLogger("global").log(Level.WARNING, parseException.getMessage());
        }
    }

    private void StartCmd() {
        String string;
        String string2;
        libPaDELDescriptorMaster libPaDELDescriptorMaster2;
        block19: {
            libPaDELDescriptorMaster2 = new libPaDELDescriptorMaster(this.directory, this.descriptorFile, this.compute2D, this.compute3D, this.computeFingerprints, this.removeSalt, this.detectAromaticity, this.standardizeTautomers, this.standardizeNitro, this.retain3D, this.convert3D);
            string2 = libPaDELDescriptorMaster2.CheckRequirements();
            if (string2 != null && !string2.isEmpty()) {
                System.out.println(string2);
                return;
            }
            try {
                if (this.descriptortypes != null) {
                    try {
                        libPaDELDescriptorMaster2.SetDescriptorTypes(this.descriptortypes);
                        break block19;
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.SEVERE, "Cannot read in descriptor types file", exception);
                        System.out.println("Cannot read in descriptor types file.");
                        return;
                    }
                }
                libPaDELDescriptorMaster2.SetDescriptorTypes("descriptors.xml");
            }
            catch (Exception exception) {
                try {
                    libPaDELDescriptorMaster2.SetDescriptorTypes(this.getClass().getClassLoader().getResourceAsStream("META-INF/descriptors.xml"));
                }
                catch (Exception exception2) {
                    Logger.getLogger("global").log(Level.SEVERE, "Cannot read in descriptor types file", exception2);
                    System.out.println("Cannot read in descriptor types file.");
                    return;
                }
            }
        }
        if (this.maxThreads > 0) {
            libPaDELDescriptorMaster2.setMaxThreads(this.maxThreads);
        }
        if (this.maxJobsWaiting > 0) {
            libPaDELDescriptorMaster2.setMaxJobsWaiting(this.maxJobsWaiting);
        }
        if (this.maxRunTime > 0L) {
            libPaDELDescriptorMaster2.setMaxRunTime(this.maxRunTime);
        }
        libPaDELDescriptorMaster2.setMaxMolPerFile(this.maxCpdPerFile);
        libPaDELDescriptorMaster2.setLogResults(this.logResults);
        libPaDELDescriptorMaster2.setRetainOrder(this.retainOrder);
        libPaDELDescriptorMaster2.setUseFilenameAsMolName(this.useFilenameAsMolName);
        if (this.tautomerList != null) {
            libPaDELDescriptorMaster2.setTautomerList(this.tautomerList);
        } else {
            try {
                libPaDELDescriptorMaster2.setTautomerList(PaDELStandardize.getTautomerList((InputStream)this.getClass().getClassLoader().getResourceAsStream("META-INF/tautomerlist.txt")));
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.SEVERE, "Cannot read in SMIRKS tautomers file", exception);
                System.out.println("Cannot read in SMIRKS tautomers file.");
                return;
            }
        }
        libPaDELDescriptorMaster2.setForcefield(this.forceField);
        string2 = libPaDELDescriptorMaster2.Initialize();
        if (string2 != null && !string2.isEmpty()) {
            System.out.println(string2);
            return;
        }
        while (libPaDELDescriptorMaster2.HasWork()) {
            string = libPaDELDescriptorMaster2.getStatus();
            if (!string.isEmpty()) {
                System.out.print(string);
            }
            libPaDELDescriptorMaster2.DoWork();
        }
        string = libPaDELDescriptorMaster2.getStatus();
        if (!string.isEmpty()) {
            System.out.println(string);
        }
    }

    @Action
    public Task Start() {
        if (this.start == null || this.start.isDone()) {
            this.start = new StartTask(Application.getInstance(PaDELDescriptorApp.class));
        } else {
            this.start.Stop();
            this.start = null;
        }
        return this.start;
    }

    static /* synthetic */ String[] access$802(PaDELDescriptorApp paDELDescriptorApp, String[] stringArray) {
        paDELDescriptorApp.tautomerList = stringArray;
        return stringArray;
    }

    private class StartTask
    extends Task<Object, Void> {
        private boolean wantsToRun;
        private libPaDELDescriptorMaster master;

        StartTask(Application application) {
            super(application);
            this.wantsToRun = true;
        }

        @Override
        protected Object doInBackground() {
            PaDELDescriptorApp paDELDescriptorApp = (PaDELDescriptorApp)this.getApplication();
            PaDELDescriptorView paDELDescriptorView = (PaDELDescriptorView)paDELDescriptorApp.getMainView();
            PaDELDescriptorApp.this.directory = paDELDescriptorView.config.data.getDirectory();
            PaDELDescriptorApp.this.descriptorFile = paDELDescriptorView.config.data.getDescriptorFile();
            PaDELDescriptorApp.this.compute2D = paDELDescriptorView.config.data.isCompute2D();
            PaDELDescriptorApp.this.compute3D = paDELDescriptorView.config.data.isCompute3D();
            PaDELDescriptorApp.this.computeFingerprints = paDELDescriptorView.config.data.isComputeFingerprints();
            PaDELDescriptorApp.this.removeSalt = paDELDescriptorView.config.data.isRemoveSalt();
            PaDELDescriptorApp.this.detectAromaticity = paDELDescriptorView.config.data.isDetectAromaticity();
            PaDELDescriptorApp.this.standardizeTautomers = paDELDescriptorView.config.data.isStandardizeTautomers();
            String string = paDELDescriptorView.config.data.getTautomerFile();
            if (string != null && !string.trim().isEmpty()) {
                PaDELDescriptorApp.access$802(PaDELDescriptorApp.this, PaDELStandardize.getTautomerList((File)new File(string)));
            } else {
                try {
                    PaDELDescriptorApp.access$802(PaDELDescriptorApp.this, PaDELStandardize.getTautomerList((InputStream)this.getClass().getClassLoader().getResourceAsStream("META-INF/tautomerlist.txt")));
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.SEVERE, "Cannot read in SMIRKS tautomers file", exception);
                }
            }
            PaDELDescriptorApp.this.standardizeNitro = paDELDescriptorView.config.data.isStandardizeNitro();
            PaDELDescriptorApp.this.retain3D = paDELDescriptorView.config.data.isRetain3D();
            String string2 = paDELDescriptorView.config.data.getConvert3D();
            if (string2.equals("No")) {
                PaDELDescriptorApp.this.convert3D = false;
            } else {
                PaDELDescriptorApp.this.convert3D = true;
                if (string2.equals("Yes (use MM2 forcefield)")) {
                    PaDELDescriptorApp.this.forceField = "mm2";
                } else {
                    PaDELDescriptorApp.this.forceField = "mmff94";
                }
            }
            PaDELDescriptorApp.this.logResults = paDELDescriptorView.config.data.isLog();
            PaDELDescriptorApp.this.maxThreads = paDELDescriptorView.config.data.getMaxThreads();
            PaDELDescriptorApp.this.maxJobsWaiting = paDELDescriptorView.config.data.getMaxJobsWaiting();
            PaDELDescriptorApp.this.maxRunTime = paDELDescriptorView.config.data.getMaxRunTime();
            PaDELDescriptorApp.this.maxCpdPerFile = paDELDescriptorView.config.data.getMaxCpdPerFile();
            PaDELDescriptorApp.this.retainOrder = paDELDescriptorView.config.data.isRetainOrder();
            PaDELDescriptorApp.this.useFilenameAsMolName = paDELDescriptorView.config.data.isUseFilenameAsMolName();
            this.master = new libPaDELDescriptorMaster(PaDELDescriptorApp.this.directory, PaDELDescriptorApp.this.descriptorFile, PaDELDescriptorApp.this.compute2D, PaDELDescriptorApp.this.compute3D, PaDELDescriptorApp.this.computeFingerprints, PaDELDescriptorApp.this.removeSalt, PaDELDescriptorApp.this.detectAromaticity, PaDELDescriptorApp.this.standardizeTautomers, PaDELDescriptorApp.this.standardizeNitro, PaDELDescriptorApp.this.retain3D, PaDELDescriptorApp.this.convert3D);
            String string3 = this.master.CheckRequirements();
            if (string3 != null && !string3.isEmpty()) {
                return string3;
            }
            this.master.SetDescriptorTypes(libPaDELDescriptorType.GetActiveDescriptorTypes(paDELDescriptorView.GetDescriptors(), (boolean)PaDELDescriptorApp.this.compute2D, (boolean)PaDELDescriptorApp.this.compute3D, (boolean)PaDELDescriptorApp.this.computeFingerprints));
            if (PaDELDescriptorApp.this.maxThreads > 0) {
                this.master.setMaxThreads(PaDELDescriptorApp.this.maxThreads);
            }
            if (PaDELDescriptorApp.this.maxJobsWaiting > 0) {
                this.master.setMaxJobsWaiting(PaDELDescriptorApp.this.maxJobsWaiting);
            }
            if (PaDELDescriptorApp.this.maxRunTime > 0L) {
                this.master.setMaxRunTime(PaDELDescriptorApp.this.maxRunTime);
            }
            this.master.setMaxMolPerFile(PaDELDescriptorApp.this.maxCpdPerFile);
            this.master.setLogResults(PaDELDescriptorApp.this.logResults);
            this.master.setRetainOrder(PaDELDescriptorApp.this.retainOrder);
            this.master.setUseFilenameAsMolName(PaDELDescriptorApp.this.useFilenameAsMolName);
            this.master.setTautomerList(PaDELDescriptorApp.this.tautomerList);
            this.master.setForcefield(PaDELDescriptorApp.this.forceField);
            string3 = this.master.Initialize();
            if (string3 != null && !string3.isEmpty()) {
                return string3;
            }
            paDELDescriptorView.start.setText("Stop");
            paDELDescriptorView.start.setToolTipText("Stop descriptor calculation");
            while (this.master.HasWork()) {
                if (!this.wantsToRun) {
                    this.master.StopAllWorkers();
                    break;
                }
                String string4 = this.master.getMessagesWorker();
                string4 = string4.replaceAll("\n", "<br>");
                string4 = "<html>" + string4 + "</html>";
                paDELDescriptorView.status.setText(string4);
                this.setProgress(this.master.getMolProcessed(), 0, this.master.GetMaxMolecules());
                this.master.DoWork();
            }
            return null;
        }

        @Override
        protected void succeeded(Object object) {
            PaDELDescriptorApp paDELDescriptorApp = (PaDELDescriptorApp)this.getApplication();
            PaDELDescriptorView paDELDescriptorView = (PaDELDescriptorView)paDELDescriptorApp.getMainView();
            this.master.StopAllWorkers();
            if (object != null && !((String)object).isEmpty()) {
                String string = (String)object;
                JOptionPane.showMessageDialog(null, string, "Error", 0);
            } else if (this.wantsToRun) {
                long l = this.master.getEndTime() - this.master.getStartTime();
                double d = (double)l / 1.0E9 / (double)this.master.getMolProcessed();
                String string = "Completed. Average speed: " + new DecimalFormat("#0.00").format(d) + " s/mol.";
                paDELDescriptorView.status.setText(string);
                string = "";
                string = string + this.master.getStatus();
                JOptionPane.showMessageDialog(null, string, "Completed", 1);
            } else {
                paDELDescriptorView.status.setText("Cancelled");
                JOptionPane.showMessageDialog(null, "Descriptor calculation cancelled", "Cancelled", 2);
            }
            paDELDescriptorView.start.setText("Start");
            paDELDescriptorView.start.setToolTipText("Start descriptor calculations");
        }

        public void Stop() {
            this.wantsToRun = false;
        }
    }
}

