/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class SimpleUnitCell {
    protected float[] notionalUnitcell;
    protected Matrix4f matrixCartesianToFractional;
    protected Matrix4f matrixFractionalToCartesian;
    protected static final float toRadians = (float)Math.PI / 180;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected double cosAlpha;
    protected double sinAlpha;
    protected double cosBeta;
    protected double sinBeta;
    protected double cosGamma;
    protected double sinGamma;
    protected double volume;
    protected double cA_;
    protected double cB_;
    protected double a_;
    protected double b_;
    protected double c_;
    protected int dimension;
    protected Matrix4f matrixCtoFAbsolute;
    protected Matrix4f matrixFtoCAbsolute;

    public static boolean isValid(float[] fArray) {
        return fArray != null && (fArray[0] > 0.0f || fArray.length > 14 && !Float.isNaN(fArray[14]));
    }

    public SimpleUnitCell(float[] fArray) {
        Object object;
        if (!SimpleUnitCell.isValid(fArray)) {
            return;
        }
        this.notionalUnitcell = fArray;
        this.a = fArray[0];
        this.b = fArray[1];
        this.c = fArray[2];
        this.alpha = fArray[3];
        this.beta = fArray[4];
        this.gamma = fArray[5];
        if (this.a <= 0.0f) {
            Vector3f vector3f = new Vector3f(fArray[6], fArray[7], fArray[8]);
            Vector3f vector3f2 = new Vector3f(fArray[9], fArray[10], fArray[11]);
            object = new Vector3f(fArray[12], fArray[13], fArray[14]);
            this.a = vector3f.length();
            this.b = vector3f2.length();
            this.c = ((Vector3f)object).length();
            if (this.a == 0.0f) {
                return;
            }
            if (this.b == 0.0f) {
                this.c = -1.0f;
                this.b = -1.0f;
            } else if (this.c == 0.0f) {
                this.c = -1.0f;
            }
            this.alpha = this.b < 0.0f || this.c < 0.0f ? 90.0f : vector3f2.angle((Vector3f)object) / ((float)Math.PI / 180);
            this.beta = this.c < 0.0f ? 90.0f : vector3f.angle((Vector3f)object) / ((float)Math.PI / 180);
            float f = this.gamma = this.b < 0.0f ? 90.0f : vector3f.angle(vector3f2) / ((float)Math.PI / 180);
            if (this.c < 0.0f) {
                float[] fArray2 = (float[])fArray.clone();
                if (this.b < 0.0f) {
                    vector3f2.set(0.0f, 0.0f, 1.0f);
                    vector3f2.cross(vector3f2, vector3f);
                    if (vector3f2.length() < 0.001f) {
                        vector3f2.set(0.0f, 1.0f, 0.0f);
                    }
                    vector3f2.normalize();
                    fArray2[9] = vector3f2.x;
                    fArray2[10] = vector3f2.y;
                    fArray2[11] = vector3f2.z;
                }
                if (this.c < 0.0f) {
                    ((Vector3f)object).cross(vector3f, vector3f2);
                    ((Vector3f)object).normalize();
                    fArray2[12] = ((Vector3f)object).x;
                    fArray2[13] = ((Vector3f)object).y;
                    fArray2[14] = ((Vector3f)object).z;
                }
                fArray = fArray2;
            }
        }
        if (this.b <= 0.0f) {
            this.c = 1.0f;
            this.b = 1.0f;
            this.dimension = 1;
        } else if (this.c <= 0.0f) {
            this.c = 1.0f;
            this.dimension = 2;
        } else {
            this.dimension = 3;
        }
        this.cosAlpha = Math.cos((float)Math.PI / 180 * this.alpha);
        this.sinAlpha = Math.sin((float)Math.PI / 180 * this.alpha);
        this.cosBeta = Math.cos((float)Math.PI / 180 * this.beta);
        this.sinBeta = Math.sin((float)Math.PI / 180 * this.beta);
        this.cosGamma = Math.cos((float)Math.PI / 180 * this.gamma);
        this.sinGamma = Math.sin((float)Math.PI / 180 * this.gamma);
        double d = Math.sqrt(this.sinAlpha * this.sinAlpha + this.sinBeta * this.sinBeta + this.sinGamma * this.sinGamma + 2.0 * this.cosAlpha * this.cosBeta * this.cosGamma - 2.0);
        this.volume = (double)(this.a * this.b * this.c) * d;
        this.cA_ = (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma;
        this.cB_ = d / this.sinGamma;
        this.a_ = (double)(this.b * this.c) * this.sinAlpha / this.volume;
        this.b_ = (double)(this.a * this.c) * this.sinBeta / this.volume;
        this.c_ = (double)(this.a * this.b) * this.sinGamma / this.volume;
        if (fArray.length > 21 && !Float.isNaN(fArray[21])) {
            object = new float[16];
            for (int i = 0; i < 16; ++i) {
                object[i] = fArray[6 + i];
            }
            this.matrixCartesianToFractional = new Matrix4f((float[])object);
            this.matrixFractionalToCartesian = new Matrix4f();
            this.matrixFractionalToCartesian.invert(this.matrixCartesianToFractional);
        } else if (fArray.length > 14 && !Float.isNaN(fArray[14])) {
            this.matrixFractionalToCartesian = new Matrix4f();
            object = this.matrixFractionalToCartesian;
            ((Matrix4f)object).setColumn(0, fArray[6], fArray[7], fArray[8], 0.0f);
            ((Matrix4f)object).setColumn(1, fArray[9], fArray[10], fArray[11], 0.0f);
            ((Matrix4f)object).setColumn(2, fArray[12], fArray[13], fArray[14], 0.0f);
            ((Matrix4f)object).setColumn(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invert(this.matrixFractionalToCartesian);
        } else {
            this.matrixFractionalToCartesian = new Matrix4f();
            object = this.matrixFractionalToCartesian;
            ((Matrix4f)object).setColumn(0, this.a, 0.0f, 0.0f, 0.0f);
            ((Matrix4f)object).setColumn(1, (float)((double)this.b * this.cosGamma), (float)((double)this.b * this.sinGamma), 0.0f, 0.0f);
            ((Matrix4f)object).setColumn(2, (float)((double)this.c * this.cosBeta), (float)((double)this.c * (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma), (float)(this.volume / ((double)(this.a * this.b) * this.sinGamma)), 0.0f);
            ((Matrix4f)object).setColumn(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invert(this.matrixFractionalToCartesian);
        }
        this.matrixCtoFAbsolute = this.matrixCartesianToFractional;
        this.matrixFtoCAbsolute = this.matrixFractionalToCartesian;
    }

    public final void toCartesian(Point3f point3f, boolean bl) {
        if (this.matrixFractionalToCartesian != null) {
            (bl ? this.matrixFtoCAbsolute : this.matrixFractionalToCartesian).transform(point3f);
        }
    }

    public final void toFractional(Point3f point3f, boolean bl) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        (bl ? this.matrixCtoFAbsolute : this.matrixCartesianToFractional).transform(point3f);
    }

    public final float[] getNotionalUnitCell() {
        return this.notionalUnitcell;
    }

    public final float[] getUnitCellAsArray() {
        Matrix4f matrix4f = this.matrixFractionalToCartesian;
        return new float[]{this.dimension, (float)this.volume, this.a, this.b, this.c, this.alpha, this.beta, this.gamma, matrix4f.m00, matrix4f.m10, matrix4f.m20, matrix4f.m01, matrix4f.m11, matrix4f.m21, matrix4f.m02, matrix4f.m12, matrix4f.m22};
    }

    public boolean isPolymer() {
        return this.dimension == 1;
    }

    public boolean isSlab() {
        return this.dimension == 2;
    }

    public final float getInfo(int n) {
        switch (n) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
            case 6: {
                return this.dimension;
            }
        }
        return Float.NaN;
    }
}

