/*
 * Decompiled with CFR 0.152.
 */
package libpadeljobs;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import libpadeljobs.Job;
import libpadeljobs.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Master<J extends Job, W extends Worker<J>> {
    public static int NO_MORE_JOBS = -1;
    protected int maxThreads = -1;
    protected int maxJobsWaiting = -1;
    protected boolean hasWork;
    protected String status;
    protected String[] messages;
    protected String[] messagesWorker;
    protected LinkedBlockingQueue<J> jobsWaiting;
    protected LinkedBlockingQueue<J> jobsRunning;
    protected LinkedBlockingQueue<J> jobsCompleted;
    protected ArrayList<W> workers;

    public final boolean HasWork() {
        return this.hasWork;
    }

    public final void DoWork() {
        this.AddJobsToQueue();
        this.ProcessRunningJobs();
        this.ProcessCompletedJobs();
    }

    public String Initialize() {
        if (this.maxThreads <= 0) {
            this.maxThreads = Runtime.getRuntime().availableProcessors();
        }
        if (this.maxJobsWaiting <= 0) {
            this.maxJobsWaiting = this.maxThreads * 50;
        }
        this.hasWork = true;
        this.jobsWaiting = new LinkedBlockingQueue(this.maxJobsWaiting);
        this.jobsRunning = new LinkedBlockingQueue();
        this.jobsCompleted = new LinkedBlockingQueue();
        this.workers = new ArrayList();
        this.status = new String();
        this.messages = new String[this.maxThreads];
        this.messagesWorker = new String[this.maxThreads];
        for (int i = 0; i < this.maxThreads; ++i) {
            this.messages[i] = new String();
            this.messagesWorker[i] = new String();
        }
        return null;
    }

    protected abstract void AddJobsToQueue();

    protected abstract void ProcessRunningJobs();

    protected abstract void ProcessCompletedJobs();

    public void StopAllWorkers() {
        if (this.workers == null) {
            return;
        }
        for (int i = 0; i < this.workers.size(); ++i) {
            if (this.workers.get(i) == null) continue;
            ((Worker)this.workers.get(i)).StopWorker();
        }
    }

    public synchronized String getMessage(int channelID) {
        if (this.messages[channelID].isEmpty()) {
            return this.messages[channelID];
        }
        return this.messages[channelID] + "\n";
    }

    public synchronized String getMessages() {
        String temp = new String();
        for (String message : this.messages) {
            if (message.isEmpty()) continue;
            temp = temp + message + "\n";
        }
        return temp;
    }

    public synchronized String clearMessage(int channelID) {
        String temp = new String(this.messages[channelID]);
        if (!temp.isEmpty()) {
            temp = temp + "\n";
        }
        this.messages[channelID] = new String();
        return temp;
    }

    public synchronized String clearMessages() {
        String temp = new String();
        for (int i = 0; i < this.messages.length; ++i) {
            if (this.messages[i].isEmpty()) continue;
            temp = temp + this.messages[i] + "\n";
            this.messages[i] = new String();
        }
        return temp;
    }

    public synchronized void setMessage(int channelID, String messagesFromWorkers) {
        this.messages[channelID] = messagesFromWorkers;
        this.messagesWorker[channelID] = messagesFromWorkers;
    }

    public synchronized void addMessage(int channelID, String messagesFromWorkers) {
        if (!this.messages[channelID].isEmpty()) {
            int n = channelID;
            this.messages[n] = this.messages[n] + "\n";
        }
        int n = channelID;
        this.messages[n] = this.messages[n] + messagesFromWorkers;
        this.messagesWorker[channelID] = messagesFromWorkers;
    }

    public synchronized String getMessageWorker(int channelID) {
        if (this.messagesWorker[channelID].isEmpty()) {
            return this.messagesWorker[channelID];
        }
        return this.messagesWorker[channelID] + "\n";
    }

    public synchronized String getMessagesWorker() {
        String temp = new String();
        for (String message : this.messagesWorker) {
            if (message.isEmpty()) continue;
            temp = temp + message + "\n";
        }
        return temp;
    }

    public String getStatus() {
        return this.status;
    }

    public int getMaxJobsWaiting() {
        return this.maxJobsWaiting;
    }

    public void setMaxJobsWaiting(int maxJobsWaiting) {
        this.maxJobsWaiting = maxJobsWaiting;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }
}

