/*
 * Decompiled with CFR 0.152.
 */
package signature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import signature.CanonicalLabellingVisitor;
import signature.ColoredTree;
import signature.DAG;
import signature.DAGVisitor;
import signature.InvariantInt;
import signature.Invariants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVertexSignature {
    public static final char START_BRANCH_SYMBOL = '(';
    public static final char END_BRANCH_SYMBOL = ')';
    public static final char START_NODE_SYMBOL = '[';
    public static final char END_NODE_SYMBOL = ']';
    private DAG dag;
    private int height;
    private int vertexCount = 0;
    private Map<Integer, Integer> vertexMapping;
    private InvariantType invariantType;
    public int TMP_COLORING_COUNT;

    public AbstractVertexSignature() {
        this(InvariantType.STRING);
    }

    public AbstractVertexSignature(InvariantType invariantType) {
        this.invariantType = invariantType;
    }

    public int getHeight() {
        return this.height;
    }

    public int getOriginalVertexIndex(int vertexIndex) {
        for (int originalVertexIndex : this.vertexMapping.keySet()) {
            int internalVertexIndex = this.vertexMapping.get(originalVertexIndex);
            if (internalVertexIndex != vertexIndex) continue;
            return originalVertexIndex;
        }
        return -1;
    }

    public void createMaximumHeight(int rootVertexIndex, int graphVertexCount) {
        this.create(rootVertexIndex, graphVertexCount, -1);
    }

    public void create(int rootVertexIndex, int graphVertexCount, int height) {
        this.height = height;
        this.vertexMapping = new HashMap<Integer, Integer>();
        this.vertexMapping.put(rootVertexIndex, 0);
        this.dag = new DAG(0, graphVertexCount);
        this.vertexCount = 1;
        this.build(1, this.dag.getRootLayer(), new ArrayList<DAG.Arc>(), height);
        if (this.invariantType == InvariantType.STRING) {
            this.createWithStringLabels();
        } else if (this.invariantType == InvariantType.INTEGER) {
            this.createWithIntLabels();
        } else {
            System.err.println("unknown invariant type " + (Object)((Object)this.invariantType));
        }
    }

    private void createWithIntLabels() {
        int[] vertexLabels = new int[this.vertexCount];
        for (int externalIndex : this.vertexMapping.keySet()) {
            int internalIndex = this.vertexMapping.get(externalIndex);
            vertexLabels[internalIndex] = this.getIntLabel(externalIndex);
        }
        this.dag.initializeWithIntLabels(vertexLabels);
    }

    private void createWithStringLabels() {
        String[] vertexLabels = new String[this.vertexCount];
        for (int externalIndex : this.vertexMapping.keySet()) {
            int internalIndex = this.vertexMapping.get(externalIndex);
            vertexLabels[internalIndex] = this.getVertexSymbol(externalIndex);
        }
        this.dag.initializeWithStringLabels(vertexLabels);
    }

    private void build(int layer, List<DAG.Node> previousLayer, List<DAG.Arc> usedArcs, int height) {
        if (height == 0) {
            return;
        }
        ArrayList<DAG.Node> nextLayer = new ArrayList<DAG.Node>();
        ArrayList<DAG.Arc> layerArcs = new ArrayList<DAG.Arc>();
        for (DAG.Node node : previousLayer) {
            int mappedIndex = this.getOriginalVertexIndex(node.vertexIndex);
            int[] connected = this.getConnected(mappedIndex);
            Arrays.sort(connected);
            int[] nArray = connected;
            int n = connected.length;
            int n2 = 0;
            while (n2 < n) {
                int connectedVertex = nArray[n2];
                this.addNode(layer, node, connectedVertex, layerArcs, usedArcs, nextLayer);
                ++n2;
            }
        }
        usedArcs.addAll(layerArcs);
        if (nextLayer.isEmpty()) {
            return;
        }
        this.dag.addLayer(nextLayer);
        this.build(layer + 1, nextLayer, usedArcs, height - 1);
    }

    private void addNode(int layer, DAG.Node parentNode, int vertexIndex, List<DAG.Arc> layerArcs, List<DAG.Arc> usedArcs, List<DAG.Node> nextLayer) {
        int mappedVertexIndex;
        if (this.vertexMapping.containsKey(vertexIndex)) {
            mappedVertexIndex = this.vertexMapping.get(vertexIndex);
        } else {
            this.vertexMapping.put(vertexIndex, this.vertexCount);
            mappedVertexIndex = this.vertexCount++;
        }
        DAG dAG = this.dag;
        dAG.getClass();
        DAG.Arc arc = new DAG.Arc(dAG, parentNode.vertexIndex, mappedVertexIndex);
        if (usedArcs.contains(arc)) {
            return;
        }
        DAG.Node existingNode = null;
        for (DAG.Node otherNode : nextLayer) {
            if (otherNode.vertexIndex != mappedVertexIndex) continue;
            existingNode = otherNode;
            break;
        }
        if (existingNode == null) {
            existingNode = this.dag.makeNode(mappedVertexIndex, layer);
            nextLayer.add(existingNode);
        }
        int originalParentIndex = this.getOriginalVertexIndex(parentNode.vertexIndex);
        String edgeLabel = this.getEdgeLabel(originalParentIndex, vertexIndex);
        int edgeColor = this.convertLabelToColor(edgeLabel);
        existingNode.addEdgeColor(parentNode.vertexIndex, edgeColor);
        parentNode.addEdgeColor(mappedVertexIndex, edgeColor);
        this.dag.addRelation(existingNode, parentNode);
        layerArcs.add(arc);
    }

    private int convertLabelToColor(String label) {
        if (label.equals("-")) {
            return 1;
        }
        if (label.equals("=")) {
            return 2;
        }
        if (label.equals("#")) {
            return 3;
        }
        return 1;
    }

    public String toCanonicalString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.TMP_COLORING_COUNT = 0;
        this.canonize(0, stringBuffer);
        return stringBuffer.toString();
    }

    public void canonize(int color, StringBuffer canonicalVertexSignature) {
        if (this.getVertexCount() == 0) {
            return;
        }
        this.dag.updateVertexInvariants();
        int[] parents = this.dag.getParentsInFinalString();
        List<Integer> orbit = this.dag.createOrbit(parents);
        if (orbit.size() < 2) {
            List<InvariantInt> pairs = this.dag.getInvariantPairs(parents);
            for (InvariantInt pair2 : pairs) {
                this.dag.setColor(pair2.index, color);
                ++color;
            }
            ++this.TMP_COLORING_COUNT;
            String signature = this.toString();
            int cmp = signature.compareTo(canonicalVertexSignature.toString());
            int l = canonicalVertexSignature.length();
            if (cmp > 0) {
                canonicalVertexSignature.replace(0, l, signature);
            }
            return;
        }
        for (int o : orbit) {
            this.dag.setColor(o, color);
            Invariants invariantsCopy = this.dag.copyInvariants();
            this.canonize(color + 1, canonicalVertexSignature);
            this.dag.setInvariants(invariantsCopy);
            this.dag.setColor(o, -1);
        }
    }

    public int[] getCanonicalLabelling(int totalVertexCount) {
        this.canonize(0, new StringBuffer());
        CanonicalLabellingVisitor labeller = new CanonicalLabellingVisitor(this.getVertexCount(), this.dag.nodeComparator);
        this.dag.accept(labeller);
        int[] internalLabels = labeller.getLabelling();
        int[] externalLabels = new int[totalVertexCount];
        Arrays.fill(externalLabels, -1);
        int i = 0;
        while (i < this.getVertexCount()) {
            int externalIndex = this.getOriginalVertexIndex(i);
            externalLabels[externalIndex] = internalLabels[i];
            ++i;
        }
        return externalLabels;
    }

    public void accept(DAGVisitor visitor) {
        this.dag.accept(visitor);
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    protected abstract int getIntLabel(int var1);

    protected abstract String getVertexSymbol(int var1);

    protected abstract int[] getConnected(int var1);

    protected abstract String getEdgeLabel(int var1, int var2);

    private void print(StringBuffer buffer, DAG.Node node, DAG.Node parent, List<DAG.Arc> arcs) {
        int vertexIndex = this.getOriginalVertexIndex(node.vertexIndex);
        if (parent != null) {
            int parentVertexIndex = this.getOriginalVertexIndex(parent.vertexIndex);
            buffer.append(this.getEdgeLabel(vertexIndex, parentVertexIndex));
        }
        buffer.append('[');
        buffer.append(this.getVertexSymbol(vertexIndex));
        int color = this.dag.colorFor(node.vertexIndex);
        if (color != -1) {
            buffer.append(',').append(color);
        }
        buffer.append(']');
        Collections.sort(node.children, this.dag.nodeComparator);
        boolean addedBranchSymbol = false;
        for (DAG.Node child : node.children) {
            DAG dAG = this.dag;
            dAG.getClass();
            DAG.Arc arc = new DAG.Arc(dAG, node.vertexIndex, child.vertexIndex);
            if (arcs.contains(arc)) continue;
            if (!addedBranchSymbol) {
                buffer.append('(');
                addedBranchSymbol = true;
            }
            arcs.add(arc);
            this.print(buffer, child, node, arcs);
        }
        if (addedBranchSymbol) {
            buffer.append(')');
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.print(buffer, this.dag.getRoot(), null, new ArrayList<DAG.Arc>());
        return buffer.toString();
    }

    public static ColoredTree parse(String s) {
        ColoredTree tree = null;
        ColoredTree.Node parent = null;
        ColoredTree.Node current = null;
        int currentHeight = 1;
        int color = -1;
        int j = 0;
        int k = 0;
        int l = 0;
        String edgeSymbol = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '(') {
                parent = current;
                tree.updateHeight(++currentHeight);
                l = i;
            } else if (c == ')') {
                parent = parent.parent;
                --currentHeight;
                l = i;
            } else if (c == '[') {
                if (l < i) {
                    edgeSymbol = s.substring(l + 1, i);
                    l = i;
                }
                j = i + 1;
            } else if (c == ']') {
                String ss;
                if (k < j) {
                    ss = s.substring(j, i);
                    color = -1;
                } else {
                    ss = s.substring(j, k - 1);
                    color = Integer.parseInt(s.substring(k, i));
                }
                if (tree == null) {
                    tree = new ColoredTree(ss);
                    parent = tree.getRoot();
                    current = tree.getRoot();
                } else {
                    current = edgeSymbol == null ? tree.makeNode(ss, parent, currentHeight, color) : tree.makeNode(ss, parent, currentHeight, color, edgeSymbol);
                }
                edgeSymbol = null;
                l = i;
            } else if (c == ',') {
                k = i + 1;
            }
            ++i;
        }
        return tree;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InvariantType {
        STRING,
        INTEGER;

    }
}

