/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.data;

import ambit2.base.data.Profile;
import ambit2.base.data.Property;
import ambit2.base.exceptions.AmbitIOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Template
extends Profile<Property> {
    private static final long serialVersionUID = -9152728910421949089L;
    protected int id;

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public Template() {
        this("DEFAULT");
    }

    public Template(String string) {
        this.setName(string);
    }

    public void addFields(String string, String string2, boolean bl, boolean bl2) {
        if (bl) {
            this.add(string, string2, Number.class);
        } else {
            this.add(string, string2, String.class);
        }
    }

    public void add(String string, String string2, Class clazz) {
        Property property = Property.getInstance(string, this.getName());
        property.setLabel(string);
        property.setOrder(1);
        property.setClazz(clazz);
        property.setUnits(string2);
        this.add(property);
    }

    public boolean save(OutputStream outputStream) throws AmbitIOException {
        try {
            this.save(new OutputStreamWriter(outputStream, "UTF-8"));
            return true;
        }
        catch (Exception exception) {
            throw new AmbitIOException(exception);
        }
    }

    public boolean save(Writer writer) throws AmbitIOException {
        try {
            DOMSource dOMSource = new DOMSource(this.buildDocument());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "Yes");
            transformer.setOutputProperty("standalone", "Yes");
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(dOMSource, streamResult);
            writer.flush();
            return true;
        }
        catch (Exception exception) {
            throw new AmbitIOException(exception);
        }
    }

    protected Document buildDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("template");
            element.setAttribute("name", this.getName());
            for (Property property : this.values()) {
                Element element2 = document.createElement("field");
                element2.setAttribute("name", property.getName());
                element2.setAttribute("units", property.getUnits());
                element2.setAttribute("class", property.getClazz().getName());
                element.appendChild(element2);
            }
            document.appendChild(element);
            return document;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean load(InputStream inputStream) throws AmbitIOException {
        try {
            return this.load(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (Exception exception) {
            throw new AmbitIOException(exception);
        }
    }

    public boolean load(Reader reader) throws AmbitIOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            Element element = document.getDocumentElement();
            if ("template".equals(element.getNodeName())) {
                this.setName(element.getAttribute("name"));
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2;
                    String string;
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !"field".equals(string = (element2 = (Element)node).getNodeName())) continue;
                    Property property = Property.getInstance(element2.getAttribute("name").toString(), this.getName());
                    property.setUnits(element2.getAttribute("units").toString());
                    String string2 = element2.getAttribute("class").toString();
                    try {
                        property.setClazz(Class.forName(string2));
                    }
                    catch (Exception exception) {
                        property.setClazz(String.class);
                    }
                    this.add(property);
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new AmbitIOException(exception);
        }
    }

    public String toString() {
        return this.getName();
    }
}

