/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.data;

import ambit2.base.data.ILiteratureEntry;
import ambit2.base.data.LiteratureEntry;
import ambit2.base.data.PropertyAnnotations;
import ambit2.base.exceptions.AmbitIOException;
import com.jgoodies.binding.beans.Model;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class Property
extends Model
implements Serializable,
Comparable<Property> {
    private static final long serialVersionUID = -6813235410505542235L;
    private static String defaultReference = "Default property reference";
    public static String AMBIT_DESCRIPTORS_ONTOLOGY = "http://ambit.sourceforge.net/descriptors.owl#%s";
    public static final String Names = "Names";
    public static final String CAS = "CasRN";
    public static final String opentox_REACHDATE = "http://www.opentox.org/api/1.1#REACHRegistrationDate";
    public static final String opentox_CAS = "http://www.opentox.org/api/1.1#CASRN";
    public static final String opentox_Name = "http://www.opentox.org/api/1.1#ChemicalName";
    public static final String opentox_TradeName = "http://www.opentox.org/api/1.1#TradeName";
    public static final String opentox_IupacName = "http://www.opentox.org/api/1.1#IUPACName";
    public static final String opentox_EC = "http://www.opentox.org/api/1.1#EINECS";
    public static final String opentox_InChI_std = "http://www.opentox.org/api/1.1#InChI_std";
    public static final String opentox_InChIAuxInfo_std = "http://www.opentox.org/api/1.1#InChI_AuxInfo_std";
    public static final String opentox_InChIKey_std = "http://www.opentox.org/api/1.1#InChIKey_std";
    public static final String opentox_InChI = "http://www.opentox.org/api/1.1#InChI";
    public static final String opentox_InChIAuxInfo = "http://www.opentox.org/api/1.1#InChI_AuxInfo";
    public static final String opentox_InChIKey = "http://www.opentox.org/api/1.1#InChIKey";
    public static final String opentox_SMILES = "http://www.opentox.org/api/1.1#SMILES";
    public static final String opentox_TupleFeature = "http://www.opentox.org/api/1.1#TupleFeature";
    public static final String opentox_ConfidenceFeature = "http://www.opentox.org/api/1.1#ConfidenceFeature";
    public static final String EC = "EC";
    protected PropertyAnnotations annotations = null;
    protected boolean isNominal = false;
    protected String name = "NA";
    protected String label = "NA";
    protected String units = "";
    protected int id = -1;
    protected int order = 0;
    protected Class clazz = String.class;
    protected boolean enabled = false;
    protected ILiteratureEntry reference = LiteratureEntry.getInstance();
    protected List<Comparable> allowedValues;

    public void setName(String string) {
        this.name = string == null ? null : (string.length() >= 256 ? string.substring(0, 255) : string);
    }

    public PropertyAnnotations getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(PropertyAnnotations propertyAnnotations) {
        this.annotations = propertyAnnotations;
    }

    public boolean isNominal() {
        return this.isNominal;
    }

    public void setNominal(boolean bl) {
        this.isNominal = bl;
    }

    public static synchronized Property getNameInstance() {
        return Property.getInstance(Names, LiteratureEntry.getIUPACReference());
    }

    public static synchronized Property getCASInstance() {
        Property property = Property.getInstance(CAS, LiteratureEntry.getCASReference());
        property.setLabel(opentox_CAS);
        return property;
    }

    public static synchronized Property getEINECSInstance() {
        Property property = Property.getInstance(EC, LiteratureEntry.getEINECSReference());
        property.setLabel(opentox_EC);
        return property;
    }

    public static synchronized Property getInstance(String string, String string2) {
        return Property.getInstance(string, string2, "");
    }

    public static synchronized Property getInChIInstance() {
        return Property.getInstance(opentox_InChI, new LiteratureEntry(opentox_InChI, "http://www.iupac.org/inchi/"));
    }

    public static synchronized Property getInChIStdInstance() {
        return Property.getInstance(opentox_InChI_std, new LiteratureEntry(opentox_InChI_std, "http://www.iupac.org/inchi/"));
    }

    public static synchronized Property getInstance(String string, ILiteratureEntry iLiteratureEntry) {
        if (iLiteratureEntry == null) {
            return Property.getInstance(string, defaultReference, "http://ambit.sourceforge.net");
        }
        return Property.getInstance(string, iLiteratureEntry.getTitle(), iLiteratureEntry.getURL());
    }

    public static synchronized Property getInstance(String string, String string2, String string3) {
        Property property = new Property(string, LiteratureEntry.getInstance(string2, string3));
        property.setLabel(string);
        property.setEnabled(true);
        return property;
    }

    public List<Comparable> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List<Comparable> list) {
        this.allowedValues = list;
    }

    public int getId() {
        return this.id;
    }

    public void addAllowedValue(Comparable comparable) {
        if (this.allowedValues == null) {
            this.allowedValues = new ArrayList<Comparable>();
        } else if (this.allowedValues.contains(comparable)) {
            return;
        }
        this.allowedValues.add(comparable);
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public ILiteratureEntry getReference() {
        return this.reference;
    }

    public void setReference(ILiteratureEntry iLiteratureEntry) {
        this.reference = iLiteratureEntry;
    }

    private Property() {
    }

    public static String guessLabel(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.toLowerCase()).startsWith("cas")) {
            return opentox_CAS;
        }
        if (string.contains("testsubstance_casrn")) {
            return opentox_CAS;
        }
        if (string.contains("species")) {
            return "Species";
        }
        if (string.contains("iupac")) {
            return opentox_IupacName;
        }
        if (string.contains("name")) {
            return opentox_Name;
        }
        if (string.contains("title")) {
            return opentox_Name;
        }
        if (string.contains("inchikey")) {
            return opentox_InChIKey;
        }
        if (string.contains("inchi")) {
            return opentox_InChI;
        }
        if (string.contains("smiles")) {
            return opentox_SMILES;
        }
        if (string.equals("ec-number")) {
            return opentox_EC;
        }
        if (string.equals("ec_number")) {
            return opentox_EC;
        }
        if (string.equals("ec")) {
            return opentox_EC;
        }
        if (string.equals("einecs")) {
            return opentox_EC;
        }
        if (string.equals("einecs")) {
            return opentox_EC;
        }
        if (string.equals("substance number")) {
            return opentox_EC;
        }
        if (string.contains("synonym")) {
            return opentox_Name;
        }
        return null;
    }

    public Property(String string) {
        this(string, Property.guessLabel(string));
    }

    public Property(String string, LiteratureEntry literatureEntry) {
        this(string, "", literatureEntry);
    }

    public Property(String string, String string2, LiteratureEntry literatureEntry) {
        this(string, Property.guessLabel(string));
        this.setUnits(string2);
        this.reference = literatureEntry;
    }

    private Property(String string, String string2) {
        this(string, string2, 0);
    }

    public Property(String string, String string2, String string3) {
        this(string, string2);
        this.setUnits(string3);
    }

    private Property(String string, String string2, int n) {
        this(string, string2, n, String.class);
    }

    private Property(String string, String string2, int n, Class clazz) {
        this(string, string2, n, clazz, false);
    }

    private Property(String string, String string2, int n, Class clazz, boolean bl) {
        this.setName(string);
        this.setLabel(string2);
        this.setOrder(n);
        this.setClazz(clazz);
        this.setEnabled(bl);
    }

    public int hashCode() {
        try {
            int n = 7;
            int n2 = null == this.getName() ? 0 : this.getName().hashCode();
            n = 31 * n + n2;
            n2 = this.getReference() == null ? 0 : (null == this.getReference().getTitle() ? 0 : this.getReference().getTitle().hashCode());
            n = 31 * n + n2;
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.getReference().getTitle();
    }

    public String getUrl() {
        return this.getReference().getURL();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String toString() {
        return this.getName();
    }

    public boolean save(OutputStream outputStream) throws AmbitIOException {
        return this.save(new OutputStreamWriter(outputStream));
    }

    public boolean save(Writer writer) throws AmbitIOException {
        try {
            writer.write("\n");
            writer.write("<field ");
            writer.write("name=\"");
            writer.write(this.getName());
            writer.write("\" units=\"");
            writer.write(this.getUnits());
            writer.write("\" class=");
            writer.write(this.getClazz().getName());
            writer.write("/>");
            return true;
        }
        catch (IOException iOException) {
            throw new AmbitIOException(this.getClass().getName(), iOException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Property) {
            if (((Property)object).getReference() == null) {
                return ((Property)object).getName().equals(this.getName());
            }
            return ((Property)object).getName().equals(this.getName()) && ((Property)object).getReference().equals(this.getReference());
        }
        return false;
    }

    @Override
    public int compareTo(Property property) {
        return this.hashCode() - property.hashCode();
    }

    public void assign(Property property) {
        this.id = property.id;
        this.setName(property.name);
        this.reference = new LiteratureEntry(property.getTitle(), property.getUrl());
        this.label = property.label;
        this.clazz = property.clazz;
        this.units = property.units;
    }

    public boolean isCAS() {
        String string = this.getLabel();
        if (this.getName().equals(string)) {
            string = Property.guessLabel(this.getName());
        }
        return opentox_CAS.equals(string);
    }

    public boolean isName() {
        String string = this.getLabel();
        if (this.getName().equals(string)) {
            string = Property.guessLabel(this.getName());
        }
        return opentox_Name.equals(string) || opentox_IupacName.equals(string);
    }

    public boolean isEINECS() {
        String string = this.getLabel();
        if (this.getName().equals(string)) {
            string = Property.guessLabel(this.getName());
        }
        return opentox_EC.equals(string);
    }

    public static enum IO_QUESTION {
        IO_START,
        IO_TRANSLATE_NAME,
        IO_STOP;

    }
}

