/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CMLResolver
implements EntityResolver {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CMLResolver.class);

    public InputSource getExternalSubset(String name, String baseURI) {
        return null;
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
        return this.resolveEntity(publicId, systemId);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        logger.debug("CMLResolver: resolving ", publicId, ", ", systemId);
        systemId = systemId.toLowerCase();
        if (systemId.indexOf("cml-1999-05-15.dtd") != -1 || systemId.indexOf("cml.dtd") != -1 || systemId.indexOf("cml1_0.dtd") != -1) {
            logger.info("File has CML 1.0 DTD");
            return this.getCMLType("cml1_0.dtd");
        }
        if (systemId.indexOf("cml-2001-04-06.dtd") != -1 || systemId.indexOf("cml1_0_1.dtd") != -1 || systemId.indexOf("cml_1_0_1.dtd") != -1) {
            logger.info("File has CML 1.0.1 DTD");
            return this.getCMLType("cml1_0_1.dtd");
        }
        logger.warn("Could not resolve systemID: ", systemId);
        return null;
    }

    private InputSource getCMLType(String type) {
        try {
            InputStream ins = this.getClass().getClassLoader().getResourceAsStream("org/openscience/cdk/io/cml/data/" + type);
            return new InputSource(new BufferedReader(new InputStreamReader(ins)));
        }
        catch (Exception e) {
            logger.error("Error while trying to read CML DTD (" + type + "): ", e.getMessage());
            logger.debug(e);
            return null;
        }
    }
}

