/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.base.processors.CASProcessor;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.core.data.MoleculeTools;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.inchi.InChIToStructure;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class MoleculeReader
extends DefaultAmbitProcessor<IStructureRecord, IAtomContainer> {
    protected InChIGeneratorFactory inchiFactory = null;
    protected CASProcessor casTransformer = null;
    private static final long serialVersionUID = 1811923574213153916L;

    public IAtomContainer process(IStructureRecord iStructureRecord) throws AmbitException {
        if (iStructureRecord.getContent() == null) {
            return null;
        }
        if (iStructureRecord.getFormat() == null) {
            throw new AmbitException("Unknown format " + iStructureRecord.getFormat());
        }
        IStructureRecord.MOL_TYPE mOL_TYPE = IStructureRecord.MOL_TYPE.SDF;
        try {
            mOL_TYPE = IStructureRecord.MOL_TYPE.valueOf((String)iStructureRecord.getFormat());
        }
        catch (Exception exception) {
            throw new AmbitException((Throwable)exception);
        }
        switch (mOL_TYPE) {
            case SDF: {
                try {
                    IMolecule iMolecule = MoleculeTools.readMolfile(iStructureRecord.getContent());
                    if (iMolecule != null && iMolecule.getProperties() != null) {
                        Object object = iMolecule.getProperty((Object)"cdk:Title");
                        if (object != null) {
                            if (CASProcessor.isValidFormat((String)object.toString())) {
                                try {
                                    if (this.casTransformer == null) {
                                        this.casTransformer = new CASProcessor();
                                    }
                                    iMolecule.setProperty((Object)"CasRN", (Object)this.casTransformer.process(object.toString()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            iMolecule.removeProperty((Object)"cdk:Title");
                        }
                        iMolecule.removeProperty((Object)"cdk:Remark");
                    }
                    return iMolecule;
                }
                catch (Exception exception) {
                    throw new AmbitException((Throwable)exception);
                }
            }
            case CML: {
                try {
                    IMolecule iMolecule = MoleculeTools.readCMLMolecule(iStructureRecord.getContent());
                    if (iMolecule != null && iMolecule.getProperties() != null) {
                        Object object = iMolecule.getProperty((Object)"cdk:Title");
                        if (object != null) {
                            if (CASProcessor.isValidFormat((String)object.toString())) {
                                try {
                                    if (this.casTransformer == null) {
                                        this.casTransformer = new CASProcessor();
                                    }
                                    iMolecule.setProperty((Object)"CasRN", (Object)this.casTransformer.process(object.toString()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            iMolecule.removeProperty((Object)"cdk:Title");
                        }
                        iMolecule.removeProperty((Object)"cdk:Remark");
                    }
                    return iMolecule;
                }
                catch (Exception exception) {
                    throw new AmbitException((Throwable)exception);
                }
            }
            case INC: {
                try {
                    if (this.inchiFactory == null) {
                        this.inchiFactory = InChIGeneratorFactory.getInstance();
                    }
                    InChIToStructure inChIToStructure = this.inchiFactory.getInChIToStructure(iStructureRecord.getContent(), SilentChemObjectBuilder.getInstance());
                    return inChIToStructure.getAtomContainer();
                }
                catch (Exception exception) {
                    throw new AmbitException((Throwable)exception);
                }
            }
        }
        throw new AmbitException("Unknown format " + iStructureRecord.getFormat());
    }
}

