/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import libpadeldescriptor.IteratingPaDELReader;
import libpadeldescriptor.PaDELLogFile;
import libpadeldescriptor.PaDELResultsFile;
import libpadeldescriptor.libPaDELDescriptorJob;
import libpadeldescriptor.libPaDELDescriptorType;
import libpadeldescriptor.libPaDELDescriptorWorker;
import libpadeljobs.Master;
import org.openscience.cdk.interfaces.IAtomContainer;

public class libPaDELDescriptorMaster
extends Master<libPaDELDescriptorJob, libPaDELDescriptorWorker> {
    private String moleculeDirFile;
    private String resultsFile;
    private boolean compute2D = false;
    private boolean compute3D = false;
    private boolean computeFingerprints = false;
    private boolean removeSalt = true;
    private boolean detectAromaticity = true;
    private boolean standardizeTautomers = true;
    private boolean standardizeNitro = true;
    private boolean retain3D = false;
    private boolean convertTo3D = false;
    private int maxMolPerFile = -1;
    private String forcefield = "mm2";
    private String[] tautomerList;
    private boolean logResults = false;
    private boolean retainOrder = true;
    private boolean useFilenameAsMolName = false;
    private long maxRunTime = -1L;
    private int progress;
    private int curMolFileIndex = -1;
    private int molProcessed = 0;
    private int curResultsFileCount = 1;
    private PaDELResultsFile results = new PaDELResultsFile();
    private String curResultsFile;
    private String curLogFile;
    private PaDELLogFile log;
    private long startTime;
    private long endTime;
    private File[] fMolecules;
    private int maxMolecules = -1;
    private List<String> descriptorNames;
    private Set<String> descriptorTypes;
    private String resultsFileName;
    private String resultsFileExt;
    private libPaDELDescriptorJob[] completedJobs;
    private int savedMoleculesIndex;
    private IteratingPaDELReader reader;
    private int PaDELReaderCount;
    private String molName;
    private IAtomContainer molStructure;

    public libPaDELDescriptorMaster(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        this.moleculeDirFile = string;
        this.resultsFile = string2;
        this.compute2D = bl;
        this.compute3D = bl2;
        this.computeFingerprints = bl3;
        this.removeSalt = bl4;
        this.detectAromaticity = bl5;
        this.standardizeTautomers = bl6;
        this.standardizeNitro = bl7;
        this.retain3D = bl8;
        this.convertTo3D = bl9;
        this.descriptorNames = new ArrayList<String>();
        this.log = new PaDELLogFile();
        this.results = new PaDELResultsFile();
    }

    public void SetDescriptorTypes(String string) throws Exception {
        this.descriptorTypes = libPaDELDescriptorType.GetActiveDescriptorTypes(string, this.compute2D, this.compute3D, this.computeFingerprints);
        libPaDELDescriptorType.SetDescriptorTypes(this.descriptorTypes, this.descriptorNames, null, null, null);
    }

    public void SetDescriptorTypes(InputStream inputStream) throws Exception {
        this.descriptorTypes = libPaDELDescriptorType.GetActiveDescriptorTypes(inputStream, this.compute2D, this.compute3D, this.computeFingerprints);
        libPaDELDescriptorType.SetDescriptorTypes(this.descriptorTypes, this.descriptorNames, null, null, null);
    }

    public void SetDescriptorTypes(Set<String> set) {
        this.descriptorTypes = set;
        libPaDELDescriptorType.SetDescriptorTypes(set, this.descriptorNames, null, null, null);
    }

    public void setTautomerList(String[] stringArray) {
        this.tautomerList = stringArray;
    }

    public void setForcefield(String string) {
        this.forcefield = string;
    }

    public void setMaxMolPerFile(int n) {
        this.maxMolPerFile = n;
    }

    public void setLogResults(boolean bl) {
        this.logResults = bl;
    }

    public void setRetainOrder(boolean bl) {
        this.retainOrder = bl;
    }

    public void setUseFilenameAsMolName(boolean bl) {
        this.useFilenameAsMolName = bl;
    }

    public void setMaxRunTime(long l) {
        this.maxRunTime = l;
    }

    public String CheckRequirements() {
        String string = new String();
        if (this.moleculeDirFile == null || this.moleculeDirFile.isEmpty()) {
            string = string + "Please set directory containing structural files or a structural file.\n";
        }
        if (this.resultsFile == null || this.resultsFile.isEmpty()) {
            string = string + "Please set file to save calculated descriptors.\n";
        }
        if (this.compute3D && (this.detectAromaticity || this.standardizeTautomers) && !this.retain3D && !this.convertTo3D) {
            string = string + "Standardization of molecules will remove 3D information.\n[3D descriptors cannot be calculated unless\n  - 3D information is retained (may not standardize properly) or\n  - convert molecule to 3D option is checked.]\n";
        }
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    public String Initialize() {
        String string;
        super.Initialize();
        this.startTime = System.nanoTime();
        this.GetMaxMolecules();
        this.curResultsFileCount = 1;
        this.curResultsFile = this.resultsFile;
        this.curLogFile = this.curResultsFile + ".log";
        if (this.maxMolPerFile > 0 && this.maxMolecules > this.maxMolPerFile) {
            int n = this.resultsFile.lastIndexOf(".");
            if (n == -1) {
                this.resultsFileName = this.resultsFile;
                this.resultsFileExt = "";
            } else {
                this.resultsFileName = this.resultsFile.substring(0, n);
                this.resultsFileExt = this.resultsFile.substring(n);
            }
            this.curResultsFile = this.resultsFileName + "_" + this.curResultsFileCount + this.resultsFileExt;
            this.curLogFile = this.resultsFile + "_" + this.curResultsFileCount + ".log";
        }
        if ((string = this.log.Open(this.curLogFile, this.logResults)) != null) {
            return string;
        }
        string = this.results.Open(this.curResultsFile);
        if (string != null) {
            return string;
        }
        this.results.Write("Name");
        for (String string2 : this.descriptorNames) {
            this.results.Write(",");
            this.results.Write(string2);
        }
        this.results.Write("\n");
        File file = new File(this.moleculeDirFile);
        if (file.isDirectory()) {
            this.fMolecules = file.listFiles();
        } else {
            this.fMolecules = new File[1];
            this.fMolecules[0] = file;
        }
        this.curMolFileIndex = -1;
        this.progress = 0;
        this.molProcessed = 0;
        this.savedMoleculesIndex = 0;
        this.completedJobs = new libPaDELDescriptorJob[this.GetMaxMolecules()];
        for (int i = 0; i < this.maxThreads; ++i) {
            libPaDELDescriptorWorker libPaDELDescriptorWorker2 = new libPaDELDescriptorWorker(this, i, (LinkedBlockingQueue<libPaDELDescriptorJob>)this.jobsWaiting, (LinkedBlockingQueue<libPaDELDescriptorJob>)this.jobsRunning, (LinkedBlockingQueue<libPaDELDescriptorJob>)this.jobsCompleted, this.descriptorTypes);
            libPaDELDescriptorWorker2.start();
            this.workers.add(libPaDELDescriptorWorker2);
        }
        return null;
    }

    private boolean hasNextJob() {
        if (this.reader == null || !this.PaDELReaderHasNext()) {
            ++this.curMolFileIndex;
            if (this.curMolFileIndex < this.fMolecules.length) {
                File file = this.fMolecules[this.curMolFileIndex];
                if (file.getName().equals(".") || file.getName().equals("..") || file.isDirectory()) {
                    return this.hasNextJob();
                }
                try {
                    this.reader = new IteratingPaDELReader(file);
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.SEVERE, file.getName(), exception);
                    this.reader = null;
                    return this.hasNextJob();
                }
                this.PaDELReaderCount = 0;
                if (!this.PaDELReaderHasNext()) {
                    return this.hasNextJob();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean PaDELReaderHasNext() {
        if (this.reader.hasNext()) {
            ++this.PaDELReaderCount;
            ++this.progress;
            this.molStructure = (IAtomContainer)this.reader.next();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.setLength(0);
            if (this.useFilenameAsMolName) {
                int n = this.fMolecules[this.curMolFileIndex].getName().lastIndexOf(".");
                if (n != -1) {
                    stringBuffer.append(this.fMolecules[this.curMolFileIndex].getName().substring(0, n));
                } else {
                    stringBuffer.append(this.fMolecules[this.curMolFileIndex].getName());
                }
                if (this.PaDELReaderCount > 1 || this.reader.hasNext()) {
                    stringBuffer.append("_" + this.PaDELReaderCount);
                }
            } else if (this.molStructure.getProperty("cdk:Title") != null && !((String)this.molStructure.getProperty("cdk:Title")).trim().isEmpty()) {
                stringBuffer.append(this.molStructure.getProperty("cdk:Title"));
            } else {
                int n = this.fMolecules[this.curMolFileIndex].getName().lastIndexOf(".");
                if (n != -1) {
                    stringBuffer.append("AUTOGEN_" + this.fMolecules[this.curMolFileIndex].getName().substring(0, n));
                } else {
                    stringBuffer.append("AUTOGEN_" + this.fMolecules[this.curMolFileIndex].getName());
                }
                if (this.PaDELReaderCount > 1 || this.reader.hasNext()) {
                    stringBuffer.append("_" + this.PaDELReaderCount);
                }
            }
            this.molName = stringBuffer.toString();
            return true;
        }
        try {
            this.reader.close();
            this.reader = null;
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.FINE, "Cannot close IteratingPaDELReader", iOException);
        }
        return false;
    }

    private libPaDELDescriptorJob nextJob() {
        libPaDELDescriptorJob libPaDELDescriptorJob2 = new libPaDELDescriptorJob(this.progress, this.fMolecules[this.curMolFileIndex].getName(), this.molName, this.molStructure, this.removeSalt, this.detectAromaticity, this.standardizeTautomers, this.tautomerList, this.standardizeNitro, this.retain3D, this.convertTo3D, this.forcefield, this.maxRunTime);
        return libPaDELDescriptorJob2;
    }

    public void AddJobsToQueue() {
        int n = this.maxJobsWaiting - this.jobsWaiting.size();
        libPaDELDescriptorJob libPaDELDescriptorJob2 = new libPaDELDescriptorJob(NO_MORE_JOBS);
        for (int i = 0; i < n; ++i) {
            try {
                if (this.hasNextJob()) {
                    libPaDELDescriptorJob2 = this.nextJob();
                    this.jobsWaiting.put(libPaDELDescriptorJob2);
                    continue;
                }
                for (int j = 0; j < this.workers.size() * 2; ++j) {
                    this.jobsWaiting.offer(new libPaDELDescriptorJob(NO_MORE_JOBS));
                }
                break;
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger("global").log(Level.SEVERE, Integer.toString(libPaDELDescriptorJob2.getId()), interruptedException);
            }
        }
    }

    public void ProcessRunningJobs() {
        this.status = this.clearMessages();
        if (!this.status.isEmpty()) {
            this.log.Write(this.status);
        }
    }

    public void ProcessCompletedJobs() {
        libPaDELDescriptorJob libPaDELDescriptorJob2;
        while ((libPaDELDescriptorJob2 = (libPaDELDescriptorJob)((Object)this.jobsCompleted.poll())) != null) {
            ++this.molProcessed;
            this.StoreAndSaveDescriptors(libPaDELDescriptorJob2);
            if (this.jobsWaiting.size() >= this.maxJobsWaiting / 10 || this.reader == null) continue;
            return;
        }
        boolean bl = true;
        for (libPaDELDescriptorWorker libPaDELDescriptorWorker2 : this.workers) {
            if (!libPaDELDescriptorWorker2.isAlive()) continue;
            bl = false;
        }
        if (this.molProcessed == this.maxMolecules) {
            if (this.retainOrder && this.savedMoleculesIndex < this.maxMolecules) {
                while (this.completedJobs[this.savedMoleculesIndex] != null) {
                    this.SaveDescriptors(this.completedJobs[this.savedMoleculesIndex]);
                    this.completedJobs[this.savedMoleculesIndex] = null;
                    ++this.savedMoleculesIndex;
                }
            }
            this.endTime = System.nanoTime();
            long l = this.endTime - this.startTime;
            String string = this.TimeTaken(this.startTime, this.endTime);
            double d = (double)l / 1.0E9 / (double)this.molProcessed;
            this.status = "Descriptor calculation completed in " + string + ". Average speed: " + new DecimalFormat("#0.00").format(d) + " s/mol.";
            this.log.Write(this.status + "\n");
            this.log.Close();
            this.results.Close();
            this.hasWork = false;
            this.StopAllWorkers();
        } else if (bl) {
            this.endTime = System.nanoTime();
            this.status = "All workers stopped for unknown reason.";
            this.log.Write(this.status + "\n");
            this.log.Close();
            this.results.Close();
            this.hasWork = false;
        } else if (this.jobsCompleted.isEmpty()) {
            try {
                libPaDELDescriptorJob2 = (libPaDELDescriptorJob)((Object)this.jobsCompleted.poll(1L, TimeUnit.SECONDS));
                if (libPaDELDescriptorJob2 != null) {
                    ++this.molProcessed;
                    this.StoreAndSaveDescriptors(libPaDELDescriptorJob2);
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger("global").log(Level.SEVERE, Integer.toString(libPaDELDescriptorJob2.getId()), interruptedException);
            }
        }
    }

    private void StoreAndSaveDescriptors(libPaDELDescriptorJob libPaDELDescriptorJob2) {
        if (this.retainOrder) {
            this.completedJobs[libPaDELDescriptorJob2.getId() - 1] = libPaDELDescriptorJob2;
            while (this.savedMoleculesIndex < this.maxMolecules && this.completedJobs[this.savedMoleculesIndex] != null) {
                this.SaveDescriptors(this.completedJobs[this.savedMoleculesIndex]);
                this.completedJobs[this.savedMoleculesIndex] = null;
                ++this.savedMoleculesIndex;
            }
        } else {
            this.SaveDescriptors(libPaDELDescriptorJob2);
        }
    }

    private void SaveDescriptors(libPaDELDescriptorJob libPaDELDescriptorJob2) {
        this.results.Write("\"" + libPaDELDescriptorJob2.getName() + "\"");
        ArrayList<String> arrayList = libPaDELDescriptorJob2.getDescriptors();
        for (String string : arrayList) {
            this.results.Write("," + string);
        }
        this.results.Write("\n");
        if (this.maxMolPerFile > 0 && this.molProcessed % this.maxMolPerFile == 0 && this.molProcessed < this.maxMolecules) {
            ++this.curResultsFileCount;
            this.curResultsFile = this.resultsFileName + "_" + this.curResultsFileCount + this.resultsFileExt;
            this.curLogFile = this.resultsFile + "_" + this.curResultsFileCount + ".log";
            this.log.Open(this.curLogFile, this.logResults);
            this.results.Open(this.curResultsFile);
            this.results.Write("Name");
            for (String string : this.descriptorNames) {
                this.results.Write(",");
                this.results.Write(string);
            }
            this.results.Write("\n");
        }
    }

    public void StopAllWorkers() {
        super.StopAllWorkers();
        if (this.workers == null || this.jobsWaiting == null) {
            return;
        }
        for (int i = 0; i < this.workers.size() * 2; ++i) {
            this.jobsWaiting.offer(new libPaDELDescriptorJob(NO_MORE_JOBS));
        }
    }

    public List<String> getDescriptorNames() {
        return this.descriptorNames;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getMolProcessed() {
        return this.molProcessed;
    }

    public int GetMaxMolecules() {
        if (this.maxMolecules == -1) {
            this.maxMolecules = 0;
            File file = new File(this.moleculeDirFile);
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    if (file2.getName().equals(".") || file2.getName().equals("..") || file2.isDirectory()) continue;
                    this.maxMolecules += this.GetMaxMoleculesInFile(file2);
                }
            } else {
                this.maxMolecules += this.GetMaxMoleculesInFile(file);
            }
        }
        return this.maxMolecules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetMaxMoleculesInFile(File file) {
        int n = 0;
        IteratingPaDELReader iteratingPaDELReader = null;
        try {
            iteratingPaDELReader = new IteratingPaDELReader(file);
            while (iteratingPaDELReader.hasNext()) {
                iteratingPaDELReader.next();
                ++n;
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.FINE, "Cannot read from IteratingPaDELReader", exception);
        }
        finally {
            if (iteratingPaDELReader != null) {
                try {
                    iteratingPaDELReader.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.FINE, "Cannot close IteratingPaDELReader", iOException);
                }
            }
        }
        return n;
    }

    private String TimeTaken(long l, long l2) {
        long l3 = l2 - l;
        int n = (int)(((double)l3 / 1.0E9 - (double)((int)((double)l3 / 1.0E9))) * 1000.0);
        int n2 = (int)((double)l3 / 1.0E9 % 60.0);
        int n3 = (int)((double)l3 / 1.0E9 / 60.0 % 60.0);
        int n4 = (int)((double)l3 / 1.0E9 / 60.0 / 60.0 % 24.0);
        int n5 = (int)((double)l3 / 1.0E9 / 60.0 / 60.0 / 24.0 % 7.0);
        int n6 = (int)((double)l3 / 1.0E9 / 60.0 / 60.0 / 24.0 / 7.0);
        StringBuffer stringBuffer = new StringBuffer();
        if (n6 > 0) {
            stringBuffer.append(n6 + " weeks ");
        }
        if (n5 > 0) {
            stringBuffer.append(n5 + " days ");
        }
        if (n4 > 0) {
            stringBuffer.append(n4 + " hours ");
        }
        if (n3 > 0) {
            stringBuffer.append(n3 + " mins ");
        }
        stringBuffer.append(n2 + "." + n + " secs ");
        return stringBuffer.toString();
    }
}

