/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;

public class PaDELSimpleTable
extends ResultObjectAdapter {
    private static final long serialVersionUID = -7401313632199345833L;
    private static final String RESULT_ICON_NAME = "table.png";
    private static Icon resultIcon = null;
    private ArrayList<ArrayList<String>> table = new ArrayList();
    private ArrayList<String> rowLabels = new ArrayList();
    private ArrayList<String> colLabels = new ArrayList();
    private String name;

    public PaDELSimpleTable(String string, String[] stringArray) {
        this(string, new String[0], stringArray);
    }

    public PaDELSimpleTable(String string, String[] stringArray, String[] stringArray2) {
        this.name = string;
        this.rowLabels.addAll(Arrays.asList(stringArray));
        this.colLabels.addAll(Arrays.asList(stringArray2));
        int n = this.rowLabels.size();
        for (int i = 0; i < n; ++i) {
            this.table.add((ArrayList)this.colLabels.clone());
        }
    }

    public void addRow(String string, String[] stringArray) {
        this.rowLabels.add(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        this.table.add(arrayList);
    }

    public void addColumn(String string, String[] stringArray) {
        this.colLabels.add(string);
        int n = this.table.size();
        for (int i = 0; i < n; ++i) {
            this.table.get(i).add(stringArray[i]);
        }
    }

    public void setValue(int n, int n2, String string) {
        this.table.get(n).set(n2, string);
    }

    public void setValue(String string, String string2, String string3) {
        int n = this.getRowIndex(string);
        if (n == -1) {
            return;
        }
        int n2 = this.getColumnIndex(string2);
        if (n2 == -1) {
            return;
        }
        this.setValue(n, n2, string3);
    }

    public String getValue(int n, int n2) {
        return this.table.get(n).get(n2);
    }

    public String getValue(String string, String string2) {
        return this.getValue(this.getRowIndex(string), this.getColumnIndex(string2));
    }

    public int getNumberOfRows() {
        return this.rowLabels.size();
    }

    public int getNumberOfColumns() {
        return this.colLabels.size();
    }

    public String getName() {
        return this.name;
    }

    public String getRowName(int n) {
        return this.rowLabels.get(n);
    }

    public int getRowIndex(String string) {
        int n = this.getNumberOfRows();
        for (int i = 0; i < n; ++i) {
            if (!this.rowLabels.get(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getColumnIndex(String string) {
        int n = this.getNumberOfColumns();
        for (int i = 0; i < n; ++i) {
            if (!this.colLabels.get(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getColumnName(int n) {
        return this.colLabels.get(n);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.name + ":" + Tools.getLineSeparator());
        int n2 = this.getNumberOfColumns();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("\t" + this.colLabels.get(n));
        }
        n = this.getNumberOfRows();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(Tools.getLineSeparator() + this.rowLabels.get(i));
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append("\t" + this.table.get(i).get(j));
            }
        }
        return stringBuffer.toString();
    }

    public String getExtension() {
        return "den";
    }

    public String getFileDescription() {
        return this.name.toLowerCase();
    }

    public Icon getResultIcon() {
        return resultIcon;
    }

    static {
        resultIcon = SwingTools.createIcon((String)"16/table.png");
    }
}

