/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.ringsearch.SSSRFinder;

public class RingCountDescriptor
implements IMolecularDescriptor {
    public static final String[] names = new String[]{"nRing", "n3Ring", "n4Ring", "n5Ring", "n6Ring", "n7Ring", "n8Ring", "n9Ring", "n10Ring", "n11Ring", "n12Ring", "nG12Ring", "nFRing", "nF4Ring", "nF5Ring", "nF6Ring", "nF7Ring", "nF8Ring", "nF9Ring", "nF10Ring", "nF11Ring", "nF12Ring", "nFG12Ring", "nTRing", "nT4Ring", "nT5Ring", "nT6Ring", "nT7Ring", "nT8Ring", "nT9Ring", "nT10Ring", "nT11Ring", "nT12Ring", "nTG12Ring", "nHeteroRing", "n3HeteroRing", "n4HeteroRing", "n5HeteroRing", "n6HeteroRing", "n7HeteroRing", "n8HeteroRing", "n9HeteroRing", "n10HeteroRing", "n11HeteroRing", "n12HeteroRing", "nG12HeteroRing", "nFHeteroRing", "nF4HeteroRing", "nF5HeteroRing", "nF6HeteroRing", "nF7HeteroRing", "nF8HeteroRing", "nF9HeteroRing", "nF10HeteroRing", "nF11HeteroRing", "nF12HeteroRing", "nFG12HeteroRing", "nTHeteroRing", "nT4HeteroRing", "nT5HeteroRing", "nT6HeteroRing", "nT7HeteroRing", "nT8HeteroRing", "nT9HeteroRing", "nT10HeteroRing", "nT11HeteroRing", "nT12HeteroRing", "nTG12HeteroRing"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("nRing", this.getClass().getName(), "$Id: RingCountDescriptor.java 1 2010-05-01 22:05:01Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        IRingSet iRingSet;
        int n2;
        int n3;
        SSSRFinder sSSRFinder = new SSSRFinder(iAtomContainer);
        IRingSet iRingSet2 = sSSRFinder.findEssentialRings();
        int[] nArray = new int[14];
        int[] nArray2 = new int[14];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = 0;
            nArray2[n3] = 0;
        }
        for (n3 = 0; n3 < iRingSet2.getAtomContainerCount(); ++n3) {
            n2 = iRingSet2.getAtomContainer(n3).getAtomCount();
            nArray[2] = nArray[2] + 1;
            boolean bl = this.isHeteroRing(iRingSet2.getAtomContainer(n3));
            if (bl) {
                nArray2[2] = nArray2[2] + 1;
            }
            if (n2 > 12) {
                nArray[13] = nArray[13] + 1;
                if (!bl) continue;
                nArray2[13] = nArray2[13] + 1;
                continue;
            }
            if (n2 < 3) continue;
            int n4 = n2;
            nArray[n4] = nArray[n4] + 1;
            if (!bl) continue;
            int n5 = n2;
            nArray2[n5] = nArray2[n5] + 1;
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (n2 = 2; n2 < 14; ++n2) {
            doubleArrayResult.add(nArray[n2]);
        }
        AllRingsFinder allRingsFinder = new AllRingsFinder();
        try {
            iRingSet = allRingsFinder.findAllRings(iAtomContainer);
        }
        catch (CDKException cDKException) {
            Logger.getLogger("global").log(Level.SEVERE, null, cDKException);
            return this.getDummyDescriptorValue(cDKException);
        }
        int[] nArray3 = new int[14];
        int[] nArray4 = new int[14];
        for (n = 0; n < nArray3.length; ++n) {
            nArray3[n] = 0;
            nArray4[n] = 0;
        }
        for (n = 0; n < iRingSet.getAtomContainerCount(); ++n) {
            int n6 = iRingSet.getAtomContainer(n).getAtomCount();
            nArray3[3] = nArray3[3] + 1;
            boolean bl = this.isHeteroRing(iRingSet.getAtomContainer(n));
            if (bl) {
                nArray4[2] = nArray4[2] + 1;
            }
            if (n6 > 12) {
                nArray3[13] = nArray3[13] + 1;
                if (!bl) continue;
                nArray4[13] = nArray4[13] + 1;
                continue;
            }
            if (n6 < 4) continue;
            int n7 = n6;
            nArray3[n7] = nArray3[n7] + 1;
            if (!bl) continue;
            int n8 = n6;
            nArray4[n8] = nArray4[n8] + 1;
        }
        if (nArray3[3] - nArray[2] > 0) {
            doubleArrayResult.add(nArray3[3] - nArray[2]);
        } else {
            doubleArrayResult.add(0.0);
        }
        for (n = 4; n < 14; ++n) {
            if (nArray3[n] - nArray[n] > 0) {
                doubleArrayResult.add(nArray3[n] - nArray[n]);
                continue;
            }
            doubleArrayResult.add(0.0);
        }
        for (n = 3; n < 14; ++n) {
            doubleArrayResult.add(nArray3[n]);
        }
        for (n = 2; n < 14; ++n) {
            doubleArrayResult.add(nArray2[n]);
        }
        if (nArray4[3] - nArray2[2] > 0) {
            doubleArrayResult.add(nArray4[3] - nArray2[2]);
        } else {
            doubleArrayResult.add(0.0);
        }
        for (n = 4; n < 14; ++n) {
            if (nArray4[n] - nArray2[n] > 0) {
                doubleArrayResult.add(nArray4[n] - nArray2[n]);
                continue;
            }
            doubleArrayResult.add(0.0);
        }
        for (n = 3; n < 14; ++n) {
            doubleArrayResult.add(nArray4[n]);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
    }

    private boolean isHeteroRing(IAtomContainer iAtomContainer) {
        for (int i = 0; i < iAtomContainer.getAtomCount(); ++i) {
            String string = iAtomContainer.getAtom(i).getSymbol();
            if (!string.equals("N") && !string.equals("O") && !string.equals("P") && !string.equals("S") && !string.equals("F") && !string.equals("Cl") && !string.equals("Br") && !string.equals("I") && !string.equals("At") && !string.equals("Uus")) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

