/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.renderer.generators.MappingGeneratorTest")
public class MappingGenerator
implements IGenerator<IReaction> {
    private IGeneratorParameter<Color> atomAtomMappingLineColor = new AtomAtomMappingLineColor();
    private IGeneratorParameter<Double> mappingLineWidth = new MappingLineWidth();
    private IGeneratorParameter<Boolean> showAtomAtomMapping = new ShowAtomAtomMapping();

    @Override
    @TestMethod(value="testEmptyReaction")
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        if (!this.showAtomAtomMapping.getValue().booleanValue()) {
            return null;
        }
        ElementGroup elementGroup = new ElementGroup();
        Color mappingColor = this.atomAtomMappingLineColor.getValue();
        for (IMapping mapping : reaction.mappings()) {
            IAtom endPointA = (IAtom)mapping.getChemObject(0);
            IAtom endPointB = (IAtom)mapping.getChemObject(1);
            Point2d pointA = endPointA.getPoint2d();
            Point2d pointB = endPointB.getPoint2d();
            elementGroup.add(new LineElement(pointA.x, pointA.y, pointB.x, pointB.y, this.getWidthForMappingLine(model), mappingColor));
        }
        return elementGroup;
    }

    private double getWidthForMappingLine(RendererModel model) {
        double scale = (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        return this.mappingLineWidth.getValue() / scale;
    }

    @Override
    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.showAtomAtomMapping, this.mappingLineWidth, this.atomAtomMappingLineColor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowAtomAtomMapping
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappingLineWidth
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 1.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomAtomMappingLineColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.gray;
        }
    }
}

