/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.reaction.mechanism.TautomerizationMechanismTest")
public class TautomerizationMechanism
implements IReactionMechanism {
    @Override
    @TestMethod(value="testInitiate_IMoleculeSet_ArrayList_ArrayList")
    public IReaction initiate(IMoleculeSet moleculeSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IMolecule reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance(moleculeSet.getBuilder());
        if (moleculeSet.getMoleculeCount() != 1) {
            throw new CDKException("TautomerizationMechanism only expects one IMolecule");
        }
        if (atomList.size() != 4) {
            throw new CDKException("TautomerizationMechanism expects four atoms in the ArrayList");
        }
        if (bondList.size() != 3) {
            throw new CDKException("TautomerizationMechanism expects three bonds in the ArrayList");
        }
        IMolecule molecule = moleculeSet.getMolecule(0);
        try {
            reactantCloned = molecule.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IMolecule!", e);
        }
        IAtom atom1 = atomList.get(0);
        IAtom atom1C = reactantCloned.getAtom(molecule.getAtomNumber(atom1));
        IAtom atom2 = atomList.get(1);
        IAtom atom2C = reactantCloned.getAtom(molecule.getAtomNumber(atom2));
        IAtom atom3 = atomList.get(2);
        IAtom atom3C = reactantCloned.getAtom(molecule.getAtomNumber(atom3));
        IAtom atom4 = atomList.get(3);
        IAtom atom4C = reactantCloned.getAtom(molecule.getAtomNumber(atom4));
        IBond bond1 = bondList.get(0);
        int posBond1 = molecule.getBondNumber(bond1);
        IBond bond2 = bondList.get(1);
        int posBond2 = molecule.getBondNumber(bond2);
        IBond bond3 = bondList.get(2);
        int posBond3 = molecule.getBondNumber(bond3);
        BondManipulator.decreaseBondOrder(reactantCloned.getBond(posBond1));
        BondManipulator.increaseBondOrder(reactantCloned.getBond(posBond2));
        reactantCloned.removeBond(reactantCloned.getBond(posBond3));
        IBond newBond = molecule.getBuilder().newInstance(IBond.class, new Object[]{atom1C, atom4C, IBond.Order.SINGLE});
        reactantCloned.addBond(newBond);
        atom1C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, atom1C);
        if (type == null) {
            return null;
        }
        atom3C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        type = atMatcher.findMatchingAtomType(reactantCloned, atom3C);
        if (type == null) {
            return null;
        }
        IReaction reaction = DefaultChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule);
        for (IAtom atom : molecule.atoms()) {
            IMapping mapping = DefaultChemObjectBuilder.getInstance().newInstance(IMapping.class, atom, reactantCloned.getAtom(molecule.getAtomNumber(atom)));
            reaction.addMapping(mapping);
        }
        reaction.addProduct(reactantCloned);
        return reaction;
    }
}

