/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.AliphaticSymbolQueryAtom;
import ambit2.smarts.AromaticSymbolQueryAtom;
import ambit2.smarts.DoubleBondAromaticityNotSpecified;
import ambit2.smarts.DoubleNonAromaticBond;
import ambit2.smarts.DoubleStereoBond;
import ambit2.smarts.RingClosure;
import ambit2.smarts.RingQueryBond;
import ambit2.smarts.SingleNonAromaticBond;
import ambit2.smarts.SingleOrAromaticBond;
import ambit2.smarts.SmartsAtomExpression;
import ambit2.smarts.SmartsBondExpression;
import ambit2.smarts.SmartsConst;
import ambit2.smarts.SmartsExpressionToken;
import ambit2.smarts.SmartsFlags;
import ambit2.smarts.SmartsParserError;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.AliphaticAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AnyAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AnyOrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.OrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSBond;
import org.openscience.cdk.ringsearch.SSSRFinder;

public class SmartsParser {
    String smarts;
    QueryAtomContainer container;
    Vector<SmartsParserError> errors = new Vector();
    Stack<IQueryAtom> brackets = new Stack();
    Vector<SMARTSBond> directionalBonds = new Vector();
    Vector<Integer> directions = new Vector();
    Vector<SMARTSBond> processedDirBonds = new Vector();
    Vector<SMARTSBond> processedDoubleBonds = new Vector();
    Vector<SMARTSBond> newStereoDoubleBonds = new Vector();
    TreeMap<Integer, RingClosure> indexes = new TreeMap();
    boolean mNeedNeighbourData;
    boolean mNeedValencyData;
    boolean mNeedRingData;
    boolean mNeedRingData2;
    boolean mNeedExplicitHData;
    boolean mNeedParentMoleculeData;
    public boolean hasRecursiveSmarts;
    public boolean mSupportMOEExtension = true;
    public boolean mUseMOEvPrimitive = false;
    public boolean mSupportOpenEyeExtension = true;
    public boolean mSupportOpenBabelExtension = true;
    public boolean mSupportSmirksSyntax = false;
    public boolean mSupportDoubleBondAromaticityNotSpecified = false;
    boolean FlagCLG = false;
    int curComponent;
    public int numFragments;
    public int maxCompNumber;
    public Vector<QueryAtomContainer> fragments = new Vector();
    public Vector<Integer> fragmentComponents = new Vector();
    QueryAtomContainer curFragment;
    int curChar;
    IQueryAtom prevAtom;
    SMARTSBond curBond;
    SmartsAtomExpression curAtExpr;
    int curBondType;
    int nChars;
    boolean insideRecSmarts;
    int curSmirksMapIndex = -1;

    public QueryAtomContainer parse(String sm) {
        this.smarts = sm;
        this.container = new QueryAtomContainer();
        this.errors.clear();
        this.nullifyDataFlags();
        this.init();
        this.parse();
        return this.container;
    }

    void init() {
        this.nChars = this.smarts.length();
        this.brackets.clear();
        this.indexes.clear();
        this.directionalBonds.clear();
        this.directions.clear();
        this.prevAtom = null;
        this.curBond = null;
        this.curBondType = 100;
        this.curChar = 0;
        this.insideRecSmarts = false;
        this.fragments.clear();
        this.fragmentComponents.clear();
        this.curComponent = 0;
        this.numFragments = 0;
        this.maxCompNumber = 0;
    }

    void parse() {
        while (this.curChar < this.nChars && this.errors.size() == 0) {
            if (Character.isLetter(this.smarts.charAt(this.curChar))) {
                this.parseAtom();
                continue;
            }
            if (Character.isDigit(this.smarts.charAt(this.curChar))) {
                this.parseAtomIndex();
                continue;
            }
            this.parseSpecialSymbol();
        }
        if (!this.brackets.empty()) {
            this.newError("There are unclosed brackets", -1, "");
        }
        if (this.indexes.size() != 0) {
            this.newError("There are unused atom indexes", -1, "");
        }
        if (this.directionalBonds.size() > 0) {
            this.setDoubleBondsStereoInfo();
        }
        this.setNeededDataFlags();
        QueryAtomContainer curContainer = this.container;
        for (int i = 0; i < curContainer.getAtomCount(); ++i) {
            if (!(curContainer.getAtom(i) instanceof SmartsAtomExpression)) continue;
            SmartsAtomExpression sa = (SmartsAtomExpression)curContainer.getAtom(i);
            for (int j = 0; j < sa.recSmartsStrings.size(); ++j) {
                this.hasRecursiveSmarts = true;
                this.smarts = sa.recSmartsStrings.get(j);
                this.container = new QueryAtomContainer();
                this.init();
                this.insideRecSmarts = true;
                this.parse();
                sa.recSmartsContainers.add(this.container);
                this.insideRecSmarts = false;
            }
            this.convertChirality(sa);
        }
        this.container = curContainer;
    }

    public void setComponentLevelGrouping(boolean flag) {
        this.FlagCLG = flag;
    }

    public boolean needNeighbourData() {
        return this.mNeedNeighbourData;
    }

    public boolean needExplicitHData() {
        return this.mNeedExplicitHData;
    }

    public boolean needValencyData() {
        return this.mNeedValencyData;
    }

    public boolean needRingData() {
        return this.mNeedRingData;
    }

    public boolean needRingData2() {
        return this.mNeedRingData2;
    }

    public boolean needParentMoleculeData() {
        return this.mNeedParentMoleculeData;
    }

    void nullifyDataFlags() {
        this.mNeedNeighbourData = false;
        this.mNeedValencyData = false;
        this.mNeedRingData = false;
        this.mNeedRingData2 = false;
        this.mNeedExplicitHData = false;
        this.mNeedParentMoleculeData = false;
        this.hasRecursiveSmarts = false;
    }

    public void setNeededDataFlags() {
        int j;
        int i;
        for (i = 0; i < this.container.getAtomCount(); ++i) {
            if (!(this.container.getAtom(i) instanceof SmartsAtomExpression)) continue;
            SmartsAtomExpression sa = (SmartsAtomExpression)this.container.getAtom(i);
            for (j = 0; j < sa.tokens.size(); ++j) {
                SmartsExpressionToken tok = sa.tokens.get(j);
                if (tok.type == 4) {
                    this.mNeedExplicitHData = true;
                }
                if (tok.type == 3 || tok.type == 9 || tok.type == 4 || tok.type == 5) {
                    this.mNeedNeighbourData = true;
                    continue;
                }
                if (tok.type == 16 || tok.type == 20 || tok.type == 21) {
                    this.mNeedParentMoleculeData = true;
                    continue;
                }
                if (tok.type == 15) {
                    this.mNeedParentMoleculeData = true;
                    this.mNeedRingData2 = true;
                    continue;
                }
                if (tok.type == 8) {
                    this.mNeedValencyData = true;
                    continue;
                }
                if (tok.type != 6 && tok.type != 7) continue;
                this.mNeedRingData = true;
            }
        }
        if (!this.mNeedRingData) {
            for (i = 0; i < this.container.getBondCount(); ++i) {
                if (this.container.getBond(i) instanceof SmartsBondExpression) {
                    SmartsBondExpression sb = (SmartsBondExpression)this.container.getBond(i);
                    for (j = 0; j < sb.tokens.size(); ++j) {
                        if (sb.tokens.get(j) != 5) continue;
                        this.mNeedRingData2 = true;
                        break;
                    }
                    if (!this.mNeedRingData2) continue;
                    break;
                }
                if (!(this.container.getBond(i) instanceof RingQueryBond)) continue;
                this.mNeedRingData2 = true;
                break;
            }
        }
    }

    void newError(String msg, int pos, String param) {
        SmartsParserError err = this.insideRecSmarts ? new SmartsParserError(this.smarts, "Inside recursive Smarts: " + msg, pos, param) : new SmartsParserError(this.smarts, msg, pos, param);
        this.errors.add(err);
    }

    public String getErrorMessages() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.errors.size(); ++i) {
            sb.append(this.errors.get(i).getError() + "\n");
        }
        return sb.toString();
    }

    void newFragment() {
        ++this.numFragments;
        this.curFragment = new QueryAtomContainer();
        this.fragments.add(this.curFragment);
        this.fragmentComponents.add(new Integer(this.curComponent));
    }

    void addAtom(IQueryAtom atom) {
        this.container.addAtom((IAtom)atom);
        if (this.prevAtom != null) {
            this.curFragment.addAtom((IAtom)atom);
            this.addBond(this.prevAtom, atom);
        } else {
            this.newFragment();
            this.curFragment.addAtom((IAtom)atom);
        }
        if (this.mSupportSmirksSyntax) {
            if (this.curSmirksMapIndex > -1) {
                atom.setProperty((Object)"SmirksMapIndex", (Object)new Integer(this.curSmirksMapIndex));
            }
            this.curSmirksMapIndex = -1;
        }
        this.prevAtom = atom;
        this.curBond = null;
        this.curBondType = 100;
    }

    void addBond(IQueryAtom atom0, IQueryAtom atom1) {
        if (this.curBond == null) {
            switch (this.curBondType) {
                case 0: {
                    this.curBond = new AnyOrderQueryBond();
                    break;
                }
                case 1: {
                    this.curBond = new SingleNonAromaticBond();
                    break;
                }
                case 2: {
                    if (this.mSupportDoubleBondAromaticityNotSpecified) {
                        this.curBond = new DoubleBondAromaticityNotSpecified();
                        break;
                    }
                    this.curBond = new DoubleNonAromaticBond();
                    break;
                }
                case 3: {
                    this.curBond = new OrderQueryBond(IBond.Order.TRIPLE);
                    break;
                }
                case 4: {
                    this.curBond = new AromaticQueryBond();
                    break;
                }
                case 5: {
                    this.curBond = new RingQueryBond();
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.curBond = new OrderQueryBond(IBond.Order.SINGLE);
                    this.directionalBonds.add(this.curBond);
                    this.directions.add(new Integer(this.curBondType));
                    break;
                }
                case 100: {
                    this.curBond = new SingleOrAromaticBond();
                }
            }
        }
        Atom[] atoms = new Atom[]{atom0, atom1};
        this.curBond.setAtoms((IAtom[])atoms);
        this.container.addBond((IBond)this.curBond);
        this.curFragment.addBond((IBond)this.curBond);
    }

    void parseAtom() {
        Object curAtom = null;
        String symb = null;
        switch (this.smarts.charAt(this.curChar)) {
            case 'a': {
                curAtom = new AromaticAtom();
                ++this.curChar;
                break;
            }
            case 'c': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 's': {
                char ch = Character.toUpperCase(this.smarts.charAt(this.curChar));
                curAtom = new AromaticSymbolQueryAtom();
                curAtom.setSymbol(Character.toString(ch));
                ++this.curChar;
                break;
            }
            case 'C': {
                symb = "C";
                ++this.curChar;
                if (this.curChar < this.nChars && this.smarts.charAt(this.curChar) == 'l') {
                    symb = "Cl";
                    ++this.curChar;
                }
                curAtom = new AliphaticSymbolQueryAtom();
                curAtom.setSymbol(symb);
                break;
            }
            case 'B': {
                symb = "B";
                ++this.curChar;
                if (this.curChar < this.nChars && this.smarts.charAt(this.curChar) == 'r') {
                    symb = "Br";
                    ++this.curChar;
                }
                curAtom = new AliphaticSymbolQueryAtom();
                curAtom.setSymbol(symb);
                break;
            }
            case 'A': {
                curAtom = new AliphaticAtom();
                ++this.curChar;
                break;
            }
            case 'F': 
            case 'I': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'S': {
                curAtom = new AliphaticSymbolQueryAtom();
                curAtom.setSymbol(Character.toString(this.smarts.charAt(this.curChar)));
                ++this.curChar;
            }
        }
        if (curAtom == null) {
            this.newError("Incorrect atomic symbol", this.curChar + 1, "");
        } else {
            this.addAtom((IQueryAtom)curAtom);
        }
    }

    void parseAtomIndex() {
        if (this.smarts.charAt(this.curChar) == '%') {
            ++this.curChar;
            if (this.curChar == this.nChars) {
                this.newError("Incorrect ring closure", this.curChar, "");
                return;
            }
            if (Character.isDigit(this.smarts.charAt(this.curChar))) {
                this.registerIndex(this.getInteger());
            } else {
                this.newError("Incorrect ring closure", this.curChar, "");
            }
        } else {
            this.registerIndex(Character.getNumericValue(this.smarts.charAt(this.curChar)));
            ++this.curChar;
        }
    }

    int getInteger() {
        char ch;
        if (!Character.isDigit(this.smarts.charAt(this.curChar))) {
            return -1;
        }
        int n = 0;
        while (this.curChar < this.nChars && Character.isDigit(ch = this.smarts.charAt(this.curChar))) {
            n = 10 * n + Character.getNumericValue(ch);
            ++this.curChar;
        }
        return n;
    }

    void registerIndex(int n) {
        Integer i = new Integer(n);
        RingClosure rc = this.indexes.get(i);
        if (rc == null) {
            RingClosure rc1 = new RingClosure();
            rc1.firstAtom = this.prevAtom;
            if (this.curBond == null) {
                rc1.firstBond = this.curBondType;
            } else {
                this.newError("Use of a bond expression for the first appearence of atom index", this.curChar + 1, "");
            }
            this.indexes.put(i, rc1);
            this.curBond = null;
            this.curBondType = 100;
        } else {
            if (rc.firstBond == 100) {
                this.addBond(rc.firstAtom, this.prevAtom);
                this.curBond = null;
                this.curBondType = 100;
            } else if (this.curBond == null) {
                if (this.curBondType == 100) {
                    this.curBondType = rc.firstBond;
                    this.addBond(rc.firstAtom, this.prevAtom);
                    this.curBond = null;
                    this.curBondType = 100;
                } else if (rc.firstBond != this.curBondType) {
                    this.newError("Atom index " + n + " is associated with two different bond types", -1, "");
                } else {
                    this.addBond(rc.firstAtom, this.prevAtom);
                    this.curBond = null;
                    this.curBondType = 100;
                }
            } else {
                this.newError("Atom index " + n + " is associated with two different bond types", -1, "");
            }
            this.indexes.remove(i);
        }
    }

    void parseSpecialSymbol() {
        switch (this.smarts.charAt(this.curChar)) {
            case '*': {
                AnyAtom curAtom = new AnyAtom();
                ++this.curChar;
                this.addAtom((IQueryAtom)curAtom);
                break;
            }
            case '!': 
            case '#': 
            case '&': 
            case ',': 
            case '-': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '@': 
            case '\\': 
            case '~': {
                this.parseBondExpression();
                break;
            }
            case '%': {
                this.parseAtomIndex();
                break;
            }
            case '(': {
                if (this.prevAtom == null) {
                    if (this.FlagCLG) {
                        if (this.curComponent > 0) {
                            this.newError("Incorrect nested componet brackets", this.curChar + 1, "");
                        } else {
                            this.brackets.push(this.prevAtom);
                            ++this.maxCompNumber;
                            this.curComponent = this.maxCompNumber;
                        }
                    } else {
                        this.newError("Component Level Grouping is off: incorrect openning brackect", this.curChar + 1, "");
                    }
                } else {
                    this.brackets.push(this.prevAtom);
                }
                ++this.curChar;
                break;
            }
            case ')': {
                if (this.brackets.empty()) {
                    this.newError("Incorrect closing brackect", this.curChar + 1, "");
                    return;
                }
                if (this.smarts.charAt(this.curChar - 1) == '(') {
                    this.newError("Empty branch/substituent ", this.curChar + 1, "");
                    this.brackets.pop();
                    return;
                }
                this.prevAtom = this.brackets.pop();
                if (this.prevAtom == null) {
                    this.curComponent = 0;
                }
                ++this.curChar;
                break;
            }
            case '[': {
                this.parseAtomExpression();
                break;
            }
            case ']': {
                this.newError("Incorrect opening bracket ']' ", this.curChar + 1, "");
                break;
            }
            case '.': {
                if (this.FlagCLG) {
                    ++this.curChar;
                    this.prevAtom = null;
                    this.curBond = null;
                    this.curBondType = 100;
                    break;
                }
                this.newError("Zero bond order (disclosure) is not allowed", this.curChar + 1, "");
                break;
            }
            default: {
                this.newError("Incorrect symbol", this.curChar + 1, "");
            }
        }
    }

    void parseBondExpression() {
        SmartsBondExpression sbe;
        int lo = -1;
        int bo = SmartsConst.getBondCharNumber(this.smarts.charAt(this.curChar));
        if (bo != -1) {
            ++this.curChar;
            if (this.curChar == this.nChars) {
                this.newError("Smarts string ends incorrectly with a bond expression", this.curChar, "");
                return;
            }
            this.curBondType = bo;
            if ((this.curBondType == 6 || this.curBondType == 7) && this.smarts.charAt(this.curChar) == '?') {
                ++this.curChar;
                if (this.curChar == this.nChars) {
                    this.newError("Smarts string ends incorrectly with a bond expression", this.curChar, "");
                    return;
                }
                if (this.curBondType == 6) {
                    this.curBondType = 8;
                } else if (this.curBondType == 7) {
                    this.curBondType = 9;
                }
            }
            if (SmartsConst.getBondCharNumber(this.smarts.charAt(this.curChar)) == -1 && SmartsConst.getLogOperationCharNumber(this.smarts.charAt(this.curChar)) == -1) {
                return;
            }
            this.curBond = new SmartsBondExpression();
            sbe = (SmartsBondExpression)this.curBond;
            sbe.tokens.add(new Integer(bo));
        } else {
            lo = SmartsConst.getLogOperationCharNumber(this.smarts.charAt(this.curChar));
            if (lo != 0) {
                this.newError("Incorrect bond expression", this.curChar + 1, "");
                return;
            }
            this.curBond = new SmartsBondExpression();
            sbe = (SmartsBondExpression)this.curBond;
            sbe.tokens.add(new Integer(1000 + lo));
            ++this.curChar;
        }
        bo = SmartsConst.getBondCharNumber(this.smarts.charAt(this.curChar));
        if (bo == 6 || bo == 7) {
            if (this.curChar + 1 == this.nChars) {
                this.newError("Smarts string ends incorrectly with a bond expression", this.curChar + 1, "");
                return;
            }
            if (this.smarts.charAt(this.curChar + 1) == '?') {
                bo = bo == 6 ? 8 : 9;
                ++this.curChar;
            }
        }
        lo = bo == -1 ? SmartsConst.getLogOperationCharNumber(this.smarts.charAt(this.curChar)) : -1;
        while (bo != -1 || lo != -1) {
            int prevToken = sbe.tokens.lastElement();
            if (bo != -1) {
                if (prevToken < 1000) {
                    sbe.tokens.add(new Integer(1001));
                }
                sbe.tokens.add(new Integer(bo));
            } else {
                if (prevToken >= 1000 && lo != 0) {
                    this.newError("Incorrect bond expression - no oprenad between logical operation", this.curChar + 1, "");
                    return;
                }
                sbe.tokens.add(new Integer(1000 + lo));
            }
            ++this.curChar;
            if (this.curChar == this.nChars) {
                this.newError("Smarts string ends incorrectly with a bond expression", this.curChar, "");
                return;
            }
            bo = SmartsConst.getBondCharNumber(this.smarts.charAt(this.curChar));
            if (bo == 6 || bo == 7) {
                if (this.curChar + 1 == this.nChars) {
                    this.newError("Smarts string ends incorrectly with a bond expression", this.curChar + 1, "");
                    return;
                }
                if (this.smarts.charAt(this.curChar + 1) == '?') {
                    bo = bo == 6 ? 8 : 9;
                    ++this.curChar;
                }
            }
            if (bo == -1) {
                lo = SmartsConst.getLogOperationCharNumber(this.smarts.charAt(this.curChar));
                continue;
            }
            lo = -1;
        }
    }

    void parseAtomExpression() {
        ++this.curChar;
        int openBrackets = 1;
        this.curAtExpr = new SmartsAtomExpression();
        while (this.curChar < this.nChars && openBrackets > 0 && this.errors.size() == 0) {
            if (this.smarts.charAt(this.curChar) == '[') {
                ++openBrackets;
                ++this.curChar;
                continue;
            }
            if (this.smarts.charAt(this.curChar) == ']') {
                --openBrackets;
                ++this.curChar;
                continue;
            }
            this.parseAtomPrimitive();
        }
        if (this.errors.size() > 0) {
            return;
        }
        if (openBrackets > 0) {
            this.newError("Incorrect atom expression - [] block is not closed", this.curChar, "");
        } else {
            this.addAtom((IQueryAtom)this.curAtExpr);
        }
    }

    public void testForDefaultAND() {
        int tok = this.getLastAtomToken();
        if (tok >= 0 && tok < 1000) {
            this.curAtExpr.tokens.add(new SmartsExpressionToken(1001, 0));
        }
    }

    public int testFor2CharElement() {
        if (this.curChar < this.nChars - 1 && Character.isLowerCase(this.smarts.charAt(this.curChar + 1))) {
            String symbol = this.smarts.substring(this.curChar, this.curChar + 2);
            this.curChar += 2;
            int par = SmartsConst.getElementNumber(symbol);
            if (par == -1) {
                this.newError("Incorrect atom type in atom expression", this.curChar, "");
            } else {
                this.curAtExpr.tokens.add(new SmartsExpressionToken(2, par));
            }
            return 1;
        }
        return 0;
    }

    public int getLastAtomToken() {
        if (this.curAtExpr.tokens.size() == 0) {
            return -1;
        }
        SmartsExpressionToken tok = this.curAtExpr.tokens.lastElement();
        return tok.type;
    }

    void parseAtomPrimitive() {
        if (Character.isLetter(this.smarts.charAt(this.curChar))) {
            switch (this.smarts.charAt(this.curChar)) {
                case 'a': {
                    this.testForDefaultAND();
                    this.curAtExpr.tokens.add(new SmartsExpressionToken(1, 0));
                    ++this.curChar;
                    break;
                }
                case 'A': {
                    this.parseAP_A();
                    break;
                }
                case 'D': {
                    this.parseAP_AtomPrimitive(3, true);
                    break;
                }
                case 'H': {
                    this.parseAP_AtomPrimitive(4, true);
                    break;
                }
                case 'h': {
                    this.parseAP_AtomPrimitive(5, false);
                    break;
                }
                case 'R': {
                    this.parseAP_RPrimitive(true);
                    break;
                }
                case 'r': {
                    this.parseAP_rPrimitive(false);
                    break;
                }
                case 'v': {
                    if (this.mSupportMOEExtension && this.mUseMOEvPrimitive) {
                        this.parseAP_AtomPrimitive(20, false);
                        break;
                    }
                    this.parseAP_AtomPrimitive(8, false);
                    break;
                }
                case 'X': {
                    this.parseAP_AtomPrimitive(9, true);
                    break;
                }
                case 'x': {
                    this.parseAP_xPrimitive(false);
                    break;
                }
                case 'i': {
                    if (this.mSupportMOEExtension) {
                        this.parseAP_iPrimitive(false);
                        break;
                    }
                    this.parseAP_AtomSymbol();
                    break;
                }
                case 'q': {
                    if (this.mSupportMOEExtension) {
                        this.parseAP_xPrimitive(false);
                        break;
                    }
                    this.parseAP_AtomSymbol();
                    break;
                }
                default: {
                    this.parseAP_AtomSymbol();
                    break;
                }
            }
        } else if (Character.isDigit(this.smarts.charAt(this.curChar))) {
            this.parseAP_AtomMass();
        } else {
            switch (this.smarts.charAt(this.curChar)) {
                case ' ': {
                    ++this.curChar;
                    break;
                }
                case '!': {
                    this.parseAP_NOT();
                    break;
                }
                case '&': {
                    this.parseAP_LogOperation(1);
                    break;
                }
                case ',': {
                    this.parseAP_LogOperation(2);
                    break;
                }
                case ';': {
                    this.parseAP_LogOperation(3);
                    break;
                }
                case '#': {
                    this.parseAP_AtomNumber();
                    break;
                }
                case '@': {
                    this.parseAP_Chirality();
                    break;
                }
                case '-': {
                    this.parseAP_Charge(-1);
                    break;
                }
                case '+': {
                    this.parseAP_Charge(1);
                    break;
                }
                case '$': {
                    this.parseAP_RecursiveSmarts();
                    break;
                }
                case '*': {
                    this.testForDefaultAND();
                    this.curAtExpr.tokens.add(new SmartsExpressionToken(0, 0));
                    ++this.curChar;
                    break;
                }
                case '^': {
                    if (this.mSupportOpenBabelExtension) {
                        this.parseAP_OpenBabel_Hybridization();
                        break;
                    }
                    this.newError("Incorrect symbol in atom expression", this.curChar + 1, "");
                    ++this.curChar;
                    break;
                }
                case ':': {
                    if (this.mSupportSmirksSyntax) {
                        this.parseAP_SmirksMaping();
                        break;
                    }
                    this.newError("Smirks mapping is not supported!", this.curChar + 1, "");
                    ++this.curChar;
                    break;
                }
                default: {
                    this.newError("Incorrect symbol in atom expression", this.curChar + 1, "");
                    ++this.curChar;
                }
            }
        }
    }

    void parseAP_AtomSymbol() {
        this.testForDefaultAND();
        if (Character.isLowerCase(this.smarts.charAt(this.curChar))) {
            char symbol = Character.toUpperCase(this.smarts.charAt(this.curChar));
            int par = SmartsConst.getElementNumberFromChar(symbol);
            ++this.curChar;
            if (par == -1) {
                this.newError("Incorrect aromatic atom type in atom expression", this.curChar, "");
            } else {
                this.curAtExpr.tokens.add(new SmartsExpressionToken(1, par));
            }
        } else {
            int n = 1;
            if (this.curChar < this.nChars - 1 && Character.isLowerCase(this.smarts.charAt(this.curChar + 1))) {
                n = 2;
            }
            String symbol = this.smarts.substring(this.curChar, this.curChar + n);
            this.curChar += n;
            int par = SmartsConst.getElementNumber(symbol);
            if (par == -1) {
                this.newError("Incorrect aliphatic atom type in atom expression", this.curChar, "");
            } else {
                this.curAtExpr.tokens.add(new SmartsExpressionToken(2, par));
            }
        }
    }

    void parseAP_NOT() {
        this.testForDefaultAND();
        this.curAtExpr.tokens.add(new SmartsExpressionToken(1000, 0));
        ++this.curChar;
    }

    void parseAP_LogOperation(int logOp) {
        int prevTok = this.getLastAtomToken();
        if (prevTok < 0) {
            this.newError("Atom expression incorrectly starts with logical opreation", this.curChar + 1, "");
        } else if (prevTok >= 1000) {
            this.newError("Incorrect expression - missing operand", this.curChar + 1, "");
        } else {
            this.curAtExpr.tokens.add(new SmartsExpressionToken(1000 + logOp, 0));
        }
        ++this.curChar;
    }

    void parseAP_AtomMass() {
        this.testForDefaultAND();
        int mass = this.getInteger();
        this.curAtExpr.tokens.add(new SmartsExpressionToken(13, mass));
    }

    void parseAP_A() {
        this.testForDefaultAND();
        if (this.testFor2CharElement() == 1) {
            return;
        }
        this.curAtExpr.tokens.add(new SmartsExpressionToken(2, 0));
        ++this.curChar;
    }

    void parseAP_AtomPrimitive(int logOpType, boolean elTest) {
        this.testForDefaultAND();
        if (elTest && this.testFor2CharElement() == 1) {
            return;
        }
        int symbolPos = this.curChar++;
        int par = this.getInteger();
        if (par == -1) {
            if (logOpType == 4 && this.isHydrogenAtom(symbolPos)) {
                this.curAtExpr.tokens.add(new SmartsExpressionToken(2, 1));
                return;
            }
            par = 1;
        }
        this.curAtExpr.tokens.add(new SmartsExpressionToken(logOpType, par));
    }

    boolean isHydrogenAtom(int symbolPos) {
        char prevCh = this.smarts.charAt(symbolPos - 1);
        if (prevCh == '*') {
            return false;
        }
        if (prevCh == '[') {
            return true;
        }
        if (prevCh == '&' && this.curAtExpr.tokens.size() > 0) {
            SmartsExpressionToken tok = this.curAtExpr.tokens.lastElement();
            if (tok.type == 13) {
                return true;
            }
        }
        return false;
    }

    void parseAP_RPrimitive(boolean elTest) {
        this.testForDefaultAND();
        if (elTest && this.testFor2CharElement() == 1) {
            return;
        }
        ++this.curChar;
        int par = this.getInteger();
        this.curAtExpr.tokens.add(new SmartsExpressionToken(6, par));
    }

    void parseAP_rPrimitive(boolean elTest) {
        this.testForDefaultAND();
        if (elTest && this.testFor2CharElement() == 1) {
            return;
        }
        ++this.curChar;
        int par = this.getInteger();
        if (par == -1) {
            par = 1;
        } else if (par < 3) {
            this.newError("Incorrect integer value for r-primitive!", this.curChar, "");
        }
        this.curAtExpr.tokens.add(new SmartsExpressionToken(7, par));
    }

    void parseAP_xPrimitive(boolean elTest) {
        this.testForDefaultAND();
        if (elTest && this.testFor2CharElement() == 1) {
            return;
        }
        ++this.curChar;
        int par = this.getInteger();
        if (par == -1) {
            par = -1;
        }
        this.curAtExpr.tokens.add(new SmartsExpressionToken(15, par));
    }

    void parseAP_iPrimitive(boolean elTest) {
        this.testForDefaultAND();
        ++this.curChar;
        int par = 0;
        this.curAtExpr.tokens.add(new SmartsExpressionToken(16, par));
    }

    void parseAP_AtomNumber() {
        this.testForDefaultAND();
        ++this.curChar;
        if (this.mSupportMOEExtension && this.curChar < this.nChars && this.parseMOEExpression()) {
            return;
        }
        int par = this.getInteger();
        if (par == -1) {
            this.newError("Incorrect atomic number after #", this.curChar, "");
        } else if (par < 1 || par >= SmartsConst.elSymbols.length) {
            this.newError("Incorrect atomic number after #", this.curChar, "");
        } else {
            this.curAtExpr.tokens.add(new SmartsExpressionToken(11, par));
        }
    }

    void parseAP_OpenBabel_Hybridization() {
        this.testForDefaultAND();
        ++this.curChar;
        int par = this.getInteger();
        if (par == -1) {
            this.newError("Missing hybridization parameter after ^", this.curChar, "");
        } else if (par < 1 || par > 3) {
            this.newError("Incorrect hybridization after ^", this.curChar, "");
        } else {
            this.curAtExpr.tokens.add(new SmartsExpressionToken(21, par));
        }
    }

    void parseAP_SmirksMaping() {
        ++this.curChar;
        int par = this.getInteger();
        if (par == -1) {
            this.newError("Missing Smirks Mapping index after ", this.curChar, "");
        } else if (par < 0 || par > 10000) {
            this.newError("Incorrect Smirks Mapping index ", this.curChar, "");
        } else if (this.curSmirksMapIndex > 0) {
            this.newError("Smirks Mapping index is specified more than once per atom ", this.curChar, "");
        } else {
            this.curSmirksMapIndex = par;
        }
    }

    boolean parseMOEExpression() {
        if (this.smarts.charAt(this.curChar) == 'G') {
            ++this.curChar;
            int par = this.getInteger();
            if (par == -1) {
                this.newError("Incorrect atomic number after #G", this.curChar, "");
            } else if (par < 1 || par > 8) {
                this.newError("Incorrect atomic number after #G", this.curChar, "");
            } else {
                this.curAtExpr.tokens.add(new SmartsExpressionToken(17, par));
            }
            return true;
        }
        if (this.smarts.charAt(this.curChar) == 'N') {
            ++this.curChar;
            this.curAtExpr.tokens.add(new SmartsExpressionToken(19, 0));
            return true;
        }
        if (this.smarts.charAt(this.curChar) == 'X') {
            ++this.curChar;
            this.curAtExpr.tokens.add(new SmartsExpressionToken(18, 0));
            return true;
        }
        return false;
    }

    void parseAP_Chirality() {
        this.testForDefaultAND();
        ++this.curChar;
        int par = 2;
        if (this.smarts.charAt(this.curChar) == '@') {
            ++this.curChar;
        } else {
            par = 1;
        }
        this.curAtExpr.tokens.add(new SmartsExpressionToken(12, par));
    }

    void parseAP_Charge(int sign) {
        this.testForDefaultAND();
        ++this.curChar;
        char ch = sign < 0 ? (char)'-' : '+';
        int num = 1;
        while (this.curChar < this.nChars && this.smarts.charAt(this.curChar) == ch) {
            ++num;
            ++this.curChar;
        }
        if (num > 1) {
            this.curAtExpr.tokens.add(new SmartsExpressionToken(10, sign * num));
        } else if (this.curChar < this.nChars) {
            if (Character.isDigit(this.smarts.charAt(this.curChar))) {
                int par = this.getInteger();
                if (par == -1) {
                    this.newError("Incorrect charge ", this.curChar, "");
                } else {
                    this.curAtExpr.tokens.add(new SmartsExpressionToken(10, sign * par));
                }
            } else {
                this.curAtExpr.tokens.add(new SmartsExpressionToken(10, sign));
            }
        } else {
            this.curAtExpr.tokens.add(new SmartsExpressionToken(10, sign));
        }
    }

    public void parseAP_RecursiveSmarts() {
        ++this.curChar;
        if (this.curChar >= this.nChars) {
            this.newError("Incorrect recursive smarts", this.curChar, "");
            return;
        }
        if (this.smarts.charAt(this.curChar) != '(') {
            this.newError("Incorrect recursive smarts", this.curChar + 1, "");
            return;
        }
        ++this.curChar;
        int openBrackets = 1;
        int firstChar = this.curChar;
        while (this.curChar < this.nChars && openBrackets > 0) {
            if (this.smarts.charAt(this.curChar) == '(') {
                ++openBrackets;
            } else if (this.smarts.charAt(this.curChar) == ')') {
                --openBrackets;
            }
            ++this.curChar;
        }
        if (this.curChar >= this.nChars && openBrackets > 0) {
            this.newError("Incorrect recursive smarts. String end is reached within $(expression)", this.curChar, "");
            return;
        }
        if (firstChar == this.curChar - 1) {
            this.newError("Empty recursive smarts", this.curChar, "");
        }
        this.curAtExpr.tokens.add(new SmartsExpressionToken(14, this.curAtExpr.recSmartsStrings.size()));
        this.curAtExpr.recSmartsStrings.add(this.smarts.substring(firstChar, this.curChar - 1));
    }

    int getAbsoluteChirality(IAtom atom, int relChirality) {
        List ca = this.container.getConnectedAtomsList(atom);
        if (ca.size() != 4) {
            return 0;
        }
        int[][] atNCode = new int[4][];
        for (int i = 0; i < 4; ++i) {
            atNCode[i] = this.getAtomNeighbourCode(atom, (IAtom)ca.get(i));
            if (atNCode[i] != null) continue;
            return 0;
        }
        boolean FlagClockWise = relChirality == 2;
        for (int i = 2; i >= 0; --i) {
            for (int j = 0; j <= i; ++j) {
                if (this.compareNeighbourCodes(atNCode[j], atNCode[j + 1]) <= 0) continue;
                FlagClockWise = !FlagClockWise;
                int[] temp = atNCode[j];
                atNCode[j] = atNCode[j + 1];
                atNCode[j + 1] = temp;
            }
        }
        if (FlagClockWise) {
            return 1001;
        }
        return 1002;
    }

    int compareNeighbourCodes(int[] atCode1, int[] atCode2) {
        int n = atCode1.length < atCode2.length ? atCode1.length : atCode2.length;
        for (int i = 0; i < n; ++i) {
            if (atCode1[i] < atCode2[i]) {
                return -1;
            }
            if (atCode1[i] <= atCode2[i]) continue;
            return 1;
        }
        if (atCode1.length < atCode2.length) {
            return -1;
        }
        if (atCode1.length > atCode2.length) {
            return 1;
        }
        return 0;
    }

    int getAtomType(IAtom atom) {
        if (atom instanceof SmartsAtomExpression) {
            SmartsAtomExpression at = (SmartsAtomExpression)atom;
            for (int i = 0; i < at.tokens.size(); ++i) {
                SmartsExpressionToken tok = at.tokens.get(i);
                if (tok.type == 0) {
                    return -1;
                }
                if (tok.type != 2 && tok.type != 1 && tok.type != 11) continue;
                if (i > 0 && at.tokens.get((int)(i - 1)).type == 1000) {
                    return -1;
                }
                if (tok.param > 0) {
                    return tok.param;
                }
                return -1;
            }
        }
        if (atom instanceof AliphaticSymbolQueryAtom || atom instanceof AromaticSymbolQueryAtom) {
            return SmartsConst.getElementNumber(atom.getSymbol());
        }
        return -1;
    }

    static int getBondType(IBond.Order order) {
        if (order == IBond.Order.SINGLE) {
            return 1;
        }
        if (order == IBond.Order.DOUBLE) {
            return 2;
        }
        if (order == IBond.Order.TRIPLE) {
            return 3;
        }
        return 1;
    }

    int getBondType(IBond bond) {
        if (bond instanceof OrderQueryBond) {
            return SmartsParser.getBondType(bond.getOrder());
        }
        if (bond instanceof SingleOrAromaticBond) {
            return 1;
        }
        if (bond instanceof DoubleNonAromaticBond) {
            return 2;
        }
        if (bond instanceof DoubleBondAromaticityNotSpecified) {
            return 2;
        }
        if (bond instanceof DoubleStereoBond) {
            return 2;
        }
        return -1;
    }

    public int[] getAtomNeighbourCode(IAtom center, IAtom neighAtom) {
        Vector<Integer> code = new Vector<Integer>();
        Vector<IAtom> usedAtoms = new Vector<IAtom>();
        Vector<IAtom> layer = new Vector<IAtom>();
        int atType = this.getAtomType(neighAtom);
        if (atType == -1) {
            return null;
        }
        code.add(new Integer(atType));
        usedAtoms.add(center);
        usedAtoms.add(neighAtom);
        layer.add(neighAtom);
        Vector<IAtom> nextLayer = this.addLayerToCode(code, layer, usedAtoms);
        layer = nextLayer;
        nextLayer = this.addLayerToCode(code, layer, usedAtoms);
        int[] result = new int[code.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = code.get(i);
        }
        return result;
    }

    Vector<IAtom> addLayerToCode(Vector<Integer> code, Vector<IAtom> layer, Vector<IAtom> usedAtoms) {
        int i;
        if (layer == null) {
            return null;
        }
        Vector<IAtom> nextLayer = new Vector<IAtom>();
        Vector<Integer> atTypes = new Vector<Integer>();
        Vector<Integer> boTypes = new Vector<Integer>();
        for (int i2 = 0; i2 < layer.size(); ++i2) {
            List ca = this.container.getConnectedAtomsList(layer.get(i2));
            for (int k = 0; k < ca.size(); ++k) {
                IAtom at = (IAtom)ca.get(k);
                if (this.isAtomUsed(at, usedAtoms)) continue;
                int atType = this.getAtomType(at);
                if (atType == -1) {
                    return null;
                }
                IBond bo = this.container.getBond(layer.get(i2), at);
                int boType = this.getBondType(bo);
                if (boType == -1) {
                    return null;
                }
                usedAtoms.add(at);
                nextLayer.add(at);
                atTypes.add(new Integer(atType));
                boTypes.add(new Integer(boType));
            }
        }
        int n = atTypes.size();
        for (i = n - 2; i >= 0; --i) {
            for (int k = 0; k <= i; ++k) {
                if ((Integer)atTypes.get(k) >= (Integer)atTypes.get(k + 1)) continue;
                Integer tmp = (int)((Integer)atTypes.get(k));
                atTypes.set(k, (Integer)atTypes.get(k + 1));
                atTypes.set(k + 1, tmp);
                tmp = (int)((Integer)boTypes.get(k));
                boTypes.set(k, (Integer)boTypes.get(k + 1));
                boTypes.set(k + 1, tmp);
            }
        }
        for (i = 0; i < n; ++i) {
            code.add((Integer)atTypes.get(i));
        }
        for (i = 0; i < n; ++i) {
            code.add((Integer)boTypes.get(i));
        }
        return nextLayer;
    }

    boolean isAtomUsed(IAtom atom, Vector<IAtom> v) {
        for (int i = 0; i < v.size(); ++i) {
            if (atom != v.get(i)) continue;
            return true;
        }
        return false;
    }

    void convertChirality(SmartsAtomExpression atom) {
        for (int i = 0; i < atom.tokens.size(); ++i) {
            SmartsExpressionToken tok = atom.tokens.get(i);
            if (tok.type != 12) continue;
            tok.param = this.getAbsoluteChirality((IAtom)atom, tok.param);
        }
    }

    void setDoubleBondsStereoInfo() {
        int i;
        this.processedDirBonds.clear();
        this.processedDoubleBonds.clear();
        this.newStereoDoubleBonds.clear();
        for (i = 0; i < this.directionalBonds.size(); ++i) {
            SMARTSBond dBo;
            SMARTSBond dirBond = this.directionalBonds.get(i);
            if (this.isBondProcessed(dirBond, this.processedDirBonds)) continue;
            IAtom at0 = dirBond.getAtom(0);
            IAtom at1 = dirBond.getAtom(1);
            if (this.isAtomForStereoDoubleBond(at0) && (dBo = this.getNeighborDoubleBond(dirBond, 0)) != null && !this.isBondProcessed(dBo, this.processedDoubleBonds)) {
                this.setDoubleStereoBond(dBo, at0, at1, dirBond, this.directions.get(i), 0);
            }
            if (this.isAtomForStereoDoubleBond(at1) && (dBo = this.getNeighborDoubleBond(dirBond, 1)) != null && !this.isBondProcessed(dBo, this.processedDoubleBonds)) {
                this.setDoubleStereoBond(dBo, at1, at0, dirBond, this.directions.get(i), 1);
            }
            this.processedDirBonds.add(dirBond);
        }
        for (i = 0; i < this.processedDoubleBonds.size(); ++i) {
            this.container.removeBond((IBond)this.processedDoubleBonds.get(i));
            this.container.addBond((IBond)this.newStereoDoubleBonds.get(i));
        }
    }

    boolean isDirectionalBond(SMARTSBond bond) {
        for (int i = 0; i < this.directionalBonds.size(); ++i) {
            if (this.directionalBonds.get(i) != bond) continue;
            return true;
        }
        return false;
    }

    boolean isAtomForStereoDoubleBond(IAtom atom) {
        if (atom.getSymbol().equals("C")) {
            return true;
        }
        if (atom.getSymbol().equals("N")) {
            return true;
        }
        if (atom.getSymbol().equals("P")) {
            return true;
        }
        return atom.getSymbol().equals("Si");
    }

    boolean isBondProcessed(SMARTSBond bond, Vector<SMARTSBond> processedBonds) {
        for (SMARTSBond bo : processedBonds) {
            if (bo != bond) continue;
            return true;
        }
        return false;
    }

    SMARTSBond getNeighborDoubleBond(SMARTSBond bond, int atNum) {
        IAtom at = bond.getAtom(atNum);
        List ca = this.container.getConnectedAtomsList(at);
        for (int k = 0; k < ca.size(); ++k) {
            IBond bo = this.container.getBond(at, (IAtom)ca.get(k));
            if (bo == bond || !(bo instanceof OrderQueryBond) || bo.getOrder() != IBond.Order.DOUBLE) continue;
            return (SMARTSBond)bo;
        }
        return null;
    }

    void setDoubleStereoBond(SMARTSBond doubleBond, IAtom atom, IAtom at0, SMARTSBond dirBond, int direction, int atomPos) {
        boolean isCis;
        IAtom at1 = null;
        IAtom at2 = null;
        IAtom at3 = null;
        IAtom atom1 = doubleBond.getAtom(0) == atom ? doubleBond.getAtom(1) : doubleBond.getAtom(0);
        List ca = this.container.getConnectedAtomsList(atom);
        for (int k = 0; k < ca.size(); ++k) {
            if (ca.get(k) == at0 || ca.get(k) == atom1) continue;
            at1 = (IAtom)ca.get(k);
            break;
        }
        boolean FlagDir2 = false;
        boolean FlagDir3 = false;
        ca = this.container.getConnectedAtomsList(atom1);
        for (int k = 0; k < ca.size(); ++k) {
            IAtom otherAt = (IAtom)ca.get(k);
            if (otherAt == atom) continue;
            IBond bo = this.container.getBond(atom1, otherAt);
            if (at2 == null) {
                FlagDir2 = this.isDirectionalBond((SMARTSBond)bo);
                at2 = otherAt;
                continue;
            }
            if (at3 != null) break;
            FlagDir3 = this.isDirectionalBond((SMARTSBond)bo);
            at3 = otherAt;
        }
        if (!FlagDir2 && !FlagDir3) {
            return;
        }
        int[] pAt0 = this.getAtomNeighbourCode(atom, at0);
        int[] pAt1 = at1 == null ? new int[]{1} : this.getAtomNeighbourCode(atom, at1);
        int[] pAt2 = at2 == null ? new int[]{1} : this.getAtomNeighbourCode(atom1, at2);
        int[] pAt3 = at3 == null ? new int[]{1} : this.getAtomNeighbourCode(atom1, at3);
        int direction2 = 0;
        SMARTSBond dirBond2 = FlagDir2 ? (SMARTSBond)this.container.getBond(atom1, at2) : (SMARTSBond)this.container.getBond(atom1, at3);
        for (int i = 0; i < this.directions.size(); ++i) {
            if (this.directionalBonds.get(i) != dirBond2) continue;
            direction2 = this.directions.get(i);
            break;
        }
        boolean isUp = direction == 6 || direction == 8;
        boolean isUp2 = direction2 == 6 || direction2 == 8;
        boolean bl = isCis = isUp == isUp2;
        if (this.container.getAtomNumber(atom) > this.container.getAtomNumber(at0)) {
            boolean bl2 = isCis = !isCis;
        }
        if (FlagDir2) {
            if (this.container.getAtomNumber(atom1) > this.container.getAtomNumber(at2)) {
                isCis = !isCis;
            }
        } else if (this.container.getAtomNumber(atom1) > this.container.getAtomNumber(at3)) {
            boolean bl3 = isCis = !isCis;
        }
        if (this.compareNeighbourCodes(pAt0, pAt1) < 0) {
            boolean bl4 = isCis = !isCis;
        }
        if (FlagDir2) {
            if (this.compareNeighbourCodes(pAt2, pAt3) < 0) {
                isCis = !isCis;
            }
        } else if (this.compareNeighbourCodes(pAt3, pAt2) < 0) {
            isCis = !isCis;
        }
        boolean isUnspecified = direction == 8 || direction == 9 || direction2 == 8 || direction2 == 9;
        DoubleStereoBond stereoBond = new DoubleStereoBond();
        stereoBond.setAtom(atom, 0);
        stereoBond.setAtom(atom1, 1);
        stereoBond.stereoParameter = isCis ? (isUnspecified ? 11 : 10) : (isUnspecified ? 13 : 12);
        this.processedDoubleBonds.add(doubleBond);
        this.newStereoDoubleBonds.add(stereoBond);
        this.processedDirBonds.add(dirBond2);
    }

    public void setSMARTSData(IAtomContainer container) throws Exception {
        SmartsParser.prepareTargetForSMARTSSearch(this.mNeedNeighbourData, this.mNeedValencyData, this.mNeedRingData, this.mNeedRingData2, this.mNeedExplicitHData, this.mNeedParentMoleculeData, container);
    }

    public static void prepareTargetForSMARTSSearch(boolean neighbourData, boolean valenceData, boolean ringData, boolean ringData2, boolean explicitHData, boolean parentMoleculeData, IAtomContainer container) throws Exception {
        if (neighbourData) {
            SmartsParser.setNeighbourData(container);
        }
        if (valenceData) {
            SmartsParser.setValenceData(container);
        }
        if (ringData || ringData2) {
            SmartsParser.setRingData(container, ringData, ringData2);
        }
        if (explicitHData) {
            SmartsParser.setExplicitHAtomData(container);
        }
        if (parentMoleculeData) {
            SmartsParser.setParentMoleculeData(container);
        }
    }

    public static void prepareTargetForSMARTSSearch(SmartsFlags flags, IAtomContainer container) {
        if (flags.mNeedNeighbourData) {
            SmartsParser.setNeighbourData(container);
        }
        if (flags.mNeedValenceData) {
            SmartsParser.setValenceData(container);
        }
        if (flags.mNeedRingData || flags.mNeedRingData2) {
            SmartsParser.setRingData(container, flags.mNeedRingData, flags.mNeedRingData2);
        }
        if (flags.mNeedExplicitHData) {
            SmartsParser.setExplicitHAtomData(container);
        }
        if (flags.mNeedParentMoleculeData) {
            SmartsParser.setParentMoleculeData(container);
        }
    }

    public static void setNeighbourData(IAtomContainer container) {
        IBond bond = null;
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom at = container.getAtom(i);
            at.setFormalNeighbourCount(Integer.valueOf(0));
        }
        for (int f = 0; f < container.getBondCount(); ++f) {
            bond = container.getBond(f);
            IAtom at1 = bond.getAtom(0);
            IAtom at2 = bond.getAtom(1);
            at1.setFormalNeighbourCount(Integer.valueOf(at1.getFormalNeighbourCount() + 1));
            at2.setFormalNeighbourCount(Integer.valueOf(at2.getFormalNeighbourCount() + 1));
        }
    }

    public static void setValenceData(IAtomContainer container) {
        IBond bond = null;
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom at = container.getAtom(i);
            Integer hci = at.getImplicitHydrogenCount();
            int hc = 0;
            if (hci != null) {
                hc = hci;
            }
            at.setValency(Integer.valueOf(hc));
        }
        for (int f = 0; f < container.getBondCount(); ++f) {
            bond = container.getBond(f);
            IAtom at1 = bond.getAtom(0);
            IAtom at2 = bond.getAtom(1);
            at1.setValency(Integer.valueOf(at1.getValency() + SmartsParser.getBondType(bond.getOrder())));
            at2.setValency(Integer.valueOf(at2.getValency() + SmartsParser.getBondType(bond.getOrder())));
        }
    }

    public static void setExplicitHAtomData(IAtomContainer container) {
        int i;
        for (i = 0; i < container.getAtomCount(); ++i) {
            container.getAtom(i).removeProperty((Object)"ExplicitH");
        }
        for (i = 0; i < container.getBondCount(); ++i) {
            Integer ha;
            IAtom at;
            IBond bo = container.getBond(i);
            if (bo.getAtom(0).getSymbol().equals("H")) {
                at = bo.getAtom(1);
                ha = (Integer)at.getProperty((Object)"ExplicitH");
                if (ha == null) {
                    at.setProperty((Object)"ExplicitH", (Object)new Integer(1));
                } else {
                    at.setProperty((Object)"ExplicitH", (Object)new Integer(1 + ha));
                }
            }
            if (!bo.getAtom(1).getSymbol().equals("H")) continue;
            at = bo.getAtom(0);
            ha = (Integer)at.getProperty((Object)"ExplicitH");
            if (ha == null) {
                at.setProperty((Object)"ExplicitH", (Object)new Integer(1));
                continue;
            }
            at.setProperty((Object)"ExplicitH", (Object)new Integer(1 + ha));
        }
    }

    public static int[] getExplicitHAtomData(IAtomContainer container) {
        int i;
        int[] numH = new int[container.getAtomCount()];
        for (i = 0; i < numH.length; ++i) {
            numH[0] = 0;
        }
        for (i = 0; i < container.getBondCount(); ++i) {
            IAtom at;
            IBond bo = container.getBond(i);
            if (bo.getAtom(0).getSymbol().equals("H")) {
                at = bo.getAtom(1);
                int n = container.getAtomNumber(at);
                numH[n] = numH[n] + 1;
            }
            if (!bo.getAtom(1).getSymbol().equals("H")) continue;
            at = bo.getAtom(0);
            int n = container.getAtomNumber(at);
            numH[n] = numH[n] + 1;
        }
        return numH;
    }

    public static void setRingData(IAtomContainer container, boolean rData, boolean rData2) {
        int k;
        int n;
        IRingSet atomRings;
        IAtom atom;
        int i;
        SSSRFinder sssrf = new SSSRFinder(container);
        IRingSet ringSet = sssrf.findSSSR();
        if (rData) {
            for (i = 0; i < container.getAtomCount(); ++i) {
                atom = container.getAtom(i);
                atomRings = ringSet.getRings(atom);
                n = atomRings.getAtomContainerCount();
                if (n <= 0) continue;
                int[] ringData = new int[n];
                for (k = 0; k < n; ++k) {
                    ringData[k] = atomRings.getAtomContainer(k).getAtomCount();
                }
                atom.setProperty((Object)"RingData", (Object)ringData);
            }
        }
        if (rData2) {
            for (i = 0; i < container.getAtomCount(); ++i) {
                atom = container.getAtom(i);
                atomRings = ringSet.getRings(atom);
                n = atomRings.getAtomContainerCount();
                if (n <= 0) continue;
                int[] ringData2 = new int[n];
                for (k = 0; k < n; ++k) {
                    ringData2[k] = SmartsParser.getRingNumberInRingSet(atomRings.getAtomContainer(k), ringSet);
                }
                atom.setProperty((Object)"RingData2", (Object)ringData2);
            }
        }
    }

    public static Vector<int[]> getRindData(IAtomContainer container, IRingSet ringSet) {
        Vector<int[]> v = new Vector<int[]>();
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            IRingSet atomRings = ringSet.getRings(atom);
            int n = atomRings.getAtomContainerCount();
            if (n > 0) {
                int[] ringData = new int[n];
                for (int k = 0; k < n; ++k) {
                    ringData[k] = atomRings.getAtomContainer(k).getAtomCount();
                }
                v.add(ringData);
                continue;
            }
            v.add(null);
        }
        return v;
    }

    public static Vector<int[]> getRindData2(IAtomContainer container, IRingSet ringSet) {
        Vector<int[]> v = new Vector<int[]>();
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            IRingSet atomRings = ringSet.getRings(atom);
            int n = atomRings.getAtomContainerCount();
            if (n > 0) {
                int[] ringData2 = new int[n];
                for (int k = 0; k < n; ++k) {
                    ringData2[k] = SmartsParser.getRingNumberInRingSet(atomRings.getAtomContainer(k), ringSet);
                }
                v.add(ringData2);
                continue;
            }
            v.add(null);
        }
        return v;
    }

    public static int getRingNumberInRingSet(IAtomContainer ring, IRingSet rs) {
        for (int i = 0; i < rs.getAtomContainerCount(); ++i) {
            if (ring != rs.getAtomContainer(i)) continue;
            return i;
        }
        return -1;
    }

    public static void setParentMoleculeData(IAtomContainer container) {
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            atom.setProperty((Object)"ParentMoleculeData", (Object)container);
        }
    }
}

