/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.windows;

import com.l2fprod.common.swing.JTaskPaneGroup;
import com.l2fprod.common.swing.plaf.basic.BasicTaskPaneGroupUI;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class WindowsTaskPaneGroupUI
extends BasicTaskPaneGroupUI {
    public static ComponentUI createUI(JComponent c) {
        return new WindowsTaskPaneGroupUI();
    }

    protected Border createPaneBorder() {
        return new XPPaneBorder();
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getParent().getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g.setColor(c.getBackground());
            g.fillRect(0, ROUND_HEIGHT, c.getWidth(), c.getHeight() - ROUND_HEIGHT);
        }
        this.paint(g, c);
    }

    class XPPaneBorder
    extends BasicTaskPaneGroupUI.PaneBorder {
        XPPaneBorder() {
        }

        protected void paintTitleBackground(JTaskPaneGroup group, Graphics g) {
            if (group.isSpecial()) {
                g.setColor(this.specialTitleBackground);
                g.fillRoundRect(0, 0, group.getWidth(), ROUND_HEIGHT * 2, ROUND_HEIGHT, ROUND_HEIGHT);
                g.fillRect(0, ROUND_HEIGHT, group.getWidth(), TITLE_HEIGHT - ROUND_HEIGHT);
            } else {
                Paint oldPaint = ((Graphics2D)g).getPaint();
                GradientPaint gradient = new GradientPaint(0.0f, group.getWidth() / 2, group.getComponentOrientation().isLeftToRight() ? this.titleBackgroundGradientStart : this.titleBackgroundGradientEnd, group.getWidth(), TITLE_HEIGHT, group.getComponentOrientation().isLeftToRight() ? this.titleBackgroundGradientEnd : this.titleBackgroundGradientStart);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)g).setPaint(gradient);
                g.fillRoundRect(0, 0, group.getWidth(), ROUND_HEIGHT * 2, ROUND_HEIGHT, ROUND_HEIGHT);
                g.fillRect(0, ROUND_HEIGHT, group.getWidth(), TITLE_HEIGHT - ROUND_HEIGHT);
                ((Graphics2D)g).setPaint(oldPaint);
            }
        }

        protected void paintExpandedControls(JTaskPaneGroup group, Graphics g, int x, int y, int width, int height) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintOvalAroundControls(group, g, x, y, width, height);
            g.setColor(this.getPaintColor(group));
            this.paintChevronControls(group, g, x, y, width, height);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        protected boolean isMouseOverBorder() {
            return true;
        }
    }
}

